/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.iterators;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.NullIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.SingleElementIterator;

public class TreeIterator
implements Iterator {
    private Iterator currentIterator;
    private Collection iterators;
    private Midwife midwife;

    public TreeIterator(Iterator iterator) {
        this(iterator, Midwife.NULL_INSTANCE);
    }

    public TreeIterator(Object object) {
        this(object, Midwife.NULL_INSTANCE);
    }

    public TreeIterator(Object object, Midwife midwife) {
        this(new SingleElementIterator(object), midwife);
    }

    public TreeIterator(Iterator iterator, Midwife midwife) {
        this.currentIterator = iterator;
        this.iterators = new LinkedList();
        this.midwife = midwife;
    }

    public boolean hasNext() {
        if (this.currentIterator.hasNext()) {
            return true;
        }
        for (Iterator iterator : this.iterators) {
            if (!iterator.hasNext()) continue;
            return true;
        }
        return false;
    }

    public Object next() {
        if (this.currentIterator.hasNext()) {
            return this.nextInternal();
        }
        Iterator iterator = this.iterators.iterator();
        while (iterator.hasNext()) {
            this.currentIterator = (Iterator)iterator.next();
            if (this.currentIterator.hasNext()) break;
            iterator.remove();
        }
        return this.nextInternal();
    }

    private Object nextInternal() {
        Object e = this.currentIterator.next();
        this.iterators.add(this.children(e));
        return e;
    }

    public void remove() {
        this.currentIterator.remove();
    }

    protected Iterator children(Object object) {
        return this.midwife.children(object);
    }

    public String toString() {
        return ClassTools.shortClassNameForObject(this) + '(' + this.currentIterator + ')';
    }

    public static interface Midwife {
        public static final Midwife NULL_INSTANCE = new Midwife(){

            public Iterator children(Object object) {
                return NullIterator.instance();
            }
        };

        public Iterator children(Object var1);
    }
}

