/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.persistence.tools.workbench.utility.AbstractModel;
import org.eclipse.persistence.tools.workbench.utility.events.ChangeNotifier;
import org.eclipse.persistence.tools.workbench.utility.events.ChangeSupport;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneListIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.FilteringIterator;
import org.eclipse.persistence.tools.workbench.utility.node.DefaultProblem;
import org.eclipse.persistence.tools.workbench.utility.node.Node;
import org.eclipse.persistence.tools.workbench.utility.node.NodeModel;
import org.eclipse.persistence.tools.workbench.utility.node.Problem;

public abstract class AbstractNodeModel
extends AbstractModel
implements NodeModel {
    private volatile Node parent;
    private volatile String comment;
    public static final String COMMENT_PROPERTY = "comment";
    private volatile boolean dirty;
    private volatile boolean dirtyBranch;
    private List problems;
    private static final Object[] EMPTY_PROBLEM_MESSAGE_ARGUMENTS = new Object[0];
    private List branchProblems;
    private static final Map transientAspectNameSets = new Hashtable();
    private static final Map insignificantAspectNameSets = new Hashtable();

    protected AbstractNodeModel() {
    }

    protected AbstractNodeModel(Node node) {
        this();
        this.initialize(node);
    }

    protected void initialize() {
        super.initialize();
        this.comment = "";
        this.dirty = true;
        this.dirtyBranch = true;
        this.problems = new Vector();
        this.branchProblems = new Vector();
    }

    protected void initialize(Node node) {
        this.checkParent(node);
        this.parent = node;
    }

    protected ChangeSupport buildDefaultChangeSupport() {
        return new ChangeSupport(this){
            private static final long serialVersionUID = 1L;

            protected ChangeNotifier notifier() {
                return AbstractNodeModel.this.getChangeNotifier();
            }

            protected ChangeSupport buildChildChangeSupport() {
                return AbstractNodeModel.this.buildChildChangeSupport();
            }

            protected void sourceChanged(String string) {
                super.sourceChanged(string);
                AbstractNodeModel.this.aspectChanged(string);
            }
        };
    }

    protected ChangeSupport buildChildChangeSupport() {
        return new ChangeSupport(this){
            private static final long serialVersionUID = 1L;

            protected ChangeNotifier notifier() {
                return AbstractNodeModel.this.getChangeNotifier();
            }

            protected ChangeSupport buildChildChangeSupport() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public final boolean equals(Object object) {
        return this == object;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final Node getParent() {
        return this.parent;
    }

    public final void setParent(Node node) {
        this.checkParent(node);
        this.parent = node;
    }

    protected void checkParent(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("The parent node cannot be null");
        }
    }

    public final Iterator children() {
        ArrayList arrayList = new ArrayList();
        this.addChildrenTo(arrayList);
        return arrayList.iterator();
    }

    protected void addChildrenTo(List list) {
    }

    public final void setChildBackpointers() {
        Iterator iterator = this.children();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            node.setParent(this);
            node.setChildBackpointers();
        }
    }

    public final boolean isDescendantOf(Node node) {
        return this == node || this.parentIsDescendantOf(node);
    }

    protected boolean parentIsDescendantOf(Node node) {
        return this.parent != null && this.parent.isDescendantOf(node);
    }

    public final Iterator branchReferences() {
        ArrayList arrayList = new ArrayList(1000);
        this.addBranchReferencesTo(arrayList);
        return arrayList.iterator();
    }

    public final void addBranchReferencesTo(Collection collection) {
        Iterator iterator = this.children();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            node.addBranchReferencesTo(collection);
        }
    }

    public final Iterator allNodes() {
        ArrayList arrayList = new ArrayList(1000);
        this.addAllNodesTo(arrayList);
        return arrayList.iterator();
    }

    public final void addAllNodesTo(Collection collection) {
        collection.add(this);
        Iterator iterator = this.children();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            node.addAllNodesTo(collection);
        }
    }

    public void nodeRemoved(Node node) {
        Iterator iterator = this.children();
        while (iterator.hasNext()) {
            Node node2 = (Node)iterator.next();
            node2.nodeRemoved(node);
        }
    }

    protected boolean nodeIsDescendantOf(Node node, Node node2) {
        return node != null && node.isDescendantOf(node2);
    }

    public void nodeRenamed(Node node) {
        Iterator iterator = this.children();
        while (iterator.hasNext()) {
            Node node2 = (Node)iterator.next();
            node2.nodeRenamed(node);
        }
    }

    public final String getComment() {
        return this.comment;
    }

    public final void setComment(String string) {
        String string2 = this.comment;
        this.comment = string;
        this.firePropertyChanged(COMMENT_PROPERTY, string2, string);
    }

    public ChangeNotifier getChangeNotifier() {
        if (this.parent == null) {
            throw new IllegalStateException("This node should not be firing change events during its construction.");
        }
        return this.parent.getChangeNotifier();
    }

    public void setChangeNotifier(ChangeNotifier changeNotifier) {
        if (this.parent == null) {
            throw new IllegalStateException("This root node should implement #setChangeNotifier(ChangeNotifier).");
        }
        throw new UnsupportedOperationException("Only root nodes implement #setChangeNotifier(ChangeNotifier).");
    }

    protected void aspectChanged(String string) {
        if (this.aspectIsPersistent(string)) {
            this.markDirty();
        }
        if (this.aspectIsSignificant(string)) {
            this.getValidator().validate();
        }
    }

    public Node.Validator getValidator() {
        if (this.parent == null) {
            throw new IllegalStateException("This node should not be firing change events during its construction.");
        }
        return this.parent.getValidator();
    }

    public void setValidator(Node.Validator validator) {
        if (this.parent == null) {
            throw new IllegalStateException("This root node should implement #setValidator(Node.Validator).");
        }
        throw new UnsupportedOperationException("Only root nodes implement #setValidator(Node.Validator).");
    }

    public final boolean isDirty() {
        return this.dirty;
    }

    public final boolean isDirtyBranch() {
        return this.dirtyBranch;
    }

    public final boolean isClean() {
        return !this.dirty;
    }

    public final boolean isCleanBranch() {
        return !this.dirtyBranch;
    }

    private void setIsDirtyBranch(boolean bl) {
        boolean bl2 = this.dirtyBranch;
        this.dirtyBranch = bl;
        this.firePropertyChanged("dirtyBranch", bl2, bl);
    }

    private void markDirty() {
        this.dirty = true;
        this.markBranchDirty();
    }

    public void markBranchDirty() {
        if (this.dirtyBranch) {
            return;
        }
        this.setIsDirtyBranch(true);
        this.markParentBranchDirty();
    }

    protected void markParentBranchDirty() {
        if (this.parent != null) {
            this.parent.markBranchDirty();
        }
    }

    public final void markEntireBranchDirty() {
        this.markDirty();
        Iterator iterator = this.children();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            node.markEntireBranchDirty();
        }
    }

    public final void markEntireBranchClean() {
        this.cascadeMarkEntireBranchClean();
        this.markParentBranchCleanIfPossible();
    }

    protected void markParentBranchCleanIfPossible() {
        if (this.parent != null) {
            this.parent.markBranchCleanIfPossible();
        }
    }

    public final void cascadeMarkEntireBranchClean() {
        Iterator iterator = this.children();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            node.cascadeMarkEntireBranchClean();
        }
        this.dirty = false;
        this.setIsDirtyBranch(false);
    }

    public final void markBranchCleanIfPossible() {
        if (this.dirty) {
            return;
        }
        Iterator iterator = this.children();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            if (!node.isDirtyBranch()) continue;
            return;
        }
        this.setIsDirtyBranch(false);
        this.markParentBranchCleanIfPossible();
    }

    private boolean aspectIsPersistent(String string) {
        return !this.aspectIsTransient(string);
    }

    private boolean aspectIsTransient(String string) {
        return this.transientAspectNames().contains(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Set transientAspectNames() {
        Map map = transientAspectNameSets;
        synchronized (map) {
            HashSet hashSet = (HashSet)transientAspectNameSets.get(this.getClass());
            if (hashSet == null) {
                hashSet = new HashSet();
                this.addTransientAspectNamesTo(hashSet);
                transientAspectNameSets.put(this.getClass(), hashSet);
            }
            return hashSet;
        }
    }

    protected void addTransientAspectNamesTo(Set set) {
        set.add("dirtyBranch");
        set.add("branchProblems");
        set.add("hasBranchProblems");
    }

    public final Iterator allDirtyNodes() {
        return new FilteringIterator(this.allNodes()){

            protected boolean accept(Object object) {
                return object instanceof AbstractNodeModel && ((AbstractNodeModel)object).isDirty();
            }
        };
    }

    public final Iterator problems() {
        return new CloneIterator(this.problems);
    }

    public final int problemsSize() {
        return this.problems.size();
    }

    public final boolean hasProblems() {
        return !this.problems.isEmpty();
    }

    public final ListIterator branchProblems() {
        return new CloneListIterator(this.branchProblems);
    }

    public final int branchProblemsSize() {
        return this.branchProblems.size();
    }

    public final boolean hasBranchProblems() {
        return !this.branchProblems.isEmpty();
    }

    public final boolean containsBranchProblem(Problem problem) {
        return this.branchProblems.contains(problem);
    }

    protected final Problem buildProblem(String string, Object[] objectArray) {
        return new DefaultProblem(this, string, objectArray);
    }

    protected final Problem buildProblem(String string) {
        return this.buildProblem(string, EMPTY_PROBLEM_MESSAGE_ARGUMENTS);
    }

    protected final Problem buildProblem(String string, Object object) {
        return this.buildProblem(string, new Object[]{object});
    }

    protected final Problem buildProblem(String string, Object object, Object object2) {
        return this.buildProblem(string, new Object[]{object, object2});
    }

    protected final Problem buildProblem(String string, Object object, Object object2, Object object3) {
        return this.buildProblem(string, new Object[]{object, object2, object3});
    }

    public void validateBranch() {
        if (this.validateBranchInternal()) {
            this.rebuildParentBranchProblems();
        }
    }

    protected void rebuildParentBranchProblems() {
        if (this.parent != null) {
            this.parent.rebuildBranchProblems();
        }
    }

    public boolean validateBranchInternal() {
        Iterator iterator = this.children();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            node.validateBranchInternal();
        }
        this.problems.clear();
        this.addProblemsTo(this.problems);
        return this.checkBranchProblems();
    }

    protected void addProblemsTo(List list) {
    }

    private boolean checkBranchProblems() {
        Vector vector = new Vector(this.branchProblems);
        int n = this.branchProblems.size();
        this.branchProblems.clear();
        this.branchProblems.addAll(this.problems);
        Iterator iterator = this.children();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            node.addBranchProblemsTo(this.branchProblems);
        }
        int n2 = this.branchProblems.size();
        if (n == 0 && n2 != 0) {
            this.firePropertyChanged("hasBranchProblems", false, true);
        } else if (n != 0 && n2 == 0) {
            this.firePropertyChanged("hasBranchProblems", true, false);
        }
        if (((Object)vector).equals(this.branchProblems)) {
            return false;
        }
        this.fireListChanged("branchProblems");
        return true;
    }

    public final void addBranchProblemsTo(List list) {
        list.addAll(this.branchProblems);
    }

    public final void rebuildBranchProblems() {
        if (!this.checkBranchProblems()) {
            throw new IllegalStateException("we should not get here unless our \"branch\" problems have changed");
        }
        this.rebuildParentBranchProblems();
    }

    public final void clearAllBranchProblems() {
        if (this.clearAllBranchProblemsInternal()) {
            this.rebuildParentBranchProblems();
        }
    }

    public final boolean clearAllBranchProblemsInternal() {
        if (this.branchProblems.isEmpty()) {
            return false;
        }
        Iterator iterator = this.children();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            node.clearAllBranchProblemsInternal();
        }
        this.problems.clear();
        this.branchProblems.clear();
        this.firePropertyChanged("hasBranchProblems", true, false);
        this.fireListChanged("branchProblems");
        return true;
    }

    private boolean aspectIsSignificant(String string) {
        return !this.aspectIsInsignificant(string);
    }

    private boolean aspectIsInsignificant(String string) {
        return this.insignificantAspectNames().contains(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Set insignificantAspectNames() {
        Map map = insignificantAspectNameSets;
        synchronized (map) {
            HashSet hashSet = (HashSet)insignificantAspectNameSets.get(this.getClass());
            if (hashSet == null) {
                hashSet = new HashSet();
                this.addInsignificantAspectNamesTo(hashSet);
                insignificantAspectNameSets.put(this.getClass(), hashSet);
            }
            return hashSet;
        }
    }

    protected void addInsignificantAspectNamesTo(Set set) {
        set.add(COMMENT_PROPERTY);
        set.add("dirtyBranch");
        set.add("branchProblems");
        set.add("hasBranchProblems");
    }

    public int compareTo(Object object) {
        return DEFAULT_COMPARATOR.compare(this, object);
    }

    public final String toString() {
        return super.toString();
    }
}

