/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.string;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.tools.workbench.utility.string.PartialStringComparatorEngine;
import org.eclipse.persistence.tools.workbench.utility.string.StringHolder;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public class AffixStrippingPartialStringComparatorEngine
implements PartialStringComparatorEngine {
    private final PartialStringComparatorEngine engine;
    private final ThresholdCalculator thresholdCalculator;
    private final StringHolderWrapperFactory wrapperFactory;

    public static PartialStringComparatorEngine forPrefixStripping(PartialStringComparatorEngine partialStringComparatorEngine) {
        return new AffixStrippingPartialStringComparatorEngine(partialStringComparatorEngine, StringHolderWrapperFactory.PREFIX);
    }

    public static PartialStringComparatorEngine forPrefixStripping(PartialStringComparatorEngine partialStringComparatorEngine, float f) {
        return new AffixStrippingPartialStringComparatorEngine(partialStringComparatorEngine, f, StringHolderWrapperFactory.PREFIX);
    }

    public static PartialStringComparatorEngine forPrefixStripping(PartialStringComparatorEngine partialStringComparatorEngine, int n) {
        return new AffixStrippingPartialStringComparatorEngine(partialStringComparatorEngine, n, StringHolderWrapperFactory.PREFIX);
    }

    public static PartialStringComparatorEngine forSuffixStripping(PartialStringComparatorEngine partialStringComparatorEngine) {
        return new AffixStrippingPartialStringComparatorEngine(partialStringComparatorEngine, StringHolderWrapperFactory.SUFFIX);
    }

    public static PartialStringComparatorEngine forSuffixStripping(PartialStringComparatorEngine partialStringComparatorEngine, float f) {
        return new AffixStrippingPartialStringComparatorEngine(partialStringComparatorEngine, f, StringHolderWrapperFactory.SUFFIX);
    }

    public static PartialStringComparatorEngine forSuffixStripping(PartialStringComparatorEngine partialStringComparatorEngine, int n) {
        return new AffixStrippingPartialStringComparatorEngine(partialStringComparatorEngine, n, StringHolderWrapperFactory.SUFFIX);
    }

    private AffixStrippingPartialStringComparatorEngine(PartialStringComparatorEngine partialStringComparatorEngine, StringHolderWrapperFactory stringHolderWrapperFactory) {
        this(partialStringComparatorEngine, 1.0f, stringHolderWrapperFactory);
    }

    private AffixStrippingPartialStringComparatorEngine(PartialStringComparatorEngine partialStringComparatorEngine, float f, StringHolderWrapperFactory stringHolderWrapperFactory) {
        this.engine = partialStringComparatorEngine;
        this.thresholdCalculator = new VariableThresholdCalculator(f);
        this.wrapperFactory = stringHolderWrapperFactory;
    }

    private AffixStrippingPartialStringComparatorEngine(PartialStringComparatorEngine partialStringComparatorEngine, int n, StringHolderWrapperFactory stringHolderWrapperFactory) {
        this.engine = partialStringComparatorEngine;
        this.thresholdCalculator = new FixedThresholdCalculator(n);
        this.wrapperFactory = stringHolderWrapperFactory;
    }

    public PartialStringComparatorEngine.StringHolderPair[] match(StringHolder[] stringHolderArray, StringHolder[] stringHolderArray2) {
        return this.unwrap(this.engine.match(this.wrap(stringHolderArray), this.wrap(stringHolderArray2)));
    }

    private StringHolder[] wrap(StringHolder[] stringHolderArray) {
        int n = stringHolderArray.length;
        StringHolder[] stringHolderArray2 = new StringHolderWrapper[n];
        int n2 = n;
        while (n2-- > 0) {
            stringHolderArray2[n2] = this.wrap(stringHolderArray[n2]);
        }
        if (n > 1 && (n2 = this.thresholdCalculator.thresholdCountFor(stringHolderArray2)) > 1) {
            this.stripAffixes((StringHolderWrapper[])stringHolderArray2, n2);
        }
        return stringHolderArray2;
    }

    private StringHolderWrapper wrap(StringHolder stringHolder) {
        return this.wrapperFactory.buildStringHolderWrapper(stringHolder);
    }

    private void stripAffixes(StringHolderWrapper[] stringHolderWrapperArray, int n) {
        StringHolderWrapper[] stringHolderWrapperArray2;
        HashMap<StringHolderWrapper[], ArrayList<Object>> hashMap = new HashMap<StringHolderWrapper[], ArrayList<Object>>(100);
        int n2 = stringHolderWrapperArray.length;
        while (n2-- > 0) {
            Map.Entry entry = stringHolderWrapperArray[n2];
            char c = ((StringHolderWrapper)((Object)entry)).outsideChar();
            if (c == '\u0000') continue;
            stringHolderWrapperArray2 = new Character(c);
            ArrayList<Object> arrayList = (ArrayList<Object>)hashMap.get(stringHolderWrapperArray2);
            if (arrayList == null) {
                arrayList = new ArrayList<Object>();
                hashMap.put(stringHolderWrapperArray2, arrayList);
            }
            arrayList.add(entry);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            ArrayList arrayList = (ArrayList)entry.getValue();
            if (arrayList.size() < n) continue;
            stringHolderWrapperArray2 = arrayList.toArray(new StringHolderWrapper[arrayList.size()]);
            int n3 = stringHolderWrapperArray2.length;
            while (n3-- > 0) {
                stringHolderWrapperArray2[n3].incrementAffixSize();
            }
            this.stripAffixes(stringHolderWrapperArray2, n);
        }
    }

    private PartialStringComparatorEngine.StringHolderPair[] unwrap(PartialStringComparatorEngine.StringHolderPair[] stringHolderPairArray) {
        PartialStringComparatorEngine.StringHolderPair[] stringHolderPairArray2 = new PartialStringComparatorEngine.StringHolderPair[stringHolderPairArray.length];
        int n = stringHolderPairArray.length;
        while (n-- > 0) {
            PartialStringComparatorEngine.StringHolderPair stringHolderPair = stringHolderPairArray[n];
            stringHolderPairArray2[n] = new PartialStringComparatorEngine.SimpleStringHolderPair(this.unwrap(stringHolderPair.getStringHolder1()), this.unwrap(stringHolderPair.getStringHolder2()), stringHolderPair.getScore());
        }
        return stringHolderPairArray2;
    }

    private StringHolder unwrap(StringHolder stringHolder) {
        return stringHolder == null ? null : ((StringHolderWrapper)stringHolder).getStringHolder();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        StringTools.buildSimpleToStringOn(this, stringBuffer);
        stringBuffer.append(" (");
        this.wrapperFactory.toString(stringBuffer);
        stringBuffer.append(" : ");
        this.thresholdCalculator.toString(stringBuffer);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    private static class StringHolderWrapper
    implements StringHolder {
        private final AffixPolicy affixPolicy;
        private final StringHolder stringHolder;
        private int stringHolderStringLength;
        private int affixLength;
        private String string;

        static StringHolderWrapper forPrefixStripping(StringHolder stringHolder) {
            return new StringHolderWrapper(stringHolder, AffixPolicy.PREFIX);
        }

        static StringHolderWrapper forSuffixStripping(StringHolder stringHolder) {
            return new StringHolderWrapper(stringHolder, AffixPolicy.SUFFIX);
        }

        private StringHolderWrapper(StringHolder stringHolder, AffixPolicy affixPolicy) {
            this.stringHolder = stringHolder;
            this.stringHolderStringLength = stringHolder.getString().length();
            this.affixPolicy = affixPolicy;
            this.affixLength = 0;
            this.string = null;
        }

        public String getString() {
            if (this.string == null) {
                this.string = this.buildString();
            }
            return this.string;
        }

        private String buildString() {
            return this.affixPolicy.buildString(this.stringHolder.getString(), this.affixLength);
        }

        StringHolder getStringHolder() {
            return this.stringHolder;
        }

        char outsideChar() {
            return this.affixLength == this.stringHolderStringLength ? (char)'\u0000' : this.affixPolicy.outsideChar(this.stringHolder.getString(), this.affixLength);
        }

        void incrementAffixSize() {
            if (this.affixLength < this.stringHolderStringLength) {
                ++this.affixLength;
            }
        }

        public String toString() {
            return StringTools.buildToStringFor(this, this.buildString());
        }

        private static interface AffixPolicy {
            public static final AffixPolicy PREFIX = new AffixPolicy(){

                public String buildString(String string, int n) {
                    return string.substring(n);
                }

                public char outsideChar(String string, int n) {
                    return string.charAt(n);
                }
            };
            public static final AffixPolicy SUFFIX = new AffixPolicy(){

                public String buildString(String string, int n) {
                    return string.substring(0, string.length() - n);
                }

                public char outsideChar(String string, int n) {
                    return string.charAt(string.length() - n - 1);
                }
            };

            public String buildString(String var1, int var2);

            public char outsideChar(String var1, int var2);
        }
    }

    private static interface StringHolderWrapperFactory {
        public static final StringHolderWrapperFactory PREFIX = new StringHolderWrapperFactory(){

            public StringHolderWrapper buildStringHolderWrapper(StringHolder stringHolder) {
                return StringHolderWrapper.forPrefixStripping(stringHolder);
            }

            public void toString(StringBuffer stringBuffer) {
                stringBuffer.append("PREFIX");
            }
        };
        public static final StringHolderWrapperFactory SUFFIX = new StringHolderWrapperFactory(){

            public StringHolderWrapper buildStringHolderWrapper(StringHolder stringHolder) {
                return StringHolderWrapper.forSuffixStripping(stringHolder);
            }

            public void toString(StringBuffer stringBuffer) {
                stringBuffer.append("SUFFIX");
            }
        };

        public StringHolderWrapper buildStringHolderWrapper(StringHolder var1);

        public void toString(StringBuffer var1);
    }

    private class FixedThresholdCalculator
    implements ThresholdCalculator {
        private int count;

        FixedThresholdCalculator(int n) {
            if (n <= 1) {
                throw new IllegalArgumentException("valid range: count > 1");
            }
            this.count = n;
        }

        public int thresholdCountFor(StringHolder[] stringHolderArray) {
            return this.count;
        }

        public void toString(StringBuffer stringBuffer) {
            stringBuffer.append(this.count);
        }
    }

    private class VariableThresholdCalculator
    implements ThresholdCalculator {
        private float factor;

        VariableThresholdCalculator(float f) {
            if (f <= 0.0f || f > 1.0f) {
                throw new IllegalArgumentException("valid range: 0.0 < factor <= 1.0");
            }
            this.factor = f;
        }

        public int thresholdCountFor(StringHolder[] stringHolderArray) {
            return (int)((float)stringHolderArray.length * this.factor);
        }

        public void toString(StringBuffer stringBuffer) {
            stringBuffer.append(this.factor);
        }
    }

    private static interface ThresholdCalculator {
        public int thresholdCountFor(StringHolder[] var1);

        public void toString(StringBuffer var1);
    }
}

