/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.annotations.IdValidation;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.columns.ColumnMetadata;

public class PrimaryKeyMetadata
extends ORMetadata {
    private Enum m_validation;
    private List<ColumnMetadata> m_columns = new ArrayList<ColumnMetadata>();

    public PrimaryKeyMetadata() {
        super("<primary-key>");
    }

    public PrimaryKeyMetadata(Annotation annotation, MetadataAccessibleObject metadataAccessibleObject) {
        super(annotation, metadataAccessibleObject);
        this.m_validation = (Enum)MetadataHelper.invokeMethod("validation", annotation);
        for (Annotation annotation2 : (Annotation[])MetadataHelper.invokeMethod("columns", annotation)) {
            this.m_columns.add(new ColumnMetadata(annotation2, metadataAccessibleObject));
        }
    }

    public boolean hasColumns() {
        return !this.m_columns.isEmpty();
    }

    public void process(MetadataDescriptor metadataDescriptor) {
        metadataDescriptor.getClassDescriptor().setIdValidation(IdValidation.valueOf((String)this.m_validation.name()));
        if (this.hasColumns()) {
            ArrayList<DatabaseField> arrayList = new ArrayList<DatabaseField>(this.m_columns.size());
            for (ColumnMetadata columnMetadata : this.m_columns) {
                if (columnMetadata.getName().equals("")) {
                    throw ValidationException.optimisticLockingSelectedColumnNamesNotSpecified((Class)metadataDescriptor.getJavaClass());
                }
                arrayList.add(columnMetadata.getDatabaseField());
            }
            metadataDescriptor.getClassDescriptor().setPrimaryKeyFields(arrayList);
        }
    }
}

