/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper;

import commonj.sdo.Type;
import commonj.sdo.helper.HelperContext;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.localization.ToStringLocalization;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.sdo.SDOConstants;
import org.eclipse.persistence.sdo.SDOProperty;
import org.eclipse.persistence.sdo.SDOType;
import org.eclipse.persistence.sdo.helper.ClassBuffer;
import org.eclipse.persistence.sdo.helper.CodeWriter;
import org.eclipse.persistence.sdo.helper.DefaultSchemaResolver;
import org.eclipse.persistence.sdo.helper.FileCodeWriter;
import org.eclipse.persistence.sdo.helper.SDOClassGeneratorListener;
import org.eclipse.persistence.sdo.helper.SDOHelperContext;
import org.eclipse.persistence.sdo.helper.SDOTypesGenerator;
import org.eclipse.persistence.sdo.helper.SchemaResolver;
import org.eclipse.persistence.sdo.helper.extension.SDOUtil;

public class SDOClassGenerator {
    private String indent = "";
    private static int INDENT_TAB = 3;
    private static final String lsep = System.getProperty("line.separator");
    private static final String lsep2 = lsep + lsep;
    private static final String START_PROPERTY_INDEX = "START_PROPERTY_INDEX";
    private Map generatedBuffers;
    private boolean interfaceGenerator = true;
    private boolean implGenerator = true;
    private CodeWriter codeWriter;
    private SDOClassGeneratorListener sdoClassGeneratorListener;
    private HelperContext aHelperContext;

    public SDOClassGenerator() {
        this(new SDOHelperContext());
    }

    public SDOClassGenerator(HelperContext helperContext) {
        this.aHelperContext = helperContext;
        this.generatedBuffers = new HashMap();
    }

    public void setInterfaceGenerator(boolean bl) {
        this.interfaceGenerator = bl;
    }

    public void setImplGenerator(boolean bl) {
        this.implGenerator = bl;
    }

    public static void main(String[] stringArray) {
        SDOClassGenerator sDOClassGenerator = new SDOClassGenerator(new SDOHelperContext());
        String string = null;
        String string2 = null;
        int n = stringArray.length;
        AbstractSessionLog.getLog().setLevel(2);
        for (int i = 0; i < n; ++i) {
            if (stringArray[i].equals("-help")) {
                sDOClassGenerator.printUsage(null);
                System.exit(0);
                continue;
            }
            if (stringArray[i].equals("-sourceFile")) {
                if (i == n - 1) {
                    sDOClassGenerator.printUsage("sdo_classgenerator_usage_missing_sourcefile_value");
                    System.exit(0);
                }
                string2 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-targetDirectory")) {
                if (i == n - 1) {
                    sDOClassGenerator.printUsage("sdo_classgenerator_usage_missing_targetdir");
                    System.exit(0);
                }
                string = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-logLevel")) {
                if (i == n - 1) continue;
                AbstractSessionLog.getLog().setLevel(Integer.parseInt(stringArray[++i]));
                continue;
            }
            if (stringArray[i].equals("-noInterfaces")) {
                sDOClassGenerator.setInterfaceGenerator(false);
                continue;
            }
            if (!stringArray[i].equals("-noImpls")) continue;
            sDOClassGenerator.setImplGenerator(false);
        }
        if (null == string2) {
            sDOClassGenerator.printUsage("sdo_classgenerator_usage_missing_sourcefile");
            System.exit(0);
        }
        try {
            FileReader fileReader = new FileReader(string2);
            FileCodeWriter fileCodeWriter = new FileCodeWriter();
            fileCodeWriter.setSourceDir(string);
            sDOClassGenerator.generate((Reader)fileReader, (CodeWriter)fileCodeWriter, (SchemaResolver)new DefaultSchemaResolver());
        }
        catch (IOException iOException) {
            AbstractSessionLog.getLog().log(7, "sdo_classgenerator_exception", (Object)iOException.getClass().getName(), (Object)iOException.getLocalizedMessage(), sDOClassGenerator.getClass());
            AbstractSessionLog.getLog().logThrowable(7, (Throwable)iOException);
        }
    }

    private void printUsage(String string) {
        if (null != string) {
            System.out.println(ToStringLocalization.buildMessage((String)string, (Object[])new Object[]{Helper.getShortClassName(this.getClass())}));
        }
        String string2 = ToStringLocalization.buildMessage((String)"sdo_classgenerator_usage_help_1of8", (Object[])new Object[]{Helper.getShortClassName(this.getClass())});
        string2 = string2 + Helper.cr() + Helper.cr();
        string2 = string2 + ToStringLocalization.buildMessage((String)"sdo_classgenerator_usage_help_2of8");
        string2 = string2 + Helper.cr();
        string2 = string2 + ToStringLocalization.buildMessage((String)"sdo_classgenerator_usage_help_3of8");
        string2 = string2 + Helper.cr();
        string2 = string2 + ToStringLocalization.buildMessage((String)"sdo_classgenerator_usage_help_4of8");
        string2 = string2 + Helper.cr();
        string2 = string2 + ToStringLocalization.buildMessage((String)"sdo_classgenerator_usage_help_5of8");
        string2 = string2 + Helper.cr();
        string2 = string2 + ToStringLocalization.buildMessage((String)"sdo_classgenerator_usage_help_6of8");
        string2 = string2 + Helper.cr();
        string2 = string2 + ToStringLocalization.buildMessage((String)"sdo_classgenerator_usage_help_7of8");
        string2 = string2 + Helper.cr();
        string2 = string2 + ToStringLocalization.buildMessage((String)"sdo_classgenerator_usage_help_8of8");
        string2 = string2 + Helper.cr();
        System.out.println(string2);
    }

    public Map generate(Reader reader) {
        FileCodeWriter fileCodeWriter = new FileCodeWriter();
        return this.generate((Source)new StreamSource(reader), (CodeWriter)fileCodeWriter, (SchemaResolver)new DefaultSchemaResolver());
    }

    public Map generate(Reader reader, String string) {
        FileCodeWriter fileCodeWriter = new FileCodeWriter();
        fileCodeWriter.setSourceDir(string);
        return this.generate((Source)new StreamSource(reader), (CodeWriter)fileCodeWriter, (SchemaResolver)new DefaultSchemaResolver());
    }

    public Map generate(Reader reader, String string, SchemaResolver schemaResolver) {
        FileCodeWriter fileCodeWriter = new FileCodeWriter();
        fileCodeWriter.setSourceDir(string);
        return this.generate((Source)new StreamSource(reader), (CodeWriter)fileCodeWriter, schemaResolver);
    }

    public Map generate(Reader reader, SchemaResolver schemaResolver) {
        return this.generate((Source)new StreamSource(reader), (CodeWriter)new FileCodeWriter(), schemaResolver);
    }

    public Map generate(Reader reader, CodeWriter codeWriter) {
        return this.generate((Source)new StreamSource(reader), codeWriter, (SchemaResolver)new DefaultSchemaResolver());
    }

    public Map generate(Reader reader, CodeWriter codeWriter, SchemaResolver schemaResolver) {
        return this.generate(new StreamSource(reader), codeWriter, schemaResolver, true);
    }

    public Map generate(Reader reader, CodeWriter codeWriter, SchemaResolver schemaResolver, boolean bl) {
        return this.generate(new StreamSource(reader), codeWriter, schemaResolver, bl);
    }

    public Map generate(Source source, String string) {
        FileCodeWriter fileCodeWriter = new FileCodeWriter();
        fileCodeWriter.setSourceDir(string);
        return this.generate(source, (CodeWriter)fileCodeWriter, (SchemaResolver)new DefaultSchemaResolver());
    }

    public Map generate(Source source, String string, SchemaResolver schemaResolver) {
        FileCodeWriter fileCodeWriter = new FileCodeWriter();
        fileCodeWriter.setSourceDir(string);
        return this.generate(source, (CodeWriter)fileCodeWriter, schemaResolver);
    }

    public Map generate(Source source, SchemaResolver schemaResolver) {
        return this.generate(source, (CodeWriter)new FileCodeWriter(), schemaResolver, true);
    }

    public Map generate(Source source, CodeWriter codeWriter) {
        return this.generate(source, codeWriter, (SchemaResolver)new DefaultSchemaResolver(), true);
    }

    public Map generate(Source source, CodeWriter codeWriter, SchemaResolver schemaResolver) {
        return this.generate(source, codeWriter, schemaResolver, true);
    }

    public Map generate(Source source, CodeWriter codeWriter, SchemaResolver schemaResolver, boolean bl) {
        SDOTypesGenerator sDOTypesGenerator = new SDOTypesGenerator(this.aHelperContext);
        List<Type> list = sDOTypesGenerator.define(source, schemaResolver, true, bl);
        return this.generate(codeWriter, list);
    }

    public Map generate(CodeWriter codeWriter, List list) {
        this.generatedBuffers = new HashMap();
        this.codeWriter = codeWriter;
        for (int i = 0; i < list.size(); ++i) {
            SDOType sDOType = (SDOType)list.get(i);
            if (sDOType.isDataType()) continue;
            ClassBuffer classBuffer = this.buildClassForType(sDOType);
            String string = classBuffer.getPackageName();
            string = string.replace('.', '/');
            if (this.interfaceGenerator) {
                this.getCodeWriter().writeInterface(string, classBuffer.getInterfaceName() + ".java", classBuffer.getInterfaceBuffer());
            }
            if (!this.implGenerator) continue;
            this.getCodeWriter().writeImpl(string, classBuffer.getClassName() + ".java", classBuffer.getClassBuffer());
        }
        return this.generatedBuffers;
    }

    private ClassBuffer buildClassForType(SDOType sDOType) {
        Object object;
        String string;
        ClassBuffer classBuffer = new ClassBuffer(this.sdoClassGeneratorListener);
        classBuffer.setSdoType(sDOType);
        classBuffer.setGenerateInterface(this.interfaceGenerator);
        classBuffer.setSdoTypeName(sDOType.getName());
        StringBuffer stringBuffer = new StringBuffer();
        if (this.sdoClassGeneratorListener != null) {
            this.sdoClassGeneratorListener.preImplPackage(stringBuffer);
        }
        String string2 = null;
        int n = sDOType.getInstanceClassName().lastIndexOf(46);
        if (n > -1) {
            string2 = sDOType.getInstanceClassName().substring(0, n);
        }
        stringBuffer.append(this.indent);
        stringBuffer.append("package ");
        if (sDOType.getURI() != null && !sDOType.getURI().equals("")) {
            classBuffer.setUri(sDOType.getURI());
        }
        stringBuffer.append(string2);
        classBuffer.setPackageName(string2);
        stringBuffer.append(";").append(lsep2);
        if (this.sdoClassGeneratorListener != null) {
            this.sdoClassGeneratorListener.preImplImports(stringBuffer);
        }
        stringBuffer.append("import ").append("org.eclipse.persistence.sdo.SDODataObject").append(";").append(lsep2);
        List list = (List)sDOType.get(SDOConstants.DOCUMENTATION_PROPERTY);
        if (list != null && list.size() > 0) {
            stringBuffer.append(this.indent);
            stringBuffer.append(this.buildJavaDoc(list));
        }
        if (this.sdoClassGeneratorListener != null) {
            this.sdoClassGeneratorListener.preImplClass(stringBuffer);
        }
        stringBuffer.append(this.indent);
        stringBuffer.append("public class ");
        String string3 = string = Helper.getShortClassName((String)sDOType.getInstanceClassName());
        classBuffer.setInterfaceName(string3);
        String string4 = string + "Impl";
        stringBuffer.append(string4 + " ");
        classBuffer.setClassName(string4);
        String string5 = null;
        String string6 = null;
        if (sDOType.isSubType()) {
            object = (SDOType)sDOType.getBaseTypes().get(0);
            if (!((SDOType)object).isDataType()) {
                string6 = ((SDOType)object).getInstanceClassName();
                string5 = ((SDOType)object).getImplClassName();
            }
        } else {
            string5 = "SDODataObject";
        }
        stringBuffer.append("extends ").append(string5);
        if (this.interfaceGenerator) {
            stringBuffer.append(" implements ").append(string3);
        }
        classBuffer.getAttributeBuffer().append(this.buildStartAndEndPropAttribute(sDOType));
        classBuffer.getMethodBuffer().append(this.buildNoArgCtor(string4));
        stringBuffer.append(this.indent).append(" {").append(lsep2);
        if (this.interfaceGenerator) {
            object = new StringBuffer();
            if (this.sdoClassGeneratorListener != null) {
                this.sdoClassGeneratorListener.preInterfacePackage((StringBuffer)object);
            }
            ((StringBuffer)object).append(this.indent);
            ((StringBuffer)object).append("package ");
            ((StringBuffer)object).append(string2);
            ((StringBuffer)object).append(";").append(lsep2);
            if (this.sdoClassGeneratorListener != null) {
                this.sdoClassGeneratorListener.preInterfaceImports((StringBuffer)object);
            }
            if (this.sdoClassGeneratorListener != null) {
                this.sdoClassGeneratorListener.preInterfaceClass((StringBuffer)object);
            }
            ((StringBuffer)object).append(this.indent);
            ((StringBuffer)object).append("public interface ");
            ((StringBuffer)object).append(string3);
            if (string6 != null) {
                ((StringBuffer)object).append(" extends " + string6);
            }
            ((StringBuffer)object).append(this.indent).append(" {").append(lsep2);
            classBuffer.setInterfaceBuffer((StringBuffer)object);
        }
        classBuffer.setClassBuffer(stringBuffer);
        this.getGeneratedBuffers().put(new QName(sDOType.getURI(), sDOType.getName()), classBuffer);
        object = sDOType.getDeclaredProperties();
        int n2 = object.size();
        for (int i = 0; i < n2; ++i) {
            SDOProperty sDOProperty = (SDOProperty)object.get(i);
            this.buildGetterAndSetter(classBuffer, sDOProperty);
        }
        classBuffer.close();
        return classBuffer;
    }

    private void addJavaDocLinesToBuffer(StringBuffer stringBuffer, List list, boolean bl) {
        for (int i = 0; i < list.size(); ++i) {
            String string = (String)list.get(i);
            StringTokenizer stringTokenizer = new StringTokenizer(string, lsep);
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                if (string2.length() > 0) {
                    if (n > 0 || n == 0 && !bl) {
                        stringBuffer.append(this.indent).append(" * ");
                    }
                    stringBuffer.append(string2).append(lsep);
                }
                ++n;
            }
            if (i >= list.size() - 1) continue;
            stringBuffer.append(this.indent).append(" * ");
        }
    }

    private StringBuffer buildJavaDoc(List list) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("/**").append(lsep);
        this.addJavaDocLinesToBuffer(stringBuffer, list, false);
        stringBuffer.append(" */").append(lsep);
        return stringBuffer;
    }

    private StringBuffer buildGetterJavaDoc(List list, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.indent).append("/**").append(lsep);
        stringBuffer.append(this.indent).append(" * ").append("Gets ").append(string).append(".").append(lsep);
        stringBuffer.append(this.indent).append(" * ").append("return ");
        this.addJavaDocLinesToBuffer(stringBuffer, list, true);
        stringBuffer.append(this.indent).append(" */").append(lsep);
        return stringBuffer;
    }

    private StringBuffer buildSetterJavaDoc(List list, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.indent).append("/**").append(lsep);
        stringBuffer.append(this.indent).append(" * ").append("Sets ").append(string).append(".").append(lsep);
        stringBuffer.append(this.indent).append(" * ").append("param value ");
        this.addJavaDocLinesToBuffer(stringBuffer, list, true);
        stringBuffer.append(this.indent).append(" */").append(lsep);
        return stringBuffer;
    }

    private StringBuffer buildStartAndEndPropAttribute(SDOType sDOType) {
        StringBuffer stringBuffer = new StringBuffer();
        this.pushIndent();
        int n = sDOType.getDeclaredProperties().size();
        stringBuffer.append(this.indent).append("public static final int START_PROPERTY_INDEX = ");
        if (sDOType.isSubType()) {
            String string = ((SDOType)sDOType.getBaseTypes().get(0)).getImplClassName();
            stringBuffer.append(string).append(".END_PROPERTY_INDEX");
            if (n > 0) {
                stringBuffer.append(" + 1");
            }
            stringBuffer.append(";");
        } else if (n > 0) {
            stringBuffer.append("0;");
        } else {
            stringBuffer.append("-1;");
        }
        stringBuffer.append(lsep2);
        int n2 = 0;
        n2 = n > 0 ? n - 1 : 0;
        stringBuffer.append(this.indent).append("public static final int END_PROPERTY_INDEX = START_PROPERTY_INDEX + ").append(n2).append(";").append(lsep2);
        this.popIndent();
        return stringBuffer;
    }

    private StringBuffer buildNoArgCtor(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        this.pushIndent();
        stringBuffer.append(this.indent).append("public ").append(string).append("() {}").append(lsep2);
        this.popIndent();
        return stringBuffer;
    }

    private void buildGetterAndSetter(ClassBuffer classBuffer, SDOProperty sDOProperty) {
        this.pushIndent();
        List list = (List)sDOProperty.get(SDOConstants.DOCUMENTATION_PROPERTY);
        this.buildGetMethodBuffer(classBuffer, sDOProperty, list);
        this.buildSetMethodBuffer(classBuffer, sDOProperty, list);
        this.popIndent();
    }

    private void buildGetMethodBuffer(ClassBuffer classBuffer, SDOProperty sDOProperty, List list) {
        String string = SDOUtil.getJavaTypeForProperty(sDOProperty);
        String string2 = SDOUtil.getMethodName(sDOProperty.getName(), string);
        if (!sDOProperty.getType().isChangeSummaryType() || !string2.equals("getChangeSummary")) {
            if (list != null && list.size() > 0) {
                classBuffer.getMethodBuffer().append(this.buildGetterJavaDoc(list, sDOProperty.getName()));
            }
            classBuffer.getMethodBuffer().append(this.indent);
            classBuffer.getMethodBuffer().append("public ");
            classBuffer.getMethodBuffer().append(string).append(" ");
            classBuffer.getMethodBuffer().append(string2);
            classBuffer.getMethodBuffer().append("() {").append(lsep);
            this.pushIndent();
            classBuffer.getMethodBuffer().append(this.indent).append("return ");
            String string3 = SDOUtil.getBuiltInType(string);
            if (string3 != null) {
                String string4 = this.getWrapperCall(string);
                if (string4 != null) {
                    classBuffer.getMethodBuffer().append(string4);
                }
                classBuffer.getMethodBuffer().append("get").append(string3).append("(");
                classBuffer.getMethodBuffer().append(START_PROPERTY_INDEX).append(" + ").append(sDOProperty.getIndexInDeclaredProperties());
                classBuffer.getMethodBuffer().append(")");
                if (string4 != null) {
                    classBuffer.getMethodBuffer().append(")");
                }
            } else {
                if (!string.equals(ClassConstants.OBJECT.getName())) {
                    classBuffer.getMethodBuffer().append("(");
                    classBuffer.getMethodBuffer().append(string).append(")");
                }
                classBuffer.getMethodBuffer().append("get(");
                classBuffer.getMethodBuffer().append(START_PROPERTY_INDEX).append(" + ").append(sDOProperty.getIndexInDeclaredProperties());
                classBuffer.getMethodBuffer().append(")");
            }
            classBuffer.getMethodBuffer().append(";").append(lsep);
            this.popIndent();
            classBuffer.getMethodBuffer().append(this.indent).append("}").append(lsep2);
        }
        if (this.interfaceGenerator) {
            classBuffer.getInterfaceBuffer().append(this.indent);
            classBuffer.getInterfaceBuffer().append("public ");
            classBuffer.getInterfaceBuffer().append(string).append(" ");
            classBuffer.getInterfaceBuffer().append(string2);
            classBuffer.getInterfaceBuffer().append("();").append(lsep2);
        }
    }

    private void buildSetMethodBuffer(ClassBuffer classBuffer, SDOProperty sDOProperty, List list) {
        if (sDOProperty.getType().isChangeSummaryType()) {
            return;
        }
        if (list != null && list.size() > 0) {
            classBuffer.getMethodBuffer().append(this.buildSetterJavaDoc(list, sDOProperty.getName()));
        }
        classBuffer.getMethodBuffer().append(this.indent);
        classBuffer.getMethodBuffer().append("public void ");
        String string = SDOUtil.setMethodName(sDOProperty.getName());
        classBuffer.getMethodBuffer().append(string);
        classBuffer.getMethodBuffer().append("(");
        String string2 = SDOUtil.getJavaTypeForProperty(sDOProperty);
        classBuffer.getMethodBuffer().append(string2).append(" value");
        classBuffer.getMethodBuffer().append(")").append(" {").append(lsep);
        this.pushIndent();
        classBuffer.getMethodBuffer().append(this.indent).append("set(");
        classBuffer.getMethodBuffer().append(START_PROPERTY_INDEX).append(" + ").append(sDOProperty.getIndexInDeclaredProperties());
        classBuffer.getMethodBuffer().append(" , value)");
        classBuffer.getMethodBuffer().append(";").append(lsep);
        this.popIndent();
        classBuffer.getMethodBuffer().append(this.indent).append("}");
        classBuffer.getMethodBuffer().append(lsep2);
        if (this.interfaceGenerator) {
            classBuffer.getInterfaceBuffer().append(this.indent);
            classBuffer.getInterfaceBuffer().append("public void ");
            classBuffer.getInterfaceBuffer().append(string);
            classBuffer.getInterfaceBuffer().append("(");
            classBuffer.getInterfaceBuffer().append(string2).append(" value");
            classBuffer.getInterfaceBuffer().append(");").append(lsep2);
        }
    }

    private void pushIndent() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < INDENT_TAB; ++i) {
            stringBuffer.append(" ");
        }
        this.indent = this.indent + stringBuffer.toString();
    }

    private void popIndent() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.indent.length() - INDENT_TAB;
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" ");
        }
        this.indent = stringBuffer.toString();
    }

    public void setGeneratedBuffers(Map map) {
        this.generatedBuffers = map;
    }

    public Map getGeneratedBuffers() {
        return this.generatedBuffers;
    }

    private String getWrapperCall(String string) {
        if (string.equals("java.lang.Integer")) {
            return "new Integer(";
        }
        if (string.equals("java.lang.Boolean")) {
            return "new Boolean(";
        }
        if (string.equals("java.lang.Short")) {
            return "new Short(";
        }
        if (string.equals("java.lang.Float")) {
            return "new Float(";
        }
        if (string.equals("java.lang.Double")) {
            return "new Double(";
        }
        if (string.equals("java.lang.Byte")) {
            return "new Byte(";
        }
        return null;
    }

    public void setCodeWriter(CodeWriter codeWriter) {
        this.codeWriter = codeWriter;
    }

    public CodeWriter getCodeWriter() {
        return this.codeWriter;
    }

    public void setSDOClassGeneratorListener(SDOClassGeneratorListener sDOClassGeneratorListener) {
        this.sdoClassGeneratorListener = sDOClassGeneratorListener;
    }

    public SDOClassGeneratorListener getSDOClassGeneratorListener() {
        return this.sdoClassGeneratorListener;
    }
}

