/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.eis;

import java.util.Vector;
import org.eclipse.persistence.internal.sessions.CollectionChangeRecord;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.mappings.DatabaseMapping;

public class EISCollectionChangeRecord
extends CollectionChangeRecord
implements org.eclipse.persistence.sessions.changesets.EISCollectionChangeRecord {
    private Vector adds;
    private Vector removes;
    private Vector changedMapKeys;

    public EISCollectionChangeRecord(ObjectChangeSet objectChangeSet, String string, DatabaseMapping databaseMapping) {
        this.owner = objectChangeSet;
        this.attribute = string;
        this.mapping = databaseMapping;
    }

    public void addAddedChangeSet(Object object) {
        this.getAdds().addElement(object);
    }

    public void addChangedMapKeyChangeSet(Object object) {
        this.getChangedMapKeys().addElement(object);
    }

    public void addRemovedChangeSet(Object object) {
        this.getRemoves().addElement(object);
    }

    public Vector getAdds() {
        if (this.adds == null) {
            this.adds = new Vector(1);
        }
        return this.adds;
    }

    public Vector getChangedMapKeys() {
        if (this.changedMapKeys == null) {
            this.changedMapKeys = new Vector(1);
        }
        return this.changedMapKeys;
    }

    public Vector getRemoves() {
        if (this.removes == null) {
            this.removes = new Vector(1);
        }
        return this.removes;
    }

    private boolean hasAdds() {
        return this.adds != null && !this.adds.isEmpty();
    }

    private boolean hasChangedMapKeys() {
        return this.changedMapKeys != null && !this.changedMapKeys.isEmpty();
    }

    public boolean hasChanges() {
        return this.hasAdds() || this.hasRemoves() || this.hasChangedMapKeys() || this.getOwner().isNew();
    }

    private boolean hasRemoves() {
        return this.removes != null && !this.removes.isEmpty();
    }

    private boolean removeAddedChangeSet(Object object) {
        if (this.adds == null) {
            return false;
        }
        return this.adds.remove(object);
    }

    private boolean removeRemovedChangeSet(Object object) {
        if (this.removes == null) {
            return false;
        }
        return this.removes.remove(object);
    }

    public void simpleAddChangeSet(Object object) {
        if (!this.removeRemovedChangeSet(object)) {
            this.addAddedChangeSet(object);
        }
    }

    public void simpleRemoveChangeSet(Object object) {
        if (!this.removeAddedChangeSet(object)) {
            this.addRemovedChangeSet(object);
        }
    }
}

