/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.queries;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.DescriptorEvent;
import org.eclipse.persistence.descriptors.DescriptorEventManager;
import org.eclipse.persistence.descriptors.DescriptorQueryManager;
import org.eclipse.persistence.descriptors.VersionLockingPolicy;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.AggregateChangeRecord;
import org.eclipse.persistence.internal.sessions.CommitManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.TransformationMappingChangeRecord;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.AggregateObjectMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.foundation.AbstractTransformationMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DoesExistQuery;
import org.eclipse.persistence.queries.ModifyQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.WriteObjectQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.tools.profiler.QueryMonitor;

public abstract class DatabaseQueryMechanism
implements Cloneable,
Serializable {
    protected DatabaseQuery query;

    public DatabaseQueryMechanism() {
    }

    public DatabaseQueryMechanism(DatabaseQuery databaseQuery) {
        this.query = databaseQuery;
    }

    protected void addWriteLockFieldForInsert() {
        if (this.getDescriptor().usesOptimisticLocking()) {
            this.getDescriptor().getOptimisticLockingPolicy().setupWriteFieldsForInsert(this.getWriteObjectQuery());
        }
    }

    public void buildSelectionCriteria(AbstractSession abstractSession) {
    }

    public Object checkCacheForObject(AbstractRecord abstractRecord, AbstractSession abstractSession) {
        if (abstractRecord == null || abstractRecord.isEmpty()) {
            return null;
        }
        Vector vector = this.query.getCall() == null ? this.query.getArguments() : this.query.getCall().getParameters();
        ClassDescriptor classDescriptor = this.getDescriptor();
        List<DatabaseField> list = classDescriptor.getPrimaryKeyFields();
        Vector<Object> vector2 = new Vector<Object>(list.size());
        for (DatabaseField databaseField : list) {
            if (vector.contains(databaseField)) {
                Object object = abstractRecord.get(databaseField);
                if (object == null) {
                    return null;
                }
                vector2.add(object);
                continue;
            }
            return null;
        }
        if (classDescriptor.shouldAcquireCascadedLocks()) {
            return abstractSession.getIdentityMapAccessorInstance().getFromIdentityMapWithDeferredLock(vector2, this.getReadObjectQuery().getReferenceClass(), false, classDescriptor);
        }
        return abstractSession.getIdentityMapAccessorInstance().getFromIdentityMap(vector2, this.getReadObjectQuery().getReferenceClass(), false, classDescriptor);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public DatabaseQueryMechanism clone(DatabaseQuery databaseQuery) {
        DatabaseQueryMechanism databaseQueryMechanism = (DatabaseQueryMechanism)this.clone();
        databaseQueryMechanism.setQuery(databaseQuery);
        return databaseQueryMechanism;
    }

    public abstract DatabaseCall cursorSelectAllRows() throws DatabaseException;

    public boolean isJPQLCallQueryMechanism() {
        return false;
    }

    public abstract Integer deleteAll() throws DatabaseException;

    public abstract Integer deleteObject() throws DatabaseException;

    public abstract Integer executeNoSelect() throws DatabaseException;

    public abstract Vector executeSelect() throws DatabaseException;

    public Object executeWrite() throws DatabaseException, OptimisticLockException {
        WriteObjectQuery writeObjectQuery = this.getWriteObjectQuery();
        Object object = writeObjectQuery.getObject();
        CommitManager commitManager = this.getSession().getCommitManager();
        if (commitManager.isCommitCompletedOrInPost(object)) {
            return object;
        }
        if (commitManager.isCommitInPreModify(object)) {
            this.shallowInsertObjectForWrite(object, writeObjectQuery, commitManager);
            return object;
        }
        try {
            this.getSession().beginTransaction();
            if (writeObjectQuery.getObjectChangeSet() == null && this.getDescriptor().getEventManager().hasAnyEventListeners()) {
                this.getDescriptor().getEventManager().executeEvent(new DescriptorEvent(0, writeObjectQuery));
            }
            writeObjectQuery.executeCommit();
            if (this.getDescriptor().getEventManager().hasAnyEventListeners()) {
                this.getDescriptor().getEventManager().executeEvent(new DescriptorEvent(1, writeObjectQuery));
            }
            this.getSession().commitTransaction();
            commitManager.markCommitCompleted(object);
            return object;
        }
        catch (RuntimeException runtimeException) {
            this.getSession().rollbackTransaction();
            commitManager.markCommitCompleted(object);
            throw runtimeException;
        }
    }

    public Object executeWriteWithChangeSet() throws DatabaseException, OptimisticLockException {
        WriteObjectQuery writeObjectQuery = this.getWriteObjectQuery();
        ObjectChangeSet objectChangeSet = writeObjectQuery.getObjectChangeSet();
        ClassDescriptor classDescriptor = this.getDescriptor();
        AbstractSession abstractSession = this.getSession();
        CommitManager commitManager = abstractSession.getCommitManager();
        Object object = writeObjectQuery.getObject();
        if (!objectChangeSet.hasChanges() && !objectChangeSet.hasForcedChanges()) {
            commitManager.markCommitCompleted(object);
            return object;
        }
        if (commitManager.isCommitCompletedOrInPost(object)) {
            return object;
        }
        try {
            writeObjectQuery.executeCommitWithChangeSet();
            if (classDescriptor.getEventManager().hasAnyEventListeners()) {
                classDescriptor.getEventManager().executeEvent(new DescriptorEvent(1, writeObjectQuery));
            }
            commitManager.markCommitCompleted(object);
            return object;
        }
        catch (RuntimeException runtimeException) {
            commitManager.markCommitCompleted(object);
            throw runtimeException;
        }
    }

    protected ClassDescriptor getDescriptor() {
        return this.getQuery().getDescriptor();
    }

    public AbstractRecord getModifyRow() {
        if (this.getQuery().isModifyQuery()) {
            return ((ModifyQuery)this.getQuery()).getModifyRow();
        }
        return null;
    }

    public DatabaseQuery getQuery() {
        return this.query;
    }

    protected ReadObjectQuery getReadObjectQuery() {
        return (ReadObjectQuery)this.getQuery();
    }

    public Expression getSelectionCriteria() {
        return null;
    }

    protected AbstractSession getSession() {
        return this.getQuery().getSession();
    }

    protected AbstractRecord getTranslationRow() {
        return this.getQuery().getTranslationRow();
    }

    protected WriteObjectQuery getWriteObjectQuery() {
        return (WriteObjectQuery)this.getQuery();
    }

    public abstract void insertObject() throws DatabaseException;

    public void insertObject(boolean bl) {
        this.insertObject();
    }

    public void insertObjectForWrite() {
        WriteObjectQuery writeObjectQuery = this.getWriteObjectQuery();
        ClassDescriptor classDescriptor = this.getDescriptor();
        DescriptorQueryManager descriptorQueryManager = classDescriptor.getQueryManager();
        if (!writeObjectQuery.isUserDefined() && descriptorQueryManager.hasInsertQuery() && this.isExpressionQueryMechanism()) {
            this.performUserDefinedInsert();
            return;
        }
        Object object = writeObjectQuery.getObject();
        AbstractSession abstractSession = writeObjectQuery.getSession();
        ObjectChangeSet objectChangeSet = writeObjectQuery.getObjectChangeSet();
        CommitManager commitManager = abstractSession.getCommitManager();
        DescriptorEventManager descriptorEventManager = classDescriptor.getEventManager();
        commitManager.markPreModifyCommitInProgress(object);
        if (objectChangeSet == null && descriptorEventManager.hasAnyEventListeners()) {
            descriptorEventManager.executeEvent(new DescriptorEvent(4, writeObjectQuery));
        }
        if (writeObjectQuery.shouldCascadeParts()) {
            descriptorQueryManager.preInsert(writeObjectQuery);
        }
        if (commitManager.isShallowCommitted(object)) {
            this.updateForeignKeyFieldAfterInsert();
        } else {
            AbstractRecord abstractRecord = writeObjectQuery.getModifyRow();
            if (abstractRecord == null) {
                if (writeObjectQuery.shouldCascadeParts()) {
                    writeObjectQuery.setModifyRow(classDescriptor.getObjectBuilder().buildRow(object, abstractSession));
                } else {
                    writeObjectQuery.setModifyRow(classDescriptor.getObjectBuilder().buildRowForShallowInsert(object, abstractSession));
                }
            } else if (writeObjectQuery.shouldCascadeParts()) {
                writeObjectQuery.setModifyRow(classDescriptor.getObjectBuilder().buildRow(abstractRecord, object, abstractSession));
            } else {
                writeObjectQuery.setModifyRow(classDescriptor.getObjectBuilder().buildRowForShallowInsert(abstractRecord, object, abstractSession));
            }
            abstractRecord = this.getModifyRow();
            writeObjectQuery.setTranslationRow(abstractRecord);
            if (!classDescriptor.isAggregateCollectionDescriptor()) {
                writeObjectQuery.setPrimaryKey(classDescriptor.getObjectBuilder().extractPrimaryKeyFromObject(object, abstractSession));
            }
            this.addWriteLockFieldForInsert();
            int n = abstractRecord.size();
            if (descriptorEventManager.hasAnyEventListeners()) {
                DescriptorEvent descriptorEvent = new DescriptorEvent(12, writeObjectQuery);
                descriptorEvent.setRecord(abstractRecord);
                descriptorEventManager.executeEvent(descriptorEvent);
            }
            if (QueryMonitor.shouldMonitor()) {
                QueryMonitor.incrementInsert(writeObjectQuery);
            }
            this.insertObject(n != abstractRecord.size());
            this.registerObjectInIdentityMap(object, classDescriptor, abstractSession);
        }
        commitManager.markPostModifyCommitInProgress(object);
        if (writeObjectQuery.shouldCascadeParts()) {
            descriptorQueryManager.postInsert(writeObjectQuery);
        }
        if (classDescriptor.getHistoryPolicy() != null && classDescriptor.getHistoryPolicy().shouldHandleWrites()) {
            classDescriptor.getHistoryPolicy().postInsert(writeObjectQuery);
        }
        if (descriptorEventManager.hasAnyEventListeners()) {
            descriptorEventManager.executeEvent(new DescriptorEvent(5, writeObjectQuery));
        }
    }

    public boolean isCallQueryMechanism() {
        return false;
    }

    public boolean isExpressionQueryMechanism() {
        return false;
    }

    public boolean isQueryByExampleMechanism() {
        return false;
    }

    public boolean isStatementQueryMechanism() {
        return false;
    }

    protected void performUserDefinedInsert() {
        this.performUserDefinedWrite(this.getDescriptor().getQueryManager().getInsertQuery());
    }

    protected void performUserDefinedUpdate() {
        this.performUserDefinedWrite(this.getDescriptor().getQueryManager().getUpdateQuery());
    }

    protected void performUserDefinedWrite(WriteObjectQuery writeObjectQuery) {
        writeObjectQuery.checkPrepare(this.getSession(), this.getTranslationRow());
        Object object = this.getWriteObjectQuery().getObject();
        WriteObjectQuery writeObjectQuery2 = (WriteObjectQuery)writeObjectQuery.clone();
        writeObjectQuery2.setIsExecutionClone(true);
        writeObjectQuery2.setObject(object);
        writeObjectQuery2.setObjectChangeSet(this.getWriteObjectQuery().getObjectChangeSet());
        writeObjectQuery2.setCascadePolicy(this.getQuery().getCascadePolicy());
        writeObjectQuery2.setShouldMaintainCache(this.getQuery().shouldMaintainCache());
        writeObjectQuery2.setTranslationRow(this.getTranslationRow());
        writeObjectQuery2.setModifyRow(this.getModifyRow());
        writeObjectQuery2.setPrimaryKey(this.getWriteObjectQuery().getPrimaryKey());
        writeObjectQuery2.setSession(this.getSession());
        if (writeObjectQuery2.getObjectChangeSet() != null) {
            writeObjectQuery2.executeCommitWithChangeSet();
        } else {
            writeObjectQuery2.executeCommit();
        }
    }

    public void prepare() throws QueryException {
    }

    public abstract void prepareCursorSelectAllRows() throws QueryException;

    public abstract void prepareDeleteAll() throws QueryException;

    public abstract void prepareDeleteObject() throws QueryException;

    public abstract void prepareDoesExist(DatabaseField var1) throws QueryException;

    public abstract void prepareExecuteNoSelect() throws QueryException;

    public abstract void prepareExecuteSelect() throws QueryException;

    public abstract void prepareInsertObject() throws QueryException;

    public abstract void prepareReportQuerySelectAllRows() throws QueryException;

    public abstract void prepareReportQuerySubSelect() throws QueryException;

    public abstract void prepareSelectAllRows() throws QueryException;

    public abstract void prepareSelectOneRow() throws QueryException;

    public abstract void prepareUpdateObject() throws QueryException;

    public abstract void prepareUpdateAll() throws QueryException;

    protected void registerObjectInIdentityMap(Object object, ClassDescriptor classDescriptor, AbstractSession abstractSession) {
        WriteObjectQuery writeObjectQuery = this.getWriteObjectQuery();
        if (writeObjectQuery.shouldMaintainCache()) {
            if (classDescriptor.usesOptimisticLocking()) {
                Object object2 = classDescriptor.getOptimisticLockingPolicy().getValueToPutInCache(writeObjectQuery.getModifyRow(), abstractSession);
                abstractSession.getIdentityMapAccessorInstance().putInIdentityMap(object, writeObjectQuery.getPrimaryKey(), object2, System.currentTimeMillis(), classDescriptor);
            } else {
                abstractSession.getIdentityMapAccessorInstance().putInIdentityMap(object, writeObjectQuery.getPrimaryKey(), null, System.currentTimeMillis(), classDescriptor);
            }
        }
    }

    public abstract Vector selectAllReportQueryRows() throws DatabaseException;

    public abstract Vector selectAllRows() throws DatabaseException;

    public abstract AbstractRecord selectOneRow() throws DatabaseException;

    public abstract AbstractRecord selectRowForDoesExist(DatabaseField var1) throws DatabaseException;

    public void setQuery(DatabaseQuery databaseQuery) {
        this.query = databaseQuery;
    }

    protected void shallowInsertObjectForWrite(Object object, WriteObjectQuery writeObjectQuery, CommitManager commitManager) throws DatabaseException, OptimisticLockException {
        boolean bl;
        if (this.getSession().isUnitOfWork()) {
            UnitOfWorkImpl unitOfWorkImpl = (UnitOfWorkImpl)this.getSession();
            boolean bl2 = bl = !unitOfWorkImpl.isCloneNewObject(object);
            if (bl) {
                bl = unitOfWorkImpl.isObjectRegistered(object);
            }
        } else {
            DoesExistQuery doesExistQuery = (DoesExistQuery)this.getDescriptor().getQueryManager().getDoesExistQuery().clone();
            doesExistQuery.setObject(object);
            doesExistQuery.setPrimaryKey(writeObjectQuery.getPrimaryKey());
            doesExistQuery.setDescriptor(this.getDescriptor());
            doesExistQuery.setTranslationRow(this.getTranslationRow());
            bl = (Boolean)this.getSession().executeQuery(doesExistQuery);
        }
        if (!bl) {
            writeObjectQuery.dontCascadeParts();
            this.insertObjectForWrite();
            commitManager.markShallowCommit(object);
        }
    }

    protected void updateForeignKeyFieldAfterInsert() {
        WriteObjectQuery writeObjectQuery = this.getWriteObjectQuery();
        Object object = writeObjectQuery.getObject();
        writeObjectQuery.setPrimaryKey(this.getDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(object, this.getSession()));
        writeObjectQuery.setTranslationRow(this.getDescriptor().getObjectBuilder().buildRowForTranslation(object, this.getSession()));
        this.updateForeignKeyFieldAfterInsert(writeObjectQuery);
    }

    public abstract Integer updateAll() throws DatabaseException;

    public abstract Integer updateObject() throws DatabaseException;

    protected abstract void updateForeignKeyFieldAfterInsert(WriteObjectQuery var1);

    protected void updateObjectAndRowWithReturnRow(Collection collection, boolean bl) {
        Serializable serializable;
        Cloneable cloneable2;
        WriteObjectQuery writeObjectQuery = this.getWriteObjectQuery();
        AbstractRecord abstractRecord = (AbstractRecord)writeObjectQuery.getProperties().get("output");
        if (abstractRecord == null || abstractRecord.isEmpty()) {
            return;
        }
        DatabaseRecord databaseRecord = new DatabaseRecord();
        for (Cloneable cloneable2 : collection) {
            if (!abstractRecord.containsKey((DatabaseField)cloneable2)) continue;
            databaseRecord.put((DatabaseField)cloneable2, abstractRecord.get((DatabaseField)cloneable2));
        }
        if (((AbstractRecord)databaseRecord).isEmpty()) {
            return;
        }
        Object object = writeObjectQuery.getObject();
        this.getDescriptor().getObjectBuilder().assignReturnRow(object, this.getSession(), databaseRecord);
        cloneable2 = null;
        if (bl) {
            serializable = new DatabaseRecord();
            List<DatabaseField> list = this.getDescriptor().getPrimaryKeyFields();
            for (int i = 0; i < list.size(); ++i) {
                DatabaseField databaseField = list.get(i);
                if (!databaseRecord.containsKey(databaseField)) continue;
                ((AbstractRecord)serializable).put(databaseField, databaseRecord.get(databaseField));
            }
            if (!((AbstractRecord)serializable).isEmpty()) {
                cloneable2 = this.getDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(object, this.getSession());
                writeObjectQuery.setPrimaryKey((Vector)cloneable2);
                this.getModifyRow().putAll((Map)((Object)serializable));
                this.getDescriptor().getObjectBuilder().addPrimaryKeyForNonDefaultTable(this.getModifyRow(), object, this.getSession());
            }
        }
        if (this.getSession().isUnitOfWork()) {
            serializable = writeObjectQuery.getObjectChangeSet();
            if (serializable == null && ((UnitOfWorkImpl)this.getSession()).getUnitOfWorkChangeSet() != null) {
                serializable = (ObjectChangeSet)((UnitOfWorkImpl)this.getSession()).getUnitOfWorkChangeSet().getObjectChangeSetForClone(object);
            }
            if (serializable != null) {
                this.updateChangeSet(this.getDescriptor(), (ObjectChangeSet)serializable, databaseRecord, object);
                if (cloneable2 != null) {
                    ((ObjectChangeSet)serializable).setCacheKey(new CacheKey((Vector)cloneable2));
                }
            }
        }
    }

    public void updateChangeSet(ClassDescriptor classDescriptor, ObjectChangeSet objectChangeSet, AbstractRecord abstractRecord, Object object) {
        int n = abstractRecord.size();
        HashSet hashSet = null;
        if (n > 1) {
            hashSet = new HashSet(n);
        }
        for (int i = 0; i < n; ++i) {
            DatabaseField databaseField = (DatabaseField)abstractRecord.getFields().get(i);
            this.updateChangeSet(classDescriptor, objectChangeSet, databaseField, object, hashSet);
        }
    }

    protected void updateChangeSet(ClassDescriptor classDescriptor, ObjectChangeSet objectChangeSet, DatabaseField databaseField, Object object) {
        this.updateChangeSet(classDescriptor, objectChangeSet, databaseField, object, null);
    }

    protected void updateChangeSet(ClassDescriptor classDescriptor, ObjectChangeSet objectChangeSet, DatabaseField databaseField, Object object, Collection collection) {
        DatabaseMapping databaseMapping;
        List<DatabaseMapping> list = classDescriptor.getObjectBuilder().getReadOnlyMappingsForField(databaseField);
        if (list != null) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                databaseMapping = list.get(i);
                this.updateChangeSet(databaseMapping, objectChangeSet, databaseField, object, collection);
            }
        }
        if ((databaseMapping = classDescriptor.getObjectBuilder().getMappingForField(databaseField)) != null) {
            this.updateChangeSet(databaseMapping, objectChangeSet, databaseField, object, collection);
        }
    }

    protected void updateChangeSet(DatabaseMapping databaseMapping, ObjectChangeSet objectChangeSet, DatabaseField databaseField, Object object, Collection collection) {
        if (collection != null && collection.contains(databaseMapping)) {
            return;
        }
        if (databaseMapping.isDirectToFieldMapping()) {
            Object object2 = databaseMapping.getAttributeValueFromObject(object);
            objectChangeSet.updateChangeRecordForAttribute(databaseMapping, object2, this.getSession());
        } else if (databaseMapping.isAggregateObjectMapping()) {
            Object object3 = databaseMapping.getAttributeValueFromObject(object);
            AggregateChangeRecord aggregateChangeRecord = (AggregateChangeRecord)objectChangeSet.getChangesForAttributeNamed(databaseMapping.getAttributeName());
            if (object3 != null) {
                if (aggregateChangeRecord == null) {
                    aggregateChangeRecord = new AggregateChangeRecord(objectChangeSet);
                    aggregateChangeRecord.setAttribute(databaseMapping.getAttributeName());
                    aggregateChangeRecord.setMapping(databaseMapping);
                    objectChangeSet.addChange(aggregateChangeRecord);
                }
                ObjectChangeSet objectChangeSet2 = (ObjectChangeSet)aggregateChangeRecord.getChangedObject();
                ClassDescriptor classDescriptor = ((AggregateObjectMapping)databaseMapping).getReferenceDescriptor();
                if (objectChangeSet2 == null) {
                    objectChangeSet2 = classDescriptor.getObjectBuilder().createObjectChangeSet(object3, (UnitOfWorkChangeSet)((UnitOfWorkImpl)this.getSession()).getUnitOfWorkChangeSet(), this.getSession());
                    aggregateChangeRecord.setChangedObject(objectChangeSet2);
                }
                this.updateChangeSet(classDescriptor, objectChangeSet2, databaseField, object3, collection);
            } else if (aggregateChangeRecord != null) {
                aggregateChangeRecord.setChangedObject(null);
            }
        } else if (databaseMapping.isTransformationMapping()) {
            TransformationMappingChangeRecord transformationMappingChangeRecord = (TransformationMappingChangeRecord)objectChangeSet.getChangesForAttributeNamed(databaseMapping.getAttributeName());
            if (transformationMappingChangeRecord == null) {
                transformationMappingChangeRecord = new TransformationMappingChangeRecord(objectChangeSet);
                transformationMappingChangeRecord.setAttribute(databaseMapping.getAttributeName());
                transformationMappingChangeRecord.setMapping(databaseMapping);
                objectChangeSet.addChange(transformationMappingChangeRecord);
            }
            DatabaseRecord databaseRecord = new DatabaseRecord(databaseMapping.getFields().size());
            int n = databaseMapping.getFields().size();
            for (int i = 0; i < n; ++i) {
                DatabaseField databaseField2 = databaseMapping.getFields().get(i);
                Object object4 = ((AbstractTransformationMapping)databaseMapping).valueFromObject(object, databaseField2, this.getSession());
                databaseRecord.add(databaseField2, object4);
            }
            transformationMappingChangeRecord.setRow(databaseRecord);
            if (collection != null) {
                collection.add(databaseMapping);
            }
        } else {
            this.getSession().log(1, "query", "field_for_unsupported_mapping_returned", databaseField, this.getDescriptor());
        }
    }

    protected void updateObjectAndRowWithSequenceNumber() throws DatabaseException {
        AbstractSession abstractSession;
        WriteObjectQuery writeObjectQuery = this.getWriteObjectQuery();
        Object object = writeObjectQuery.getObject();
        ClassDescriptor classDescriptor = writeObjectQuery.getDescriptor();
        ObjectBuilder objectBuilder = classDescriptor.getObjectBuilder();
        Object object2 = objectBuilder.assignSequenceNumber(object, abstractSession = writeObjectQuery.getSession());
        if (object2 == null) {
            return;
        }
        Vector vector = objectBuilder.extractPrimaryKeyFromObject(object, this.getSession());
        writeObjectQuery.setPrimaryKey(vector);
        DatabaseField databaseField = classDescriptor.getSequenceNumberField();
        AbstractRecord abstractRecord = this.getModifyRow();
        abstractRecord.put(databaseField, object2);
        if (classDescriptor.hasMultipleTables()) {
            objectBuilder.addPrimaryKeyForNonDefaultTable(abstractRecord, object, abstractSession);
        }
        if (abstractSession.isUnitOfWork()) {
            ObjectChangeSet objectChangeSet = writeObjectQuery.getObjectChangeSet();
            if (objectChangeSet == null && ((UnitOfWorkImpl)abstractSession).getUnitOfWorkChangeSet() != null) {
                objectChangeSet = (ObjectChangeSet)((UnitOfWorkImpl)abstractSession).getUnitOfWorkChangeSet().getObjectChangeSetForClone(object);
            }
            if (objectChangeSet != null) {
                this.updateChangeSet(classDescriptor, objectChangeSet, databaseField, object);
                objectChangeSet.setCacheKey(new CacheKey(vector));
            }
        }
    }

    public void updateObjectForWrite() {
        WriteObjectQuery writeObjectQuery = this.getWriteObjectQuery();
        ClassDescriptor classDescriptor = this.getDescriptor();
        DescriptorQueryManager descriptorQueryManager = classDescriptor.getQueryManager();
        if (!writeObjectQuery.isUserDefined() && descriptorQueryManager.hasUpdateQuery() && this.isExpressionQueryMechanism()) {
            this.performUserDefinedUpdate();
            return;
        }
        Object object = writeObjectQuery.getObject();
        AbstractSession abstractSession = this.getSession();
        CommitManager commitManager = abstractSession.getCommitManager();
        commitManager.markPreModifyCommitInProgress(object);
        DescriptorEventManager descriptorEventManager = classDescriptor.getEventManager();
        if (writeObjectQuery.getObjectChangeSet() == null && descriptorEventManager.hasAnyEventListeners()) {
            descriptorEventManager.executeEvent(new DescriptorEvent(6, writeObjectQuery));
        }
        if (writeObjectQuery.shouldCascadeParts()) {
            descriptorQueryManager.preUpdate(writeObjectQuery);
        }
        if ((writeObjectQuery.isUserDefined() || writeObjectQuery.isCallQuery()) && !this.getSession().isUnitOfWork()) {
            writeObjectQuery.setModifyRow(classDescriptor.getObjectBuilder().buildRow(object, this.getSession()));
        } else {
            writeObjectQuery.setModifyRow(classDescriptor.getObjectBuilder().buildRowForUpdate(writeObjectQuery));
        }
        Boolean bl = null;
        if (abstractSession.isUnitOfWork() && ((UnitOfWorkImpl)abstractSession).hasOptimisticReadLockObjects()) {
            bl = (Boolean)((UnitOfWorkImpl)abstractSession).getOptimisticReadLockObjects().get(writeObjectQuery.getObject());
        }
        if (!this.getModifyRow().isEmpty() || bl != null || classDescriptor.getCMPPolicy() != null && classDescriptor.getCMPPolicy().getForceUpdate()) {
            int n;
            Serializable serializable;
            if ((writeObjectQuery.isUserDefined() || writeObjectQuery.isCallQuery()) && this.getSession().isUnitOfWork()) {
                writeObjectQuery.setModifyRow(classDescriptor.getObjectBuilder().buildRow(object, this.getSession()));
            }
            if (classDescriptor.usesOptimisticLocking()) {
                serializable = classDescriptor.getOptimisticLockingPolicy();
                serializable.addLockValuesToTranslationRow(writeObjectQuery);
                if (!this.getModifyRow().isEmpty() || bl.booleanValue()) {
                    serializable.updateRowAndObjectForUpdate(writeObjectQuery, object);
                } else if (!bl.booleanValue() && serializable instanceof VersionLockingPolicy) {
                    ((VersionLockingPolicy)serializable).writeLockValueIntoRow(writeObjectQuery, object);
                }
            }
            if (descriptorEventManager.hasAnyEventListeners()) {
                serializable = new DescriptorEvent(13, writeObjectQuery);
                ((DescriptorEvent)serializable).setRecord(this.getModifyRow());
                descriptorEventManager.executeEvent((DescriptorEvent)serializable);
            }
            if (QueryMonitor.shouldMonitor()) {
                QueryMonitor.incrementUpdate(this.getWriteObjectQuery());
            }
            if ((n = this.updateObject().intValue()) < 1) {
                abstractSession.getEventManager().noRowsModified(writeObjectQuery, object);
            }
            if (classDescriptor.usesOptimisticLocking()) {
                classDescriptor.getOptimisticLockingPolicy().validateUpdate(n, object, writeObjectQuery);
            }
        }
        commitManager.markPostModifyCommitInProgress(object);
        if (writeObjectQuery.shouldCascadeParts()) {
            descriptorQueryManager.postUpdate(writeObjectQuery);
        }
        if (classDescriptor.getHistoryPolicy() != null && classDescriptor.getHistoryPolicy().shouldHandleWrites()) {
            classDescriptor.getHistoryPolicy().postUpdate(writeObjectQuery);
        }
        if (descriptorEventManager.hasAnyEventListeners()) {
            descriptorEventManager.executeEvent(new DescriptorEvent(7, writeObjectQuery));
        }
    }

    public void updateObjectForWriteWithChangeSet() {
        Serializable serializable;
        Serializable serializable2;
        WriteObjectQuery writeObjectQuery = this.getWriteObjectQuery();
        ObjectChangeSet objectChangeSet = writeObjectQuery.getObjectChangeSet();
        Object object = writeObjectQuery.getObject();
        ClassDescriptor classDescriptor = this.getDescriptor();
        DescriptorQueryManager descriptorQueryManager = classDescriptor.getQueryManager();
        AbstractSession abstractSession = this.getSession();
        CommitManager commitManager = abstractSession.getCommitManager();
        if (!writeObjectQuery.isUserDefined() && descriptorQueryManager.hasUpdateQuery() && this.isExpressionQueryMechanism()) {
            commitManager.markPreModifyCommitInProgress(object);
            this.performUserDefinedUpdate();
            return;
        }
        commitManager.markPreModifyCommitInProgress(object);
        DescriptorEventManager descriptorEventManager = classDescriptor.getEventManager();
        if (objectChangeSet.hasChanges() && descriptorEventManager.hasAnyEventListeners()) {
            serializable2 = new DescriptorEvent(17, writeObjectQuery);
            descriptorEventManager.executeEvent((DescriptorEvent)serializable2);
            serializable = (UnitOfWorkChangeSet)((UnitOfWorkImpl)abstractSession).getUnitOfWorkChangeSet();
            if (!((UnitOfWorkChangeSet)serializable).isChangeSetFromOutsideUOW()) {
                if (!classDescriptor.getObjectChangePolicy().isAttributeChangeTrackingPolicy()) {
                    writeObjectQuery.getObjectChangeSet().clear();
                }
                if (classDescriptor.getObjectChangePolicy().calculateChangesForExistingObject(object, (UnitOfWorkChangeSet)serializable, (UnitOfWorkImpl)abstractSession, classDescriptor, false) == null) {
                    ((UnitOfWorkChangeSet)serializable).getAllChangeSets().remove(writeObjectQuery.getObjectChangeSet());
                }
            }
        }
        if (writeObjectQuery.shouldCascadeParts()) {
            descriptorQueryManager.preUpdate(writeObjectQuery);
        }
        writeObjectQuery.setModifyRow(classDescriptor.getObjectBuilder().buildRowForUpdateWithChangeSet(writeObjectQuery));
        serializable2 = objectChangeSet.shouldModifyVersionField();
        if (!this.getModifyRow().isEmpty() || serializable2 != null || objectChangeSet.hasCmpPolicyForcedUpdate()) {
            int n;
            if (writeObjectQuery.isUserDefined() || writeObjectQuery.isCallQuery()) {
                writeObjectQuery.setModifyRow(classDescriptor.getObjectBuilder().buildRow(object, abstractSession));
            }
            if ((serializable = classDescriptor.getOptimisticLockingPolicy()) != null) {
                serializable.addLockValuesToTranslationRow(writeObjectQuery);
                if (!this.getModifyRow().isEmpty() || ((Boolean)serializable2).booleanValue()) {
                    serializable.updateRowAndObjectForUpdate(writeObjectQuery, object);
                } else if (!((Boolean)serializable2).booleanValue() && serializable instanceof VersionLockingPolicy) {
                    ((VersionLockingPolicy)serializable).writeLockValueIntoRow(writeObjectQuery, object);
                }
            }
            if (descriptorEventManager.hasAnyEventListeners()) {
                DescriptorEvent descriptorEvent = new DescriptorEvent(13, writeObjectQuery);
                descriptorEvent.setRecord(this.getModifyRow());
                descriptorEventManager.executeEvent(descriptorEvent);
            }
            if (QueryMonitor.shouldMonitor()) {
                QueryMonitor.incrementUpdate(this.getWriteObjectQuery());
            }
            if ((n = this.updateObject().intValue()) < 1) {
                abstractSession.getEventManager().noRowsModified(writeObjectQuery, object);
            }
            if (serializable != null) {
                serializable.validateUpdate(n, object, writeObjectQuery);
            }
        }
        commitManager.markPostModifyCommitInProgress(object);
        if (writeObjectQuery.shouldCascadeParts()) {
            descriptorQueryManager.postUpdate(writeObjectQuery);
        }
        if (classDescriptor.getHistoryPolicy() != null && classDescriptor.getHistoryPolicy().shouldHandleWrites()) {
            classDescriptor.getHistoryPolicy().postUpdate(writeObjectQuery);
        }
        if (descriptorEventManager.hasAnyEventListeners()) {
            descriptorEventManager.executeEvent(new DescriptorEvent(7, writeObjectQuery));
        }
    }
}

