/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.queries;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.changetracking.CollectionChangeEvent;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.indirection.IndirectCollection;
import org.eclipse.persistence.internal.queries.ListContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.CollectionChangeRecord;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.OrderedChangeObject;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;

public class OrderedListContainerPolicy
extends ListContainerPolicy {
    public OrderedListContainerPolicy() {
    }

    public OrderedListContainerPolicy(Class clazz) {
        super(clazz);
    }

    public OrderedListContainerPolicy(String string) {
        super(string);
    }

    protected void addIntoAtIndex(Integer n, Object object, Object object2, AbstractSession abstractSession) {
        if (this.hasElementDescriptor()) {
            object = this.getElementDescriptor().getObjectBuilder().wrapObject(object, abstractSession);
        }
        try {
            if (n == null || n > this.sizeFor(object2)) {
                ((List)object2).add(object);
            } else {
                ((List)object2).add(n, object);
            }
        }
        catch (ClassCastException classCastException) {
            throw QueryException.cannotAddElement(object, object2, classCastException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw QueryException.cannotAddElement(object, object2, illegalArgumentException);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw QueryException.cannotAddElement(object, object2, unsupportedOperationException);
        }
    }

    public void compareCollectionsForChange(Object object, Object object2, CollectionChangeRecord collectionChangeRecord, AbstractSession abstractSession, ClassDescriptor classDescriptor) {
        Object object3;
        Vector vector = new Vector();
        Hashtable<Integer, Integer> hashtable = new Hashtable<Integer, Integer>();
        Hashtable hashtable2 = new Hashtable();
        IdentityHashMap identityHashMap = new IdentityHashMap();
        IdentityHashMap identityHashMap2 = new IdentityHashMap();
        IdentityHashMap identityHashMap3 = new IdentityHashMap();
        if (object != null) {
            object3 = (ListIterator)this.iteratorFor(object);
            while (object3.hasNext()) {
                Integer n = new Integer(object3.nextIndex());
                Object e = object3.next();
                identityHashMap.put(e, n);
                hashtable2.put(n, e);
                hashtable.put(n, n);
            }
        }
        if (object2 != null) {
            object3 = (ListIterator)this.iteratorFor(object2);
            while (object3.hasNext()) {
                identityHashMap3.put(object3.next(), new Integer(object3.previousIndex()));
            }
            int n = 0;
            int n2 = 0;
            object3 = (ListIterator)this.iteratorFor(object2);
            while (object3.hasNext()) {
                n = object3.nextIndex();
                Object e = object3.next();
                if (e != null) {
                    if (identityHashMap.containsKey(e)) {
                        int n3 = (Integer)identityHashMap.get(e);
                        identityHashMap.remove(e);
                        if (n == n3) {
                            hashtable.remove(new Integer(n3));
                            n2 = 0;
                            continue;
                        }
                        if (n == n3 + n2) {
                            hashtable.remove(new Integer(n3));
                            continue;
                        }
                        int n4 = 0;
                        int n5 = 0;
                        boolean bl = true;
                        if (n3 < n) {
                            ++n2;
                        } else {
                            for (int i = n3 - 1; i >= n; --i) {
                                Object v = hashtable2.get(new Integer(i));
                                if (identityHashMap3.containsKey(v)) {
                                    ++n4;
                                    continue;
                                }
                                ++n5;
                            }
                            if (n == n3 + n2 - n5) {
                                n2 -= n5;
                                bl = false;
                            } else if (n4 > 1) {
                                ++n2;
                            } else {
                                Object v = hashtable2.get(new Integer(n));
                                if (identityHashMap3.containsKey(v) && (Integer)identityHashMap3.get(v) - n > 1) {
                                    bl = false;
                                    --n2;
                                }
                            }
                        }
                        if (bl) {
                            vector.add(e);
                            continue;
                        }
                        hashtable.remove(new Integer(n3));
                        continue;
                    }
                    ++n2;
                    identityHashMap2.put(e, e);
                    vector.add(e);
                    continue;
                }
                --n2;
            }
        }
        object3 = new Vector(hashtable.values());
        Collections.sort(object3);
        collectionChangeRecord.addAdditionChange(identityHashMap2, this, (UnitOfWorkChangeSet)collectionChangeRecord.getOwner().getUOWChangeSet(), abstractSession);
        collectionChangeRecord.addRemoveChange(identityHashMap, this, (UnitOfWorkChangeSet)collectionChangeRecord.getOwner().getUOWChangeSet(), abstractSession);
        collectionChangeRecord.addOrderedAdditionChange(vector, identityHashMap3, (UnitOfWorkChangeSet)collectionChangeRecord.getOwner().getUOWChangeSet(), abstractSession);
        collectionChangeRecord.addOrderedRemoveChange((Vector)object3, hashtable2, (UnitOfWorkChangeSet)collectionChangeRecord.getOwner().getUOWChangeSet(), abstractSession);
    }

    public Iterator getChangeValuesFrom(Map map) {
        return map.keySet().iterator();
    }

    public Object iteratorFor(Object object) {
        return ((List)object).listIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void mergeChanges(CollectionChangeRecord collectionChangeRecord, Object object, boolean bl, MergeManager mergeManager, AbstractSession abstractSession) {
        Object object2 = object;
        if (object instanceof IndirectCollection) {
            object2 = ((IndirectCollection)object).getDelegateObject();
        }
        Object object3 = object2;
        synchronized (object3) {
            Object object4;
            ObjectChangeSet objectChangeSet2;
            block20: {
                Vector vector;
                block19: {
                    block18: {
                        if (!collectionChangeRecord.getOrderedChangeObjectList().isEmpty()) break block18;
                        vector = collectionChangeRecord.getOrderedRemoveObjectIndices();
                        if (!vector.isEmpty()) break block19;
                        for (ObjectChangeSet objectChangeSet2 : collectionChangeRecord.getRemoveObjectList().keySet()) {
                            this.removeFrom(objectChangeSet2.getOldKey(), objectChangeSet2.getTargetVersionOfSourceObject(mergeManager.getSession()), object, abstractSession);
                            this.registerRemoveNewObjectIfRequired(objectChangeSet2, mergeManager);
                        }
                        break block20;
                    }
                    Vector vector2 = new Vector();
                    Iterator iterator = collectionChangeRecord.getOrderedChangeObjectList().iterator();
                    while (iterator.hasNext()) {
                        Object object5;
                        boolean bl2;
                        OrderedChangeObject orderedChangeObject = (OrderedChangeObject)iterator.next();
                        ObjectChangeSet objectChangeSet3 = orderedChangeObject.getChangeSet();
                        if (orderedChangeObject.getChangeType() == CollectionChangeEvent.REMOVE) {
                            bl2 = collectionChangeRecord.getRemoveObjectList().containsKey(objectChangeSet3);
                            object5 = objectChangeSet3.getTargetVersionOfSourceObject(mergeManager.getSession());
                            if (object5 == null) continue;
                            Integer n = orderedChangeObject.getIndex();
                            if (n != null) {
                                if (!object5.equals(this.get(n, object, mergeManager.getSession()))) {
                                    Vector vector3 = ((ObjectChangeSet)collectionChangeRecord.getOwner()).getPrimaryKeys();
                                    abstractSession.getIdentityMapAccessor().invalidateObject(vector3, collectionChangeRecord.getOwner().getClassType(abstractSession));
                                    return;
                                }
                                this.removeFromAtIndex(n, object);
                            } else {
                                this.removeFrom(object5, object, abstractSession);
                            }
                            if (mergeManager.shouldMergeChangesIntoDistributedCache() || !collectionChangeRecord.getMapping().isPrivateOwned() || !bl2) continue;
                            mergeManager.registerRemovedNewObjectIfRequired(objectChangeSet3.getUnitOfWorkClone());
                            continue;
                        }
                        bl2 = collectionChangeRecord.getAddObjectList().containsKey(objectChangeSet3);
                        object5 = null;
                        if (bl2 && bl) {
                            object5 = this.mergeCascadeParts(objectChangeSet3, mergeManager, abstractSession);
                        }
                        if (object5 == null) {
                            object5 = objectChangeSet3.getTargetVersionOfSourceObject(mergeManager.getSession());
                        }
                        if (bl2 && mergeManager.shouldMergeChangesIntoDistributedCache()) {
                            if (this.contains(object5, object, mergeManager.getSession())) continue;
                            this.addIntoAtIndex(orderedChangeObject.getIndex(), object5, object, mergeManager.getSession());
                            continue;
                        }
                        this.addIntoAtIndex(orderedChangeObject.getIndex(), object5, object, mergeManager.getSession());
                    }
                    return;
                }
                for (int i = vector.size() - 1; i >= 0; --i) {
                    Integer n = (int)((Integer)vector.elementAt(i));
                    objectChangeSet2 = (ObjectChangeSet)collectionChangeRecord.getOrderedRemoveObject(n);
                    object4 = objectChangeSet2.getTargetVersionOfSourceObject(mergeManager.getSession());
                    if (object4 != null && object4.equals(this.get(n, object, mergeManager.getSession()))) {
                        this.removeFromAtIndex(n, object);
                        if (!collectionChangeRecord.getRemoveObjectList().containsKey(objectChangeSet2)) continue;
                        this.registerRemoveNewObjectIfRequired(objectChangeSet2, mergeManager);
                        continue;
                    }
                    Vector vector4 = ((ObjectChangeSet)collectionChangeRecord.getOwner()).getPrimaryKeys();
                    abstractSession.getIdentityMapAccessor().invalidateObject(vector4, collectionChangeRecord.getOwner().getClassType(abstractSession));
                    return;
                }
            }
            Enumeration enumeration = collectionChangeRecord.getOrderedAddObjects().elements();
            while (enumeration.hasMoreElements()) {
                objectChangeSet2 = (ObjectChangeSet)enumeration.nextElement();
                boolean bl3 = collectionChangeRecord.getAddObjectList().containsKey(objectChangeSet2);
                object4 = null;
                if (bl3 && bl) {
                    object4 = this.mergeCascadeParts(objectChangeSet2, mergeManager, abstractSession);
                }
                if (object4 == null) {
                    object4 = objectChangeSet2.getTargetVersionOfSourceObject(mergeManager.getSession());
                }
                if (bl3 && mergeManager.shouldMergeChangesIntoDistributedCache()) {
                    if (this.contains(object4, object, mergeManager.getSession())) continue;
                    this.addIntoAtIndex(collectionChangeRecord.getOrderedAddObjectIndex(objectChangeSet2), object4, object, mergeManager.getSession());
                    continue;
                }
                this.addIntoAtIndex(collectionChangeRecord.getOrderedAddObjectIndex(objectChangeSet2), object4, object, mergeManager.getSession());
            }
            return;
        }
    }

    protected void registerRemoveNewObjectIfRequired(ObjectChangeSet objectChangeSet, MergeManager mergeManager) {
        if (!mergeManager.shouldMergeChangesIntoDistributedCache()) {
            mergeManager.registerRemovedNewObjectIfRequired(objectChangeSet.getUnitOfWorkClone());
        }
    }

    protected void removeFromAtIndex(int n, Object object) {
        try {
            ((List)object).remove(n);
        }
        catch (ClassCastException classCastException) {
            throw QueryException.cannotRemoveFromContainer(new Integer(n), object, this);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw QueryException.cannotRemoveFromContainer(new Integer(n), object, this);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw QueryException.cannotRemoveFromContainer(new Integer(n), object, this);
        }
    }

    public void recordAddToCollectionInChangeRecord(ObjectChangeSet objectChangeSet, CollectionChangeRecord collectionChangeRecord) {
        OrderedChangeObject orderedChangeObject = new OrderedChangeObject(CollectionChangeEvent.ADD, null, objectChangeSet);
        collectionChangeRecord.getOrderedChangeObjectList().add(orderedChangeObject);
    }

    public void recordRemoveFromCollectionInChangeRecord(ObjectChangeSet objectChangeSet, CollectionChangeRecord collectionChangeRecord) {
        OrderedChangeObject orderedChangeObject = new OrderedChangeObject(CollectionChangeEvent.REMOVE, null, objectChangeSet);
        collectionChangeRecord.getOrderedChangeObjectList().add(orderedChangeObject);
    }

    public void recordUpdateToCollectionInChangeRecord(CollectionChangeEvent collectionChangeEvent, ObjectChangeSet objectChangeSet, CollectionChangeRecord collectionChangeRecord) {
        int n = collectionChangeEvent.getChangeType();
        if (n == CollectionChangeEvent.ADD) {
            super.recordAddToCollectionInChangeRecord(objectChangeSet, collectionChangeRecord);
        } else if (n == CollectionChangeEvent.REMOVE) {
            super.recordRemoveFromCollectionInChangeRecord(objectChangeSet, collectionChangeRecord);
        } else {
            throw ValidationException.wrongCollectionChangeEventType(n);
        }
        OrderedChangeObject orderedChangeObject = new OrderedChangeObject(n, collectionChangeEvent.getIndex(), objectChangeSet);
        collectionChangeRecord.getOrderedChangeObjectList().add(orderedChangeObject);
    }
}

