/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.util.Properties;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.descriptors.Namespace;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.oxm.FragmentContentHandler;
import org.eclipse.persistence.internal.oxm.TreeObjectBuilder;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.XMLObjectBuilder;
import org.eclipse.persistence.internal.oxm.XPathEngine;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.record.DOMReader;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLMarshalListener;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.oxm.attachment.XMLAttachmentMarshaller;
import org.eclipse.persistence.oxm.record.ContentHandlerRecord;
import org.eclipse.persistence.oxm.record.FormattedWriterRecord;
import org.eclipse.persistence.oxm.record.MarshalRecord;
import org.eclipse.persistence.oxm.record.NodeRecord;
import org.eclipse.persistence.oxm.record.WriterRecord;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.platform.xml.XMLPlatform;
import org.eclipse.persistence.platform.xml.XMLPlatformException;
import org.eclipse.persistence.platform.xml.XMLPlatformFactory;
import org.eclipse.persistence.platform.xml.XMLTransformer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.ext.LexicalHandler;

public class XMLMarshaller {
    private static final String DEFAULT_XML_ENCODING = "UTF-8";
    private static final String DEFAULT_XML_VERSION = "1.0";
    private String schemaLocation;
    private String noNamespaceSchemaLocation;
    private XMLTransformer transformer;
    private XMLContext xmlContext;
    private XMLMarshalListener marshalListener;
    private XMLAttachmentMarshaller attachmentMarshaller;
    private Properties marshalProperties;

    public XMLMarshaller(XMLContext xMLContext) {
        this.setXMLContext(xMLContext);
        this.initialize();
    }

    private void initialize() {
        XMLPlatform xMLPlatform = XMLPlatformFactory.getInstance().getXMLPlatform();
        this.transformer = xMLPlatform.newXMLTransformer();
        this.setEncoding(DEFAULT_XML_ENCODING);
        this.setFormattedOutput(true);
        this.marshalProperties = new Properties();
    }

    public XMLContext getXMLContext() {
        return this.xmlContext;
    }

    public void setXMLContext(XMLContext xMLContext) {
        this.xmlContext = xMLContext;
    }

    public boolean isFormattedOutput() {
        return this.transformer.isFormattedOutput();
    }

    public void setFormattedOutput(boolean bl) {
        this.transformer.setFormattedOutput(bl);
    }

    public String getEncoding() {
        return this.transformer.getEncoding();
    }

    public void setEncoding(String string) {
        this.transformer.setEncoding(string);
    }

    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String string) {
        this.schemaLocation = string;
    }

    public String getNoNamespaceSchemaLocation() {
        return this.noNamespaceSchemaLocation;
    }

    public Properties getProperties() {
        return this.marshalProperties;
    }

    public Object getProperty(Object object) {
        return this.marshalProperties.get(object);
    }

    public void setNoNamespaceSchemaLocation(String string) {
        this.noNamespaceSchemaLocation = string;
    }

    public void setXMLMarshalHandler(XMLMarshalListener xMLMarshalListener) {
        this.marshalListener = xMLMarshalListener;
    }

    public XMLMarshalListener getMarshalListener() {
        return this.marshalListener;
    }

    public void setMarshalListener(XMLMarshalListener xMLMarshalListener) {
        this.marshalListener = xMLMarshalListener;
    }

    public void marshal(Object object, Result result) throws XMLMarshalException {
        if (object == null || result == null) {
            throw XMLMarshalException.nullArgumentException();
        }
        boolean bl = object instanceof XMLRoot;
        XMLDescriptor xMLDescriptor = this.getDescriptor(object, bl);
        AbstractSession abstractSession = this.xmlContext.getSession(xMLDescriptor);
        if (abstractSession == null || !this.xmlContext.getDocumentPreservationPolicy(abstractSession).shouldPreserveDocument()) {
            if (result instanceof DOMResult) {
                DOMResult dOMResult = (DOMResult)result;
                this.marshal(object, dOMResult.getNode());
            } else if (result instanceof SAXResult) {
                SAXResult sAXResult = (SAXResult)result;
                this.marshal(object, sAXResult.getHandler());
            } else if (result instanceof StreamResult) {
                StreamResult streamResult = (StreamResult)result;
                Writer writer = streamResult.getWriter();
                if (writer != null) {
                    this.marshal(object, writer);
                } else if (streamResult.getOutputStream() != null) {
                    this.marshal(object, streamResult.getOutputStream());
                } else {
                    try {
                        File file = new File(new URL(streamResult.getSystemId()).toURI());
                        this.marshal(object, new FileWriter(file));
                    }
                    catch (Exception exception) {
                        throw XMLMarshalException.marshalException(exception);
                    }
                }
            } else {
                StringWriter stringWriter = new StringWriter();
                this.marshal(object, stringWriter);
                System.out.println(stringWriter.toString());
                StreamSource streamSource = new StreamSource(new StringReader(stringWriter.toString()));
                this.transformer.transform(streamSource, result);
            }
            return;
        }
        try {
            Document document = this.objectToXML(object, xMLDescriptor, bl);
            if (result instanceof SAXResult && this.isFragment()) {
                FragmentContentHandler fragmentContentHandler = new FragmentContentHandler(((SAXResult)result).getHandler());
                if (bl) {
                    String string = this.transformer.getEncoding();
                    String string2 = this.transformer.getVersion();
                    if (((XMLRoot)object).getEncoding() != null) {
                        this.transformer.setEncoding(((XMLRoot)object).getEncoding());
                    }
                    if (((XMLRoot)object).getXMLVersion() != null) {
                        this.transformer.setVersion(((XMLRoot)object).getXMLVersion());
                    }
                    this.transformer.transform((Node)document, fragmentContentHandler);
                    this.transformer.setEncoding(string);
                    this.transformer.setVersion(string2);
                } else {
                    this.transformer.transform((Node)document, fragmentContentHandler);
                }
            } else if (bl) {
                String string = this.transformer.getEncoding();
                String string3 = this.transformer.getVersion();
                if (((XMLRoot)object).getEncoding() != null) {
                    this.transformer.setEncoding(((XMLRoot)object).getEncoding());
                }
                if (((XMLRoot)object).getXMLVersion() != null) {
                    this.transformer.setVersion(((XMLRoot)object).getXMLVersion());
                }
                this.transformer.transform((Node)document, result);
                this.transformer.setEncoding(string);
                this.transformer.setVersion(string3);
            } else {
                this.transformer.transform((Node)document, result);
            }
        }
        catch (XMLPlatformException xMLPlatformException) {
            throw XMLMarshalException.marshalException(xMLPlatformException);
        }
    }

    public void marshal(Object object, OutputStream outputStream) throws XMLMarshalException {
        if (object == null || outputStream == null) {
            throw XMLMarshalException.nullArgumentException();
        }
        try {
            String string = this.getEncoding();
            if (object instanceof XMLRoot && ((XMLRoot)object).getEncoding() != null) {
                string = ((XMLRoot)object).getEncoding();
            }
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, string);
            this.marshal(object, outputStreamWriter);
            outputStreamWriter.flush();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw XMLMarshalException.marshalException(unsupportedEncodingException);
        }
        catch (Exception exception) {
            throw XMLMarshalException.marshalException(exception);
        }
    }

    public void marshal(Object object, Writer writer) throws XMLMarshalException {
        Object object2;
        if (object == null || writer == null) {
            throw XMLMarshalException.nullArgumentException();
        }
        boolean bl = false;
        String string = DEFAULT_XML_VERSION;
        String string2 = this.getEncoding();
        if (object instanceof XMLRoot) {
            bl = true;
            object2 = (XMLRoot)object;
            string = ((XMLRoot)object2).getXMLVersion() != null ? ((XMLRoot)object2).getXMLVersion() : string;
            string2 = ((XMLRoot)object2).getEncoding() != null ? ((XMLRoot)object2).getEncoding() : string2;
        }
        object2 = this.getDescriptor(object, bl);
        AbstractSession abstractSession = this.xmlContext.getSession((XMLDescriptor)object2);
        WriterRecord writerRecord = this.isFormattedOutput() ? new FormattedWriterRecord() : new WriterRecord();
        writerRecord.setMarshaller(this);
        writerRecord.setWriter(writer);
        if (abstractSession == null || !this.xmlContext.getDocumentPreservationPolicy(abstractSession).shouldPreserveDocument()) {
            this.marshal(object, writerRecord, (XMLDescriptor)object2, bl);
            try {
                writer.flush();
            }
            catch (IOException iOException) {
                throw XMLMarshalException.marshalException(iOException);
            }
            return;
        }
        try {
            Node node = this.objectToXMLNode(object, (XMLDescriptor)object2, bl);
            writerRecord.setSession(abstractSession);
            if (this.isFragment()) {
                writerRecord.node(node, ((XMLDescriptor)object2).getNamespaceResolver());
            } else {
                writerRecord.startDocument(string2, string);
                writerRecord.node(node, writerRecord.getNamespaceResolver());
                writerRecord.endDocument();
            }
        }
        catch (XMLPlatformException xMLPlatformException) {
            throw XMLMarshalException.marshalException(xMLPlatformException);
        }
    }

    public void marshal(Object object, ContentHandler contentHandler) throws XMLMarshalException {
        this.marshal(object, contentHandler, null);
    }

    public void marshal(Object object, ContentHandler contentHandler, LexicalHandler lexicalHandler) throws XMLMarshalException {
        if (object == null || contentHandler == null) {
            throw XMLMarshalException.nullArgumentException();
        }
        boolean bl = object instanceof XMLRoot;
        XMLDescriptor xMLDescriptor = this.getDescriptor(object, bl);
        AbstractSession abstractSession = this.xmlContext.getSession(xMLDescriptor);
        if (abstractSession == null || !this.xmlContext.getDocumentPreservationPolicy(abstractSession).shouldPreserveDocument()) {
            ContentHandlerRecord contentHandlerRecord = new ContentHandlerRecord();
            contentHandlerRecord.setMarshaller(this);
            contentHandlerRecord.setContentHandler(contentHandler);
            contentHandlerRecord.setLexicalHandler(lexicalHandler);
            this.marshal(object, contentHandlerRecord, xMLDescriptor, bl);
            return;
        }
        try {
            Document document = this.objectToXML(object, xMLDescriptor, bl);
            DOMReader dOMReader = new DOMReader();
            dOMReader.setProperty("http://xml.org/sax/properties/lexical-handler", lexicalHandler);
            if (this.isFragment()) {
                FragmentContentHandler fragmentContentHandler = new FragmentContentHandler(contentHandler);
                dOMReader.setContentHandler(fragmentContentHandler);
            } else {
                dOMReader.setContentHandler(contentHandler);
            }
            dOMReader.parse(document);
        }
        catch (XMLPlatformException xMLPlatformException) {
            throw XMLMarshalException.marshalException(xMLPlatformException);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
        }
        catch (SAXException sAXException) {
            throw XMLMarshalException.marshalException(sAXException);
        }
    }

    public void marshal(Object object, Node node) throws XMLMarshalException {
        if (object == null || node == null) {
            throw XMLMarshalException.nullArgumentException();
        }
        try {
            boolean bl = object instanceof XMLRoot;
            XMLDescriptor xMLDescriptor = this.getDescriptor(object, bl);
            AbstractSession abstractSession = this.xmlContext.getSession(xMLDescriptor);
            if (abstractSession == null || !this.xmlContext.getDocumentPreservationPolicy(abstractSession).shouldPreserveDocument()) {
                NodeRecord nodeRecord = new NodeRecord();
                nodeRecord.setMarshaller(this);
                nodeRecord.setDOM(node);
                if (!bl && null == xMLDescriptor.getDefaultRootElement() && node.getNodeType() == 1 && xMLDescriptor.getSchemaReference() != null && xMLDescriptor.getSchemaReference().getType() == 1) {
                    Attr attr = ((Element)node).getAttributeNodeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
                    if (attr == null) {
                        NamespaceResolver namespaceResolver = xMLDescriptor.getNamespaceResolver();
                        String string = null;
                        if (null == namespaceResolver) {
                            namespaceResolver = new NamespaceResolver();
                            xMLDescriptor.setNamespaceResolver(namespaceResolver);
                        } else {
                            string = namespaceResolver.resolveNamespaceURI("http://www.w3.org/2001/XMLSchema-instance");
                        }
                        if (null == string) {
                            string = namespaceResolver.generatePrefix("xsi");
                        }
                        String string2 = xMLDescriptor.getSchemaReference().getSchemaContext();
                        ((Element)node).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + string, "http://www.w3.org/2001/XMLSchema-instance");
                        ((Element)node).setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", string + ":" + "type", string2);
                    } else {
                        String string = xMLDescriptor.getSchemaReference().getSchemaContext();
                        attr.setValue(string);
                    }
                }
                this.marshal(object, nodeRecord, xMLDescriptor, bl);
                return;
            }
            Node node2 = this.objectToXMLNode(object, node, xMLDescriptor, bl);
            DOMResult dOMResult = new DOMResult(node);
            if (bl) {
                String string = this.transformer.getEncoding();
                String string3 = this.transformer.getVersion();
                if (((XMLRoot)object).getEncoding() != null) {
                    this.transformer.setEncoding(((XMLRoot)object).getEncoding());
                }
                if (((XMLRoot)object).getXMLVersion() != null) {
                    this.transformer.setVersion(((XMLRoot)object).getXMLVersion());
                }
                this.transformer.transform(node2, (Result)dOMResult);
                this.transformer.setEncoding(string);
                this.transformer.setVersion(string3);
            } else {
                this.transformer.transform(node2, (Result)dOMResult);
            }
        }
        catch (Exception exception) {
            if (exception instanceof XMLMarshalException) {
                throw (XMLMarshalException)exception;
            }
            throw XMLMarshalException.marshalException(exception);
        }
    }

    public void marshal(Object object, MarshalRecord marshalRecord) {
        boolean bl = object instanceof XMLRoot;
        this.marshal(object, marshalRecord, this.getDescriptor(object, bl), bl);
    }

    private void marshal(Object object, MarshalRecord marshalRecord, XMLDescriptor xMLDescriptor, boolean bl) {
        Object object2;
        this.addDescriptorNamespacesToXMLRecord(xMLDescriptor, marshalRecord);
        NamespaceResolver namespaceResolver = marshalRecord.getNamespaceResolver();
        XMLRoot xMLRoot = null;
        if (bl) {
            xMLRoot = (XMLRoot)object;
        }
        if (this.getMarshalListener() != null) {
            this.getMarshalListener().beforeMarshal(object);
        }
        if (!this.isFragment()) {
            object2 = this.getEncoding();
            String string = DEFAULT_XML_VERSION;
            if (!bl) {
                marshalRecord.setLeafElementType(xMLDescriptor.getDefaultRootElementType());
            } else {
                if (xMLRoot.getEncoding() != null) {
                    object2 = xMLRoot.getEncoding();
                }
                if (xMLRoot.getXMLVersion() != null) {
                    string = xMLRoot.getXMLVersion();
                }
            }
            marshalRecord.startDocument((String)object2, string);
        }
        object2 = this.buildRootFragment(object, xMLDescriptor, bl, marshalRecord);
        boolean bl2 = this.shouldWriteTypeAttribute(object, xMLDescriptor, bl);
        String string = this.getSchemaLocation();
        String string2 = this.getNoNamespaceSchemaLocation();
        if (bl) {
            object = xMLRoot.getObject();
            if (xMLRoot.getSchemaLocation() != null) {
                string = xMLRoot.getSchemaLocation();
            }
            if (xMLRoot.getNoNamespaceSchemaLocation() != null) {
                string2 = xMLRoot.getNoNamespaceSchemaLocation();
            }
            marshalRecord.setLeafElementType(xMLRoot.getSchemaType());
        }
        String string3 = null;
        if ((null != this.getSchemaLocation() || null != this.getNoNamespaceSchemaLocation() || bl2) && null == (string3 = namespaceResolver.resolveNamespaceURI("http://www.w3.org/2001/XMLSchema-instance"))) {
            string3 = "xsi";
            namespaceResolver.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        }
        TreeObjectBuilder treeObjectBuilder = null;
        AbstractSession abstractSession = null;
        if (xMLDescriptor != null) {
            abstractSession = this.xmlContext.getSession(object);
            treeObjectBuilder = (TreeObjectBuilder)xMLDescriptor.getObjectBuilder();
        } else {
            abstractSession = (AbstractSession)((Object)this.xmlContext.getSession(0));
        }
        marshalRecord.setSession(abstractSession);
        if (null != object2) {
            marshalRecord.startPrefixMappings(namespaceResolver);
            if (!bl && xMLDescriptor.getNamespaceResolver() == null && ((XPathFragment)object2).hasNamespace()) {
                throw XMLMarshalException.namespaceResolverNotSpecified(((XPathFragment)object2).getShortName());
            }
            marshalRecord.openStartElement((XPathFragment)object2, namespaceResolver);
            if (null != string) {
                marshalRecord.attribute("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation", string3 + ":" + "schemaLocation", string);
            }
            if (null != string2) {
                marshalRecord.attribute("http://www.w3.org/2001/XMLSchema-instance", "noNamespaceSchemaLocation", string3 + ":" + "noNamespaceSchemaLocation", string2);
            }
            if (xMLDescriptor != null) {
                if (bl2) {
                    this.writeTypeAttribute(marshalRecord, xMLDescriptor, string3);
                }
                treeObjectBuilder.marshalAttributes(marshalRecord, object, abstractSession);
            }
            marshalRecord.namespaceDeclarations(namespaceResolver);
            marshalRecord.closeStartElement();
        }
        if (treeObjectBuilder != null) {
            treeObjectBuilder.buildRow((AbstractRecord)marshalRecord, object, abstractSession, this);
        } else if (bl) {
            String string4 = null;
            string4 = (String)XMLConversionManager.getDefaultXMLManager().convertObject(object, String.class, xMLRoot.getSchemaType());
            marshalRecord.characters(string4);
        }
        if (null != object2) {
            marshalRecord.endElement((XPathFragment)object2, namespaceResolver);
            marshalRecord.endPrefixMappings(namespaceResolver);
        }
        if (!this.isFragment()) {
            marshalRecord.endDocument();
        }
        if (this.getMarshalListener() != null) {
            this.getMarshalListener().afterMarshal(object);
        }
    }

    private XPathFragment buildRootFragment(Object object, XMLDescriptor xMLDescriptor, boolean bl, MarshalRecord marshalRecord) {
        XPathFragment xPathFragment = null;
        if (bl) {
            xPathFragment = ((XMLRoot)object).getRootFragment();
            String string = ((XMLRoot)object).getNamespaceURI();
            String string2 = ((XMLRoot)object).getLocalName();
            if (string != null) {
                if (xMLDescriptor != null) {
                    String string3 = marshalRecord.getNamespaceResolver().resolveNamespaceURI(string);
                    if (string3 == null && !string.equals(marshalRecord.getNamespaceResolver().getDefaultNamespaceURI())) {
                        string3 = marshalRecord.getNamespaceResolver().generatePrefix();
                        marshalRecord.getNamespaceResolver().put(string3, string);
                    }
                    if (string3 == null) {
                        xPathFragment.setXPath(string2);
                    } else {
                        xPathFragment.setXPath(string3 + ":" + string2);
                    }
                } else {
                    String string4 = "ns0";
                    marshalRecord.getNamespaceResolver().put(string4, string);
                    xPathFragment.setXPath(string4 + ":" + string2);
                }
            }
        } else {
            String string = xMLDescriptor.getDefaultRootElement();
            if (null != string) {
                xPathFragment = new XPathFragment(string);
                NamespaceResolver namespaceResolver = xMLDescriptor.getNamespaceResolver();
                if (xPathFragment.getPrefix() != null && xPathFragment.getNamespaceURI() == null) {
                    String string5 = null;
                    if (null == namespaceResolver) {
                        throw XMLMarshalException.namespaceResolverNotSpecified(null);
                    }
                    string5 = xMLDescriptor.getNamespaceResolver().resolveNamespacePrefix(xPathFragment.getPrefix());
                    if (string5 == null) {
                        throw XMLMarshalException.namespaceNotFound(xPathFragment.getPrefix());
                    }
                    xPathFragment.setNamespaceURI(string5);
                } else if (namespaceResolver != null) {
                    xPathFragment.setNamespaceURI(namespaceResolver.getDefaultNamespaceURI());
                }
            }
        }
        return xPathFragment;
    }

    private void writeTypeAttribute(MarshalRecord marshalRecord, XMLDescriptor xMLDescriptor, String string) {
        String string2 = xMLDescriptor.getSchemaReference().getSchemaContext();
        if (string2 == null) {
            QName qName = xMLDescriptor.getSchemaReference().getSchemaContextAsQName();
            if (qName == null) {
                return;
            }
            String string3 = qName.getNamespaceURI();
            String string4 = qName.getLocalPart();
            String string5 = marshalRecord.getNamespaceResolver().resolveNamespaceURI(string3);
            if (string5 == null) {
                String string6 = marshalRecord.getNamespaceResolver().getDefaultNamespaceURI();
                if (string6 != null && string6.equals(string3)) {
                    string2 = string4;
                } else {
                    string5 = marshalRecord.getNamespaceResolver().generatePrefix();
                    marshalRecord.attribute("http://www.w3.org/2000/xmlns/", "xmlns", "xmlns:" + string5, string3);
                    string2 = string5 + ":" + string4;
                }
            } else {
                string2 = string5 + ":" + string4;
            }
        } else {
            string2 = string2.substring(1);
        }
        marshalRecord.attribute("http://www.w3.org/2001/XMLSchema-instance", "type", string + ":" + "type", string2);
    }

    private boolean isSimpleXMLRoot(XMLRoot xMLRoot) {
        Class<?> clazz = xMLRoot.getObject().getClass();
        return XMLConversionManager.getDefaultJavaTypes().get(clazz) != null || ClassConstants.List_Class.isAssignableFrom(clazz) || ClassConstants.XML_GREGORIAN_CALENDAR.isAssignableFrom(clazz) || ClassConstants.DURATION.isAssignableFrom(clazz);
    }

    public Document objectToXML(Object object) throws XMLMarshalException {
        boolean bl = object instanceof XMLRoot;
        XMLDescriptor xMLDescriptor = this.getDescriptor(object, bl);
        return this.objectToXML(object, xMLDescriptor, bl);
    }

    protected Document objectToXML(Object object, XMLDescriptor xMLDescriptor, boolean bl) throws XMLMarshalException {
        AbstractSession abstractSession = this.xmlContext.getSession(xMLDescriptor);
        if (abstractSession != null && this.xmlContext.getDocumentPreservationPolicy(abstractSession).shouldPreserveDocument()) {
            XMLRecord xMLRecord = null;
            if (!bl) {
                xMLRecord = (XMLRecord)((XMLObjectBuilder)xMLDescriptor.getObjectBuilder()).createRecordFor(object, this.xmlContext.getDocumentPreservationPolicy(abstractSession));
                xMLRecord.setMarshaller(this);
                this.addDescriptorNamespacesToXMLRecord(xMLDescriptor, xMLRecord);
            }
            return this.objectToXML(object, xMLDescriptor, xMLRecord, bl);
        }
        NodeRecord nodeRecord = new NodeRecord();
        nodeRecord.setMarshaller(this);
        this.marshal(object, nodeRecord, xMLDescriptor, bl);
        return ((MarshalRecord)nodeRecord).getDocument();
    }

    protected Node objectToXMLNode(Object object, XMLDescriptor xMLDescriptor, boolean bl) throws XMLMarshalException {
        return this.objectToXMLNode(object, null, xMLDescriptor, bl);
    }

    protected Node objectToXMLNode(Object object, Node node, XMLDescriptor xMLDescriptor, boolean bl) throws XMLMarshalException {
        AbstractSession abstractSession = this.xmlContext.getSession(xMLDescriptor);
        if (abstractSession != null && this.xmlContext.getDocumentPreservationPolicy(abstractSession).shouldPreserveDocument()) {
            XMLRecord xMLRecord = null;
            if (!bl) {
                xMLRecord = (XMLRecord)((XMLObjectBuilder)xMLDescriptor.getObjectBuilder()).createRecordFor(object, this.xmlContext.getDocumentPreservationPolicy(abstractSession));
                xMLRecord.setMarshaller(this);
                if (xMLRecord.getDOM().getNodeType() == 1) {
                    this.addDescriptorNamespacesToXMLRecord(xMLDescriptor, xMLRecord);
                }
            }
            Document document = this.objectToXML(object, node, xMLDescriptor, xMLRecord, bl);
            if (xMLRecord != null && xMLRecord.getDOM().getNodeType() == 11) {
                return xMLRecord.getDOM();
            }
            return document;
        }
        NodeRecord nodeRecord = new NodeRecord();
        nodeRecord.setMarshaller(this);
        nodeRecord.getNamespaceResolver().setDOM(node);
        this.marshal(object, nodeRecord, xMLDescriptor, bl);
        return ((MarshalRecord)nodeRecord).getDocument();
    }

    private void addDescriptorNamespacesToXMLRecord(XMLDescriptor xMLDescriptor, XMLRecord xMLRecord) {
        if (null == xMLDescriptor) {
            return;
        }
        this.copyNamespaces(xMLDescriptor.getNamespaceResolver(), xMLRecord.getNamespaceResolver());
    }

    private void copyNamespaces(NamespaceResolver namespaceResolver, NamespaceResolver namespaceResolver2) {
        if (null != namespaceResolver && null != namespaceResolver2) {
            Vector vector = namespaceResolver.getNamespaces();
            for (int i = 0; i < vector.size(); ++i) {
                Namespace namespace = (Namespace)vector.get(i);
                namespaceResolver2.put(namespace.getPrefix(), namespace.getNamespaceURI());
            }
            namespaceResolver2.setDefaultNamespaceURI(namespaceResolver.getDefaultNamespaceURI());
        }
    }

    public Document objectToXML(Object object, Node node) throws XMLMarshalException {
        boolean bl = object instanceof XMLRoot;
        XMLDescriptor xMLDescriptor = this.getDescriptor(object, bl);
        String string = xMLDescriptor.getDefaultRootElement();
        if (null == string) {
            throw XMLMarshalException.defaultRootElementNotSpecified(xMLDescriptor);
        }
        AbstractSession abstractSession = this.xmlContext.getSession(xMLDescriptor);
        if (abstractSession != null && this.xmlContext.getDocumentPreservationPolicy(abstractSession).shouldPreserveDocument()) {
            XMLRecord xMLRecord = (XMLRecord)((XMLObjectBuilder)xMLDescriptor.getObjectBuilder()).createRecord(string, node, abstractSession);
            xMLRecord.setMarshaller(this);
            return this.objectToXML(object, xMLDescriptor, xMLRecord, bl);
        }
        NodeRecord nodeRecord = new NodeRecord(string, node);
        nodeRecord.setMarshaller(this);
        this.marshal(object, nodeRecord, xMLDescriptor, bl);
        return ((MarshalRecord)nodeRecord).getDocument();
    }

    public Document objectToXML(Object object, XMLDescriptor xMLDescriptor, XMLRecord xMLRecord, boolean bl) {
        return this.objectToXML(object, null, xMLDescriptor, xMLRecord, bl);
    }

    private Document objectToXML(Object object, Node node, XMLDescriptor xMLDescriptor, XMLRecord xMLRecord, boolean bl) {
        Object object2;
        short s;
        if (null != node && (s = node.getNodeType()) != 9 && s != 1 && s != 11) {
            throw XMLMarshalException.marshalException(null);
        }
        Document document = null;
        NamespaceResolver namespaceResolver = new NamespaceResolver();
        namespaceResolver.setDOM(node);
        this.copyNamespaces(xMLDescriptor.getNamespaceResolver(), namespaceResolver);
        boolean bl2 = false;
        boolean bl3 = false;
        AbstractSession abstractSession = this.xmlContext.getSession(xMLDescriptor);
        if (xMLRecord != null) {
            boolean bl4 = bl3 = xMLRecord.getDOM().getNodeType() == 11;
        }
        if (bl) {
            Object object3;
            object2 = ((XMLRoot)object).getNamespaceURI();
            String string = null;
            if (xMLRecord == null) {
                object3 = ((XMLRoot)object).getLocalName();
                if (object2 != null) {
                    string = namespaceResolver.resolveNamespaceURI((String)object2);
                    if (string == null && !((String)object2).equals(namespaceResolver.getDefaultNamespaceURI())) {
                        string = namespaceResolver.generatePrefix();
                        namespaceResolver.put(string, (String)object2);
                        bl2 = true;
                    }
                    if (string != null) {
                        object3 = string + ":" + (String)object3;
                    }
                }
                xMLRecord = (XMLRecord)((XMLObjectBuilder)xMLDescriptor.getObjectBuilder()).createRecordFor(((XMLRoot)object).getObject(), this.xmlContext.getDocumentPreservationPolicy(abstractSession), (String)object3, (String)object2);
                xMLRecord.setMarshaller(this);
                if (!bl3 && bl2) {
                    if (string != null) {
                        ((Element)xMLRecord.getDOM()).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + string, (String)object2);
                    }
                    bl2 = false;
                }
            }
            this.copyNamespaces(namespaceResolver, xMLRecord.getNamespaceResolver());
            document = xMLRecord.getDocument();
            object3 = document.getDocumentElement();
            xMLRecord.getNamespaceResolver().put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            boolean bl5 = this.shouldWriteTypeAttribute(object, xMLDescriptor, bl);
            if (bl5 && xMLDescriptor.getSchemaReference() != null && xMLDescriptor.getSchemaReference().getSchemaContext() != null) {
                ((Element)xMLRecord.getDOM()).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
                String string2 = xMLDescriptor.getSchemaReference().getSchemaContext();
                string2 = string2.substring(1);
                XMLField xMLField = new XMLField("@xsi:type");
                xMLField.setNamespaceResolver(xMLRecord.getNamespaceResolver());
                XPathEngine.getInstance().create(xMLField, (Node)object3, string2, abstractSession);
            }
            object = ((XMLRoot)object).getObject();
        }
        object2 = (XMLObjectBuilder)xMLDescriptor.getObjectBuilder();
        xMLRecord = (XMLRecord)((XMLObjectBuilder)object2).buildRow(xMLRecord, object, this.xmlContext.getSession(object), bl);
        xMLRecord.setMarshaller(this);
        if (bl2 && !bl3) {
            ((Element)xMLRecord.getDOM()).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        }
        document = xMLRecord.getDocument();
        this.addSchemaLocations(document, abstractSession);
        return document;
    }

    private void addSchemaLocations(Document document, AbstractSession abstractSession) {
        XMLField xMLField;
        Element element = document.getDocumentElement();
        NamespaceResolver namespaceResolver = new NamespaceResolver();
        namespaceResolver.put("xmlns", "http://www.w3.org/2000/xmlns/");
        namespaceResolver.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        if (this.getSchemaLocation() != null || this.getNoNamespaceSchemaLocation() != null) {
            xMLField = new XMLField("@xmlns:xsi");
            xMLField.setNamespaceResolver(namespaceResolver);
            XPathEngine.getInstance().create(xMLField, element, "http://www.w3.org/2001/XMLSchema-instance", abstractSession);
        }
        if (this.getSchemaLocation() != null) {
            xMLField = new XMLField("@xsi:schemaLocation");
            xMLField.setNamespaceResolver(namespaceResolver);
            XPathEngine.getInstance().create(xMLField, element, this.getSchemaLocation(), abstractSession);
        }
        if (this.getNoNamespaceSchemaLocation() != null) {
            xMLField = new XMLField("@xsi:noNamespaceSchemaLocation");
            xMLField.setNamespaceResolver(namespaceResolver);
            XPathEngine.getInstance().create(xMLField, element, this.getNoNamespaceSchemaLocation(), abstractSession);
        }
    }

    public boolean shouldWriteTypeAttribute(Object object, XMLDescriptor xMLDescriptor, boolean bl) {
        boolean bl2 = false;
        if (bl && xMLDescriptor != null) {
            String string;
            String string2;
            Object object2;
            Serializable serializable;
            XMLRoot xMLRoot = (XMLRoot)object;
            if (xMLDescriptor.hasInheritance()) {
                serializable = (XMLField)xMLDescriptor.getInheritancePolicy().getClassIndicatorField();
                object2 = null;
                string2 = ((XMLField)serializable).getXPathFragment().getLocalName();
                string = ((XMLField)serializable).getXPathFragment().getPrefix();
                if (string != null) {
                    object2 = xMLDescriptor.getNamespaceResolver().resolveNamespacePrefix(string);
                }
                if (string2 != null && string2.equals("type") && object2 != null && ((String)object2).equals("http://www.w3.org/2001/XMLSchema-instance")) {
                    return false;
                }
            }
            if ((object2 = this.xmlContext.getDescriptor((QName)(serializable = new QName(xMLRoot.getNamespaceURI(), xMLRoot.getLocalName())))) != null) {
                return ((ClassDescriptor)object2).getJavaClass() != xMLDescriptor.getJavaClass();
            }
            if (xMLDescriptor.getSchemaReference() == null) {
                return false;
            }
            string2 = xMLRoot.getLocalName();
            string = xMLRoot.getNamespaceURI();
            bl2 = true;
            for (int i = 0; i < xMLDescriptor.getTableNames().size() && bl2; ++i) {
                String string3 = (String)xMLDescriptor.getTableNames().get(i);
                if (string3 != null) {
                    String string4 = null;
                    String string5 = null;
                    int n = string3.indexOf(58);
                    if (n > 0) {
                        String string6 = string3.substring(0, n);
                        string4 = string3.substring(n + 1);
                        if (xMLDescriptor.getNamespaceResolver() != null) {
                            string5 = xMLDescriptor.getNamespaceResolver().resolveNamespacePrefix(string6);
                        }
                    } else {
                        string4 = string3;
                    }
                    if (string2 == null || (string4 != null || string2 != null) && !string4.equals(string2) || (string5 != null || string != null) && (string == null || string5 == null || !string5.equals(string))) continue;
                    bl2 = false;
                    continue;
                }
                if (string2 != null) continue;
                bl2 = false;
            }
        }
        return bl2;
    }

    protected XMLDescriptor getDescriptor(Object object) throws XMLMarshalException {
        XMLDescriptor xMLDescriptor = (XMLDescriptor)this.xmlContext.getSession(object).getDescriptor(object);
        if (xMLDescriptor == null) {
            throw XMLMarshalException.descriptorNotFoundInProject(object.getClass().getName());
        }
        return xMLDescriptor;
    }

    protected XMLDescriptor getDescriptor(Object object, boolean bl) {
        if (bl) {
            return this.getDescriptor((XMLRoot)object);
        }
        return this.getDescriptor(object);
    }

    protected XMLDescriptor getDescriptor(XMLRoot xMLRoot) throws XMLMarshalException {
        XMLDescriptor xMLDescriptor = null;
        try {
            xMLDescriptor = (XMLDescriptor)this.xmlContext.getSession(xMLRoot.getObject()).getDescriptor(xMLRoot.getObject());
        }
        catch (XMLMarshalException xMLMarshalException) {
            if (xMLDescriptor == null && this.isSimpleXMLRoot(xMLRoot)) {
                return null;
            }
            throw xMLMarshalException;
        }
        if (xMLDescriptor == null) {
            throw XMLMarshalException.descriptorNotFoundInProject(xMLRoot.getClass().getName());
        }
        return xMLDescriptor;
    }

    public void setFragment(boolean bl) {
        this.transformer.setFragment(bl);
    }

    public boolean isFragment() {
        return this.transformer.isFragment();
    }

    public void setAttachmentMarshaller(XMLAttachmentMarshaller xMLAttachmentMarshaller) {
        this.attachmentMarshaller = xMLAttachmentMarshaller;
    }

    public XMLAttachmentMarshaller getAttachmentMarshaller() {
        return this.attachmentMarshaller;
    }

    public XMLTransformer getTransformer() {
        return this.transformer;
    }
}

