/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.mappings.converters;

import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.mappings.converters.XMLConverter;
import org.eclipse.persistence.sessions.Session;

public class XMLRootConverter
implements XMLConverter {
    private XPathFragment rootFragment;
    private XMLField associatedField;
    private DatabaseMapping mapping;

    public XMLRootConverter(XMLField xMLField) {
        this.associatedField = xMLField;
    }

    public Object convertDataValueToObjectValue(Object object, Session session, XMLUnmarshaller xMLUnmarshaller) {
        return this.convertDataValueToObjectValue(object, session);
    }

    public Object convertObjectValueToDataValue(Object object, Session session, XMLMarshaller xMLMarshaller) {
        return this.convertObjectValueToDataValue(object, session);
    }

    public Object convertDataValueToObjectValue(Object object, Session session) {
        XMLRoot xMLRoot = new XMLRoot();
        xMLRoot.setLocalName(this.rootFragment.getLocalName());
        xMLRoot.setNamespaceURI(this.rootFragment.getNamespaceURI());
        if (this.mapping.isAbstractDirectMapping() && (object == null || object.getClass() != this.mapping.getAttributeClassification())) {
            try {
                object = session.getDatasourcePlatform().convertObject(object, this.mapping.getAttributeClassification());
            }
            catch (ConversionException conversionException) {
                throw ConversionException.couldNotBeConverted((Object)this, this.mapping.getDescriptor(), conversionException);
            }
        }
        xMLRoot.setObject(object);
        return xMLRoot;
    }

    public Object convertObjectValueToDataValue(Object object, Session session) {
        if (object instanceof XMLRoot) {
            return ((XMLRoot)object).getObject();
        }
        return object;
    }

    public void initialize(DatabaseMapping databaseMapping, Session session) {
        XPathFragment xPathFragment = this.associatedField.getXPathFragment();
        while (xPathFragment.getNextFragment() != null && !xPathFragment.getNextFragment().nameIsText()) {
            xPathFragment = xPathFragment.getNextFragment();
        }
        this.rootFragment = xPathFragment;
        this.mapping = databaseMapping;
    }

    public boolean isMutable() {
        return false;
    }
}

