/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.schema;

import java.net.URL;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.platform.xml.XMLPlatform;
import org.eclipse.persistence.platform.xml.XMLPlatformException;
import org.eclipse.persistence.platform.xml.XMLPlatformFactory;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;

public abstract class XMLSchemaReference
implements org.eclipse.persistence.platform.xml.XMLSchemaReference {
    protected String resource;
    protected String schemaContext;
    protected int type = 1;
    protected QName schemaContextAsQName;

    protected XMLSchemaReference() {
    }

    protected XMLSchemaReference(String string) {
        this();
        this.resource = string;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String string) {
        this.resource = string;
    }

    public abstract URL getURL();

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        if (n < 1 || n > 3 && n != 5) {
            throw XMLPlatformException.xmlPlatformInvalidTypeException(n);
        }
        this.type = n;
    }

    public String getSchemaContext() {
        return this.schemaContext;
    }

    public void setSchemaContext(String string) {
        this.schemaContext = string;
    }

    public void setSchemaContextAsQName(QName qName) {
        this.schemaContextAsQName = qName;
    }

    public QName getSchemaContextAsQName() {
        return this.schemaContextAsQName;
    }

    public QName getSchemaContextAsQName(NamespaceResolver namespaceResolver) {
        if (this.schemaContext == null) {
            return null;
        }
        if (this.schemaContextAsQName == null) {
            String string;
            int n = this.schemaContext.lastIndexOf("/");
            if (n == -1) {
                n = 0;
            }
            if ((n = (string = this.schemaContext.substring(n + 1)).indexOf(":")) != -1) {
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + 1);
                String string4 = namespaceResolver.resolveNamespacePrefix(string2);
                this.schemaContextAsQName = new QName(string4, string3);
            } else {
                this.schemaContextAsQName = namespaceResolver != null && namespaceResolver.getDefaultNamespaceURI() != null ? new QName(namespaceResolver.getDefaultNamespaceURI(), string) : new QName(string);
            }
        }
        return this.schemaContextAsQName;
    }

    public boolean isValid(Document document, ErrorHandler errorHandler) {
        try {
            XMLPlatform xMLPlatform = XMLPlatformFactory.getInstance().getXMLPlatform();
            return xMLPlatform.validateDocument(document, this.getURL(), errorHandler);
        }
        catch (XMLPlatformException xMLPlatformException) {
            if (xMLPlatformException.getErrorCode() == 27006) {
                throw XMLMarshalException.errorResolvingXMLSchema(xMLPlatformException);
            }
            return false;
        }
    }

    public boolean isGlobalDefinition() {
        return this.schemaContext.lastIndexOf("/") <= 0;
    }

    public void initialize(AbstractSession abstractSession) {
    }
}

