/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.List;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.indirection.IndirectContainer;
import org.eclipse.persistence.internal.expressions.ForUpdateClause;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadQuery;

public abstract class ObjectBuildingQuery
extends ReadQuery {
    protected Class referenceClass;
    protected String referenceClassName;
    protected boolean shouldRefreshIdentityMapResult = false;
    protected boolean shouldRefreshRemoteIdentityMapResult;
    protected boolean shouldRegisterResultsInUnitOfWork = true;
    protected boolean shouldProcessResultsInUnitOfWork = true;
    protected ForUpdateClause lockingClause;
    public static final short NO_LOCK = 0;
    public static final short LOCK = 1;
    public static final short LOCK_NOWAIT = 2;
    public static final short DEFAULT_LOCK_MODE = -1;
    protected long executionTime = 0L;
    protected boolean shouldUseExclusiveConnection = false;
    public static final String LOCK_RESULT_PROPERTY = "LOCK_RESULT";
    protected boolean wasDefaultLockMode = false;
    protected boolean shouldBuildNullForNullPk;

    public void convertClassNamesToClasses(ClassLoader classLoader) {
        Class clazz;
        block5: {
            super.convertClassNamesToClasses(classLoader);
            clazz = null;
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        clazz = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.getReferenceClassName(), true, classLoader));
                        break block5;
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        throw ValidationException.classNotFoundWhileConvertingClassNames(this.getReferenceClassName(), privilegedActionException.getException());
                    }
                }
                clazz = PrivilegedAccessHelper.getClassForName(this.getReferenceClassName(), true, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw ValidationException.classNotFoundWhileConvertingClassNames(this.getReferenceClassName(), classNotFoundException);
            }
        }
        this.setReferenceClass(clazz);
    }

    protected boolean wasDefaultLockMode() {
        return this.wasDefaultLockMode;
    }

    protected void setWasDefaultLockMode(boolean bl) {
        this.wasDefaultLockMode = bl;
    }

    public Object deepClone() {
        return this.clone();
    }

    public void copyFromQuery(DatabaseQuery databaseQuery) {
        super.copyFromQuery(databaseQuery);
        if (databaseQuery.isObjectBuildingQuery()) {
            ObjectBuildingQuery objectBuildingQuery = (ObjectBuildingQuery)databaseQuery;
            this.shouldBuildNullForNullPk = objectBuildingQuery.shouldBuildNullForNullPk;
            this.shouldProcessResultsInUnitOfWork = objectBuildingQuery.shouldProcessResultsInUnitOfWork;
            this.shouldRefreshIdentityMapResult = objectBuildingQuery.shouldRefreshIdentityMapResult;
            this.shouldRefreshRemoteIdentityMapResult = objectBuildingQuery.shouldRefreshRemoteIdentityMapResult;
            this.shouldRegisterResultsInUnitOfWork = objectBuildingQuery.shouldRegisterResultsInUnitOfWork;
            this.shouldUseExclusiveConnection = objectBuildingQuery.shouldUseExclusiveConnection;
        }
    }

    public void prepareFromQuery(DatabaseQuery databaseQuery) {
        super.prepareFromQuery(databaseQuery);
        if (databaseQuery.isObjectBuildingQuery()) {
            ObjectBuildingQuery objectBuildingQuery = (ObjectBuildingQuery)databaseQuery;
            this.referenceClass = objectBuildingQuery.referenceClass;
            this.referenceClassName = objectBuildingQuery.referenceClassName;
            this.lockingClause = objectBuildingQuery.lockingClause;
            this.wasDefaultLockMode = objectBuildingQuery.wasDefaultLockMode;
        }
    }

    public void dontRefreshIdentityMapResult() {
        this.setShouldRefreshIdentityMapResult(false);
    }

    public void dontRefreshRemoteIdentityMapResult() {
        this.setShouldRefreshRemoteIdentityMapResult(false);
    }

    public FetchGroup getFetchGroup() {
        return null;
    }

    public short getLockMode() {
        if (this.lockingClause == null) {
            return -1;
        }
        return this.lockingClause.getLockMode();
    }

    public List getDataResults() {
        return null;
    }

    public long getExecutionTime() {
        return this.executionTime;
    }

    public Class getReferenceClass() {
        return this.referenceClass;
    }

    public String getReferenceClassName() {
        if (this.referenceClassName == null && this.referenceClass != null) {
            this.referenceClassName = this.referenceClass.getName();
        }
        return this.referenceClassName;
    }

    public boolean hasPartialAttributeExpressions() {
        return false;
    }

    public boolean isLockQuery() {
        return this.getLockMode() > 0;
    }

    public boolean isObjectBuildingQuery() {
        return true;
    }

    protected boolean isRegisteringResults() {
        return this.shouldRegisterResultsInUnitOfWork() && this.getDescriptor().shouldRegisterResultsInUnitOfWork() || this.isLockQuery();
    }

    public void refreshIdentityMapResult() {
        this.setShouldRefreshIdentityMapResult(true);
    }

    public void refreshRemoteIdentityMapResult() {
        this.setShouldRefreshRemoteIdentityMapResult(true);
    }

    public Object registerIndividualResult(Object object, UnitOfWorkImpl unitOfWorkImpl, JoinedAttributeManager joinedAttributeManager) {
        if (unitOfWorkImpl.isClassReadOnly(object.getClass())) {
            this.recordCloneForPessimisticLocking(object, unitOfWorkImpl);
            return object;
        }
        Object object2 = null;
        if (!this.isRegisteringResults()) {
            object2 = unitOfWorkImpl.getIdentityMapAccessorInstance().getIdentityMapManager().getFromIdentityMap(object);
            if (object2 == null) {
                object2 = object;
            }
        } else {
            object2 = unitOfWorkImpl.registerExistingObject(object);
        }
        if (this.shouldRefreshIdentityMapResult()) {
            if (unitOfWorkImpl.getParent().getIdentityMapAccessor().containsObjectInIdentityMap(object2)) {
                if (this.shouldCascadeAllParts()) {
                    unitOfWorkImpl.deepRevertObject(object2);
                } else if (this.shouldCascadePrivateParts()) {
                    unitOfWorkImpl.revertObject(object2);
                } else if (this.shouldCascadeByMapping()) {
                    unitOfWorkImpl.revertObject(object2, 4);
                } else if (!this.shouldCascadeParts()) {
                    unitOfWorkImpl.shallowRevertObject(object2);
                }
            } else if (this.shouldCascadeAllParts()) {
                unitOfWorkImpl.deepMergeClone(object);
            } else if (this.shouldCascadePrivateParts()) {
                unitOfWorkImpl.mergeClone(object);
            } else if (this.shouldCascadeByMapping()) {
                unitOfWorkImpl.mergeClone(object, 4);
            } else if (!this.shouldCascadeParts()) {
                unitOfWorkImpl.shallowMergeClone(object);
            }
        }
        if (joinedAttributeManager != null && joinedAttributeManager.hasJoinedAttributeExpressions()) {
            this.triggerJoinExpressions(unitOfWorkImpl, joinedAttributeManager, object2);
        }
        return object2;
    }

    private void triggerJoinExpressions(UnitOfWorkImpl unitOfWorkImpl, JoinedAttributeManager joinedAttributeManager, Object object) {
        List<Expression> list = joinedAttributeManager.getJoinedAttributeExpressions();
        int n = list.size();
        if (n == 0 || object == null) {
            return;
        }
        ClassDescriptor classDescriptor = unitOfWorkImpl.getDescriptor(object);
        for (int i = 0; i < n; ++i) {
            QueryKeyExpression queryKeyExpression;
            Object object2;
            DatabaseMapping databaseMapping = classDescriptor.getObjectBuilder().getMappingForAttributeName(joinedAttributeManager.getJoinedAttributes().get(i));
            if (databaseMapping == null || (object2 = databaseMapping.getRealAttributeValueFromObject(object, unitOfWorkImpl)) == null) continue;
            if (databaseMapping.isForeignReferenceMapping() && ((ForeignReferenceMapping)databaseMapping).getIndirectionPolicy().usesTransparentIndirection()) {
                ((IndirectContainer)object2).getValueHolder().getValue();
            }
            if ((queryKeyExpression = (QueryKeyExpression)list.get(i)).getBaseExpression().isExpressionBuilder()) continue;
            ObjectLevelReadQuery objectLevelReadQuery = null;
            if (joinedAttributeManager.getJoinedMappingQueryClones() == null) {
                if (joinedAttributeManager.getJoinedMappingQueries_() != null) {
                    objectLevelReadQuery = joinedAttributeManager.getJoinedMappingQueries_().get(databaseMapping);
                }
            } else {
                objectLevelReadQuery = joinedAttributeManager.getJoinedMappingQueryClones().get(databaseMapping);
            }
            if (objectLevelReadQuery == null || objectLevelReadQuery.getJoinedAttributeManager() == null) continue;
            if (!databaseMapping.isCollectionMapping()) {
                this.triggerJoinExpressions(unitOfWorkImpl, objectLevelReadQuery.getJoinedAttributeManager(), object2);
                continue;
            }
            ContainerPolicy containerPolicy = ((CollectionMapping)databaseMapping).getContainerPolicy();
            Object object3 = containerPolicy.iteratorFor(object2);
            while (containerPolicy.hasNext(object3)) {
                this.triggerJoinExpressions(unitOfWorkImpl, objectLevelReadQuery.getJoinedAttributeManager(), containerPolicy.next(object3, unitOfWorkImpl));
            }
        }
    }

    public void setExecutionTime(long l) {
        this.executionTime = l;
    }

    public void setLockMode(short s) {
        this.lockingClause = ForUpdateClause.newInstance(s);
    }

    public void setReferenceClass(Class clazz) {
        this.referenceClass = clazz;
        this.setIsPrepared(false);
    }

    public void setReferenceClassName(String string) {
        this.referenceClassName = string;
        this.setIsPrepared(false);
    }

    public void setShouldRefreshIdentityMapResult(boolean bl) {
        this.shouldRefreshIdentityMapResult = bl;
        if (bl) {
            this.setShouldRefreshRemoteIdentityMapResult(true);
        }
    }

    public void setShouldRefreshRemoteIdentityMapResult(boolean bl) {
        this.shouldRefreshRemoteIdentityMapResult = bl;
    }

    public void setShouldRegisterResultsInUnitOfWork(boolean bl) {
        this.shouldRegisterResultsInUnitOfWork = bl;
    }

    public void setShouldUseExclusiveConnection(boolean bl) {
        this.shouldUseExclusiveConnection = bl;
    }

    public boolean shouldRegisterResultsInUnitOfWork() {
        return this.shouldRegisterResultsInUnitOfWork;
    }

    public boolean shouldUseExclusiveConnection() {
        return this.shouldUseExclusiveConnection;
    }

    public boolean shouldReadAllMappings() {
        return true;
    }

    public boolean shouldReadMapping(DatabaseMapping databaseMapping) {
        return true;
    }

    public boolean shouldRefreshIdentityMapResult() {
        return this.shouldRefreshIdentityMapResult;
    }

    public boolean shouldRefreshRemoteIdentityMapResult() {
        return this.shouldRefreshRemoteIdentityMapResult;
    }

    public void setShouldProcessResultsInUnitOfWork(boolean bl) {
        this.shouldProcessResultsInUnitOfWork = bl;
    }

    public boolean shouldProcessResultsInUnitOfWork() {
        return this.shouldProcessResultsInUnitOfWork;
    }

    public boolean isAttributeJoined(ClassDescriptor classDescriptor, String string) {
        return false;
    }

    public boolean isClonePessimisticLocked(Object object, UnitOfWorkImpl unitOfWorkImpl) {
        return false;
    }

    public void recordCloneForPessimisticLocking(Object object, UnitOfWorkImpl unitOfWorkImpl) {
        if (this.isLockQuery() && this.lockingClause.isReferenceClassLocked()) {
            unitOfWorkImpl.addPessimisticLockedClone(object);
        }
    }

    public boolean isDefaultLock() {
        return this.lockingClause == null;
    }

    public boolean shouldBuildNullForNullPk() {
        return this.shouldBuildNullForNullPk;
    }

    public void setShouldBuildNullForNullPk(boolean bl) {
        this.shouldBuildNullForNullPk = bl;
    }
}

