/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DoesExistQuery;
import org.eclipse.persistence.queries.ObjectLevelModifyQuery;
import org.eclipse.persistence.queries.QueryRedirector;

public class WriteObjectQuery
extends ObjectLevelModifyQuery {
    public WriteObjectQuery() {
    }

    public WriteObjectQuery(Object object) {
        this();
        this.setObject(object);
    }

    public WriteObjectQuery(Call call) {
        this();
        this.setCall(call);
    }

    public Object executeDatabaseQuery() throws DatabaseException, OptimisticLockException {
        if (this.getObjectChangeSet() != null) {
            return this.getQueryMechanism().executeWriteWithChangeSet();
        }
        return this.getQueryMechanism().executeWrite();
    }

    public void executeCommit() throws DatabaseException, OptimisticLockException {
        boolean bl;
        if (this.getSession().isUnitOfWork()) {
            boolean bl2 = bl = !((UnitOfWorkImpl)this.getSession()).isCloneNewObject(this.getObject());
            if (bl) {
                bl = ((UnitOfWorkImpl)this.getSession()).isObjectRegistered(this.getObject());
            }
        } else {
            DoesExistQuery doesExistQuery = (DoesExistQuery)this.getDescriptor().getQueryManager().getDoesExistQuery().clone();
            doesExistQuery.setObject(this.getObject());
            doesExistQuery.setPrimaryKey(this.getPrimaryKey());
            doesExistQuery.setDescriptor(this.getDescriptor());
            doesExistQuery.setTranslationRow(this.getTranslationRow());
            bl = (Boolean)this.getSession().executeQuery(doesExistQuery);
        }
        if (bl) {
            this.getQueryMechanism().updateObjectForWrite();
        } else {
            this.getQueryMechanism().insertObjectForWrite();
        }
    }

    public void executeCommitWithChangeSet() throws DatabaseException, OptimisticLockException {
        if (!this.getObjectChangeSet().isNew()) {
            if (!this.getSession().getCommitManager().isCommitInPreModify(this.getObject())) {
                this.getQueryMechanism().updateObjectForWriteWithChangeSet();
            }
        } else if (this.getSession().getCommitManager().isCommitInPreModify(this.getObject())) {
            this.dontCascadeParts();
            this.getQueryMechanism().insertObjectForWrite();
            this.getSession().getCommitManager().markShallowCommit(this.object);
        } else {
            this.getQueryMechanism().insertObjectForWrite();
        }
    }

    protected QueryRedirector getDefaultRedirector() {
        return this.descriptor.getDefaultQueryRedirector();
    }

    public boolean isWriteObjectQuery() {
        return true;
    }

    public void prepareForExecution() throws QueryException {
        super.prepareForExecution();
        if (!this.isInsertObjectQuery() && (this.getTranslationRow() == null || this.getTranslationRow().isEmpty())) {
            this.setTranslationRow(this.getDescriptor().getObjectBuilder().buildRowForTranslation(this.getObject(), this.getSession()));
        }
    }
}

