/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.xr;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DBWSException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.descriptors.InstantiationPolicy;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.internal.xr.Attachment;
import org.eclipse.persistence.internal.xr.AttachmentHelper;
import org.eclipse.persistence.internal.xr.Invocation;
import org.eclipse.persistence.internal.xr.Operation;
import org.eclipse.persistence.internal.xr.QueryHandler;
import org.eclipse.persistence.internal.xr.Result;
import org.eclipse.persistence.internal.xr.Util;
import org.eclipse.persistence.internal.xr.ValueObject;
import org.eclipse.persistence.internal.xr.XRServiceAdapter;
import org.eclipse.persistence.internal.xr.sxf.SimpleXMLFormat;
import org.eclipse.persistence.internal.xr.sxf.SimpleXMLFormatModel;
import org.eclipse.persistence.mappings.AttributeAccessor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.oxm.mappings.XMLBinaryDataMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.oxm.mappings.XMLFragmentCollectionMapping;
import org.eclipse.persistence.oxm.schema.XMLSchemaReference;
import org.eclipse.persistence.oxm.schema.XMLSchemaURLReference;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.sessions.Session;
import org.w3c.dom.Element;

public class QueryOperation
extends Operation {
    protected Result result;
    protected QueryHandler queryHandler;
    protected boolean userDefined = true;

    public Result getResult() {
        return this.result;
    }

    public void setResult(Result result) {
        this.result = result;
    }

    public QueryHandler getQueryHandler() {
        return this.queryHandler;
    }

    public void setQueryHandler(QueryHandler queryHandler) {
        this.queryHandler = queryHandler;
    }

    public boolean isUserDefined() {
        return this.userDefined;
    }

    public void setUserDefined(boolean bl) {
        this.userDefined = bl;
    }

    public boolean isCollection() {
        return this.result.isCollection();
    }

    public boolean isSimpleXMLFormat() {
        return this.result != null && this.result.getSimpleXMLFormat() != null;
    }

    public boolean isAttachment() {
        return this.result != null && this.result.getAttachment() != null;
    }

    public QName getResultType() {
        if (this.result != null) {
            return this.result.getType();
        }
        return null;
    }

    public boolean hasResponse() {
        return this.result != null;
    }

    public void validate(XRServiceAdapter xRServiceAdapter) {
        QName qName;
        super.validate(xRServiceAdapter);
        QName qName2 = qName = this.result == null ? null : this.result.getType();
        if (qName != null && !qName.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
            boolean bl;
            boolean bl2 = bl = qName.getLocalPart().equals("simple-xml-format") || qName.getLocalPart().equals("cursor of simple-xml-format");
            if (!bl && !xRServiceAdapter.descriptorsByQName.containsKey(qName)) {
                throw DBWSException.resultHasNoMapping((String)qName.toString(), (String)this.name);
            }
        }
        if (this.queryHandler != null) {
            this.queryHandler.validate(xRServiceAdapter, this);
        }
    }

    public void initialize(XRServiceAdapter xRServiceAdapter) {
        DatabaseQuery databaseQuery;
        super.initialize(xRServiceAdapter);
        if (this.queryHandler == null && (databaseQuery = xRServiceAdapter.getORSession().getQuery(this.name)) != null) {
            this.queryHandler = new QueryHandler(){

                public void initializeDatabaseQuery(XRServiceAdapter xRServiceAdapter, QueryOperation queryOperation) {
                }

                public void initializeArguments(XRServiceAdapter xRServiceAdapter, QueryOperation queryOperation, DatabaseQuery databaseQuery) {
                }

                public void initializeCall(XRServiceAdapter xRServiceAdapter, QueryOperation queryOperation, DatabaseQuery databaseQuery) {
                }
            };
            this.queryHandler.setDatabaseQuery(databaseQuery);
        }
        if (this.queryHandler == null) {
            throw DBWSException.couldNotLocateQueryForSession((String)this.name, (String)xRServiceAdapter.getORSession().getName());
        }
        this.queryHandler.initialize(xRServiceAdapter, this);
        databaseQuery = xRServiceAdapter.getOXSession();
        QName qName = this.result == null ? null : this.result.getType();
        this.addSimpleXMLFormatModelDescriptor(xRServiceAdapter);
        this.addValueObjectDescriptor(xRServiceAdapter);
        if (qName == null && this.isAttachment()) {
            Attachment attachment = this.result.getAttachment();
            XMLDescriptor xMLDescriptor = (XMLDescriptor)databaseQuery.getProject().getClassDescriptor(DataHandler.class);
            if (xMLDescriptor == null) {
                xMLDescriptor = new XMLDescriptor();
                xMLDescriptor.setAlias("DataHandler");
                xMLDescriptor.setJavaClass(DataHandler.class);
                xMLDescriptor.setInstantiationPolicy((InstantiationPolicy)new DataHandlerInstantiationPolicy(attachment.getMimeType()));
                XMLBinaryDataMapping xMLBinaryDataMapping = new XMLBinaryDataMapping();
                xMLBinaryDataMapping.setAttributeName("results");
                xMLBinaryDataMapping.setAttributeAccessor(new AttributeAccessor(){

                    public Object getAttributeValueFromObject(Object object) throws DescriptorException {
                        Object object2 = null;
                        DataHandler dataHandler = (DataHandler)object;
                        try {
                            object2 = dataHandler.getContent();
                            if (object2 instanceof InputStream) {
                                InputStream inputStream = (InputStream)object2;
                                byte[] byArray = new byte[2048];
                                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                                int n = inputStream.read(byArray);
                                while (n >= 0) {
                                    byteArrayOutputStream.write(byArray, 0, n);
                                    n = inputStream.read(byArray);
                                }
                                object2 = byteArrayOutputStream.toByteArray();
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        return object2;
                    }

                    public void setAttributeValueInObject(Object object, Object object2) throws DescriptorException {
                    }
                });
                xMLBinaryDataMapping.setXPath("simple-xml-format/simple-xml/attachment");
                xMLBinaryDataMapping.setSwaRef(true);
                xMLBinaryDataMapping.setShouldInlineBinaryData(false);
                xMLBinaryDataMapping.setMimeType(attachment.getMimeType());
                xMLDescriptor.addMapping((DatabaseMapping)xMLBinaryDataMapping);
                NamespaceResolver namespaceResolver = new NamespaceResolver();
                xMLDescriptor.setNamespaceResolver(namespaceResolver);
                databaseQuery.getProject().addDescriptor((ClassDescriptor)xMLDescriptor);
                ((DatabaseSessionImpl)databaseQuery).initializeDescriptorIfSessionAlive((ClassDescriptor)xMLDescriptor);
                xRServiceAdapter.getXMLContext().storeXMLDescriptorByQName(xMLDescriptor);
            }
        }
    }

    protected void addValueObjectDescriptor(XRServiceAdapter xRServiceAdapter) {
        Session session = xRServiceAdapter.getOXSession();
        XMLDescriptor xMLDescriptor = (XMLDescriptor)session.getProject().getClassDescriptor(ValueObject.class);
        if (xMLDescriptor == null) {
            xMLDescriptor = new XMLDescriptor();
            xMLDescriptor.setAlias("ValueObject");
            xMLDescriptor.setJavaClass(ValueObject.class);
            XMLDirectMapping xMLDirectMapping = new XMLDirectMapping();
            xMLDirectMapping.setAttributeName("value");
            xMLDirectMapping.setXPath("value");
            xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping);
            NamespaceResolver namespaceResolver = new NamespaceResolver();
            xMLDescriptor.setNamespaceResolver(namespaceResolver);
            session.getProject().addDescriptor((ClassDescriptor)xMLDescriptor);
            ((DatabaseSessionImpl)session).initializeDescriptorIfSessionAlive((ClassDescriptor)xMLDescriptor);
            xRServiceAdapter.getXMLContext().storeXMLDescriptorByQName(xMLDescriptor);
        }
    }

    protected void addSimpleXMLFormatModelDescriptor(XRServiceAdapter xRServiceAdapter) {
        Session session;
        XMLDescriptor xMLDescriptor;
        if (this.isSimpleXMLFormat() && (xMLDescriptor = (XMLDescriptor)(session = xRServiceAdapter.getOXSession()).getProject().getClassDescriptor(SimpleXMLFormatModel.class)) == null) {
            xMLDescriptor = new XMLDescriptor();
            xMLDescriptor.setJavaClass(SimpleXMLFormatModel.class);
            xMLDescriptor.setAlias("simple-xml-format");
            xMLDescriptor.setDefaultRootElement("simple-xml-format");
            XMLFragmentCollectionMapping xMLFragmentCollectionMapping = new XMLFragmentCollectionMapping();
            xMLFragmentCollectionMapping.setAttributeName("simpleXML");
            xMLFragmentCollectionMapping.setXPath("simple-xml");
            xMLDescriptor.addMapping((DatabaseMapping)xMLFragmentCollectionMapping);
            NamespaceResolver namespaceResolver = new NamespaceResolver();
            xMLDescriptor.setNamespaceResolver(namespaceResolver);
            XMLSchemaURLReference xMLSchemaURLReference = new XMLSchemaURLReference("");
            xMLSchemaURLReference.setSchemaContext("/any");
            xMLSchemaURLReference.setType(1);
            xMLDescriptor.setSchemaReference((XMLSchemaReference)xMLSchemaURLReference);
            session.getProject().addDescriptor((ClassDescriptor)xMLDescriptor);
            ((DatabaseSessionImpl)session).initializeDescriptorIfSessionAlive((ClassDescriptor)xMLDescriptor);
            xRServiceAdapter.getXMLContext().storeXMLDescriptorByQName(xMLDescriptor);
        }
    }

    public Object invoke(XRServiceAdapter xRServiceAdapter, Invocation invocation) {
        Object object;
        DatabaseQuery databaseQuery = this.queryHandler.getDatabaseQuery();
        Vector vector = databaseQuery.getArguments();
        int n = vector.size();
        NonSynchronizedVector nonSynchronizedVector = new NonSynchronizedVector();
        for (int i = 0; i < n; ++i) {
            object = (String)vector.get(i);
            nonSynchronizedVector.add(invocation.getParameter((String)object));
        }
        Object object2 = xRServiceAdapter.getORSession().getActiveSession().executeQuery(databaseQuery, (List)nonSynchronizedVector);
        if (object2 != null) {
            if (this.isSimpleXMLFormat()) {
                object2 = this.createSimpleXMLFormat(xRServiceAdapter, object2);
            } else {
                object = this.getResultType();
                if (this.isAttachment() || !this.isCollection() && ((QName)object).equals(XMLConstants.BASE_64_BINARY_QNAME)) {
                    String string = "application/octet-stream";
                    if (this.isAttachment() && this.result.getAttachment().getMimeType() != null) {
                        string = this.result.getAttachment().getMimeType();
                    }
                    return AttachmentHelper.buildAttachmentHandler((byte[])object2, string);
                }
                if (object != null && ((QName)object).getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
                    ValueObject valueObject = new ValueObject();
                    valueObject.value = object2;
                    object2 = valueObject;
                }
            }
        }
        return object2;
    }

    public Object createSimpleXMLFormat(XRServiceAdapter xRServiceAdapter, Object object) {
        SimpleXMLFormatModel simpleXMLFormatModel;
        XMLRoot xMLRoot = new XMLRoot();
        SimpleXMLFormat simpleXMLFormat = this.result.getSimpleXMLFormat();
        String string = "simple-xml-format";
        String string2 = simpleXMLFormat.getSimpleXMLFormatTag();
        if (string2 != null && !"".equals(string2)) {
            string = string2;
        }
        xMLRoot.setLocalName(string);
        String string3 = "simple-xml";
        String string4 = simpleXMLFormat.getXMLTag();
        if (string4 != null && !"".equals(string4)) {
            string3 = string4;
        }
        Vector<SimpleXMLFormatModel> vector = null;
        if (object instanceof Vector) {
            vector = (Vector<SimpleXMLFormatModel>)object;
        } else {
            vector = new Vector<SimpleXMLFormatModel>();
            simpleXMLFormatModel = new DatabaseRecord();
            simpleXMLFormatModel.add(new DatabaseField("result"), object);
            vector.add(simpleXMLFormatModel);
        }
        simpleXMLFormatModel = new SimpleXMLFormatModel();
        XMLConversionManager xMLConversionManager = (XMLConversionManager)xRServiceAdapter.getOXSession().getDatasourcePlatform().getConversionManager();
        for (DatabaseRecord databaseRecord : vector) {
            Element element = Util.TEMP_DOC.createElement(string3);
            for (DatabaseField databaseField : databaseRecord.getFields()) {
                Object object2;
                Object object3 = databaseRecord.get(databaseField);
                if (object3 == null) continue;
                if (object3 instanceof Calendar) {
                    object2 = (Calendar)object3;
                    object3 = xMLConversionManager.convertObject(object2, ClassConstants.STRING, XMLConstants.DATE_TIME_QNAME);
                }
                if (object3 instanceof Date) {
                    object2 = (Date)object3;
                    object3 = xMLConversionManager.convertObject(object2, ClassConstants.STRING, XMLConstants.DATE_QNAME);
                } else if (object3 instanceof Time) {
                    object2 = (Time)object3;
                    object3 = xMLConversionManager.convertObject(object2, ClassConstants.STRING, XMLConstants.TIME_QNAME);
                } else if (object3 instanceof Timestamp) {
                    object2 = (Timestamp)object3;
                    object3 = xMLConversionManager.convertObject(object2, ClassConstants.STRING, XMLConstants.DATE_TIME_QNAME);
                }
                object2 = Util.sqlToXmlName(databaseField.getName());
                Element element2 = Util.TEMP_DOC.createElement((String)object2);
                element.appendChild(element2);
                element2.appendChild(Util.TEMP_DOC.createTextNode(object3.toString()));
            }
            simpleXMLFormatModel.simpleXML.add(element);
        }
        xMLRoot.setObject((Object)simpleXMLFormatModel);
        return xMLRoot;
    }

    public class DataHandlerInstantiationPolicy
    extends InstantiationPolicy {
        protected String mimeType;

        public DataHandlerInstantiationPolicy(String string) {
            this.mimeType = string;
        }

        public Object buildNewInstance() throws DescriptorException {
            return new DataHandler(null, this.mimeType);
        }
    }
}

