/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jaxb;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.descriptors.InstantiationPolicy;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedMethodInvoker;

public class MultiArgInstantiationPolicy
extends InstantiationPolicy {
    private String[] parameterTypeNames;
    private Class[] parameterTypes;
    private Object[] defaultValues;

    public void setParameterTypeNames(String[] stringArray) {
        this.parameterTypeNames = stringArray;
    }

    public void setParameterTypes(Class[] classArray) {
        this.parameterTypes = classArray;
    }

    public void setDefaultValues(Object[] objectArray) {
        this.defaultValues = objectArray;
    }

    public void convertClassNamesToClasses(ClassLoader classLoader) {
        super.convertClassNamesToClasses(classLoader);
        if (this.parameterTypes == null && this.parameterTypeNames != null) {
            Class[] classArray = new Class[this.parameterTypeNames.length];
            for (int i = 0; i < classArray.length; ++i) {
                try {
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            classArray[i] = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.parameterTypeNames[i], true, classLoader));
                            continue;
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            throw ValidationException.classNotFoundWhileConvertingClassNames((String)this.parameterTypeNames[i], (Exception)privilegedActionException.getException());
                        }
                    }
                    classArray[i] = PrivilegedAccessHelper.getClassForName((String)this.parameterTypeNames[i], (boolean)true, (ClassLoader)classLoader);
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw ValidationException.classNotFoundWhileConvertingClassNames((String)this.factoryClassName, (Exception)classNotFoundException);
                }
            }
            this.parameterTypes = classArray;
        }
    }

    protected void initializeMethod() throws DescriptorException {
        Class<?> clazz = this.getFactory() == null ? this.getDescriptor().getJavaClass() : this.getFactory().getClass();
        if (this.parameterTypes == null) {
            this.setMethod(this.buildMethod(clazz, this.getMethodName(), new Class[0]));
        } else {
            this.setMethod(this.buildMethod(clazz, this.getMethodName(), this.parameterTypes));
        }
    }

    protected Object buildNewInstanceUsingFactory() throws DescriptorException {
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    return AccessController.doPrivileged(new PrivilegedMethodInvoker(this.getMethod(), this.getFactory(), this.defaultValues));
                }
                catch (PrivilegedActionException privilegedActionException) {
                    Exception exception = privilegedActionException.getException();
                    if (exception instanceof IllegalAccessException) {
                        throw DescriptorException.illegalAccessWhileMethodInstantiation((String)this.getMethod().toString(), (ClassDescriptor)this.getDescriptor(), (Exception)exception);
                    }
                    throw DescriptorException.targetInvocationWhileMethodInstantiation((String)this.getMethod().toString(), (ClassDescriptor)this.getDescriptor(), (Exception)exception);
                }
            }
            return PrivilegedAccessHelper.invokeMethod((Method)this.getMethod(), (Object)this.getFactory(), (Object[])this.defaultValues);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw DescriptorException.illegalAccessWhileMethodInstantiation((String)this.getMethod().toString(), (ClassDescriptor)this.getDescriptor(), (Exception)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw DescriptorException.targetInvocationWhileMethodInstantiation((String)this.getMethod().toString(), (ClassDescriptor)this.getDescriptor(), (Exception)invocationTargetException);
        }
        catch (NullPointerException nullPointerException) {
            throw DescriptorException.nullPointerWhileMethodInstantiation((String)this.getMethod().toString(), (ClassDescriptor)this.getDescriptor(), (Exception)nullPointerException);
        }
    }
}

