/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.HashMap;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.MarshalException;
import javax.xml.bind.PropertyException;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.UnmarshallerHandler;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.attachment.AttachmentUnmarshaller;
import javax.xml.bind.helpers.DefaultValidationEventHandler;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.jaxb.WrappedValue;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.jaxb.JAXBErrorHandler;
import org.eclipse.persistence.jaxb.JAXBUnmarshalListener;
import org.eclipse.persistence.jaxb.JAXBUnmarshallerHandler;
import org.eclipse.persistence.jaxb.attachment.AttachmentUnmarshallerAdapter;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.oxm.XMLUnmarshalListener;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.attachment.XMLAttachmentUnmarshaller;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXBUnmarshaller
implements Unmarshaller {
    private ValidationEventHandler validationEventHandler = new DefaultValidationEventHandler();
    private XMLUnmarshaller xmlUnmarshaller;
    public static final String XML_JAVATYPE_ADAPTERS = "xml-javatype-adapters";
    public static final String STAX_SOURCE_CLASS_NAME = "javax.xml.transform.stax.StAXSource";
    private HashMap<QName, Class> qNamesToDeclaredClasses;

    public JAXBUnmarshaller(XMLUnmarshaller xMLUnmarshaller) {
        this.xmlUnmarshaller = xMLUnmarshaller;
        this.xmlUnmarshaller.setValidationMode(0);
        this.xmlUnmarshaller.setUnmarshalListener((XMLUnmarshalListener)new JAXBUnmarshalListener(this));
    }

    public XMLUnmarshaller getXMLUnmarshaller() {
        return this.xmlUnmarshaller;
    }

    public Object unmarshal(File file) throws JAXBException {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        try {
            Object object = this.xmlUnmarshaller.unmarshal(file);
            return this.createJAXBElementIfRequired(object);
        }
        catch (Exception exception) {
            throw new UnmarshalException((Throwable)exception);
        }
    }

    public Object unmarshal(InputStream inputStream) throws JAXBException {
        if (inputStream == null) {
            throw new IllegalArgumentException();
        }
        try {
            Object object = this.xmlUnmarshaller.unmarshal(inputStream);
            return this.createJAXBElementIfRequired(object);
        }
        catch (Exception exception) {
            throw new UnmarshalException((Throwable)exception);
        }
    }

    public Object unmarshal(URL uRL) throws JAXBException {
        if (uRL == null) {
            throw new IllegalArgumentException();
        }
        try {
            Object object = this.xmlUnmarshaller.unmarshal(uRL);
            return this.createJAXBElementIfRequired(object);
        }
        catch (Exception exception) {
            throw new UnmarshalException((Throwable)exception);
        }
    }

    public Object unmarshal(InputSource inputSource) throws JAXBException {
        if (inputSource == null) {
            throw new IllegalArgumentException();
        }
        try {
            Object object = this.xmlUnmarshaller.unmarshal(inputSource);
            return this.createJAXBElementIfRequired(object);
        }
        catch (Exception exception) {
            throw new UnmarshalException((Throwable)exception);
        }
    }

    public Object unmarshal(Reader reader) throws JAXBException {
        if (reader == null) {
            throw new IllegalArgumentException();
        }
        try {
            Object object = this.xmlUnmarshaller.unmarshal(reader);
            return this.createJAXBElementIfRequired(object);
        }
        catch (Exception exception) {
            throw new JAXBException((Throwable)exception);
        }
    }

    public Object unmarshal(Node node) throws JAXBException {
        if (node == null) {
            throw new IllegalArgumentException();
        }
        try {
            Object object = this.xmlUnmarshaller.unmarshal(node);
            return this.createJAXBElementIfRequired(object);
        }
        catch (Exception exception) {
            throw new UnmarshalException((Throwable)exception);
        }
    }

    private JAXBElement buildJAXBElementFromObject(Object object) {
        if (object instanceof XMLRoot) {
            return this.createJAXBElementFromXMLRoot((XMLRoot)object);
        }
        if (object instanceof WrappedValue) {
            return this.createJAXBElementFromWrappedValue((WrappedValue)object);
        }
        AbstractSession abstractSession = this.xmlUnmarshaller.getXMLContext().getSession(object);
        XMLDescriptor xMLDescriptor = (XMLDescriptor)abstractSession.getClassDescriptor(object);
        String string = xMLDescriptor.getDefaultRootElement();
        if (string == null) {
            return this.createJAXBElement(new QName(""), object.getClass(), object);
        }
        String string2 = null;
        int n = string.indexOf(":");
        if (n != -1) {
            string2 = xMLDescriptor.getNamespaceResolver().resolveNamespacePrefix(string.substring(0, n));
            string = string.substring(n + 1);
        }
        QName qName = string2 == null ? new QName(string) : new QName(string2, string);
        return this.createJAXBElement(qName, object.getClass(), object);
    }

    public JAXBElement unmarshal(Node node, Class clazz) throws JAXBException {
        return this.buildJAXBElementFromObject(this.xmlUnmarshaller.unmarshal(node, clazz));
    }

    public Object unmarshal(Source source) throws JAXBException {
        if (source == null) {
            throw new IllegalArgumentException();
        }
        try {
            Object object = this.xmlUnmarshaller.unmarshal(source);
            return this.createJAXBElementIfRequired(object);
        }
        catch (Exception exception) {
            throw new UnmarshalException((Throwable)exception);
        }
    }

    public JAXBElement unmarshal(Source source, Class clazz) throws JAXBException {
        return this.buildJAXBElementFromObject(this.xmlUnmarshaller.unmarshal(source, clazz));
    }

    public JAXBElement unmarshal(XMLStreamReader xMLStreamReader, Class clazz) throws JAXBException {
        Source source = null;
        try {
            Class clazz2 = PrivilegedAccessHelper.getClassForName((String)STAX_SOURCE_CLASS_NAME);
            Constructor constructor = PrivilegedAccessHelper.getDeclaredConstructorFor((Class)clazz2, (Class[])new Class[]{XMLStreamReader.class}, (boolean)false);
            source = (Source)PrivilegedAccessHelper.invokeConstructor((Constructor)constructor, (Object[])new Object[]{xMLStreamReader});
        }
        catch (Exception exception) {
            throw new MarshalException((Throwable)exception);
        }
        return this.unmarshal(source, clazz);
    }

    public Object unmarshal(XMLStreamReader xMLStreamReader) throws JAXBException {
        Source source = null;
        try {
            Class clazz = PrivilegedAccessHelper.getClassForName((String)STAX_SOURCE_CLASS_NAME);
            Constructor constructor = PrivilegedAccessHelper.getDeclaredConstructorFor((Class)clazz, (Class[])new Class[]{XMLStreamReader.class}, (boolean)false);
            source = (Source)PrivilegedAccessHelper.invokeConstructor((Constructor)constructor, (Object[])new Object[]{xMLStreamReader});
        }
        catch (Exception exception) {
            throw new MarshalException((Throwable)exception);
        }
        return this.unmarshal(source);
    }

    public JAXBElement unmarshal(XMLEventReader xMLEventReader, Class clazz) throws JAXBException {
        Source source = null;
        try {
            Class clazz2 = PrivilegedAccessHelper.getClassForName((String)STAX_SOURCE_CLASS_NAME);
            Constructor constructor = PrivilegedAccessHelper.getDeclaredConstructorFor((Class)clazz2, (Class[])new Class[]{XMLEventReader.class}, (boolean)false);
            source = (Source)PrivilegedAccessHelper.invokeConstructor((Constructor)constructor, (Object[])new Object[]{xMLEventReader});
        }
        catch (Exception exception) {
            throw new MarshalException((Throwable)exception);
        }
        return this.unmarshal(source, clazz);
    }

    public Object unmarshal(XMLEventReader xMLEventReader) throws JAXBException {
        Source source = null;
        try {
            Class clazz = PrivilegedAccessHelper.getClassForName((String)STAX_SOURCE_CLASS_NAME);
            Constructor constructor = PrivilegedAccessHelper.getDeclaredConstructorFor((Class)clazz, (Class[])new Class[]{XMLEventReader.class}, (boolean)false);
            source = (Source)PrivilegedAccessHelper.invokeConstructor((Constructor)constructor, (Object[])new Object[]{xMLEventReader});
        }
        catch (Exception exception) {
            throw new MarshalException((Throwable)exception);
        }
        return this.unmarshal(source);
    }

    public UnmarshallerHandler getUnmarshallerHandler() {
        return new JAXBUnmarshallerHandler(this);
    }

    public void setValidating(boolean bl) throws JAXBException {
        if (bl) {
            this.xmlUnmarshaller.setValidationMode(3);
        } else {
            this.xmlUnmarshaller.setValidationMode(0);
        }
    }

    public boolean isValidating() throws JAXBException {
        return this.xmlUnmarshaller.getValidationMode() != 0;
    }

    public void setEventHandler(ValidationEventHandler validationEventHandler) throws JAXBException {
        this.validationEventHandler = null == validationEventHandler ? new DefaultValidationEventHandler() : validationEventHandler;
        this.xmlUnmarshaller.setErrorHandler((ErrorHandler)new JAXBErrorHandler(this.validationEventHandler));
    }

    public ValidationEventHandler getEventHandler() throws JAXBException {
        return this.validationEventHandler;
    }

    public void setProperty(String string, Object object) throws PropertyException {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        throw new PropertyException(string, object);
    }

    public Object getProperty(String string) throws PropertyException {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        throw new PropertyException("Unsupported Property");
    }

    public Unmarshaller.Listener getListener() {
        return ((JAXBUnmarshalListener)this.xmlUnmarshaller.getUnmarshalListener()).getListener();
    }

    public void setListener(Unmarshaller.Listener listener) {
        ((JAXBUnmarshalListener)this.xmlUnmarshaller.getUnmarshalListener()).setListener(listener);
    }

    public XmlAdapter getAdapter(Class clazz) {
        HashMap hashMap = (HashMap)this.xmlUnmarshaller.getProperty((Object)XML_JAVATYPE_ADAPTERS);
        if (hashMap == null) {
            return null;
        }
        return (XmlAdapter)hashMap.get(clazz);
    }

    public void setAdapter(Class clazz, XmlAdapter xmlAdapter) {
        HashMap<Class, XmlAdapter> hashMap = (HashMap<Class, XmlAdapter>)this.xmlUnmarshaller.getProperty((Object)XML_JAVATYPE_ADAPTERS);
        if (hashMap == null) {
            hashMap = new HashMap<Class, XmlAdapter>();
            this.xmlUnmarshaller.getProperties().put(XML_JAVATYPE_ADAPTERS, hashMap);
        }
        hashMap.put(clazz, xmlAdapter);
    }

    public void setAdapter(XmlAdapter xmlAdapter) {
        this.setAdapter(xmlAdapter.getClass(), xmlAdapter);
    }

    public void setSchema(Schema schema) {
        this.xmlUnmarshaller.setSchema(schema);
    }

    public Schema getSchema() {
        return this.xmlUnmarshaller.getSchema();
    }

    public AttachmentUnmarshaller getAttachmentUnmarshaller() {
        return ((AttachmentUnmarshallerAdapter)this.xmlUnmarshaller.getAttachmentUnmarshaller()).getAttachmentUnmarshaller();
    }

    public void setAttachmentUnmarshaller(AttachmentUnmarshaller attachmentUnmarshaller) {
        this.xmlUnmarshaller.setAttachmentUnmarshaller((XMLAttachmentUnmarshaller)new AttachmentUnmarshallerAdapter(attachmentUnmarshaller));
    }

    public void setUnmarshalCallbacks(HashMap hashMap) {
        ((JAXBUnmarshalListener)this.xmlUnmarshaller.getUnmarshalListener()).setClassBasedUnmarshalEvents(hashMap);
    }

    private Object createJAXBElementIfRequired(Object object) {
        if (object instanceof WrappedValue) {
            return this.createJAXBElementFromWrappedValue((WrappedValue)object);
        }
        if (object instanceof XMLRoot) {
            return this.createJAXBElementFromXMLRoot((XMLRoot)object);
        }
        return object;
    }

    private JAXBElement createJAXBElementFromWrappedValue(WrappedValue wrappedValue) {
        Object object = wrappedValue.getWrappedValue();
        if (object == null && wrappedValue.getWrappedValueClass().equals(ClassConstants.STRING) && !wrappedValue.isSetValue()) {
            object = "";
        }
        return this.createJAXBElement(wrappedValue.getQName(), wrappedValue.getWrappedValueClass(), object);
    }

    private JAXBElement createJAXBElementFromXMLRoot(XMLRoot xMLRoot) {
        Class clazz;
        Object object = xMLRoot.getObject();
        QName qName = new QName(xMLRoot.getNamespaceURI(), xMLRoot.getLocalName());
        if (object == null) {
            return this.createJAXBElement(qName, Object.class, object);
        }
        if (this.qNamesToDeclaredClasses != null && (clazz = this.qNamesToDeclaredClasses.get(qName)) != null) {
            return this.createJAXBElement(qName, clazz, object);
        }
        clazz = this.xmlUnmarshaller.getXMLContext().getDescriptor(qName);
        if (clazz != null) {
            return this.createJAXBElement(qName, clazz.getJavaClass(), object);
        }
        return this.createJAXBElement(qName, object.getClass(), object);
    }

    private JAXBElement createJAXBElement(QName qName, Class clazz, Object object) {
        if (clazz == null) {
            return new JAXBElement(qName, Object.class, object);
        }
        if (ClassConstants.XML_GREGORIAN_CALENDAR.isAssignableFrom(clazz)) {
            clazz = ClassConstants.XML_GREGORIAN_CALENDAR;
        } else if (ClassConstants.DURATION.isAssignableFrom(clazz)) {
            clazz = ClassConstants.DURATION;
        }
        return new JAXBElement(qName, clazz, object);
    }

    public void setQNamesToDeclaredClasses(HashMap<QName, Class> hashMap) {
        this.qNamesToDeclaredClasses = hashMap;
    }
}

