/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.oracle.publisher;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SerializableType;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.Sortable;

public class Util {
    public static final int CASE_SAME = 1;
    public static final int CASE_UPPER = 2;
    public static final int CASE_LOWER = 3;
    public static final int CASE_MIXED = 4;
    public static final int CASE_OPPOSITE = 5;
    public static final String ALL_OBJECTS = "ALL_OBJECTS";
    public static final String ALL_ARGUMENTS = "ALL_ARGUMENTS";
    public static final String USER_ARGUMENTS = "USER_ARGUMENTS";
    public static final String ALL_TYPES = "ALL_TYPES";
    public static final String ALL_TYPE_ATTRS = "ALL_TYPE_ATTRS";
    public static final String ALL_COLL_TYPES = "ALL_COLL_TYPES";
    public static final int SCHEMA_ALWAYS = 1;
    public static final int SCHEMA_IF_NEEDED = 2;
    public static final int SCHEMA_FROM_INTYPE = 3;
    public static final int SCHEMA_OMIT = 4;
    public static final String DUAL = "DUAL";
    public static final String PACKAGE_NAME = "PACKAGE_NAME";
    public static final String OBJECT_NAME = "OBJECT_NAME";
    public static final String ARGUMENT_NAME = "ARGUMENT_NAME";
    public static final String DATA_LEVEL = "DATA_LEVEL";
    public static final String POSITION = "POSITION";
    public static final String SEQUENCE = "SEQUENCE";
    public static final String OWNER = "OWNER";
    public static final String OVERLOAD = "OVERLOAD";
    public static final String NOT_NULL = "NOT NULL";
    public static final String IS_NULL = "IS NULL";
    public static final int METHODS_NONE = 1;
    public static final int METHODS_NAMED = 2;
    public static final int METHODS_ALL = 4;
    public static final int METHODS_ALWAYS = 8;
    public static final int METHODS_OVERLOAD = 16;
    public static final int METHODS_UNIQUE = 32;
    public static final int METHODS_RETRY = 64;
    public static final int METHODS_PARAM_INTERFACE = 128;
    public static final int JDBC_USERTYPES = 16;
    public static final int USERTYPES_MASK = 16;
    public static final String TOPLEVEL = "TOPLEVEL";
    public static final int IS_OBJECT = 1;
    public static final int IS_COLLECTION = 2;
    public static final int IS_TYPE = 3;
    public static final int IS_PACKAGE = 4;
    public static final int IS_TYPE_OR_PACKAGE = 7;
    private static final int IS_TOPLEVEL_FUNCTION_ONLY = 8;
    public static final int IS_TOPLEVEL = 12;
    private static final int IS_SQLSTATEMENT_ONLY = 16;
    public static final int IS_SQLSTATEMENTS = 27;
    public static final String TYPE_NAME = "TYPE_NAME";
    public static final String ATTR_NAME = "ATTR_NAME";
    public static final String ATTR_TYPE_NAME = "ATTR_TYPE_NAME";
    public static final String ELEM_TYPE_NAME = "ELEM_TYPE_NAME";
    public static final String ALL_SYNONYMS = "ALL_SYNONYMS";
    public static final String ALL_TAB_PRIVS = "ALL_TAB_PRIVS";
    public static final String TABLE_OWNER = "TABLE_OWNER";
    public static final String TABLE_NAME = "TABLE_NAME";
    public static final String TABLE_SCHEMA = "TABLE_SCHEMA";
    public static final String PRIVILEGE = "PRIVILEGE";
    public static final String GRANTEE = "GRANTEE";
    public static final String SYNONYM_NAME = "SYNONYM_NAME";
    public static final String SUPERTYPE_NAME = "SUPERTYPE_NAME";
    public static final int MAX_IDENTIFIER_LENGTH = 29;
    private static final int DEFAULT_STRING_BUFFER_LEN = 1024;
    public static final String DEFAULT_VARCHAR_LEN = "4000";
    public static final String DEFAULT_RAW_LEN = "1000";
    public static final String DEFAULT_LONG_LEN = "32767";
    private static Hashtable m_defaultTypeLen = new Hashtable();
    private static Method[] m_objectMethods;
    private static Hashtable m_wrappers;
    private static Hashtable m_wrappedTypes;
    private static Hashtable m_primitives;
    private static Hashtable m_getters;
    private static Hashtable uniqueResultTypeNames;
    private static final String[] SQL_RESERVED;
    private static HashMap m_sqlReservedMap;

    public static String getDefaultTypeLen(String string) {
        return (String)m_defaultTypeLen.get(string.toUpperCase().replace(' ', '_'));
    }

    public static String printTypeWithLength(String string) {
        return Util.printTypeWithLength(string, 0, 0, 0);
    }

    public static String printTypeWithLength(String string, int n, int n2, int n3) {
        if (string == null) {
            return "<unsupported type>";
        }
        if (string.equalsIgnoreCase("NCHAR")) {
            string = "CHAR";
        }
        if (string.equalsIgnoreCase("NVARCHAR2")) {
            string = "VARCHAR2";
        }
        if (string.equalsIgnoreCase("NCLOB")) {
            string = "CLOB";
        }
        if (n != 0) {
            if (string.equals("NUMBER")) {
                if (n2 != 0 && n3 != 0) {
                    return string + "(" + n2 + ", " + n3 + ")";
                }
                if (n2 != 0) {
                    return string + "(" + n2 + ")";
                }
            } else if (string.equals("FLOAT")) {
                if (n2 != 0) {
                    return string + "(" + n2 + ")";
                }
            } else {
                if (string.equals("NCHAR") || string.equals("NVARCHAR2")) {
                    return string + "(" + n / 2 + ")";
                }
                return string + "(" + n + ")";
            }
        }
        if (Util.getDefaultTypeLen(string) == null) {
            return string;
        }
        return string + "(" + Util.getDefaultTypeLen(string) + ")";
    }

    public static String concat(ArrayList arrayList) {
        return Util.concat(arrayList.toArray(new String[0]));
    }

    public static String concat(ArrayList arrayList, int n, int n2) {
        return Util.concat(arrayList.toArray(new String[0]), n, n2);
    }

    public static String concat(ArrayList arrayList, int n) {
        return Util.concat(arrayList.toArray(new String[0]), n);
    }

    public static String concat(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer(1024);
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (stringArray[i] == null) continue;
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    public static String concat(String[] stringArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(1024);
        int n3 = stringArray.length;
        if (n2 < n3) {
            n3 = n2;
        }
        for (int i = n; i < n3; ++i) {
            if (stringArray[i] == null) continue;
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    public static String concat(String[] stringArray, int n) {
        StringBuffer stringBuffer = new StringBuffer(1024);
        int n2 = stringArray.length;
        for (int i = n; i < n2; ++i) {
            if (stringArray[i] == null) continue;
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    public static String concat5(String string, String string2, String string3, String string4, String string5) {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append(string);
        stringBuffer.append(string2);
        stringBuffer.append(string3);
        stringBuffer.append(string4);
        stringBuffer.append(string5);
        return stringBuffer.toString();
    }

    public static String[] renameExceptions(String string, String[] stringArray, String[] stringArray2) {
        String[] stringArray3 = stringArray2;
        try {
            if (m_objectMethods == null) {
                m_objectMethods = Object.class.getMethods();
            }
            for (int i = 0; i < m_objectMethods.length; ++i) {
                Method method = m_objectMethods[i];
                Class<?>[] classArray = method.getParameterTypes();
                if (!method.getName().equals(string) || stringArray.length != classArray.length) continue;
                boolean bl = true;
                for (int j = 0; j > stringArray.length; ++j) {
                    if (classArray[j].getName().equals(stringArray[j])) continue;
                    bl = false;
                }
                if (!bl) continue;
                Class<?>[] classArray2 = method.getExceptionTypes();
                stringArray3 = new String[classArray2.length];
                for (int j = 0; j < classArray2.length; ++j) {
                    stringArray3[j] = classArray2[j].getName();
                }
                break;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return stringArray3;
    }

    public static boolean offendingObject(String string, String[] stringArray, boolean bl) {
        boolean bl2 = false;
        try {
            if (m_objectMethods == null) {
                m_objectMethods = Object.class.getMethods();
            }
            for (int i = 0; i < m_objectMethods.length; ++i) {
                int n;
                Method method = m_objectMethods[i];
                Class<?>[] classArray = method.getParameterTypes();
                if (!method.getName().equals(string) || stringArray.length != classArray.length) continue;
                boolean bl3 = true;
                for (n = 0; n > stringArray.length; ++n) {
                    if (classArray[n].getName().equals(stringArray[n])) continue;
                    bl3 = false;
                }
                if (!bl3) continue;
                n = method.getModifiers();
                if (bl && !Modifier.isStatic(n)) {
                    bl2 = true;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return bl2;
    }

    public static String wrapJdbcColumn(String string, String string2, String string3) {
        if (string == null || string2 == null) {
            return string3;
        }
        if (string2.equals("Int") && string.endsWith("Integer")) {
            return "new Integer(" + string3 + ")";
        }
        if (string2.equals("Short") && string.endsWith("Short")) {
            return "new Short(" + string3 + ")";
        }
        if (string2.equals("Float") && string.endsWith("Float")) {
            return "new Float(" + string3 + ")";
        }
        if (string2.equals("Double") && string.endsWith("Double")) {
            return "new Double(" + string3 + ")";
        }
        if (string2.equals("Boolean") && string.endsWith("Boolean")) {
            return "new Boolean(" + string3 + ")";
        }
        if (string2.equals("Byte") && string.endsWith("Byte")) {
            return "new Byte(" + string3 + ")";
        }
        return string3;
    }

    public static String getPackage(Class clazz) {
        return Util.getPackage(clazz.getName());
    }

    public static String getPackage(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(".");
        if (n < 0) {
            n = string.lastIndexOf("/");
        }
        return n < 0 ? "" : string.substring(0, n);
    }

    public static String getPackage(String string, String string2) {
        if (string != null && !string.equals("")) {
            return string;
        }
        return Util.getPackage(string2);
    }

    public static String getClassName(Class clazz) {
        return Util.getClassName(clazz.getName());
    }

    public static String getClassName(String string) {
        int n = string.lastIndexOf(".");
        if (n < 0) {
            n = string.lastIndexOf("/");
        }
        if (n > -1) {
            return string.substring(n + 1);
        }
        return string;
    }

    public static String printClass(Class clazz) {
        if (clazz.isArray()) {
            return Util.printClass(clazz.getComponentType()) + "[]";
        }
        if (clazz == Void.class) {
            return "void";
        }
        return clazz.getName();
    }

    public static String printClass(String string) {
        if (string == null) {
            return null;
        }
        int n = Util.getDim(string);
        string = Util.getBaseType(string);
        for (int i = 0; i < n; ++i) {
            string = string + "[]";
        }
        return string;
    }

    public static int getDim(String string) {
        int n = 0;
        while (string != null && string.endsWith("[]")) {
            string = "[" + string.substring(0, string.length() - "[]".length());
        }
        if (string != null) {
            n = string.lastIndexOf("[") + 1;
        }
        return n;
    }

    public static String getBaseType(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        while (string != null && string.endsWith("[]")) {
            string = "[" + string.substring(0, string.length() - "[]".length());
        }
        int n = string.lastIndexOf("[") + 1;
        if (n > 0) {
            string = string.substring(n);
        }
        if (string.charAt(string.length() - 1) == ';' && string.charAt(0) == 'L') {
            string = string.substring(1, string.length() - 1);
        }
        if (string.equals("void") || string.equals("V")) {
            string = "void";
        } else if (string.equals("boolean") || string.equals("Z")) {
            string = "boolean";
        } else if (string.equals("byte") || string.equals("B")) {
            string = "byte";
        } else if (string.equals("short") || string.equals("S")) {
            string = "short";
        } else if (string.equals("char") || string.equals("C")) {
            string = "char";
        } else if (string.equals("int") || string.equals("I")) {
            string = "int";
        } else if (string.equals("long") || string.equals("J")) {
            string = "long";
        } else if (string.equals("float") || string.equals("F")) {
            string = "float";
        } else if (string.equals("double") || string.equals("D")) {
            string = "double";
        }
        return string;
    }

    public static String getObjectWrapper(String string) {
        if (m_wrappers == null) {
            Util.initWrapper();
        }
        return (String)m_wrappers.get(string);
    }

    public static String getObjectWrapper(Class clazz) {
        if (m_wrappers == null) {
            Util.initWrapper();
        }
        return (String)m_wrappers.get(clazz);
    }

    private static void initWrapper() {
        m_wrappers = new Hashtable();
        m_wrappers.put("boolean", "java.lang.Boolean");
        m_wrappers.put(Boolean.TYPE, "java.lang.Boolean");
        m_wrappers.put("byte", "java.lang.Byte");
        m_wrappers.put(Byte.TYPE, "java.lang.Byte");
        m_wrappers.put("short", "java.lang.Short");
        m_wrappers.put(Short.TYPE, "java.lang.Short");
        m_wrappers.put("int", "java.lang.Integer");
        m_wrappers.put(Integer.TYPE, "java.lang.Integer");
        m_wrappers.put("long", "java.lang.Long");
        m_wrappers.put(Long.TYPE, "java.lang.Long");
        m_wrappers.put("char", "java.lang.Character");
        m_wrappers.put(Character.TYPE, "java.lang.Character");
        m_wrappers.put("float", "java.lang.Float");
        m_wrappers.put(Float.TYPE, "java.lang.Float");
        m_wrappers.put("double", "java.lang.Double");
        m_wrappers.put(Double.TYPE, "java.lang.Double");
    }

    public static String getWrappedType(String string) {
        if (m_wrappedTypes == null) {
            Util.initWrappedTypes();
        }
        return (String)m_wrappedTypes.get(string);
    }

    public static String getWrappedType(Class clazz) {
        if (m_wrappedTypes == null) {
            Util.initWrappedTypes();
        }
        return (String)m_wrappedTypes.get(clazz);
    }

    public static boolean isWrappedType(String string) {
        if (m_wrappedTypes == null) {
            Util.initWrappedTypes();
        }
        return m_wrappedTypes.get(string) != null;
    }

    private static void initWrappedTypes() {
        m_wrappedTypes = new Hashtable();
        m_wrappedTypes.put("java.lang.Boolean", "boolean");
        m_wrappedTypes.put("Boolean", "boolean");
        m_wrappedTypes.put(Boolean.class, "boolean");
        m_wrappedTypes.put("java.lang.Byte", "byte");
        m_wrappedTypes.put("Byte", "byte");
        m_wrappedTypes.put(Byte.class, "byte");
        m_wrappedTypes.put("java.lang.Short", "short");
        m_wrappedTypes.put("Short", "short");
        m_wrappedTypes.put(Short.class, "short");
        m_wrappedTypes.put("java.lang.Integer", "int");
        m_wrappedTypes.put("Integer", "int");
        m_wrappedTypes.put(Integer.class, "int");
        m_wrappedTypes.put("java.lang.Long", "long");
        m_wrappedTypes.put("Long", "long");
        m_wrappedTypes.put(Long.class, "long");
        m_wrappedTypes.put("java.lang.Character", "char");
        m_wrappedTypes.put("Character", "char");
        m_wrappedTypes.put(Character.class, "char");
        m_wrappedTypes.put("java.lang.Float", "float");
        m_wrappedTypes.put("Float", "float");
        m_wrappedTypes.put(Float.class, "float");
        m_wrappedTypes.put("java.lang.Double", "double");
        m_wrappedTypes.put("Double", "double");
        m_wrappedTypes.put(Double.class, "double");
    }

    public static boolean isPrimitive(String string) {
        if (m_primitives == null) {
            Util.initPrimitives();
        }
        return m_primitives.get(string) != null;
    }

    public static void initPrimitives() {
        m_primitives = new Hashtable();
        m_primitives.put("boolean", "booleanValue");
        m_primitives.put(Boolean.TYPE, "booleanValue");
        m_primitives.put("byte", "byteValue");
        m_primitives.put(Byte.TYPE, "byteValue");
        m_primitives.put("short", "shortValue");
        m_primitives.put(Short.TYPE, "shortValue");
        m_primitives.put("int", "intValue");
        m_primitives.put(Integer.TYPE, "intValue");
        m_primitives.put("long", "longValue");
        m_primitives.put(Long.TYPE, "longValue");
        m_primitives.put("char", "charValue");
        m_primitives.put(Character.TYPE, "charValue");
        m_primitives.put("float", "floatValue");
        m_primitives.put(Float.TYPE, "floatValue");
        m_primitives.put("double", "doubleValue");
        m_primitives.put(Double.TYPE, "doubleValue");
    }

    public static String getPrimitiveGetter(String string) {
        if (m_getters == null) {
            Util.initGetter();
        }
        return (String)m_getters.get(string);
    }

    public static String getPrimitiveGetter(Class clazz) {
        if (m_getters == null) {
            Util.initGetter();
        }
        return (String)m_getters.get(clazz);
    }

    public static void initGetter() {
        m_getters = new Hashtable();
        m_getters.put("boolean", "booleanValue");
        m_getters.put(Boolean.TYPE, "booleanValue");
        m_getters.put("byte", "byteValue");
        m_getters.put(Byte.TYPE, "byteValue");
        m_getters.put("short", "shortValue");
        m_getters.put(Short.TYPE, "shortValue");
        m_getters.put("int", "intValue");
        m_getters.put(Integer.TYPE, "intValue");
        m_getters.put(Long.TYPE, "longValue");
        m_getters.put("long", "longValue");
        m_getters.put(Character.TYPE, "charValue");
        m_getters.put("char", "charValue");
        m_getters.put(Float.TYPE, "floatValue");
        m_getters.put("float", "floatValue");
        m_getters.put(Double.TYPE, "doubleValue");
        m_getters.put("double", "doubleValue");
        m_getters.put("Boolean", "booleanValue");
        m_getters.put("java.lang.Boolean", "booleanValue");
        m_getters.put(Boolean.class, "booleanValue");
        m_getters.put("Byte", "byteValue");
        m_getters.put("java.lang.Byte", "byteValue");
        m_getters.put(Byte.class, "byteValue");
        m_getters.put("Short", "shortValue");
        m_getters.put("java.lang.Short", "shortValue");
        m_getters.put(Short.class, "shortValue");
        m_getters.put("Integer", "intValue");
        m_getters.put("java.lang.Integer", "intValue");
        m_getters.put(Integer.class, "intValue");
        m_getters.put(Long.class, "longValue");
        m_getters.put("Long", "longValue");
        m_getters.put("java.lang.Long", "longValue");
        m_getters.put(Character.class, "charValue");
        m_getters.put("Character", "charValue");
        m_getters.put("java.lang.Character", "charValue");
        m_getters.put(Float.class, "floatValue");
        m_getters.put("Float", "floatValue");
        m_getters.put("java.lang.Float", "floatValue");
        m_getters.put(Double.class, "doubleValue");
        m_getters.put("Double", "doubleValue");
        m_getters.put("java.lang.Double", "doubleValue");
    }

    public static String stringize(String string) {
        return "\"" + string + "\"";
    }

    public static void checkClass(String string) throws ClassNotFoundException {
        if (string == null || string.equals("void") || string.equals("boolean") || string.equals("byte") || string.equals("short") || string.equals("char") || string.equals("int") || string.equals("long") || string.equals("float") || string.equals("double")) {
            return;
        }
        if (string.startsWith("[")) {
            Util.checkPrimitiveClass(string.substring(1));
        } else if (string.endsWith("[]")) {
            Util.checkClass(string.substring(0, string.length() - 2));
        } else {
            Class.forName(string);
        }
    }

    private static void checkPrimitiveClass(String string) throws ClassNotFoundException {
        if (string.startsWith("[")) {
            Util.checkPrimitiveClass(string.substring(1));
        } else {
            if (string.equals("V") || string.equals("Z") || string.equals("B") || string.equals("S") || string.equals("I") || string.equals("J") || string.equals("D") || string.equals("F")) {
                return;
            }
            if (string.startsWith("L")) {
                Util.checkClass(string.substring(1, string.length() - 1));
            } else {
                Class.forName(string);
            }
        }
    }

    public static String[] getClasses(String string) {
        if (string == null || string.equals("")) {
            return new String[0];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreElements()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static String[] getClasses(Class[] classArray) {
        if (classArray == null || classArray.length == 0) {
            return new String[0];
        }
        String[] stringArray = new String[classArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            stringArray[i] = classArray[i].getName();
        }
        return stringArray;
    }

    public static String serialize(String string, String string2, String string3, SerializableType serializableType, String string4) {
        return string + "try\n" + string + "{\n" + string + " java.io.ByteArrayOutputStream bos = new java.io.ByteArrayOutputStream();\n" + string + " java.io.ObjectOutputStream oos = new java.io.ObjectOutputStream(bos);\n" + string + " oos.writeObject(" + string2 + ");\n" + string + " oos.flush();\n" + string + " bos.flush();\n" + string + " " + string3 + " = " + serializableType.getJdbcClass() + ".createTemporary((oracle.jdbc.OracleConnection) " + string4 + ", false, " + serializableType.getJdbcClass() + ".DURATION_SESSION);\n" + string + " java.io.OutputStream blobos = " + string3 + ".setBinaryStream(0L);\n" + string + " blobos.write(bos.toByteArray());\n" + string + " blobos.flush();\n" + string + " blobos.close();\n" + string + " try {oos.close(); } catch (java.io.IOException _){}\n" + string + " try {bos.close(); } catch (java.io.IOException _){}\n" + string + "}\n" + string + "catch (Exception io_or_cnf_e) { throw new java.sql.SQLException(io_or_cnf_e.getMessage()); }\n";
    }

    public static String deserialize(String string, String string2, String string3, SerializableType serializableType) {
        return string + "try\n" + string + "{\n" + string + " java.io.ObjectInputStream ois = new java.io.ObjectInputStream(new java.io.ByteArrayInputStream(" + string2 + ".getBytes(1l, (int) " + string2 + ".length())));\n" + string + " " + string3 + " = (" + serializableType.getFullDeclClass() + ")ois.readObject();\n" + string + " ois.close();\n" + string + "}\n" + string + "catch (Exception io_or_cnf_e) { throw new java.sql.SQLException(io_or_cnf_e.getMessage()); }\n";
    }

    public static File[] listFiles(String string) {
        Object object;
        Vector<File> vector = new Vector<File>();
        ArrayList<File> arrayList = new ArrayList<File>();
        arrayList.add(new File(string));
        while (!arrayList.isEmpty()) {
            object = (File)arrayList.get(0);
            arrayList.remove(object);
            File[] fileArray = ((File)object).listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isDirectory()) {
                    arrayList.add(fileArray[i]);
                    continue;
                }
                vector.add(fileArray[i]);
            }
        }
        object = new File[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            object[i] = (File)vector.get(i);
        }
        return object;
    }

    public static String nullify(String string) {
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).equals("int")) {
            return "0";
        }
        if (string.equals("float")) {
            return "0";
        }
        if (string.equals("long")) {
            return "0";
        }
        if (string.equals("short")) {
            return "0";
        }
        if (string.equals("double")) {
            return "0";
        }
        if (string.equals("byte")) {
            return "0";
        }
        if (string.equals("char")) {
            return "0";
        }
        if (string.equals("boolean")) {
            return "false";
        }
        return "null";
    }

    public static String uniqueResultTypeName(String string, String string2) {
        String string3 = string + string2;
        int n = 0;
        while (uniqueResultTypeNames.containsKey(string3)) {
            string3 = string + n++ + string2;
        }
        uniqueResultTypeNames.put(string3, string3);
        return string3;
    }

    public static Object[] sort(Object[] objectArray) {
        int n;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (n = 0; n < objectArray.length; ++n) {
            boolean bl = false;
            for (int i = 0; i < arrayList.size(); ++i) {
                if (((Sortable)objectArray[n]).getSortingKey().compareTo(((Sortable)arrayList.get(i)).getSortingKey()) >= 0) continue;
                arrayList.add(i, objectArray[n]);
                bl = true;
                break;
            }
            if (bl) continue;
            arrayList.add(objectArray[n]);
        }
        for (n = 0; n < objectArray.length; ++n) {
            objectArray[n] = (Sortable)arrayList.get(n);
        }
        return objectArray;
    }

    public static void mkdirForFile(String string) throws IOException {
        int n = -1;
        String string2 = null;
        n = string.lastIndexOf(File.separator);
        if (n > -1 && n != 0 && !new File(string2 = string.substring(0, n)).exists()) {
            new File(string2).mkdirs();
        }
    }

    public static String quote(String string) {
        return "\"" + Util.escapeQuote(string) + "\"";
    }

    public static String escapeQuote(String string) {
        if (string == null) {
            return string;
        }
        String string2 = "";
        if (string.startsWith("\"")) {
            string2 = string2 + "\\\"";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\"");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            string2 = string2 + string3;
            if (!stringTokenizer.hasMoreTokens()) continue;
            string2 = string2 + "\\\"";
        }
        if (string.endsWith("\"")) {
            string2 = string2 + "\\\"";
        }
        return string2;
    }

    public static void initStaticVariables() {
        uniqueResultTypeNames = new Hashtable();
    }

    public static String getSchema(String string, String string2) {
        if ((string == null || string.equals("")) && string2.indexOf(46) >= 0) {
            return string2.substring(0, string2.indexOf(46));
        }
        return string;
    }

    public static String getType(String string, String string2) {
        if ((string == null || string.equals("")) && string2.indexOf(46) >= 0) {
            return string2.substring(string2.indexOf(46) + 1);
        }
        return string2;
    }

    public static String getSchemaType(String string, String string2) {
        if (string == null || string.equals("")) {
            return string2;
        }
        return string + "." + string2;
    }

    public static boolean isReservedBySql(String string) {
        return m_sqlReservedMap.get(string.toUpperCase()) != null;
    }

    public static String unreserveSql(String string) {
        String string2 = (String)m_sqlReservedMap.get(string.toUpperCase());
        if (string2 == null) {
            string2 = string;
        }
        return string2;
    }

    static {
        m_defaultTypeLen.put("VARCHAR", DEFAULT_VARCHAR_LEN);
        m_defaultTypeLen.put("VARCHAR2", DEFAULT_VARCHAR_LEN);
        m_defaultTypeLen.put("NVARCHAR2", DEFAULT_VARCHAR_LEN);
        m_defaultTypeLen.put("RAW", DEFAULT_RAW_LEN);
        m_defaultTypeLen.put("LONG", DEFAULT_LONG_LEN);
        m_defaultTypeLen.put("LONG_CHAR", DEFAULT_LONG_LEN);
        m_defaultTypeLen.put("LONG_RAW", DEFAULT_LONG_LEN);
        m_wrappers = null;
        m_wrappedTypes = null;
        m_primitives = null;
        m_getters = null;
        uniqueResultTypeNames = new Hashtable();
        SQL_RESERVED = new String[]{"ALL", "ALTER", "AND", "ANY", "ARRAY", "AS", "ASC", "AT", "AUTHID", "AVG", "BEGIN", "BETWEEN", "BINARY_INTEGER", "BODY", "BOOLEAN", "BULK", "BY", "CASE", "CHAR", "CHAR_BASE", "CHECK", "CLOSE", "CLUSTER", "COALESCE", "COLLECT", "COMMENT", "COMMIT", "COMPRESS", "CONNECT", "CONSTANT", "CREATE", "CURRENT", "CURRVAL", "CURSOR", "DATE", "DAY", "DECLARE", "DECIMAL", "DEFAULT", "DELETE", "DESC", "DISTINCT", "DO", "DROP", "ELSE", "ELSIF", "END", "EXCEPTION", "EXCLUSIVE", "EXECUTE", "EXISTS", "EXIT", "EXTENDS", "EXTRACT", "FALSE", "FETCH", "FLOAT", "FOR", "FORALL", "FROM", "FUNCTION", "GOTO", "GROUP", "HAVING", "HEAP", "HOUR", "IF", "IMMEDIATE", "IN", "INDEX", "INDICATOR", "INSERT", "INTEGER", "INTERFACE", "INTERSECT", "INTERVAL", "INTO", "IS", "ISOLATION", "JAVA", "LEVEL", "LIKE", "LIMITED", "LOCK", "LONG", "LOOP", "MAX", "MIN", "MINUS", "MINUTE", "MLSLABEL", "MOD", "MODE", "MONTH", "NATURAL", "NATURALN", "NEW", "NEXTVAL", "NOCOPY", "NOT", "NOWAIT", "NULL", "NULLIF", "NUMBER", "NUMBER_BASE", "OCIROWID", "OF", "ON", "OPAQUE", "OPEN", "OPERATOR", "OPTION", "OR", "ORDER", "ORGANIZATION", "OTHERS", "OUT", "PACKAGE", "PARTITION", "PCTFREE", "PLS_INTEGER", "POSITIVE", "POSITIVEN", "PRAGMA", "PRIOR", "PRIVATE", "PROCEDURE", "PUBLIC", "RAISE", "RANGE", "RAW", "REAL", "RECORD", "REF", "RELEASE", "RETURN", "REVERSE", "ROLLBACK", "ROW", "ROWID", "ROWNUM", "ROWTYPE", "SAVEPOINT", "SECOND", "SELECT", "SEPARATE", "SET", "SHARE", "SMALLINT", "SPACE", "SQL", "SQLCODE", "SQLERRM", "START", "STDDEV", "SUBTYPE", "SUCCESSFUL", "SUM", "SYNONYM", "SYSDATE", "TABLE", "THEN", "TIME", "TIMESTAMP", "TIMEZONE_REGION", "TIMEZONE_ABBR", "TIMEZONE_MINUTE", "TIMEZONE_HOUR", "TO", "TRIGGER", "TRUE", "TYPE", "UID", "UNION", "UNIQUE", "UPDATE", "USE", "USER", "VALIDATE", "VALUES", "VARCHAR", "VARCHAR2", "VARIANCE", "VIEW", "WHEN", "WHENEVER", "WHERE", "WHILE", "WITH", "WORK", "WRITE", "YEAR", "ZONE"};
        m_sqlReservedMap = new HashMap();
        for (int i = 0; i < SQL_RESERVED.length; ++i) {
            m_sqlReservedMap.put(SQL_RESERVED[i].toUpperCase(), SQL_RESERVED[i].toUpperCase() + "_");
        }
    }
}

