/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.persistence.platform.database.oracle.publisher.MethodFilter;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.ProcedureMethod;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlName;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlReflector;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlType;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlTypeWithMethods;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.AllSynonyms;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.FieldInfo;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.MethodInfo;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.ParamInfo;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.ResultInfo;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.SingleColumnViewRow;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.UserArguments;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.ViewCache;
import org.eclipse.persistence.platform.database.oracle.publisher.visit.PublisherVisitor;

public class SqlPackageType
extends SqlTypeWithMethods {
    protected String m_synonymOwner;
    protected String m_synonymName;
    protected String[] m_executeNames;
    private ResultInfoValues m_resultInfoValues;
    private ParamInfoValues m_paramInfoValues;

    @Override
    public boolean isPackage() {
        return true;
    }

    public SqlPackageType(SqlName sqlName, SqlType sqlType, MethodFilter methodFilter, SqlReflector sqlReflector) throws SQLException {
        super(sqlName, 1999, true, sqlType, methodFilter, sqlReflector);
        this.initSecurityAttributes(sqlName);
    }

    public SqlPackageType(SqlName sqlName, ProcedureMethod[] procedureMethodArray, SqlReflector sqlReflector) throws SQLException {
        super(sqlName, 1999, true, null, null, sqlReflector);
        this.m_methods = procedureMethodArray;
        this.initSecurityAttributes(sqlName);
    }

    @Override
    protected FieldInfo[] getFieldInfo() {
        return null;
    }

    public String getSynonymName() {
        return this.m_synonymName;
    }

    public String[] getExecuteNames() {
        return this.m_executeNames;
    }

    public boolean hasSecurityAttributes() {
        return this.m_synonymName != null || this.m_executeNames.length > 0;
    }

    protected void initSecurityAttributes(SqlName sqlName) throws SQLException {
        Serializable serializable;
        String string = sqlName.getContextName();
        String string2 = sqlName.getTypeName();
        Iterator iterator = this.m_viewCache.getRows("ALL_SYNONYMS", new String[0], new String[]{"TABLE_OWNER", "TABLE_NAME"}, new Object[]{string, string2}, new String[0]);
        if (iterator.hasNext()) {
            serializable = (AllSynonyms)iterator.next();
            this.m_synonymOwner = ((AllSynonyms)serializable).OWNER;
            this.m_synonymName = ((AllSynonyms)serializable).SYNONYM_NAME;
        }
        iterator = this.m_viewCache.getRows("ALL_TAB_PRIVS", new String[]{"GRANTEE"}, new String[]{"TABLE_SCHEMA", "TABLE_NAME", "PRIVILEGE"}, new Object[]{string, string2, "EXECUTE"}, new String[0]);
        serializable = new ArrayList();
        while (iterator.hasNext()) {
            SingleColumnViewRow singleColumnViewRow = (SingleColumnViewRow)iterator.next();
            ((ArrayList)serializable).add(singleColumnViewRow.getValue());
        }
        this.m_executeNames = ((ArrayList)serializable).toArray(new String[0]);
    }

    public String[] getSecurityDeclarations() {
        String[] stringArray;
        String string = "";
        String string2 = "";
        String string3 = ((SqlName)this.m_name).getSchemaName();
        String string4 = "";
        if (this.getSynonymName() != null && string3 != null && string3.length() > 0) {
            string = string + "CREATE OR REPLACE PUBLIC SYNONYM " + string4 + " for " + string3 + "." + string4 + ";\n";
            string = string + "/\nshow errors\n";
            string2 = string2 + "DROP PUBLIC synonym " + string4 + ";\n";
            string2 = string2 + "show errors\n";
        }
        if ((stringArray = this.getExecuteNames()) != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                string = string + "GRANT EXECUTE on " + string3 + "." + string4 + " to " + stringArray[i] + ";\n";
                string = string + "show errors\n";
                string2 = string2 + "REVOKE EXECUTE on " + string3 + "." + string4 + " from " + stringArray[i] + ";\n";
                string2 = string2 + "show errors\n";
            }
        }
        return new String[]{string, string2};
    }

    @Override
    protected MethodInfo[] getMethodInfo(String string, String string2) throws SQLException {
        String[] stringArray = null;
        Object[] objectArray = null;
        if (this.m_methodFilter != null && this.m_methodFilter.isSingleMethod()) {
            stringArray = new String[]{"OWNER", "PACKAGE_NAME", "OBJECT_NAME", "DATA_LEVEL"};
            objectArray = new Object[]{string, string2, this.m_methodFilter.getSingleMethodName(), new Integer(0)};
        } else {
            stringArray = new String[]{"OWNER", "PACKAGE_NAME", "DATA_LEVEL"};
            objectArray = new Object[]{string, string2, new Integer(0)};
        }
        Iterator iterator = this.m_viewCache.getRows("ALL_ARGUMENTS", new String[0], stringArray, objectArray, new String[0]);
        MethodInfo[] methodInfoArray = MethodInfo.groupBy(iterator);
        return methodInfoArray;
    }

    @Override
    protected ResultInfo getResultInfo(String string, String string2, String string3, String string4) throws SQLException {
        if (this.m_resultInfoValues == null || !this.m_resultInfoValues.matches(string, string2)) {
            this.m_resultInfoValues = new ResultInfoValues(string, string2, this.m_methodFilter, this.m_viewCache);
        }
        return this.m_resultInfoValues.get(string3, string4);
    }

    @Override
    protected ParamInfo[] getParamInfo(String string, String string2, String string3, String string4) throws SQLException {
        if (this.m_paramInfoValues == null || !this.m_paramInfoValues.matches(string, string2)) {
            this.m_paramInfoValues = new ParamInfoValues(string, string2, this.m_methodFilter, this.m_viewCache);
        }
        return this.m_paramInfoValues.get(string3, string4);
    }

    @Override
    public void accept(PublisherVisitor publisherVisitor) {
        publisherVisitor.visit(this);
    }

    private static class InfoValues {
        protected String m_schema;
        protected String m_name;
        protected Hashtable m_ht;

        public InfoValues(String string, String string2) throws SQLException {
            this.m_schema = string;
            this.m_name = string2;
            this.m_ht = new Hashtable();
        }

        protected static String makeKey(String string, String string2) {
            return "" + string + "/" + string2;
        }

        public boolean matches(String string, String string2) {
            return (string == null ? this.m_schema == null : string.equals(this.m_schema)) && (string2 == null ? this.m_name != null : string2.equals(this.m_name));
        }
    }

    private static class ParamInfoValues
    extends InfoValues {
        public ParamInfoValues(String string, String string2, MethodFilter methodFilter, ViewCache viewCache) throws SQLException {
            super(string, string2);
            String[] stringArray = null;
            Object[] objectArray = null;
            if (methodFilter != null && methodFilter.isSingleMethod()) {
                stringArray = new String[]{"OWNER", "PACKAGE_NAME", "OBJECT_NAME", "DATA_LEVEL"};
                objectArray = new Object[]{string, string2, methodFilter.getSingleMethodName(), new Integer(0)};
            } else {
                stringArray = new String[]{"OWNER", "PACKAGE_NAME", "DATA_LEVEL"};
                objectArray = new Object[]{string, string2, new Integer(0)};
            }
            Iterator iterator = viewCache.getRows("ALL_ARGUMENTS", new String[0], stringArray, objectArray, new String[0]);
            ArrayList<UserArguments> arrayList = new ArrayList<UserArguments>();
            while (iterator.hasNext()) {
                UserArguments userArguments = (UserArguments)iterator.next();
                if (userArguments.ARGUMENT_NAME == null) continue;
                arrayList.add(userArguments);
            }
            UserArguments.orderByPosition(arrayList);
            for (int i = 0; i < arrayList.size(); ++i) {
                UserArguments userArguments = (UserArguments)arrayList.get(i);
                String string3 = ParamInfoValues.makeKey(userArguments.OBJECT_NAME, userArguments.OVERLOAD);
                ArrayList<UserArguments> arrayList2 = (ArrayList<UserArguments>)this.m_ht.get(string3);
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList<UserArguments>();
                    this.m_ht.put(string3, arrayList2);
                }
                arrayList2.add(userArguments);
            }
        }

        public ParamInfo[] get(String string, String string2) throws SQLException {
            ArrayList arrayList = (ArrayList)this.m_ht.get(ParamInfoValues.makeKey(string, string2));
            if (arrayList == null) {
                arrayList = new ArrayList();
            }
            return ParamInfo.getParamInfo(arrayList);
        }
    }

    private static class ResultInfoValues
    extends InfoValues {
        public ResultInfoValues(String string, String string2, MethodFilter methodFilter, ViewCache viewCache) throws SQLException {
            super(string, string2);
            String[] stringArray = null;
            Object[] objectArray = null;
            if (methodFilter != null && methodFilter.isSingleMethod()) {
                stringArray = new String[]{"OWNER", "PACKAGE_NAME", "OBJECT_NAME", "DATA_LEVEL", "POSITION"};
                objectArray = new Object[]{string, string2, methodFilter.getSingleMethodName(), new Integer(0), new Integer(0)};
            } else {
                stringArray = new String[]{"OWNER", "PACKAGE_NAME", "DATA_LEVEL", "POSITION"};
                objectArray = new Object[]{string, string2, new Integer(0), new Integer(0)};
            }
            Iterator iterator = viewCache.getRows("ALL_ARGUMENTS", new String[0], stringArray, objectArray, new String[0]);
            while (iterator.hasNext()) {
                UserArguments userArguments = (UserArguments)iterator.next();
                String string3 = ResultInfoValues.makeKey(userArguments.OBJECT_NAME, userArguments.OVERLOAD);
                if (this.m_ht.get(string3) != null) continue;
                this.m_ht.put(string3, userArguments);
            }
        }

        public ResultInfo get(String string, String string2) throws SQLException {
            Object v = this.m_ht.get(ResultInfoValues.makeKey(string, string2));
            ResultInfo resultInfo = null;
            resultInfo = new ResultInfo((UserArguments)v);
            return resultInfo;
        }
    }
}

