/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.dbws;

import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.persistence.internal.xr.Attachment;
import org.eclipse.persistence.internal.xr.CollectionResult;
import org.eclipse.persistence.internal.xr.Parameter;
import org.eclipse.persistence.internal.xr.ProcedureArgument;
import org.eclipse.persistence.internal.xr.ProcedureOutputArgument;
import org.eclipse.persistence.internal.xr.QNameTransformer;
import org.eclipse.persistence.internal.xr.QueryOperation;
import org.eclipse.persistence.internal.xr.Result;
import org.eclipse.persistence.internal.xr.sxf.SimpleXMLFormat;
import org.eclipse.persistence.internal.xr.sxf.SimpleXMLFormatProject;
import org.eclipse.persistence.tools.dbws.DBWSBuilder;
import org.eclipse.persistence.tools.dbws.ProcedureOperationModel;
import org.eclipse.persistence.tools.dbws.Util;
import org.eclipse.persistence.tools.dbws.jdbc.DbStoredArgument;
import org.eclipse.persistence.tools.dbws.jdbc.DbStoredFunction;
import org.eclipse.persistence.tools.dbws.jdbc.DbStoredProcedure;
import org.eclipse.persistence.tools.dbws.oracle.OracleHelper;
import org.eclipse.persistence.tools.dbws.oracle.PLSQLStoredArgument;

public class PLSQLProcedureOperationModel
extends ProcedureOperationModel {
    @Override
    public void buildOperation(DBWSBuilder dBWSBuilder) {
        List<DbStoredProcedure> list = dBWSBuilder.loadProcedures(this.catalogPattern, this.schemaPattern, this.procedurePattern, this.overload, true);
        for (DbStoredProcedure dbStoredProcedure : list) {
            QName qName;
            String string;
            Object object2;
            StringBuilder stringBuilder = new StringBuilder();
            if (this.name == null || this.name.length() == 0) {
                if (dbStoredProcedure.getOverload() > 0) {
                    stringBuilder.append(dbStoredProcedure.getOverload());
                    stringBuilder.append('_');
                }
                if (dbStoredProcedure.getCatalog() != null && dbStoredProcedure.getCatalog().length() > 0) {
                    stringBuilder.append(dbStoredProcedure.getCatalog());
                    stringBuilder.append('_');
                }
                if (dbStoredProcedure.getSchema() != null && dbStoredProcedure.getSchema().length() > 0) {
                    stringBuilder.append(dbStoredProcedure.getSchema());
                    stringBuilder.append('_');
                }
                stringBuilder.append(dbStoredProcedure.getName());
            } else {
                stringBuilder.append(this.name);
            }
            QueryOperation queryOperation = new QueryOperation();
            queryOperation.setName(stringBuilder.toString());
            SimpleXMLFormat simpleXMLFormat = null;
            if (this.isSimpleXMLFormat() || this.getReturnType() == null) {
                simpleXMLFormat = new SimpleXMLFormat();
            }
            if (this.simpleXMLFormatTag != null && this.simpleXMLFormatTag.length() > 0) {
                simpleXMLFormat.setSimpleXMLFormatTag(this.simpleXMLFormatTag);
            }
            if (this.xmlTag != null && this.xmlTag.length() > 0) {
                if (simpleXMLFormat == null) {
                    simpleXMLFormat = new SimpleXMLFormat();
                }
                simpleXMLFormat.setXMLTag(this.xmlTag);
            }
            Object object3 = null;
            if (!dbStoredProcedure.isFunction() && Util.noOutArguments(dbStoredProcedure)) {
                object3 = new Result();
                object3.setType(new QName("http://www.w3.org/2001/XMLSchema", "int", "xsd"));
            } else if (dbStoredProcedure.isFunction()) {
                object2 = (DbStoredFunction)dbStoredProcedure;
                DbStoredArgument dbStoredArgument = ((DbStoredFunction)object2).getReturnArg();
                if (dbStoredArgument.getJdbcTypeName().contains("CURSOR")) {
                    object3 = new CollectionResult();
                    object3.setType(Util.SXF_QNAME_CURSOR);
                } else {
                    object3 = new Result();
                    object3.setType(Util.getXMLTypeFromJDBCType(dbStoredArgument.getJdbcType()));
                }
            } else if (this.returnType != null) {
                object2 = null;
                Object var10_12 = null;
                string = null;
                int n = this.returnType.indexOf(58);
                object3 = new Result();
                if (n > 0) {
                    qName = null;
                    String string2 = this.returnType.substring(0, n);
                    object2 = dBWSBuilder.schema.getNamespaceResolver().resolveNamespacePrefix(string2);
                    if (object2 == null) {
                        object2 = "";
                    }
                    string = this.returnType.substring(n + 1);
                    if ("http://www.w3.org/2001/XMLSchema".equals(object2)) {
                        qName = (QName)QNameTransformer.SCHEMA_QNAMES.get(string);
                        if (qName == null) {
                            qName = new QName("http://www.w3.org/2001/XMLSchema", string, string2 == null ? "" : string2);
                        }
                    } else {
                        qName = new QName((String)(object2 == null ? "" : object2), string, string2 == null ? "" : string2);
                    }
                    object3.setType(qName);
                } else {
                    object3.setType(Util.qNameFromString("{" + dBWSBuilder.getTargetNamespace() + "}" + this.returnType, dBWSBuilder.schema));
                }
            } else if (this.isCollection) {
                object3 = new CollectionResult();
                if (this.isSimpleXMLFormat()) {
                    object3.setType(Util.SXF_QNAME_CURSOR);
                }
            } else {
                object3 = new Result();
                object3.setType(org.eclipse.persistence.internal.xr.Util.SXF_QNAME);
            }
            if (this.binaryAttachment) {
                object2 = new Attachment();
                object2.setMimeType("application/octet-stream");
                object3.setAttachment((Attachment)object2);
            }
            for (DbStoredArgument dbStoredArgument : dbStoredProcedure.getArguments()) {
                string = dbStoredArgument.getName();
                if (string == null) continue;
                ProcedureOutputArgument procedureOutputArgument = null;
                qName = null;
                Util.InOut inOut = dbStoredArgument.getInOut();
                QName qName2 = null;
                qName2 = OracleHelper.getXMLTypeFromJDBCType(dbStoredArgument, dBWSBuilder.getTargetNamespace());
                if (inOut == Util.InOut.IN) {
                    qName = new Parameter();
                    qName.setName(string);
                    qName.setType(qName2);
                    procedureOutputArgument = new ProcedureArgument();
                    procedureOutputArgument.setName(string);
                    procedureOutputArgument.setParameterName(string);
                } else {
                    ProcedureOutputArgument procedureOutputArgument2 = procedureOutputArgument = new ProcedureOutputArgument();
                    procedureOutputArgument2.setName(string);
                    procedureOutputArgument2.setParameterName(string);
                    if (dbStoredArgument.getJdbcTypeName().contains("CURSOR") && this.returnType == null) {
                        procedureOutputArgument2.setResultType(Util.SXF_QNAME_CURSOR);
                        if (object3 == null) {
                            object3 = new CollectionResult();
                            object3.setType(Util.SXF_QNAME_CURSOR);
                        }
                    } else {
                        if (this.returnType != null && simpleXMLFormat == null) {
                            qName2 = Util.qNameFromString("{" + dBWSBuilder.getTargetNamespace() + "}" + this.returnType, dBWSBuilder.schema);
                        }
                        procedureOutputArgument2.setResultType(qName2);
                        if (object3 == null) {
                            object3 = this.isCollection ? new CollectionResult() : new Result();
                            object3.setType(qName2);
                        }
                    }
                }
                if (dbStoredArgument instanceof PLSQLStoredArgument) {
                    procedureOutputArgument.setComplexTypeName(((PLSQLStoredArgument)dbStoredArgument).getPlSqlTypeName());
                }
                if (qName == null) continue;
                queryOperation.getParameters().add(qName);
            }
            if (simpleXMLFormat != null) {
                object3.setSimpleXMLFormat(simpleXMLFormat);
                if (dBWSBuilder.oxProject.getDescriptorForAlias("simple-xml-format") == null) {
                    object2 = new SimpleXMLFormatProject();
                    dBWSBuilder.oxProject.addDescriptor(object2.buildXRRowSetModelDescriptor());
                }
            }
            queryOperation.setResult(object3);
            dBWSBuilder.xrServiceModel.getOperations().put(queryOperation.getName(), queryOperation);
        }
        Util.addSimpleXMLFormat(dBWSBuilder.schema);
    }
}

