/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors.changetracking;

import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.DescriptorEvent;
import org.eclipse.persistence.descriptors.changetracking.ObjectChangePolicy;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelModifyQuery;
import org.eclipse.persistence.queries.WriteObjectQuery;
import org.eclipse.persistence.sessions.changesets.ChangeRecord;

public class DeferredChangeDetectionPolicy
implements ObjectChangePolicy,
Serializable {
    public ObjectChangeSet calculateChangesForNewObject(Object object, UnitOfWorkChangeSet unitOfWorkChangeSet, UnitOfWorkImpl unitOfWorkImpl, ClassDescriptor classDescriptor, boolean bl) {
        return this.calculateChanges(object, null, true, unitOfWorkChangeSet, unitOfWorkImpl, classDescriptor, bl);
    }

    public ObjectChangeSet calculateChangesForExistingObject(Object object, UnitOfWorkChangeSet unitOfWorkChangeSet, UnitOfWorkImpl unitOfWorkImpl, ClassDescriptor classDescriptor, boolean bl) {
        return this.calculateChanges(object, unitOfWorkImpl.getBackupClone(object, classDescriptor), false, unitOfWorkChangeSet, unitOfWorkImpl, classDescriptor, bl);
    }

    public ObjectChangeSet calculateChanges(Object object, Object object2, boolean bl, UnitOfWorkChangeSet unitOfWorkChangeSet, UnitOfWorkImpl unitOfWorkImpl, ClassDescriptor classDescriptor, boolean bl2) {
        Serializable serializable;
        if (classDescriptor.getEventManager().hasAnyEventListeners() && bl2) {
            serializable = new WriteObjectQuery(object.getClass());
            ((ObjectLevelModifyQuery)serializable).setObject(object);
            ((ObjectLevelModifyQuery)serializable).setBackupClone(object2);
            ((DatabaseQuery)serializable).setSession(unitOfWorkImpl);
            ((DatabaseQuery)serializable).setDescriptor(classDescriptor);
            classDescriptor.getEventManager().executeEvent(new DescriptorEvent(0, (ObjectLevelModifyQuery)serializable));
            if (bl) {
                classDescriptor.getEventManager().executeEvent(new DescriptorEvent(4, (ObjectLevelModifyQuery)serializable));
            } else {
                classDescriptor.getEventManager().executeEvent(new DescriptorEvent(6, (ObjectLevelModifyQuery)serializable));
            }
        }
        if (((ObjectChangeSet)(serializable = this.createObjectChangeSet(object, object2, unitOfWorkChangeSet, bl, unitOfWorkImpl, classDescriptor))).hasChanges() && classDescriptor.hasMappingsPostCalculateChanges() && !((ObjectChangeSet)serializable).isNew() && !unitOfWorkImpl.getCommitManager().isActive() && !unitOfWorkImpl.isNestedUnitOfWork()) {
            int n = classDescriptor.getMappingsPostCalculateChanges().size();
            for (int i = 0; i < n; ++i) {
                DatabaseMapping databaseMapping = classDescriptor.getMappingsPostCalculateChanges().get(i);
                ChangeRecord changeRecord = ((ObjectChangeSet)serializable).getChangesForAttributeNamed(databaseMapping.getAttributeName());
                if (changeRecord == null || ((ObjectChangeSet)serializable).hasDeferredAttributes() && ((ObjectChangeSet)serializable).getDeferredSet().contains(databaseMapping.getAttributeName())) continue;
                databaseMapping.postCalculateChanges(changeRecord, unitOfWorkImpl);
            }
        }
        if (!(((ObjectChangeSet)serializable).getPrimaryKeys() != null || bl || ((ObjectChangeSet)serializable).isAggregate() || unitOfWorkImpl.isNestedUnitOfWork() && (!unitOfWorkImpl.isNestedUnitOfWork() || ((UnitOfWorkImpl)unitOfWorkImpl.getParent()).isObjectNew(object2)))) {
            throw ValidationException.nullPrimaryKeyInUnitOfWorkClone(object);
        }
        if (classDescriptor.getCMPPolicy() != null && classDescriptor.getCMPPolicy().getForceUpdate()) {
            ((ObjectChangeSet)serializable).setHasCmpPolicyForcedUpdate(true);
        }
        if (!((ObjectChangeSet)serializable).hasForcedChangesFromCascadeLocking() && unitOfWorkImpl.hasOptimisticReadLockObjects()) {
            ((ObjectChangeSet)serializable).setShouldModifyVersionField((Boolean)unitOfWorkImpl.getOptimisticReadLockObjects().get(object));
        }
        if (((ObjectChangeSet)serializable).hasChanges() || ((ObjectChangeSet)serializable).hasForcedChanges()) {
            return serializable;
        }
        return null;
    }

    public void clearChanges(Object object, UnitOfWorkImpl unitOfWorkImpl, ClassDescriptor classDescriptor) {
    }

    public ObjectChangeSet createObjectChangeSet(Object object, Object object2, UnitOfWorkChangeSet unitOfWorkChangeSet, boolean bl, AbstractSession abstractSession, ClassDescriptor classDescriptor) {
        return this.createObjectChangeSetThroughComparison(object, object2, unitOfWorkChangeSet, bl, abstractSession, classDescriptor);
    }

    public ObjectChangeSet createObjectChangeSetThroughComparison(Object object, Object object2, UnitOfWorkChangeSet unitOfWorkChangeSet, boolean bl, AbstractSession abstractSession, ClassDescriptor classDescriptor) {
        ObjectBuilder objectBuilder = classDescriptor.getObjectBuilder();
        ObjectChangeSet objectChangeSet = objectBuilder.createObjectChangeSet(object, unitOfWorkChangeSet, bl, true, abstractSession);
        if (classDescriptor.usesOptimisticLocking() && objectChangeSet.getPrimaryKeys() != null) {
            objectChangeSet.setOptimisticLockingPolicyAndInitialWriteLockValue(classDescriptor.getOptimisticLockingPolicy(), abstractSession);
        }
        if (!bl || classDescriptor.shouldUseFullChangeSetsForNewObjects() || classDescriptor.isAggregateDescriptor() || classDescriptor.isAggregateCollectionDescriptor()) {
            Vector<DatabaseMapping> vector = classDescriptor.getMappings();
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                DatabaseMapping databaseMapping = (DatabaseMapping)vector.get(i);
                objectChangeSet.addChange(databaseMapping.compareForChange(object, object2, objectChangeSet, abstractSession));
            }
        }
        return objectChangeSet;
    }

    public void dissableEventProcessing(Object object) {
    }

    public void enableEventProcessing(Object object) {
    }

    public boolean shouldCompareExistingObjectForChange(Object object, UnitOfWorkImpl unitOfWorkImpl, ClassDescriptor classDescriptor) {
        return true;
    }

    public Object buildBackupClone(Object object, ObjectBuilder objectBuilder, UnitOfWorkImpl unitOfWorkImpl) {
        return objectBuilder.buildBackupClone(object, unitOfWorkImpl);
    }

    public void setAggregateChangeListener(Object object, Object object2, UnitOfWorkImpl unitOfWorkImpl, ClassDescriptor classDescriptor, String string) {
    }

    public PropertyChangeListener setChangeListener(Object object, UnitOfWorkImpl unitOfWorkImpl, ClassDescriptor classDescriptor) {
        return null;
    }

    public void setChangeSetOnListener(ObjectChangeSet objectChangeSet, Object object) {
    }

    public void updateWithChanges(Object object, ObjectChangeSet objectChangeSet, UnitOfWorkImpl unitOfWorkImpl, ClassDescriptor classDescriptor) {
        if (objectChangeSet == null) {
            return;
        }
        Object v = unitOfWorkImpl.getCloneMapping().get(object);
        if (v != null) {
            if (objectChangeSet.isNew()) {
                unitOfWorkImpl.getCloneMapping().put(object, classDescriptor.getObjectBuilder().buildBackupClone(object, unitOfWorkImpl));
            } else {
                MergeManager mergeManager = new MergeManager(unitOfWorkImpl);
                mergeManager.setCascadePolicy(1);
                classDescriptor.getObjectBuilder().mergeChangesIntoObject(v, objectChangeSet, object, mergeManager);
            }
        }
        this.clearChanges(object, unitOfWorkImpl, classDescriptor);
    }

    public void raiseInternalPropertyChangeEvent(Object object, String string, Object object2, Object object3) {
    }

    public void revertChanges(Object object, ClassDescriptor classDescriptor, UnitOfWorkImpl unitOfWorkImpl, Map map) {
        map.put(object, this.buildBackupClone(object, classDescriptor.getObjectBuilder(), unitOfWorkImpl));
        this.clearChanges(object, unitOfWorkImpl, classDescriptor);
    }

    public void initialize(AbstractSession abstractSession, ClassDescriptor classDescriptor) {
    }

    public boolean isDeferredChangeDetectionPolicy() {
        return true;
    }

    public boolean isObjectChangeTrackingPolicy() {
        return false;
    }

    public boolean isAttributeChangeTrackingPolicy() {
        return false;
    }
}

