/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.eis.adapters.jms;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueReceiver;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.resource.cci.Connection;
import javax.resource.cci.Interaction;
import javax.resource.cci.InteractionSpec;
import javax.resource.cci.Record;
import javax.resource.cci.ResourceWarning;
import org.eclipse.persistence.eis.EISException;
import org.eclipse.persistence.internal.eis.adapters.jms.CciJMSConnection;
import org.eclipse.persistence.internal.eis.adapters.jms.CciJMSInteractionSpec;
import org.eclipse.persistence.internal.eis.adapters.jms.CciJMSReceiveInteractionSpec;
import org.eclipse.persistence.internal.eis.adapters.jms.CciJMSRecord;
import org.eclipse.persistence.internal.eis.adapters.jms.CciJMSSendInteractionSpec;
import org.eclipse.persistence.internal.eis.adapters.jms.CciJMSSendReceiveInteractionSpec;

public class CciJMSInteraction
implements Interaction {
    protected CciJMSConnection connection;

    public CciJMSInteraction(CciJMSConnection cciJMSConnection) {
        this.connection = cciJMSConnection;
    }

    public Record execute(InteractionSpec interactionSpec, Record record) throws EISException {
        CciJMSRecord cciJMSRecord = new CciJMSRecord();
        this.execute(interactionSpec, record, (Record)cciJMSRecord);
        return cciJMSRecord;
    }

    public boolean execute(InteractionSpec interactionSpec, Record record, Record record2) throws EISException {
        block12: {
            if (!(interactionSpec instanceof CciJMSInteractionSpec)) {
                throw EISException.invalidInteractionSpecType();
            }
            if (!(record instanceof CciJMSRecord) || !(record2 instanceof CciJMSRecord)) {
                throw EISException.invalidRecordType();
            }
            boolean bl = false;
            if (!this.connection.getJMSTransaction().isInTransaction()) {
                bl = true;
                this.connection.getJMSTransaction().begin();
            }
            try {
                if (interactionSpec instanceof CciJMSSendInteractionSpec) {
                    this.executeSendInteraction((CciJMSSendInteractionSpec)interactionSpec, (CciJMSRecord)record, (CciJMSRecord)record2);
                    break block12;
                }
                if (interactionSpec instanceof CciJMSReceiveInteractionSpec) {
                    this.executeReceiveInteraction((CciJMSReceiveInteractionSpec)interactionSpec, (CciJMSRecord)record, (CciJMSRecord)record2);
                    break block12;
                }
                if (interactionSpec instanceof CciJMSSendReceiveInteractionSpec) {
                    this.executeSendReceiveInteraction((CciJMSSendReceiveInteractionSpec)interactionSpec, (CciJMSRecord)record, (CciJMSRecord)record2);
                    break block12;
                }
                throw EISException.unknownInteractionSpecType();
            }
            catch (Exception exception) {
                throw EISException.createException(exception);
            }
            finally {
                if (bl) {
                    this.connection.getJMSTransaction().commit();
                }
            }
        }
        return true;
    }

    protected void executeSendInteraction(CciJMSSendInteractionSpec cciJMSSendInteractionSpec, CciJMSRecord cciJMSRecord, CciJMSRecord cciJMSRecord2) throws EISException {
        if (cciJMSRecord.size() != 1) {
            throw EISException.invalidInput();
        }
        try {
            QueueSession queueSession = (QueueSession)this.connection.getSession();
            Queue queue = cciJMSSendInteractionSpec.hasDestinationURL() ? (Queue)new InitialContext().lookup(cciJMSSendInteractionSpec.getDestinationURL()) : queueSession.createQueue(cciJMSSendInteractionSpec.getDestination());
            Message message = this.createMessage(cciJMSRecord.get(0), queueSession);
            if (cciJMSSendInteractionSpec.hasMessageSelector()) {
                message.setJMSCorrelationID(cciJMSSendInteractionSpec.getMessageSelector());
            }
            if (cciJMSSendInteractionSpec.hasReplyToDestinationURL()) {
                message.setJMSReplyTo((Destination)((Queue)new InitialContext().lookup(cciJMSSendInteractionSpec.getReplyToDestinationURL())));
            } else {
                message.setJMSReplyTo((Destination)queueSession.createQueue(cciJMSSendInteractionSpec.getReplyToDestination()));
            }
            queueSession.createSender(queue).send(message);
        }
        catch (Exception exception) {
            throw EISException.createException(exception);
        }
    }

    protected void executeReceiveInteraction(CciJMSReceiveInteractionSpec cciJMSReceiveInteractionSpec, CciJMSRecord cciJMSRecord, CciJMSRecord cciJMSRecord2) throws EISException {
        try {
            QueueSession queueSession = (QueueSession)this.connection.getSession();
            Queue queue = cciJMSReceiveInteractionSpec.hasDestinationURL() ? (Queue)new InitialContext().lookup(cciJMSReceiveInteractionSpec.getDestinationURL()) : queueSession.createQueue(cciJMSReceiveInteractionSpec.getDestination());
            QueueReceiver queueReceiver = cciJMSReceiveInteractionSpec.hasMessageSelector() ? queueSession.createReceiver(queue, cciJMSReceiveInteractionSpec.getFormattedMessageSelector()) : queueSession.createReceiver(queue);
            Message message = queueReceiver.receive(cciJMSReceiveInteractionSpec.getTimeout());
            if (message == null) {
                throw EISException.timeoutOccurred();
            }
            cciJMSRecord2.add(message);
        }
        catch (Exception exception) {
            throw EISException.createException(exception);
        }
    }

    protected void executeSendReceiveInteraction(CciJMSSendReceiveInteractionSpec cciJMSSendReceiveInteractionSpec, CciJMSRecord cciJMSRecord, CciJMSRecord cciJMSRecord2) throws EISException {
        if (cciJMSRecord.size() != 1) {
            throw EISException.invalidInput();
        }
        try {
            QueueSession queueSession = (QueueSession)this.connection.getSession();
            Queue queue = cciJMSSendReceiveInteractionSpec.hasDestinationURL() ? (Queue)new InitialContext().lookup(cciJMSSendReceiveInteractionSpec.getDestinationURL()) : queueSession.createQueue(cciJMSSendReceiveInteractionSpec.getDestination());
            Queue queue2 = cciJMSSendReceiveInteractionSpec.hasReplyToDestinationURL() ? (Queue)new InitialContext().lookup(cciJMSSendReceiveInteractionSpec.getReplyToDestinationURL()) : queueSession.createQueue(cciJMSSendReceiveInteractionSpec.getReplyToDestination());
            Message message = this.createMessage(cciJMSRecord.get(0), queueSession);
            message.setJMSReplyTo((Destination)queue2);
            if (cciJMSSendReceiveInteractionSpec.hasMessageSelector()) {
                message.setJMSCorrelationID(cciJMSSendReceiveInteractionSpec.getMessageSelector());
                this.sendMessageAndCommit(queueSession, queue, message);
            } else {
                this.sendMessageAndCommit(queueSession, queue, message);
                cciJMSSendReceiveInteractionSpec.setMessageSelector(message.getJMSMessageID());
            }
            Queue queue3 = cciJMSSendReceiveInteractionSpec.hasReplyToDestinationURL() ? (Queue)new InitialContext().lookup(cciJMSSendReceiveInteractionSpec.getReplyToDestinationURL()) : queueSession.createQueue(cciJMSSendReceiveInteractionSpec.getReplyToDestination());
            message = queueSession.createReceiver(queue3, cciJMSSendReceiveInteractionSpec.getFormattedMessageSelector()).receive(cciJMSSendReceiveInteractionSpec.getTimeout());
            if (message == null) {
                throw EISException.timeoutOccurred();
            }
            cciJMSRecord2.add(message);
        }
        catch (Exception exception) {
            throw EISException.createException(exception);
        }
    }

    protected void sendMessageAndCommit(QueueSession queueSession, Queue queue, Message message) throws EISException {
        try {
            queueSession.createSender(queue).send(message);
        }
        catch (Exception exception) {
            throw EISException.createException(exception);
        }
        this.connection.getJMSTransaction().commit();
        this.connection.getJMSTransaction().begin();
    }

    protected Message createMessage(Object object, QueueSession queueSession) throws EISException {
        TextMessage textMessage;
        try {
            if (!(object instanceof String)) {
                throw EISException.unsupportedMessageInInputRecord();
            }
            textMessage = queueSession.createTextMessage((String)object);
        }
        catch (JMSException jMSException) {
            throw EISException.createException((Exception)((Object)jMSException));
        }
        return textMessage;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public ResourceWarning getWarnings() {
        return null;
    }

    public void clearWarnings() {
    }

    public void close() {
    }
}

