/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.eis.adapters.xmlfile;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.resource.ResourceException;
import javax.resource.cci.LocalTransaction;
import org.eclipse.persistence.eis.EISDOMRecord;
import org.eclipse.persistence.internal.eis.adapters.xmlfile.XMLFileConnection;

public class XMLFileTransaction
implements LocalTransaction {
    protected boolean isInTransaction;
    protected Map domFiles;
    protected XMLFileConnection connection;

    public XMLFileTransaction(XMLFileConnection xMLFileConnection) {
        this.connection = xMLFileConnection;
        this.isInTransaction = false;
    }

    public void begin() {
        this.isInTransaction = true;
        this.domFiles = new HashMap(10);
    }

    public boolean isInTransaction() {
        return this.isInTransaction;
    }

    public void commit() throws ResourceException {
        try {
            for (Map.Entry entry : this.domFiles.entrySet()) {
                String string = (String)entry.getKey();
                EISDOMRecord eISDOMRecord = (EISDOMRecord)entry.getValue();
                FileWriter fileWriter = new FileWriter(string);
                eISDOMRecord.transformToWriter(fileWriter);
                ((Writer)fileWriter).flush();
                ((Writer)fileWriter).close();
            }
        }
        catch (Exception exception) {
            throw new ResourceException(exception.toString());
        }
        this.domFiles = new HashMap(10);
        this.isInTransaction = false;
    }

    public void rollback() {
        this.domFiles = new HashMap(10);
        this.isInTransaction = false;
    }

    public EISDOMRecord retrieveDOMRecord(File file) throws Exception {
        EISDOMRecord eISDOMRecord = (EISDOMRecord)this.domFiles.get(file.getPath());
        if (eISDOMRecord == null) {
            if (file.exists()) {
                FileReader fileReader = new FileReader(file);
                eISDOMRecord = new EISDOMRecord();
                eISDOMRecord.transformFromXML(fileReader);
                ((Reader)fileReader).close();
            } else {
                eISDOMRecord = new EISDOMRecord();
                eISDOMRecord.setDOM(eISDOMRecord.createNewDocument("root"));
            }
            this.domFiles.put(file.getPath(), eISDOMRecord);
        }
        return eISDOMRecord;
    }
}

