/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.identitymaps;

import java.lang.ref.ReferenceQueue;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.identitymaps.QueueableWeakCacheKey;
import org.eclipse.persistence.internal.identitymaps.UnitOfWorkIdentityMap;

public class WeakUnitOfWorkIdentityMap
extends UnitOfWorkIdentityMap {
    protected ReferenceQueue referenceQueue;
    protected volatile int cleanupCount = 0;
    protected volatile int cleanupSize;

    public WeakUnitOfWorkIdentityMap(int n, ClassDescriptor classDescriptor) {
        super(n, classDescriptor);
        this.cleanupSize = n;
        this.referenceQueue = new ReferenceQueue();
    }

    protected void cleanupDeadCacheKeys() {
        QueueableWeakCacheKey.CacheKeyReference cacheKeyReference = (QueueableWeakCacheKey.CacheKeyReference)this.referenceQueue.poll();
        while (cacheKeyReference != null) {
            QueueableWeakCacheKey queueableWeakCacheKey = cacheKeyReference.getOwner();
            this.remove(queueableWeakCacheKey);
            cacheKeyReference = (QueueableWeakCacheKey.CacheKeyReference)this.referenceQueue.poll();
        }
    }

    public CacheKey createCacheKey(Vector vector, Object object, Object object2, long l) {
        return new QueueableWeakCacheKey(vector, object, object2, l, this.referenceQueue);
    }

    protected CacheKey getCacheKeyIfAbsentPut(CacheKey cacheKey) {
        CacheKey cacheKey2 = super.getCacheKeyIfAbsentPut(cacheKey);
        if (cacheKey2 == null) {
            this.checkCleanup();
        }
        return cacheKey2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkCleanup() {
        if (this.cleanupCount > this.cleanupSize) {
            WeakUnitOfWorkIdentityMap weakUnitOfWorkIdentityMap = this;
            synchronized (weakUnitOfWorkIdentityMap) {
                if (this.cleanupCount > this.cleanupSize) {
                    this.cleanupDeadCacheKeys();
                    this.cleanupCount = 0;
                    int n = this.getSize();
                    if (n > this.cleanupSize) {
                        this.cleanupSize = n;
                    }
                }
            }
        }
        ++this.cleanupCount;
    }
}

