/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.deployment.osgi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.exceptions.EntityManagerSetupException;
import org.eclipse.persistence.internal.jpa.deployment.JPAInitializer;
import org.eclipse.persistence.internal.jpa.deployment.PersistenceInitializationHelper;
import org.eclipse.persistence.internal.jpa.deployment.osgi.BundleProxyClassLoader;
import org.eclipse.persistence.internal.jpa.deployment.osgi.CompositeClassLoader;
import org.eclipse.persistence.internal.jpa.deployment.osgi.OSGiInitializer;
import org.eclipse.persistence.internal.localization.LoggingLocalization;
import org.eclipse.persistence.jpa.osgi.Activator;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.osgi.framework.Bundle;

public class OSGiPersistenceInitializationHelper
extends PersistenceInitializationHelper {
    private String initializerClassName = null;
    public static final String EQUINOX_INITIALIZER_NAME = "org.eclipse.persistence.internal.jpa.deployment.osgi.equinox.EquinoxInitializer";
    private static final String ORG_ECLIPSE_PERSISTENCE_CORE = "org.eclipse.persistence.core";
    private static Map<String, Bundle> puToBundle = Collections.synchronizedMap(new HashMap());
    private static Map<Bundle, String[]> bundleToPUs = Collections.synchronizedMap(new HashMap());
    private Map<String, ClassLoader> puClassLoaders = new HashMap<String, ClassLoader>();

    public static void addBundle(Bundle bundle, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            puToBundle.put(string, bundle);
        }
        bundleToPUs.put(bundle, stringArray);
    }

    public static void removeBundle(Bundle bundle) {
        String[] stringArray = bundleToPUs.remove(bundle);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                puToBundle.remove(string);
            }
        }
    }

    public OSGiPersistenceInitializationHelper(String string) {
        this.initializerClassName = string;
    }

    public ClassLoader getClassLoader(String string, Map map) {
        Object object;
        Object object2;
        Object object3;
        ClassLoader classLoader = this.puClassLoaders.get(string);
        if (classLoader != null) {
            return classLoader;
        }
        ArrayList<ClassLoader> arrayList = new ArrayList<ClassLoader>();
        ClassLoader classLoader2 = null;
        if (map != null && (object3 = map.get("eclipselink.classloader")) != null && object3 instanceof ClassLoader) {
            classLoader2 = (ClassLoader)object3;
            arrayList.add(classLoader2);
        }
        if ((object3 = puToBundle.get(string)) != null) {
            object2 = new BundleProxyClassLoader((Bundle)object3);
            arrayList.add((ClassLoader)object2);
        }
        if (classLoader2 == null && object3 == null) {
            throw EntityManagerSetupException.couldNotFindPersistenceUnitBundle(string);
        }
        object2 = Activator.getContext();
        if (object2 != null) {
            object = object2.getBundles();
            Bundle bundle = null;
            for (int i = 0; i < ((Bundle[])object).length; ++i) {
                if (!ORG_ECLIPSE_PERSISTENCE_CORE.equals(object[i].getSymbolicName())) continue;
                bundle = object[i];
                arrayList.add(new BundleProxyClassLoader(bundle));
                break;
            }
            BundleProxyClassLoader bundleProxyClassLoader = new BundleProxyClassLoader(object2.getBundle());
            arrayList.add(bundleProxyClassLoader);
        }
        object = null;
        object = arrayList.size() == 1 && arrayList.get(0) == classLoader2 ? classLoader2 : new CompositeClassLoader(arrayList);
        this.puClassLoaders.put(string, (ClassLoader)object);
        return object;
    }

    public JPAInitializer getInitializer(ClassLoader classLoader, Map map) {
        if (this.initializerClassName != null) {
            try {
                Class<?> clazz = Class.forName(this.initializerClassName);
                Class[] classArray = new Class[]{ClassLoader.class, Map.class, PersistenceInitializationHelper.class};
                Object[] objectArray = new Object[]{classLoader, map, this};
                JPAInitializer jPAInitializer = (JPAInitializer)clazz.getConstructor(classArray).newInstance(objectArray);
                return jPAInitializer;
            }
            catch (Exception exception) {
                AbstractSessionLog.getLog().log(1, LoggingLocalization.buildMessage("osgi_initializer_failed", new Object[]{this.initializerClassName, exception}));
            }
        }
        return new OSGiInitializer(classLoader);
    }

    public static boolean includesBundle(Bundle bundle) {
        return bundleToPUs.containsKey(bundle);
    }
}

