/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.persistence.spi.PersistenceUnitInfo;
import org.eclipse.persistence.config.DescriptorCustomizer;
import org.eclipse.persistence.exceptions.PersistenceUnitLoadingException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.deployment.ArchiveFactoryImpl;
import org.eclipse.persistence.internal.jpa.deployment.PersistenceUnitProcessor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProject;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.EmbeddableAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.EntityAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.MappedSuperclassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.converters.StructConverterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappingsReader;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.platform.database.converters.StructConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataProcessor {
    protected ClassLoader m_loader;
    protected MetadataProject m_project;
    protected AbstractSession m_session;

    public MetadataProcessor(PersistenceUnitInfo persistenceUnitInfo, AbstractSession abstractSession, ClassLoader classLoader, boolean bl, boolean bl2) {
        this.m_loader = classLoader;
        this.m_session = abstractSession;
        this.m_project = new MetadataProject(persistenceUnitInfo, abstractSession, bl, bl2);
    }

    public void addEntityListeners() {
        for (EntityAccessor entityAccessor : this.m_project.getEntityAccessors()) {
            entityAccessor.setJavaClass(entityAccessor.getDescriptor().getClassDescriptor().getJavaClass());
            entityAccessor.processListeners(this.m_loader);
        }
    }

    public void addNamedQueries() {
        this.m_project.processQueries(this.m_loader);
    }

    public Set<String> getPersistenceUnitClassSetFromMappingFiles() {
        HashSet<String> hashSet = new HashSet<String>();
        for (XMLEntityMappings xMLEntityMappings : this.m_project.getEntityMappings()) {
            for (EntityAccessor entityAccessor : xMLEntityMappings.getEntities()) {
                hashSet.add(xMLEntityMappings.getFullyQualifiedClassName(entityAccessor.getClassName()));
            }
            for (EmbeddableAccessor embeddableAccessor : xMLEntityMappings.getEmbeddables()) {
                hashSet.add(xMLEntityMappings.getFullyQualifiedClassName(embeddableAccessor.getClassName()));
            }
            for (MappedSuperclassAccessor mappedSuperclassAccessor : xMLEntityMappings.getMappedSuperclasses()) {
                hashSet.add(xMLEntityMappings.getFullyQualifiedClassName(mappedSuperclassAccessor.getClassName()));
            }
        }
        return hashSet;
    }

    public MetadataProject getProject() {
        return this.m_project;
    }

    public List<StructConverter> getStructConverters() {
        ArrayList<StructConverter> arrayList = new ArrayList<StructConverter>();
        for (StructConverterMetadata structConverterMetadata : this.m_project.getStructConverters()) {
            StructConverter structConverter = (StructConverter)MetadataHelper.getClassInstance(structConverterMetadata.getConverterClassName(), this.m_loader);
            arrayList.add(structConverter);
        }
        return arrayList;
    }

    protected void handleORMException(RuntimeException runtimeException, String string, boolean bl) {
        if (this.m_session == null) {
            AbstractSessionLog.getLog().log(4, "error_loading_xml_file", new Object[]{string, runtimeException});
        } else if (!bl) {
            this.m_session.log(4, "ejb_or_metadata", "error_loading_xml_file", new Object[]{string, runtimeException});
        } else {
            this.m_session.handleException(runtimeException);
        }
    }

    protected void initPersistenceUnitClasses() {
        HashMap<String, EntityAccessor> hashMap = new HashMap<String, EntityAccessor>();
        HashMap<String, EmbeddableAccessor> hashMap2 = new HashMap<String, EmbeddableAccessor>();
        for (XMLEntityMappings object2 : this.m_project.getEntityMappings()) {
            object2.initPersistenceUnitClasses(hashMap, hashMap2);
        }
        for (EntityAccessor entityAccessor : hashMap.values()) {
            this.m_project.addEntityAccessor(entityAccessor);
            entityAccessor.getAccessibleObject().getEntityMappings().processEntityMappingsDefaults(entityAccessor);
        }
        for (EmbeddableAccessor embeddableAccessor : hashMap2.values()) {
            this.m_project.addEmbeddableAccessor(embeddableAccessor);
            embeddableAccessor.getAccessibleObject().getEntityMappings().processEntityMappingsDefaults(embeddableAccessor);
        }
        Iterator<ORMetadata> iterator = this.m_project.getPersistenceUnitInfo();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(iterator.getManagedClassNames());
        for (Object object : iterator.getJarFileUrls()) {
            arrayList.addAll(PersistenceUnitProcessor.getClassNamesFromURL((URL)object));
        }
        if (!iterator.excludeUnlistedClasses()) {
            arrayList.addAll(PersistenceUnitProcessor.getClassNamesFromURL(iterator.getPersistenceUnitRootUrl()));
        }
        for (Object object : arrayList) {
            Class clazz = PersistenceUnitProcessor.loadClass((String)object, this.m_loader, true, this.m_project);
            if (clazz == null) continue;
            if (PersistenceUnitProcessor.isEntity(clazz) && !this.m_project.hasEntity(clazz)) {
                this.m_project.addEntityAccessor(new EntityAccessor(PersistenceUnitProcessor.getEntityAnnotation(clazz), clazz, this.m_project));
                continue;
            }
            if (!PersistenceUnitProcessor.isEmbeddable(clazz) || this.m_project.hasEmbeddable(clazz)) continue;
            this.m_project.addEmbeddableAccessor(new EmbeddableAccessor(PersistenceUnitProcessor.getEmbeddableAnnotation(clazz), clazz, this.m_project));
        }
    }

    public void loadMappingFiles(boolean bl) {
        this.loadStandardMappingFiles("META-INF/orm.xml");
        this.loadSpecifiedMappingFiles(bl);
        Boolean bl2 = new Boolean((String)this.m_project.getPersistenceUnitInfo().getProperties().get("eclipselink.exclude-eclipselink-orm"));
        if (!bl2.booleanValue()) {
            this.loadStandardMappingFiles("META-INF/eclipselink-orm.xml");
        }
    }

    protected void loadSpecifiedMappingFiles(boolean bl) {
        PersistenceUnitInfo persistenceUnitInfo = this.m_project.getPersistenceUnitInfo();
        for (String string : persistenceUnitInfo.getMappingFileNames()) {
            try {
                Enumeration<URL> enumeration = this.m_loader.getResources(string);
                if (enumeration.hasMoreElements()) {
                    URL uRL = enumeration.nextElement();
                    if (enumeration.hasMoreElements()) {
                        this.handleORMException(ValidationException.nonUniqueMappingFileName(persistenceUnitInfo.getPersistenceUnitName(), string), string, bl);
                    }
                    this.m_project.addEntityMappings(XMLEntityMappingsReader.read(uRL, this.m_loader, this.m_project.getPersistenceUnitInfo().getProperties()));
                    continue;
                }
                this.handleORMException(ValidationException.mappingFileNotFound(persistenceUnitInfo.getPersistenceUnitName(), string), string, bl);
            }
            catch (IOException iOException) {
                this.handleORMException(PersistenceUnitLoadingException.exceptionLoadingORMXML(string, iOException), string, bl);
            }
        }
    }

    protected void loadStandardMappingFiles(String string) {
        PersistenceUnitInfo persistenceUnitInfo = this.m_project.getPersistenceUnitInfo();
        HashSet<URL> hashSet = new HashSet<URL>(persistenceUnitInfo.getJarFileUrls());
        hashSet.add(persistenceUnitInfo.getPersistenceUnitRootUrl());
        for (URL uRL : hashSet) {
            Object object;
            this.logMessage("Searching for default mapping file in " + uRL);
            URL uRL2 = null;
            try {
                object = null;
                object = new ArchiveFactoryImpl().createArchive(uRL);
                uRL2 = object.getEntryAsURL(string);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new RuntimeException(uRISyntaxException);
            }
            if (uRL2 == null) continue;
            this.logMessage("Found a default mapping file at " + uRL2 + " for root URL " + uRL);
            try {
                object = XMLEntityMappingsReader.read(uRL2, this.m_loader, this.m_project.getPersistenceUnitInfo().getProperties());
                ((XMLEntityMappings)object).setIsEclipseLinkORMFile(string.equals("META-INF/eclipselink-orm.xml"));
                this.m_project.addEntityMappings((XMLEntityMappings)object);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }

    protected void logMessage(String string) {
        if (this.m_session == null) {
            AbstractSessionLog.getLog().log(2, string);
        } else {
            this.m_session.logMessage(string);
        }
    }

    protected void logThrowable(Throwable throwable) {
        if (this.m_session == null) {
            AbstractSessionLog.getLog().logThrowable(2, throwable);
        } else {
            this.m_session.getSessionLog().logThrowable(2, throwable);
        }
    }

    public void processCustomizers() {
        for (ClassAccessor classAccessor : this.m_project.getAccessorsWithCustomizer()) {
            DescriptorCustomizer descriptorCustomizer = (DescriptorCustomizer)MetadataHelper.getClassInstance(classAccessor.getCustomizerClass().getName(), this.m_loader);
            try {
                descriptorCustomizer.customize(classAccessor.getDescriptor().getClassDescriptor());
            }
            catch (Exception exception) {
                this.logThrowable(exception);
            }
        }
    }

    public void processEntityMappings() {
        for (XMLEntityMappings xMLEntityMappings : this.m_project.getEntityMappings()) {
            xMLEntityMappings.setLoader(this.m_loader);
            xMLEntityMappings.setProject(this.m_project);
            xMLEntityMappings.processPersistenceUnitMetadata();
        }
        this.initPersistenceUnitClasses();
        for (XMLEntityMappings xMLEntityMappings : this.m_project.getEntityMappings()) {
            xMLEntityMappings.process();
        }
    }

    public void processORMMetadata() {
        this.m_project.processStage1();
        this.m_project.processStage2();
        this.m_project.processStage3();
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.m_loader = classLoader;
        for (XMLEntityMappings xMLEntityMappings : this.m_project.getEntityMappings()) {
            xMLEntityMappings.setLoader(this.m_loader);
        }
    }
}

