/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.lang.annotation.Annotation;
import java.sql.Blob;
import java.util.Collection;
import java.util.Map;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.SequenceGenerator;
import javax.persistence.TableGenerator;
import org.eclipse.persistence.annotations.Mutable;
import org.eclipse.persistence.annotations.ReturnInsert;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.DirectAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.columns.ColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.EnumeratedMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.LobMetadata;
import org.eclipse.persistence.internal.jpa.metadata.sequencing.GeneratedValueMetadata;
import org.eclipse.persistence.internal.jpa.metadata.sequencing.SequenceGeneratorMetadata;
import org.eclipse.persistence.internal.jpa.metadata.sequencing.TableGeneratorMetadata;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;

public class BasicAccessor
extends DirectAccessor {
    private Boolean m_mutable;
    private ColumnMetadata m_column;
    private DatabaseField m_field;
    private GeneratedValueMetadata m_generatedValue;
    private SequenceGeneratorMetadata m_sequenceGenerator;
    private TableGeneratorMetadata m_tableGenerator;

    public BasicAccessor() {
        super("<basic>");
    }

    public BasicAccessor(String string) {
        super(string);
    }

    public BasicAccessor(Annotation annotation, MetadataAccessibleObject metadataAccessibleObject, ClassAccessor classAccessor) {
        super(annotation, metadataAccessibleObject, classAccessor);
        Object t = this.getAnnotation(Basic.class);
        if (t != null) {
            this.setFetch((Enum)MetadataHelper.invokeMethod("fetch", t));
            this.setOptional((Boolean)MetadataHelper.invokeMethod("optional", t));
        }
        this.m_column = new ColumnMetadata((Annotation)this.getAnnotation(Column.class), metadataAccessibleObject, this.getAttributeName());
        if (this.isAnnotationPresent(Mutable.class)) {
            this.m_mutable = (Boolean)MetadataHelper.invokeMethod("value", this.getAnnotation(Mutable.class));
        }
        if (this.isAnnotationPresent(GeneratedValue.class)) {
            this.m_generatedValue = new GeneratedValueMetadata((Annotation)this.getAnnotation(GeneratedValue.class));
        }
        if (this.isAnnotationPresent(SequenceGenerator.class)) {
            this.m_sequenceGenerator = new SequenceGeneratorMetadata((Annotation)this.getAnnotation(SequenceGenerator.class), metadataAccessibleObject);
        }
        if (this.isAnnotationPresent(TableGenerator.class)) {
            this.m_tableGenerator = new TableGeneratorMetadata((Annotation)this.getAnnotation(TableGenerator.class), metadataAccessibleObject);
        }
    }

    public ColumnMetadata getColumn() {
        return this.m_column;
    }

    protected ColumnMetadata getColumn(String string) {
        return this.m_column == null ? super.getColumn(string) : this.m_column;
    }

    protected DatabaseField getDatabaseField(DatabaseTable databaseTable, String string) {
        DatabaseField databaseField = super.getDatabaseField(databaseTable, string);
        if (this.getAccessibleObject().isGenericType()) {
            databaseField.setType(this.getReferenceClass());
        }
        return databaseField;
    }

    public FetchType getDefaultFetchType() {
        return FetchType.EAGER;
    }

    protected DatabaseField getField() {
        return this.m_field;
    }

    public GeneratedValueMetadata getGeneratedValue() {
        return this.m_generatedValue;
    }

    public Boolean getMutable() {
        return this.m_mutable;
    }

    public SequenceGeneratorMetadata getSequenceGenerator() {
        return this.m_sequenceGenerator;
    }

    public TableGeneratorMetadata getTableGenerator() {
        return this.m_tableGenerator;
    }

    public void initXMLObject(MetadataAccessibleObject metadataAccessibleObject) {
        super.initXMLObject(metadataAccessibleObject);
        if (this.m_column == null) {
            this.m_column = new ColumnMetadata(metadataAccessibleObject, this.getAttributeName());
        } else {
            this.initXMLObject(this.m_column, metadataAccessibleObject);
        }
        this.initXMLObject(this.m_sequenceGenerator, metadataAccessibleObject);
        this.initXMLObject(this.m_tableGenerator, metadataAccessibleObject);
    }

    protected boolean isCollectionClass(Class clazz) {
        return Collection.class.isAssignableFrom(clazz);
    }

    protected boolean isMapClass(Class clazz) {
        return Map.class.isAssignableFrom(clazz);
    }

    public void process() {
        DirectToFieldMapping directToFieldMapping = new DirectToFieldMapping();
        this.setMapping(directToFieldMapping);
        this.m_field = this.getDatabaseField(this.getDescriptor().getPrimaryTable(), "metadata_default_column");
        if (this.getAccessibleObject().isGenericType()) {
            directToFieldMapping.setAttributeClassification(this.getReferenceClass());
        }
        directToFieldMapping.setField(this.m_field);
        directToFieldMapping.setIsReadOnly(this.m_field.isReadOnly());
        directToFieldMapping.setAttributeName(this.getAttributeName());
        directToFieldMapping.setIsOptional(this.isOptional());
        directToFieldMapping.setIsLazy(this.usesIndirection());
        directToFieldMapping.setIsIDMapping(this.isId());
        this.setAccessorMethods(directToFieldMapping);
        this.processMappingValueConverter(directToFieldMapping, this.getConvert(), this.getReferenceClass());
        if (this.m_mutable != null) {
            directToFieldMapping.setIsMutable(this.m_mutable);
        }
        this.processReturnInsertAndUpdate();
        this.processGeneratedValue();
        if (this.m_tableGenerator != null) {
            this.getProject().addTableGenerator(this.m_tableGenerator, this.getDescriptor().getDefaultCatalog(), this.getDescriptor().getDefaultSchema());
        }
        if (this.m_sequenceGenerator != null) {
            this.getProject().addSequenceGenerator(this.m_sequenceGenerator);
        }
    }

    protected void processEnumerated(EnumeratedMetadata enumeratedMetadata, DatabaseMapping databaseMapping, Class clazz, boolean bl) {
        if (this.isCollectionClass(clazz) || this.isMapClass(clazz)) {
            this.processSerialized(databaseMapping, clazz, bl);
        } else {
            super.processEnumerated(enumeratedMetadata, databaseMapping, clazz, bl);
        }
    }

    protected void processGeneratedValue() {
        if (this.m_generatedValue != null) {
            DatabaseField databaseField = this.getOwningDescriptor().getSequenceNumberField();
            if (databaseField == null) {
                this.getOwningDescriptor().setSequenceNumberField(this.m_field);
                this.getProject().addGeneratedValue(this.m_generatedValue, this.getOwningDescriptor().getJavaClass());
            } else {
                throw ValidationException.onlyOneGeneratedValueIsAllowed(this.getOwningDescriptor().getJavaClass(), databaseField.getQualifiedName(), this.m_field.getQualifiedName());
            }
        }
    }

    protected void processLob(LobMetadata lobMetadata, DatabaseMapping databaseMapping, Class clazz, boolean bl) {
        if (this.isCollectionClass(clazz) || this.isMapClass(clazz)) {
            this.processSerialized(databaseMapping, clazz, Blob.class, bl);
        } else {
            super.processLob(lobMetadata, databaseMapping, clazz, bl);
        }
    }

    protected void processReturnInsert() {
        Object t = this.getAnnotation(ReturnInsert.class);
        if (t != null) {
            boolean bl = (Boolean)MetadataHelper.invokeMethod("returnOnly", t);
            if (bl) {
                this.getDescriptor().addFieldForInsertReturnOnly(this.m_field);
            } else {
                this.getDescriptor().addFieldForInsert(this.m_field);
            }
        }
    }

    protected void processReturnUpdate() {
        if (this.hasReturnUpdate()) {
            this.getDescriptor().addFieldForUpdate(this.m_field);
        }
    }

    public void setColumn(ColumnMetadata columnMetadata) {
        this.m_column = columnMetadata;
    }

    public void setGeneratedValue(GeneratedValueMetadata generatedValueMetadata) {
        this.m_generatedValue = generatedValueMetadata;
    }

    public void setMutable(Boolean bl) {
        this.m_mutable = bl;
    }

    public void setSequenceGenerator(SequenceGeneratorMetadata sequenceGeneratorMetadata) {
        this.m_sequenceGenerator = sequenceGeneratorMetadata;
    }

    public void setTableGenerator(TableGeneratorMetadata tableGeneratorMetadata) {
        this.m_tableGenerator = tableGeneratorMetadata;
    }
}

