/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.lang.annotation.Annotation;
import javax.persistence.FetchType;
import org.eclipse.persistence.annotations.JoinFetch;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.DirectAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.tables.CollectionTableMetadata;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DirectCollectionMapping;
import org.eclipse.persistence.mappings.DirectMapMapping;

public abstract class DirectCollectionAccessor
extends DirectAccessor {
    private Enum m_joinFetch;
    private CollectionTableMetadata m_collectionTable;

    protected DirectCollectionAccessor(String string) {
        super(string);
    }

    protected DirectCollectionAccessor(Annotation annotation, MetadataAccessibleObject metadataAccessibleObject, ClassAccessor classAccessor) {
        super(annotation, metadataAccessibleObject, classAccessor);
        if (annotation != null) {
            this.setFetch((Enum)MetadataHelper.invokeMethod("fetch", annotation));
        }
        if (this.isAnnotationPresent(JoinFetch.class)) {
            this.m_joinFetch = (Enum)MetadataHelper.invokeMethod("value", this.getAnnotation(JoinFetch.class));
        }
    }

    public CollectionTableMetadata getCollectionTable() {
        return this.m_collectionTable;
    }

    protected String getDefaultCollectionTableName() {
        return this.getDescriptor().getAlias() + "_" + this.getUpperCaseAttributeName();
    }

    public FetchType getDefaultFetchType() {
        return FetchType.LAZY;
    }

    public Enum getJoinFetch() {
        return this.m_joinFetch;
    }

    public String getPrivateOwned() {
        return null;
    }

    public Class getReferenceClass() {
        Class clazz = this.getReferenceClassFromGeneric();
        return clazz == null ? Void.TYPE : clazz;
    }

    protected DatabaseTable getReferenceDatabaseTable() {
        return this.m_collectionTable.getDatabaseTable();
    }

    public MetadataDescriptor getReferenceDescriptor() {
        return this.getDescriptor();
    }

    protected abstract String getKeyConverter();

    protected String getValueConverter() {
        return this.getConvert();
    }

    protected boolean hasMapKeyClass() {
        return false;
    }

    public void initXMLObject(MetadataAccessibleObject metadataAccessibleObject) {
        super.initXMLObject(metadataAccessibleObject);
        this.initXMLObject(this.m_collectionTable, metadataAccessibleObject);
    }

    public boolean isDirectCollection() {
        return true;
    }

    protected boolean isValidDirectCollectionType() {
        return this.getAccessibleObject().isSupportedCollectionClass(this.getDescriptor());
    }

    protected boolean isValidDirectMapType() {
        return this.getAccessibleObject().isSupportedMapClass(this.getDescriptor());
    }

    protected void process(CollectionMapping collectionMapping) {
        this.setMapping(collectionMapping);
        collectionMapping.setAttributeName(this.getAttributeName());
        this.setAccessorMethods(collectionMapping);
        collectionMapping.setJoinFetch(this.getMappingJoinFetchType(this.m_joinFetch));
        this.processCollectionTable(collectionMapping);
        this.processReturnInsertAndUpdate();
    }

    protected void processCollectionTable(CollectionMapping collectionMapping) {
        if (this.m_collectionTable == null) {
            this.m_collectionTable = new CollectionTableMetadata(this.getAccessibleObject());
        }
        this.processTable(this.m_collectionTable, this.getDefaultCollectionTableName());
        if (!this.isDirectEmbeddableCollection()) {
            ((DirectCollectionMapping)collectionMapping).setReferenceTable(this.m_collectionTable.getDatabaseTable());
        }
    }

    protected void processDirectCollectionMapping() {
        DirectCollectionMapping directCollectionMapping = new DirectCollectionMapping();
        this.process(directCollectionMapping);
        this.processContainerPolicyAndIndirection(directCollectionMapping);
        directCollectionMapping.setDirectField(this.getDatabaseField(this.getReferenceDatabaseTable(), "metadata_default_value_column"));
        this.processMappingValueConverter(directCollectionMapping, this.getValueConverter(), this.getReferenceClass());
    }

    protected void processDirectMapMapping() {
        DirectMapMapping directMapMapping = new DirectMapMapping();
        this.process(directMapMapping);
        this.processContainerPolicyAndIndirection(directMapMapping);
        directMapMapping.setDirectKeyField(this.getDatabaseField(this.getReferenceDatabaseTable(), "metadata_default_key_column"));
        if (this.isBasicMap()) {
            this.processMappingKeyConverter(directMapMapping, this.getKeyConverter(), this.getMapKeyReferenceClass());
        }
        directMapMapping.setDirectField(this.getDatabaseField(this.getReferenceDatabaseTable(), "metadata_default_value_column"));
        this.processMappingValueConverter(directMapMapping, this.getValueConverter(), this.getReferenceClass());
    }

    public void setCollectionTable(CollectionTableMetadata collectionTableMetadata) {
        this.m_collectionTable = collectionTableMetadata;
    }

    public void setJoinFetch(Enum enum_) {
        this.m_joinFetch = enum_;
    }
}

