/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.converters;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.sql.Blob;
import java.sql.Clob;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappingAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.converters.MetadataConverter;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.SerializedObjectConverter;
import org.eclipse.persistence.mappings.converters.TypeConversionConverter;

public class LobMetadata
extends MetadataConverter {
    public LobMetadata() {
        super("<lob>");
    }

    public LobMetadata(Annotation annotation, MetadataAccessibleObject metadataAccessibleObject) {
        super(annotation, metadataAccessibleObject);
    }

    public static boolean isValidBlobType(Class clazz) {
        return clazz.equals(byte[].class) || clazz.equals(Byte[].class) || clazz.equals(Blob.class);
    }

    public static boolean isValidClobType(Class clazz) {
        return clazz.equals(char[].class) || clazz.equals(String.class) || clazz.equals(Character[].class) || clazz.equals(Clob.class);
    }

    public static boolean isValidLobType(Class clazz) {
        return LobMetadata.isValidClobType(clazz) || LobMetadata.isValidBlobType(clazz);
    }

    public void process(DatabaseMapping databaseMapping, MappingAccessor mappingAccessor, Class clazz, boolean bl) {
        if (LobMetadata.isValidClobType(clazz)) {
            this.setFieldClassification(databaseMapping, Clob.class, bl);
            this.setConverter(databaseMapping, new TypeConversionConverter(databaseMapping), bl);
        } else if (LobMetadata.isValidBlobType(clazz)) {
            this.setFieldClassification(databaseMapping, Blob.class, bl);
            this.setConverter(databaseMapping, new TypeConversionConverter(databaseMapping), bl);
        } else if (Helper.classImplementsInterface(clazz, Serializable.class)) {
            this.setFieldClassification(databaseMapping, Blob.class, bl);
            this.setConverter(databaseMapping, new SerializedObjectConverter(databaseMapping), bl);
        } else {
            throw ValidationException.invalidTypeForLOBAttribute(databaseMapping.getAttributeName(), clazz, mappingAccessor.getJavaClass());
        }
    }
}

