/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.tables;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.tables.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.tables.UniqueConstraintMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableMetadata
extends ORMetadata {
    private DatabaseTable m_databaseTable = new DatabaseTable();
    private List<UniqueConstraintMetadata> m_uniqueConstraints = new ArrayList<UniqueConstraintMetadata>();
    private String m_name;
    private String m_schema;
    private String m_catalog;

    public TableMetadata() {
        super("<table>");
    }

    protected TableMetadata(String string) {
        super(string);
    }

    public TableMetadata(Annotation annotation, MetadataAccessibleObject metadataAccessibleObject) {
        super(annotation, metadataAccessibleObject);
        if (annotation != null) {
            this.m_name = (String)MetadataHelper.invokeMethod("name", annotation);
            this.m_schema = (String)MetadataHelper.invokeMethod("schema", annotation);
            this.m_catalog = (String)MetadataHelper.invokeMethod("catalog", annotation);
            for (Annotation annotation2 : (Annotation[])MetadataHelper.invokeMethod("uniqueConstraints", annotation)) {
                this.m_uniqueConstraints.add(new UniqueConstraintMetadata(annotation2, metadataAccessibleObject));
            }
        }
    }

    public boolean equals(Object object) {
        if (object instanceof TableMetadata) {
            TableMetadata tableMetadata = (TableMetadata)object;
            if (!this.valuesMatch(this.m_name, tableMetadata.getName())) {
                return false;
            }
            if (!this.valuesMatch(this.m_schema, tableMetadata.getSchema())) {
                return false;
            }
            if (!this.valuesMatch(this.m_catalog, tableMetadata.getCatalog())) {
                return false;
            }
            return this.valuesMatch(this.m_uniqueConstraints, tableMetadata.getUniqueConstraints());
        }
        return false;
    }

    public String getCatalog() {
        return this.m_catalog;
    }

    public String getCatalogContext() {
        return "metadata_default_table_catalog";
    }

    public DatabaseTable getDatabaseTable() {
        return this.m_databaseTable;
    }

    public String getName() {
        return this.m_name;
    }

    public String getNameContext() {
        return "metadata_default_table_name";
    }

    public String getSchema() {
        return this.m_schema;
    }

    public String getSchemaContext() {
        return "metadata_default_table_schema";
    }

    public List<UniqueConstraintMetadata> getUniqueConstraints() {
        return this.m_uniqueConstraints;
    }

    public void processUniqueConstraints() {
        if (this.m_uniqueConstraints != null) {
            for (UniqueConstraintMetadata uniqueConstraintMetadata : this.m_uniqueConstraints) {
                this.m_databaseTable.addUniqueConstraints(uniqueConstraintMetadata.getColumnNames());
            }
        }
    }

    public void setFullyQualifiedTableName(String string) {
        this.m_databaseTable.setPossiblyQualifiedName(string);
    }

    public void setCatalog(String string) {
        this.m_catalog = string;
    }

    public void setDatabaseTable(DatabaseTable databaseTable) {
        this.m_databaseTable = databaseTable;
    }

    public void setName(String string) {
        this.m_name = string;
    }

    public void setSchema(String string) {
        this.m_schema = string;
    }

    public void setUniqueConstraints(List<UniqueConstraintMetadata> list) {
        this.m_uniqueConstraints = list;
    }
}

