/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.queries;

import java.io.Serializable;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.expressions.FunctionExpression;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.ReportQuery;

public class ReportItem
implements Cloneable,
Serializable {
    protected Expression attributeExpression;
    protected String name;
    protected DatabaseMapping mapping;
    protected ClassDescriptor descriptor;
    protected Class resultType;
    protected JoinedAttributeManager joinedAttributeManager;
    protected int resultIndex;

    public ReportItem() {
    }

    public ReportItem(String string, Expression expression) {
        this();
        this.name = string;
        this.attributeExpression = expression;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public Expression getAttributeExpression() {
        return this.attributeExpression;
    }

    public ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    public JoinedAttributeManager getJoinedAttributeManager() {
        if (this.joinedAttributeManager == null) {
            this.joinedAttributeManager = new JoinedAttributeManager();
        }
        return this.joinedAttributeManager;
    }

    public JoinedAttributeManager getJoinedAttributeManagerInternal() {
        return this.joinedAttributeManager;
    }

    public boolean hasJoining() {
        return this.joinedAttributeManager != null;
    }

    public DatabaseMapping getMapping() {
        return this.mapping;
    }

    public String getName() {
        return this.name;
    }

    public int getResultIndex() {
        return this.resultIndex;
    }

    public Class getResultType() {
        return this.resultType;
    }

    public void initialize(ReportQuery reportQuery) throws QueryException {
        if (this.getMapping() == null) {
            DatabaseMapping databaseMapping = reportQuery.getLeafMappingFor(this.getAttributeExpression(), reportQuery.getDescriptor());
            if (databaseMapping == null) {
                if (this.getAttributeExpression() != null && this.getAttributeExpression().isExpressionBuilder()) {
                    Class clazz = ((ExpressionBuilder)this.getAttributeExpression()).getQueryClass();
                    if (clazz == null) {
                        clazz = reportQuery.getReferenceClass();
                    }
                    this.setDescriptor(reportQuery.getSession().getDescriptor(clazz));
                    if (this.getDescriptor().hasInheritance()) {
                        ((ExpressionBuilder)this.getAttributeExpression()).setShouldUseOuterJoinForMultitableInheritance(true);
                    }
                }
            } else if (databaseMapping.isForeignReferenceMapping()) {
                this.setDescriptor(databaseMapping.getReferenceDescriptor());
                if (this.getDescriptor().hasInheritance()) {
                    ((QueryKeyExpression)this.getAttributeExpression()).setShouldUseOuterJoinForMultitableInheritance(true);
                }
            } else if (databaseMapping.isAbstractDirectMapping()) {
                this.setMapping(databaseMapping);
            } else {
                throw QueryException.invalidExpressionForQueryItem(this.getAttributeExpression(), reportQuery);
            }
            if (this.hasJoining()) {
                this.joinedAttributeManager.setDescriptor(this.descriptor);
                this.joinedAttributeManager.setBaseQuery(reportQuery);
            }
            if (this.getAttributeExpression() != null) {
                if (this.getAttributeExpression().getBuilder().wasQueryClassSetInternally()) {
                    this.attributeExpression = this.getAttributeExpression().rebuildOn(reportQuery.getExpressionBuilder());
                }
                if (this.hasJoining()) {
                    this.joinedAttributeManager.setBaseExpressionBuilder(this.attributeExpression.getBuilder());
                }
            } else if (this.hasJoining()) {
                this.joinedAttributeManager.setBaseExpressionBuilder(reportQuery.getExpressionBuilder());
            }
            if (this.hasJoining()) {
                this.joinedAttributeManager.processJoinedMappings();
                this.joinedAttributeManager.prepareJoinExpressions(reportQuery.getSession());
                this.joinedAttributeManager.computeJoiningMappingQueries(reportQuery.getSession());
            }
        }
    }

    public boolean isConstructorItem() {
        return false;
    }

    public boolean isPlaceHolder() {
        return this.getAttributeExpression() == null;
    }

    public void setDescriptor(ClassDescriptor classDescriptor) {
        this.descriptor = classDescriptor;
    }

    public void setJoinedAttributeManager(JoinedAttributeManager joinedAttributeManager) {
        this.joinedAttributeManager = joinedAttributeManager;
    }

    public void setMapping(DatabaseMapping databaseMapping) {
        this.mapping = databaseMapping;
    }

    public void setResultIndex(int n) {
        this.resultIndex = n;
        if (this.hasJoining()) {
            this.getJoinedAttributeManager().setParentResultIndex(n);
        }
    }

    public void setResultType(Class clazz) {
        this.resultType = clazz;
        if (this.getAttributeExpression() != null && this.getAttributeExpression().isFunctionExpression()) {
            ((FunctionExpression)this.getAttributeExpression()).setResultType(clazz);
        }
    }

    public String toString() {
        return "ReportQueryItem(" + this.getName() + " -> " + this.getAttributeExpression() + ")";
    }
}

