/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.IntegrityException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.internal.helper.DBPlatformHelper;
import org.eclipse.persistence.internal.sequencing.Sequencing;
import org.eclipse.persistence.internal.sequencing.SequencingFactory;
import org.eclipse.persistence.internal.sequencing.SequencingHome;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.platform.database.OraclePlatform;
import org.eclipse.persistence.platform.server.NoServerPlatform;
import org.eclipse.persistence.platform.server.ServerPlatform;
import org.eclipse.persistence.platform.server.ServerPlatformBase;
import org.eclipse.persistence.sequencing.SequencingControl;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.DatasourceLogin;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.Project;

public class DatabaseSessionImpl
extends AbstractSession
implements DatabaseSession {
    private SequencingHome sequencingHome;
    private ServerPlatform serverPlatform;
    private long connectedTime;
    protected volatile boolean isLoggedIn;

    protected void setSequencingHome(SequencingHome sequencingHome) {
        this.sequencingHome = sequencingHome;
    }

    protected SequencingHome getSequencingHome() {
        if (this.sequencingHome == null) {
            this.setSequencingHome(SequencingFactory.createSequencingHome(this));
        }
        return this.sequencingHome;
    }

    public boolean isLoggedIn() {
        return this.isLoggedIn;
    }

    public SequencingControl getSequencingControl() {
        return this.getSequencingHome().getSequencingControl();
    }

    public Sequencing getSequencing() {
        return this.getSequencingHome().getSequencing();
    }

    public boolean isSequencingCallbackRequired() {
        return this.getSequencingHome().isSequencingCallbackRequired();
    }

    public void initializeSequencing() {
        this.getSequencingHome().onDisconnect();
        this.getSequencingHome().onConnect();
    }

    public void releaseJTSConnection() {
        this.getAccessor().closeJTSConnection();
    }

    public DatabaseSessionImpl() {
        this.setServerPlatform(new NoServerPlatform(this));
    }

    public DatabaseSessionImpl(Login login) {
        this(new Project(login));
    }

    public DatabaseSessionImpl(Project project) {
        super(project);
        this.setServerPlatform(new NoServerPlatform(this));
    }

    public void addDescriptor(ClassDescriptor classDescriptor) {
        this.lastDescriptorAccessed = null;
        this.getProject().addDescriptor(classDescriptor, this);
    }

    public void addDescriptors(Collection collection) {
        this.lastDescriptorAccessed = null;
        this.getProject().addDescriptors(collection, this);
    }

    public void addDescriptors(Project project) {
        this.lastDescriptorAccessed = null;
        this.getProject().addDescriptors(project, this);
    }

    public void connect() throws DatabaseException {
        this.getAccessor().connect(this.getDatasourceLogin(), this);
    }

    public void disconnect() throws DatabaseException {
        this.getSequencingHome().onDisconnect();
        this.getAccessor().disconnect(this);
    }

    public ServerPlatform getServerPlatform() {
        return this.serverPlatform;
    }

    public void setServerPlatform(ServerPlatform serverPlatform) {
        if (this.isLoggedIn) {
            throw ValidationException.serverPlatformIsReadOnlyAfterLogin(serverPlatform.getClass().getName());
        }
        this.serverPlatform = serverPlatform;
    }

    protected void finalize() throws DatabaseException {
        if (this.isConnected()) {
            this.logout();
        }
    }

    public DatabasePlatform getPlatform() {
        if (this.platform == null) {
            if (this.isLoggedIn) {
                this.platform = this.getDatasourceLogin().getPlatform();
            } else {
                return this.getDatasourceLogin().getPlatform();
            }
        }
        return (DatabasePlatform)this.platform;
    }

    public Platform getDatasourcePlatform() {
        if (this.platform == null) {
            if (this.isLoggedIn) {
                this.platform = this.getDatasourceLogin().getDatasourcePlatform();
            } else {
                return this.getDatasourceLogin().getDatasourcePlatform();
            }
        }
        return this.platform;
    }

    public Platform getPlatform(Class clazz) {
        if (this.platform == null) {
            if (this.isLoggedIn) {
                this.platform = this.getDatasourceLogin().getDatasourcePlatform();
            } else {
                return this.getDatasourceLogin().getDatasourcePlatform();
            }
        }
        return this.platform;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeDescriptorIfSessionAlive(ClassDescriptor classDescriptor) {
        if (this.isConnected() && classDescriptor.requiresInitialization()) {
            try {
                try {
                    this.initializeSequencing();
                    classDescriptor.preInitialize(this);
                    classDescriptor.initialize(this);
                    classDescriptor.postInitialize(this);
                    this.getCommitManager().initializeCommitOrder();
                }
                catch (RuntimeException runtimeException) {
                    this.getIntegrityChecker().handleError(runtimeException);
                }
                if (this.getIntegrityChecker().hasErrors()) {
                    this.handleException(new IntegrityException(this.getIntegrityChecker()));
                }
            }
            finally {
                this.clearIntegrityChecker();
            }
        }
    }

    public void initializeDescriptors() {
        this.initializeDescriptors((Map)((HashMap)this.getDescriptors()).clone());
        this.processJPAQueries();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeDescriptors(Map map) {
        this.initializeSequencing();
        try {
            AbstractSession abstractSession;
            for (ClassDescriptor classDescriptor : map.values()) {
                try {
                    abstractSession = this.getSessionForClass(classDescriptor.getJavaClass());
                    if (classDescriptor.requiresInitialization()) {
                        classDescriptor.preInitialize(abstractSession);
                    }
                    if (!classDescriptor.isAggregateDescriptor() && !classDescriptor.isAggregateCollectionDescriptor() || !classDescriptor.isChildDescriptor()) continue;
                    classDescriptor.initializeAggregateInheritancePolicy(abstractSession);
                }
                catch (RuntimeException runtimeException) {
                    this.getIntegrityChecker().handleError(runtimeException);
                }
            }
            for (ClassDescriptor classDescriptor : map.values()) {
                try {
                    abstractSession = this.getSessionForClass(classDescriptor.getJavaClass());
                    if (!classDescriptor.requiresInitialization()) continue;
                    classDescriptor.initialize(abstractSession);
                }
                catch (RuntimeException runtimeException) {
                    this.getIntegrityChecker().handleError(runtimeException);
                }
            }
            for (ClassDescriptor classDescriptor : map.values()) {
                try {
                    abstractSession = this.getSessionForClass(classDescriptor.getJavaClass());
                    if (!classDescriptor.requiresInitialization()) continue;
                    classDescriptor.postInitialize(abstractSession);
                }
                catch (RuntimeException runtimeException) {
                    this.getIntegrityChecker().handleError(runtimeException);
                }
            }
            try {
                this.getCommitManager().initializeCommitOrder();
            }
            catch (RuntimeException runtimeException) {
                this.getIntegrityChecker().handleError(runtimeException);
            }
            if (this.getIntegrityChecker().hasErrors()) {
                this.handleSevere(new IntegrityException(this.getIntegrityChecker()));
            }
        }
        finally {
            this.clearIntegrityChecker();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeDescriptors(Collection collection) {
        this.initializeSequencing();
        try {
            AbstractSession abstractSession;
            ClassDescriptor classDescriptor;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                try {
                    classDescriptor = (ClassDescriptor)iterator.next();
                    abstractSession = this.getSessionForClass(classDescriptor.getJavaClass());
                    if (classDescriptor.requiresInitialization()) {
                        classDescriptor.preInitialize(abstractSession);
                    }
                    if (!classDescriptor.isAggregateDescriptor() || !classDescriptor.isChildDescriptor()) continue;
                    classDescriptor.initializeAggregateInheritancePolicy(abstractSession);
                }
                catch (RuntimeException runtimeException) {
                    this.getIntegrityChecker().handleError(runtimeException);
                }
            }
            iterator = collection.iterator();
            while (iterator.hasNext()) {
                try {
                    classDescriptor = (ClassDescriptor)iterator.next();
                    abstractSession = this.getSessionForClass(classDescriptor.getJavaClass());
                    if (!classDescriptor.requiresInitialization()) continue;
                    classDescriptor.initialize(abstractSession);
                }
                catch (RuntimeException runtimeException) {
                    this.getIntegrityChecker().handleError(runtimeException);
                }
            }
            iterator = collection.iterator();
            while (iterator.hasNext()) {
                try {
                    classDescriptor = (ClassDescriptor)iterator.next();
                    abstractSession = this.getSessionForClass(classDescriptor.getJavaClass());
                    if (!classDescriptor.requiresInitialization()) continue;
                    classDescriptor.postInitialize(abstractSession);
                }
                catch (RuntimeException runtimeException) {
                    this.getIntegrityChecker().handleError(runtimeException);
                }
            }
            try {
                this.getCommitManager().initializeCommitOrder();
            }
            catch (RuntimeException runtimeException) {
                this.getIntegrityChecker().handleError(runtimeException);
            }
            if (this.getIntegrityChecker().hasErrors()) {
                this.handleException(new IntegrityException(this.getIntegrityChecker()));
            }
        }
        finally {
            this.clearIntegrityChecker();
        }
    }

    public boolean isDatabaseSession() {
        return true;
    }

    protected Login getReadLogin() {
        return this.getDatasourceLogin();
    }

    public void loginAndDetectDatasource() throws DatabaseException {
        block13: {
            this.preConnectDatasource();
            Connection connection = null;
            try {
                connection = (Connection)this.getReadLogin().connectToDatasource(null, this);
                this.platform = null;
                String string = null;
                try {
                    string = DBPlatformHelper.getDBPlatform(connection.getMetaData().getDatabaseProductName(), this.getSessionLog());
                    this.getLogin().setPlatformClassName(string);
                }
                catch (EclipseLinkException eclipseLinkException) {
                    if (string.indexOf("Oracle") != -1) {
                        this.getLogin().setPlatform(new OraclePlatform());
                        break block13;
                    }
                    throw eclipseLinkException;
                }
            }
            catch (SQLException sQLException) {
                DatabaseException databaseException = DatabaseException.errorRetrieveDbMetadataThroughJDBCConnection();
                databaseException.initCause(sQLException);
                throw databaseException;
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException sQLException) {
                        DatabaseException databaseException = DatabaseException.errorRetrieveDbMetadataThroughJDBCConnection();
                        databaseException.initCause(sQLException);
                        throw databaseException;
                    }
                }
            }
        }
        this.connect();
        this.postConnectDatasource();
    }

    public void login() throws DatabaseException {
        this.preConnectDatasource();
        this.connect();
        this.postConnectDatasource();
    }

    protected void preConnectDatasource() {
        if (this.isLoggedIn) {
            throw ValidationException.alreadyLoggedIn(this.getName());
        }
        this.platform = null;
        if (this.isInProfile()) {
            this.getProfiler().initialize();
        }
        this.updateProfile("loginTime", new Date(System.currentTimeMillis()));
        this.getEventManager().preLogin(this);
        this.getServerPlatform().initializeExternalTransactionController();
        this.log(5, null, "topLink_version", DatasourceLogin.getVersion());
        if (this.getServerPlatform().getServerNameAndVersion() != null && !this.getServerPlatform().getServerNameAndVersion().equals(ServerPlatformBase.DEFAULT_SERVER_NAME_AND_VERSION)) {
            this.log(5, null, "application_server_name_and_version", this.getServerPlatform().getServerNameAndVersion());
        }
        this.isLoggingOff = this.getLogLevel() == 8;
    }

    protected void postConnectDatasource() {
        this.initializeDescriptors();
        if (this.getCommandManager() != null) {
            this.getCommandManager().initialize();
        }
        this.log(5, null, "login_successful", this.getName());
        this.getEventManager().postLogin(this);
        this.initializeConnectedTime();
        this.isLoggedIn = true;
        this.platform = null;
        this.getServerPlatform().registerMBean();
    }

    public void login(String string, String string2) throws DatabaseException {
        this.getDatasourceLogin().setUserName(string);
        this.getDatasourceLogin().setPassword(string2);
        this.login();
    }

    public void login(Login login) throws DatabaseException {
        this.setLogin(login);
        this.login();
    }

    public void logout() throws DatabaseException {
        this.lastDescriptorAccessed = null;
        if (this.isInTransaction()) {
            throw DatabaseException.logoutWhileTransactionInProgress();
        }
        if (this.getAccessor() == null) {
            return;
        }
        this.setShouldPropagateChanges(false);
        if (this.getCommandManager() != null) {
            this.getCommandManager().shutdown();
        }
        this.getServerPlatform().unregisterMBean();
        this.disconnect();
        this.getIdentityMapAccessor().initializeIdentityMaps();
        this.isLoggedIn = false;
        this.log(5, null, "logout_successful", this.getName());
    }

    public void initializeConnectedTime() {
        this.connectedTime = System.currentTimeMillis();
    }

    public long getConnectedTime() {
        return this.connectedTime;
    }

    public void writeAllObjects(Collection collection) throws DatabaseException, OptimisticLockException {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.writeObject(iterator.next());
        }
    }

    public void writeAllObjects(Vector vector) throws DatabaseException, OptimisticLockException {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.writeObject(enumeration.nextElement());
        }
    }
}

