/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.compiler;

import java.awt.Image;
import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorOrder;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyAttribute;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttachmentRef;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementDecl;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementRefs;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlIDREF;
import javax.xml.bind.annotation.XmlMimeType;
import javax.xml.bind.annotation.XmlMixed;
import javax.xml.bind.annotation.XmlNs;
import javax.xml.bind.annotation.XmlNsForm;
import javax.xml.bind.annotation.XmlRegistry;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchema;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlSchemaTypes;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapters;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.eclipse.persistence.exceptions.JAXBException;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.jaxb.compiler.AnyProperty;
import org.eclipse.persistence.jaxb.compiler.ChoiceProperty;
import org.eclipse.persistence.jaxb.compiler.ElementDeclaration;
import org.eclipse.persistence.jaxb.compiler.EnumTypeInfo;
import org.eclipse.persistence.jaxb.compiler.MarshalCallback;
import org.eclipse.persistence.jaxb.compiler.NamespaceInfo;
import org.eclipse.persistence.jaxb.compiler.Property;
import org.eclipse.persistence.jaxb.compiler.ReferenceProperty;
import org.eclipse.persistence.jaxb.compiler.SchemaTypeInfo;
import org.eclipse.persistence.jaxb.compiler.TypeInfo;
import org.eclipse.persistence.jaxb.compiler.UnmarshalCallback;
import org.eclipse.persistence.jaxb.javamodel.Helper;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.jaxb.javamodel.JavaField;
import org.eclipse.persistence.jaxb.javamodel.JavaHasAnnotations;
import org.eclipse.persistence.jaxb.javamodel.JavaMethod;
import org.eclipse.persistence.jaxb.javamodel.JavaPackage;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationsProcessor {
    private static final String JAVAX_ACTIVATION_DATAHANDLER = "javax.activation.DataHandler";
    private static final String JAVAX_MAIL_INTERNET_MIMEMULTIPART = "javax.mail.internet.MimeMultipart";
    private ArrayList<JavaClass> typeInfoClasses;
    private HashMap<String, NamespaceInfo> packageToNamespaceMappings;
    private HashMap<String, MarshalCallback> marshalCallbacks;
    private HashMap<String, QName> userDefinedSchemaTypes;
    private HashMap<String, TypeInfo> typeInfo;
    private ArrayList<QName> typeQNames;
    private HashMap<String, UnmarshalCallback> unmarshalCallbacks;
    private HashMap<QName, ElementDeclaration> globalElements;
    private HashMap<String, ElementDeclaration> xmlRootElements;
    private HashMap<String, JavaMethod> factoryMethods;
    private NamespaceResolver namespaceResolver;
    private Helper helper;

    public AnnotationsProcessor(Helper helper) {
        this.helper = helper;
    }

    public void processClassesAndProperties(JavaClass[] javaClassArray) {
        this.typeInfoClasses = new ArrayList();
        this.typeInfo = new HashMap();
        this.typeQNames = new ArrayList();
        this.userDefinedSchemaTypes = new HashMap();
        this.packageToNamespaceMappings = new HashMap();
        this.factoryMethods = new HashMap();
        this.namespaceResolver = new NamespaceResolver();
        this.xmlRootElements = new HashMap();
        ArrayList<JavaClass> arrayList = new ArrayList<JavaClass>();
        for (JavaClass javaClass : javaClassArray) {
            if (this.helper.isAnnotationPresent(javaClass, XmlRegistry.class)) {
                this.processObjectFactory(javaClass, arrayList);
                continue;
            }
            arrayList.add(javaClass);
            Class clazz = null;
            Method method = null;
            try {
                clazz = PrivilegedAccessHelper.getClassForName("javax.xml.bind.annotation.XmlSeeAlso");
                method = PrivilegedAccessHelper.getDeclaredMethod(clazz, "value", new Class[0]);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (clazz != null && this.helper.isAnnotationPresent(javaClass, clazz)) {
                Annotation annotation = this.helper.getAnnotation(javaClass, clazz);
                Class[] classArray = null;
                try {
                    classArray = (Class[])PrivilegedAccessHelper.invokeMethod(method, annotation, new Object[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                for (Class clazz2 : classArray) {
                    arrayList.add(this.helper.getJavaClass(clazz2));
                }
            }
            for (Class[] classArray : javaClass.getDeclaredClasses()) {
                if (!this.shouldGenerateTypeInfo((JavaClass)classArray) || this.helper.isAnnotationPresent((JavaHasAnnotations)classArray, XmlTransient.class)) continue;
                arrayList.add((JavaClass)classArray);
            }
        }
        this.updateGlobalElements(arrayList);
        for (JavaClass javaClass : arrayList) {
            if (javaClass == null) continue;
            this.createTypeInfoFor(javaClass);
            JavaClass javaClass2 = javaClass.getSuperclass();
            if (!this.shouldGenerateTypeInfo(javaClass2)) continue;
            this.createTypeInfoFor(javaClass2);
        }
        this.checkForCallbackMethods();
    }

    public SchemaTypeInfo addClass(JavaClass javaClass) {
        if (javaClass == null) {
            return null;
        }
        if (this.helper.isAnnotationPresent(javaClass, XmlTransient.class)) {
            return null;
        }
        if (this.typeInfo == null) {
            this.typeInfoClasses = new ArrayList();
            this.typeInfo = new HashMap();
            this.typeQNames = new ArrayList();
            this.userDefinedSchemaTypes = new HashMap();
            this.packageToNamespaceMappings = new HashMap();
            this.namespaceResolver = new NamespaceResolver();
        }
        TypeInfo typeInfo = this.createTypeInfoFor(javaClass);
        JavaPackage javaPackage = javaClass.getPackage();
        NamespaceInfo namespaceInfo = this.packageToNamespaceMappings.get(javaPackage.getQualifiedName());
        SchemaTypeInfo schemaTypeInfo = new SchemaTypeInfo();
        schemaTypeInfo.setSchemaTypeName(new QName(typeInfo.getClassNamespace(), typeInfo.getSchemaTypeName()));
        if (this.helper.isAnnotationPresent(javaClass, XmlRootElement.class)) {
            int n;
            char c;
            XmlRootElement xmlRootElement = (XmlRootElement)this.helper.getAnnotation(javaClass, XmlRootElement.class);
            String string = xmlRootElement.name();
            if ((string.equals("##default") || string.equals("")) && (string = javaClass.getName().indexOf("$") != -1 ? Introspector.decapitalize(javaClass.getName().substring(javaClass.getName().lastIndexOf(36) + 1)) : Introspector.decapitalize(javaClass.getName().substring(javaClass.getName().lastIndexOf(46) + 1))).length() >= 3 && Character.isDigit(c = string.charAt((n = string.length() - 1) - 1))) {
                char c2 = Character.toUpperCase(string.charAt(n));
                string = string.substring(0, n) + c2;
            }
            String string2 = xmlRootElement.namespace();
            QName qName = null;
            qName = string2.equals("##default") ? new QName(namespaceInfo.getNamespace(), string) : new QName(string2, string);
            schemaTypeInfo.getGlobalElementDeclarations().add(qName);
            ElementDeclaration elementDeclaration = new ElementDeclaration(qName, javaClass, javaClass.getRawName(), false);
            this.globalElements.put(qName, elementDeclaration);
        }
        return schemaTypeInfo;
    }

    public TypeInfo createTypeInfoFor(JavaClass javaClass) {
        JavaClass javaClass2;
        Object object;
        Object object2;
        Object object32;
        XmlJavaTypeAdapters xmlJavaTypeAdapters;
        JavaClass[] javaClassArray;
        JavaMethod javaMethod;
        if (javaClass == null) {
            return null;
        }
        if (this.typeInfo.containsKey(javaClass.getQualifiedName())) {
            return this.typeInfo.get(javaClass.getQualifiedName());
        }
        TypeInfo typeInfo = null;
        typeInfo = javaClass.isEnum() ? new EnumTypeInfo(this.helper) : new TypeInfo(this.helper);
        if (this.helper.isAnnotationPresent(javaClass, XmlTransient.class)) {
            typeInfo.setTransient(true);
        }
        if ((javaMethod = this.factoryMethods.get(javaClass.getRawName())) != null) {
            typeInfo.setFactoryMethodName(javaMethod.getName());
            typeInfo.setObjectFactoryClassName(javaMethod.getOwningClass().getRawName());
            javaClassArray = javaMethod.getParameterTypes();
            if (javaClassArray != null && javaClassArray.length > 0) {
                xmlJavaTypeAdapters = new String[javaClassArray.length];
                for (int i = 0; i < javaClassArray.length; ++i) {
                    xmlJavaTypeAdapters[i] = javaClassArray[i].getRawName();
                }
                typeInfo.setFactoryMethodParamTypes((String[])xmlJavaTypeAdapters);
            }
        }
        if (this.helper.isAnnotationPresent((JavaHasAnnotations)(javaClassArray = javaClass.getPackage()), XmlJavaTypeAdapters.class)) {
            xmlJavaTypeAdapters = (XmlJavaTypeAdapters)this.helper.getAnnotation((JavaHasAnnotations)javaClassArray, XmlJavaTypeAdapters.class);
            XmlJavaTypeAdapter[] xmlJavaTypeAdapterArray = xmlJavaTypeAdapters.value();
            for (XmlJavaTypeAdapter xmlJavaTypeAdapter : xmlJavaTypeAdapterArray) {
                object32 = this.helper.getJavaClass(xmlJavaTypeAdapter.value());
                object2 = this.helper.getJavaClass(xmlJavaTypeAdapter.type());
                if (object2 == null) continue;
                typeInfo.addAdapterClass((JavaClass)object32, (JavaClass)object2);
            }
        }
        if (this.helper.isAnnotationPresent(javaClass, XmlJavaTypeAdapters.class)) {
            xmlJavaTypeAdapters = (XmlJavaTypeAdapters)this.helper.getAnnotation(javaClass, XmlJavaTypeAdapters.class);
            XmlJavaTypeAdapter[] xmlJavaTypeAdapterArray = xmlJavaTypeAdapters.value();
            for (XmlJavaTypeAdapter xmlJavaTypeAdapter : xmlJavaTypeAdapterArray) {
                object32 = this.helper.getJavaClass(xmlJavaTypeAdapter.value());
                object2 = this.helper.getJavaClass(xmlJavaTypeAdapter.type());
                if (object2 == null) continue;
                typeInfo.addAdapterClass((JavaClass)object32, (JavaClass)object2);
            }
        }
        xmlJavaTypeAdapters = this.getNamespaceInfoForPackage((JavaPackage)javaClassArray);
        if (this.helper.isAnnotationPresent((JavaHasAnnotations)javaClassArray, XmlSchemaTypes.class)) {
            XmlSchemaTypes xmlSchemaTypes = (XmlSchemaTypes)this.helper.getAnnotation((JavaHasAnnotations)javaClassArray, XmlSchemaTypes.class);
            object = xmlSchemaTypes.value();
            for (Object object32 : object) {
                this.processSchemaType((XmlSchemaType)object32);
            }
        } else if (this.helper.isAnnotationPresent((JavaHasAnnotations)javaClassArray, XmlSchemaType.class)) {
            this.processSchemaType((XmlSchemaType)this.helper.getAnnotation((JavaHasAnnotations)javaClassArray, XmlSchemaType.class));
        }
        String[] stringArray = new String[]{""};
        object = "";
        if (this.helper.isAnnotationPresent(javaClass, XmlType.class)) {
            String string;
            XmlType xmlType = (XmlType)this.helper.getAnnotation(javaClass, XmlType.class);
            object = xmlType.name();
            if (((String)object).equals("##default")) {
                object = this.getSchemaTypeNameForClassName(javaClass.getName());
            }
            stringArray = xmlType.propOrder();
            if (!xmlType.namespace().equals("##default")) {
                typeInfo.setClassNamespace(xmlType.namespace());
            } else {
                typeInfo.setClassNamespace(xmlJavaTypeAdapters.getNamespace());
            }
            Class clazz = xmlType.factoryClass();
            if (clazz != XmlType.DEFAULT.class) {
                string = xmlType.factoryMethod();
                if (string == null || string.equals("")) {
                    throw JAXBException.factoryClassWithoutFactoryMethod(javaClass.getName());
                }
                typeInfo.setFactoryMethodName(string);
                typeInfo.setObjectFactoryClassName(clazz.getCanonicalName());
            } else {
                string = xmlType.factoryMethod();
                if (string != null && !string.equals("")) {
                    object32 = javaClass.getDeclaredMethod(string, new JavaClass[0]);
                    if (object32 == null) {
                        throw JAXBException.factoryMethodNotDeclared(string, javaClass.getName());
                    }
                    typeInfo.setFactoryMethodName(string);
                    typeInfo.setObjectFactoryClassName(javaClass.getRawName());
                }
            }
        } else {
            object = this.getSchemaTypeNameForClassName(javaClass.getName());
            typeInfo.setClassNamespace(xmlJavaTypeAdapters.getNamespace());
        }
        typeInfo.setPropOrder(stringArray);
        typeInfo.setSchemaTypeName((String)object);
        if (typeInfo.isEnumerationType()) {
            this.addEnumTypeInfo(javaClass, (EnumTypeInfo)typeInfo);
            return typeInfo;
        }
        this.typeInfoClasses.add(javaClass);
        this.typeInfo.put(javaClass.getQualifiedName(), typeInfo);
        if (object != null && !"".equals(object)) {
            QName qName = new QName(xmlJavaTypeAdapters.getNamespace(), (String)object);
            boolean bl = this.typeQNames.contains(qName);
            if (bl) {
                throw JAXBException.nameCollision(qName.getNamespaceURI(), qName.getLocalPart());
            }
            this.typeQNames.add(qName);
        }
        if (this.helper.isAnnotationPresent(javaClass, XmlAccessorType.class)) {
            XmlAccessorType xmlAccessorType = (XmlAccessorType)this.helper.getAnnotation(javaClass, XmlAccessorType.class);
            typeInfo.setAccessType(xmlAccessorType.value());
        } else {
            typeInfo.setAccessType(xmlJavaTypeAdapters.getAccessType());
        }
        typeInfo.setProperties(this.getPropertiesForClass(javaClass, typeInfo));
        XmlAccessorOrder xmlAccessorOrder = null;
        if (this.helper.isAnnotationPresent((JavaHasAnnotations)javaClassArray, XmlAccessorOrder.class)) {
            xmlAccessorOrder = (XmlAccessorOrder)this.helper.getAnnotation((JavaHasAnnotations)javaClassArray, XmlAccessorOrder.class);
        }
        if (this.helper.isAnnotationPresent(javaClass, XmlAccessorOrder.class)) {
            xmlAccessorOrder = (XmlAccessorOrder)this.helper.getAnnotation(javaClass, XmlAccessorOrder.class);
        }
        if (xmlAccessorOrder != null) {
            typeInfo.orderProperties(xmlAccessorOrder.value());
        }
        if (this.shouldGenerateTypeInfo(javaClass2 = javaClass.getSuperclass())) {
            this.createTypeInfoFor(javaClass2);
        }
        ArrayList<Property> arrayList = typeInfo.getPropertyList();
        object32 = arrayList.iterator();
        while (object32.hasNext()) {
            JavaClass javaClass3;
            object2 = (Property)object32.next();
            JavaClass javaClass4 = ((Property)object2).getType();
            if (this.isCollectionType((Property)object2)) {
                javaClass3 = ((Property)object2).getGenericType();
                if (javaClass3 != null) {
                    if (javaClass3.hasActualTypeArguments()) {
                        javaClass4 = this.helper.getJavaClass(javaClass3.getRawName());
                    } else if (javaClass3 instanceof JavaClass) {
                        javaClass4 = javaClass3;
                    }
                }
            } else if (javaClass4.isArray()) {
                javaClass4 = javaClass4.getComponentType();
            }
            if (this.helper.isAnnotationPresent(((Property)object2).getElement(), XmlElement.class) && (javaClass3 = (XmlElement)this.helper.getAnnotation(((Property)object2).getElement(), XmlElement.class)).type() != XmlElement.DEFAULT.class) {
                javaClass4 = this.helper.getJavaClass(javaClass3.type());
            }
            if (this.helper.isAnnotationPresent(((Property)object2).getElement(), XmlID.class)) {
                if (!this.areEquals(((Property)object2).getType(), String.class)) {
                    // empty if block
                }
                if (typeInfo.isIDSet()) {
                    // empty if block
                }
                typeInfo.setIDProperty((Property)object2);
            }
            if (this.helper.isAnnotationPresent(((Property)object2).getElement(), XmlJavaTypeAdapter.class)) {
                ((Property)object2).setAdapterClass(((XmlJavaTypeAdapter)this.helper.getAnnotation(((Property)object2).getElement(), XmlJavaTypeAdapter.class)).value());
            }
            if (!this.shouldGenerateTypeInfo(javaClass4)) continue;
            this.createTypeInfoFor(javaClass4);
        }
        if (typeInfo.getFactoryMethodName() == null && typeInfo.getObjectFactoryClassName() == null && (object32 = javaClass.getDeclaredConstructor(new JavaClass[0])) == null) {
            throw JAXBException.factoryMethodOrConstructorRequired(javaClass.getName());
        }
        return typeInfo;
    }

    public boolean shouldGenerateTypeInfo(JavaClass javaClass) {
        if (javaClass == null || javaClass.isPrimitive() || javaClass.isAnnotation() || javaClass.isInterface() || javaClass.isArray()) {
            return false;
        }
        if (this.userDefinedSchemaTypes.get(javaClass.getQualifiedName()) != null) {
            return false;
        }
        return !this.helper.isBuiltInJavaType(javaClass);
    }

    public ArrayList<Property> getPropertiesForClass(JavaClass javaClass, TypeInfo typeInfo) {
        ArrayList<Property> arrayList = typeInfo.isTransient() ? this.getNoAccessTypePropertiesForClass(javaClass, typeInfo) : (typeInfo.getAccessType() == XmlAccessType.FIELD ? this.getFieldPropertiesForClass(javaClass, typeInfo, false) : (typeInfo.getAccessType() == XmlAccessType.PROPERTY ? this.getPropertyPropertiesForClass(javaClass, typeInfo, false) : (typeInfo.getAccessType() == XmlAccessType.PUBLIC_MEMBER ? this.getPublicMemberPropertiesForClass(javaClass, typeInfo) : this.getNoAccessTypePropertiesForClass(javaClass, typeInfo))));
        if (typeInfo.getXmlValueProperty() != null) {
            for (Property property : arrayList) {
                if (property.equals(typeInfo.getXmlValueProperty()) || property.isAttribute()) continue;
                throw JAXBException.propertyOrFieldShouldBeAnAttribute(property.getPropertyName());
            }
        }
        return arrayList;
    }

    public ArrayList<Property> getFieldPropertiesForClass(JavaClass javaClass, TypeInfo typeInfo, boolean bl) {
        ArrayList<Property> arrayList = new ArrayList<Property>();
        if (javaClass == null) {
            return arrayList;
        }
        boolean bl2 = false;
        for (JavaField javaField : javaClass.getDeclaredFields()) {
            if (!this.helper.isAnnotationPresent(javaField, XmlTransient.class)) {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                String string;
                Object object5;
                Property property;
                int n;
                Object object7;
                Object object8;
                int n2 = javaField.getModifiers();
                if (Modifier.isStatic(n2) || Modifier.isTransient(n2) || (!Modifier.isPublic(javaField.getModifiers()) || !bl) && bl) continue;
                Property property2 = null;
                if (this.helper.isAnnotationPresent(javaField, XmlElements.class)) {
                    property2 = new ChoiceProperty(this.helper);
                    property2.setElement(javaField);
                    object8 = (XmlElements)this.helper.getAnnotation(property2.getElement(), XmlElements.class);
                    object7 = object8.value();
                    ArrayList<Property> arrayList2 = new ArrayList<Property>(((XmlElement[])object7).length);
                    for (n = 0; n < ((XmlElementRef)object7).length; ++n) {
                        XmlElementRef xmlElementRef = object7[n];
                        property = new Property();
                        object5 = xmlElementRef.name();
                        string = xmlElementRef.namespace();
                        object4 = null;
                        if (((String)object5).equals("##default")) {
                            object5 = javaField.getName();
                        }
                        object4 = !string.equals("##default") ? new QName(string, (String)object5) : (((NamespaceInfo)(object3 = this.getNamespaceInfoForPackage(javaClass.getPackage()))).isElementFormQualified() ? new QName(((NamespaceInfo)object3).getNamespace(), (String)object5) : new QName((String)object5));
                        property.setPropertyName(property2.getPropertyName());
                        object3 = xmlElementRef.type();
                        if (object3.equals(XmlElement.DEFAULT.class)) {
                            object2 = javaField.getResolvedType();
                            if (this.isCollectionType((JavaClass)object2)) {
                                if (object2.hasActualTypeArguments()) {
                                    object = (JavaClass)object2.getActualTypeArguments().toArray()[0];
                                    property.setType((JavaClass)object);
                                } else {
                                    property.setType(this.helper.getJavaClass("java.lang.Object"));
                                }
                            } else {
                                property.setType((JavaClass)object2);
                            }
                        } else {
                            property.setType(this.helper.getJavaClass(xmlElementRef.type()));
                        }
                        property.setSchemaName((QName)object4);
                        property.setSchemaType(this.getSchemaTypeFor(this.helper.getJavaClass(xmlElementRef.type())));
                        property.setElement(property2.getElement());
                        arrayList2.add(property);
                    }
                    ((ChoiceProperty)property2).setChoiceProperties(arrayList2);
                } else if (this.helper.isAnnotationPresent(javaField, XmlAnyElement.class)) {
                    property2 = new AnyProperty(this.helper);
                    property2.setElement(javaField);
                    object8 = (XmlAnyElement)this.helper.getAnnotation(javaField, XmlAnyElement.class);
                    ((AnyProperty)property2).setLax(object8.lax());
                    ((AnyProperty)property2).setDomHandlerClass(object8.value());
                } else if (this.helper.isAnnotationPresent(javaField, XmlElementRef.class) || this.helper.isAnnotationPresent(javaField, XmlElementRefs.class)) {
                    property2 = new ReferenceProperty(this.helper);
                    property2.setElement(javaField);
                    object7 = (XmlElementRef)this.helper.getAnnotation(javaField, XmlElementRef.class);
                    if (object7 != null) {
                        object8 = new XmlElementRef[]{object7};
                    } else {
                        XmlElementRefs xmlElementRefs = (XmlElementRefs)this.helper.getAnnotation(javaField, XmlElementRefs.class);
                        object8 = xmlElementRefs.value();
                        typeInfo.setHasElementRefs(true);
                    }
                    XmlElementRef[] xmlElementRefArray = object8;
                    n = xmlElementRefArray.length;
                    for (int i = 0; i < n; ++i) {
                        property = xmlElementRefArray[i];
                        object5 = javaField.getResolvedType();
                        string = object5.getQualifiedName();
                        property2.setType((JavaClass)object5);
                        if (this.isCollectionType(property2) && object5.hasActualTypeArguments()) {
                            object5 = (JavaClass)object5.getActualTypeArguments().toArray()[0];
                            string = object5.getQualifiedName();
                        }
                        if (property.type() != XmlElementRef.DEFAULT.class) {
                            string = this.helper.getJavaClass(property.type()).getQualifiedName();
                        }
                        if ((object4 = this.xmlRootElements.get(string)) != null) {
                            this.addReferencedElement((ReferenceProperty)property2, (ElementDeclaration)object4);
                            continue;
                        }
                        object3 = property.name();
                        object2 = property.namespace();
                        if (((String)object2).equals("##default")) {
                            object2 = "";
                        }
                        if ((object4 = this.globalElements.get(object = new QName((String)object2, (String)object3))) != null) {
                            this.addReferencedElement((ReferenceProperty)property2, (ElementDeclaration)object4);
                            continue;
                        }
                        throw JAXBException.invalidElementRef(property2.getPropertyName(), javaClass.getName());
                    }
                } else {
                    property2 = new Property(this.helper);
                    property2.setElement(javaField);
                }
                if (this.helper.isAnnotationPresent(javaField, XmlMixed.class)) {
                    typeInfo.setMixed(true);
                }
                if (!this.helper.isAnnotationPresent((JavaHasAnnotations)(object8 = javaField.getResolvedType()), XmlTransient.class)) {
                    property2.setType((JavaClass)object8);
                } else {
                    for (object7 = object8.getSuperclass(); object7 != null; object7 = object7.getSuperclass()) {
                        if (object7.getName().equals("java.lang.Object")) {
                            property2.setType((JavaClass)object7);
                            break;
                        }
                        if (this.helper.isAnnotationPresent((JavaHasAnnotations)object7, XmlTransient.class)) continue;
                        property2.setType((JavaClass)object7);
                        break;
                    }
                }
                if (this.helper.isAnnotationPresent(property2.getElement(), XmlJavaTypeAdapter.class)) {
                    object7 = (XmlJavaTypeAdapter)this.helper.getAnnotation(property2.getElement(), XmlJavaTypeAdapter.class);
                    property2.setAdapterClass(object7.value());
                } else if (typeInfo.getAdaptersByClass().get(object8) != null) {
                    property2.setAdapterClass(typeInfo.getAdapterClass((JavaClass)object8));
                }
                if (property2.hasAdapterClass()) {
                    object8 = property2.getValueType();
                }
                property2.setGenericType(this.helper.getGenericType(javaField));
                property2.setPropertyName(javaField.getName());
                if (this.helper.isAnnotationPresent(property2.getElement(), XmlAttachmentRef.class) && this.areEquals((JavaClass)object8, JAVAX_ACTIVATION_DATAHANDLER)) {
                    property2.setIsSwaAttachmentRef(true);
                    property2.setSchemaType(XMLConstants.SWA_REF_QNAME);
                } else if (this.areEquals((JavaClass)object8, JAVAX_ACTIVATION_DATAHANDLER) || this.areEquals((JavaClass)object8, byte[].class) || this.areEquals((JavaClass)object8, Byte[].class) || this.areEquals((JavaClass)object8, Image.class) || this.areEquals((JavaClass)object8, Source.class) || this.areEquals((JavaClass)object8, JAVAX_MAIL_INTERNET_MIMEMULTIPART)) {
                    property2.setIsMtomAttachment(true);
                    property2.setSchemaType(XMLConstants.BASE_64_BINARY_QNAME);
                }
                if (this.helper.isAnnotationPresent(property2.getElement(), XmlMimeType.class)) {
                    property2.setMimeType(((XmlMimeType)this.helper.getAnnotation(property2.getElement(), XmlMimeType.class)).value());
                }
                if (this.helper.isAnnotationPresent(property2.getElement(), XmlSchemaType.class)) {
                    object7 = (XmlSchemaType)this.helper.getAnnotation(property2.getElement(), XmlSchemaType.class);
                    QName qName = new QName(object7.namespace(), object7.name());
                    property2.setSchemaType(qName);
                }
                if (this.helper.isAnnotationPresent(property2.getElement(), XmlAttribute.class)) {
                    property2.setIsAttribute(true);
                    property2.setIsRequired(((XmlAttribute)this.helper.getAnnotation(property2.getElement(), XmlAttribute.class)).required());
                }
                if (this.helper.isAnnotationPresent(property2.getElement(), XmlAnyAttribute.class)) {
                    if (bl2) {
                        throw JAXBException.multipleAnyAttributeMapping(javaClass.getName());
                    }
                    if (!object8.getName().equals("java.util.Map")) {
                        throw JAXBException.anyAttributeOnNonMap(property2.getPropertyName());
                    }
                    property2.setIsAttribute(true);
                    bl2 = true;
                }
                if (object8.isPrimitive()) {
                    property2.setIsRequired(true);
                } else if (this.helper.isAnnotationPresent(property2.getElement(), XmlElement.class)) {
                    object7 = (XmlElement)this.helper.getAnnotation(property2.getElement(), XmlElement.class);
                    property2.setIsRequired(object7.required());
                    property2.setNillable(object7.nillable());
                }
                if (this.helper.isAnnotationPresent(property2.getElement(), XmlValue.class)) {
                    typeInfo.setXmlValueProperty(property2);
                    for (object7 = javaClass.getSuperclass(); object7 != null && !object7.getQualifiedName().equals("java.lang.Object"); object7 = object7.getSuperclass()) {
                        if (this.typeInfo.get(object7.getQualifiedName()) == null) continue;
                        throw JAXBException.propertyOrFieldCannotBeXmlValue(javaField.getName());
                    }
                }
                property2.setSchemaName(this.getQNameForProperty(Introspector.decapitalize(javaField.getName()), javaField, this.getNamespaceInfoForPackage(javaClass.getPackage())));
                arrayList.add(property2);
                continue;
            }
            List<String> list = Arrays.asList(typeInfo.getPropOrder());
            if (!list.contains(javaField.getName())) continue;
            throw JAXBException.transientInProporder(javaField.getName());
        }
        return arrayList;
    }

    protected boolean areEquals(JavaClass javaClass, Class clazz) {
        if (javaClass == null || clazz == null) {
            return false;
        }
        return javaClass.getRawName().equals(clazz.getCanonicalName());
    }

    protected boolean areEquals(JavaClass javaClass, String string) {
        if (javaClass == null || string == null) {
            return false;
        }
        return javaClass.getRawName().equals(string);
    }

    public ArrayList<Property> getPropertyPropertiesForClass(JavaClass javaClass, TypeInfo typeInfo, boolean bl) {
        ArrayList<Property> arrayList = new ArrayList<Property>();
        if (javaClass == null) {
            return arrayList;
        }
        ArrayList<JavaMethod> arrayList2 = new ArrayList<JavaMethod>();
        for (JavaMethod javaMethod : new ArrayList(javaClass.getDeclaredMethods())) {
            int n;
            if ((!javaMethod.getName().startsWith("get") || javaMethod.getName().length() <= 3) && (!javaMethod.getName().startsWith("is") || javaMethod.getName().length() <= 2) || Modifier.isStatic(n = javaMethod.getModifiers()) || Modifier.isTransient(n) || (!bl || !Modifier.isPublic(javaMethod.getModifiers())) && bl) continue;
            arrayList2.add(javaMethod);
        }
        boolean bl2 = false;
        for (int i = 0; i < arrayList2.size(); ++i) {
            Object object;
            String string;
            Object object2;
            XmlElementRef[] xmlElementRefArray;
            XmlElementRef xmlElementRef;
            Object object3;
            JavaClass javaClass2;
            JavaMethod javaMethod = (JavaMethod)arrayList2.get(i);
            String string2 = "";
            if (javaMethod.getName().startsWith("get")) {
                string2 = javaMethod.getName().substring(3);
            } else if (javaMethod.getName().startsWith("is")) {
                string2 = javaMethod.getName().substring(2);
            }
            String string3 = "set" + string2;
            string2 = Character.toLowerCase(string2.charAt(0)) + string2.substring(1);
            JavaClass[] javaClassArray = new JavaClass[]{javaMethod.getReturnType()};
            JavaMethod javaMethod2 = javaClass.getDeclaredMethod(string3, javaClassArray);
            JavaMethod javaMethod3 = null;
            if (javaMethod2 != null && !javaMethod2.getAnnotations().isEmpty()) {
                if (!this.helper.isAnnotationPresent(javaMethod2, XmlTransient.class)) {
                    javaMethod3 = javaMethod2;
                }
            } else if (!this.helper.isAnnotationPresent(javaMethod, XmlTransient.class)) {
                javaMethod3 = javaMethod;
            }
            Property property = null;
            property = this.helper.isAnnotationPresent(javaMethod3, XmlElements.class) ? new ChoiceProperty(this.helper) : (this.helper.isAnnotationPresent(javaMethod3, XmlAnyElement.class) ? new AnyProperty(this.helper) : (this.helper.isAnnotationPresent(javaMethod3, XmlElementRef.class) || this.helper.isAnnotationPresent(javaMethod3, XmlElementRefs.class) ? new ReferenceProperty(this.helper) : new Property(this.helper)));
            if (this.helper.isAnnotationPresent(javaMethod3, XmlMixed.class)) {
                typeInfo.setMixed(true);
            }
            property.setElement(javaMethod3);
            property.setSchemaName(this.getQNameForProperty(string2, javaMethod3, this.getNamespaceInfoForPackage(javaClass.getPackage())));
            property.setPropertyName(string2);
            JavaClass javaClass3 = javaMethod.getReturnType();
            if (!this.helper.isAnnotationPresent(javaClass3, XmlTransient.class)) {
                property.setType(javaClass3);
            } else {
                for (javaClass2 = javaClass3.getSuperclass(); javaClass2 != null; javaClass2 = javaClass2.getSuperclass()) {
                    if (javaClass2.getName().equals("java.lang.Object")) {
                        property.setType(javaClass2);
                        break;
                    }
                    if (this.helper.isAnnotationPresent(javaClass2, XmlTransient.class)) continue;
                    property.setType(javaClass2);
                    break;
                }
            }
            property.setGenericType(this.helper.getGenericReturnType(javaMethod));
            property.setGetMethodName(javaMethod.getName());
            if (javaMethod2 != null) {
                property.setSetMethodName(string3);
            }
            property.setMethodProperty(true);
            javaClass2 = property.getType();
            if (this.helper.isAnnotationPresent(property.getElement(), XmlJavaTypeAdapter.class)) {
                object3 = (XmlElementRef[])this.helper.getAnnotation(property.getElement(), XmlJavaTypeAdapter.class);
                property.setAdapterClass(object3.value());
            } else if (typeInfo.getAdaptersByClass().get(javaClass2) != null) {
                property.setAdapterClass(typeInfo.getAdaptersByClass().get(javaClass2));
            }
            if (property.hasAdapterClass()) {
                javaClass2 = property.getValueType();
            }
            if (this.helper.isAnnotationPresent(property.getElement(), XmlSchemaType.class)) {
                object3 = (XmlSchemaType)this.helper.getAnnotation(property.getElement(), XmlSchemaType.class);
                xmlElementRef = new QName(object3.namespace(), object3.name());
                property.setSchemaType((QName)xmlElementRef);
            }
            if (this.helper.isAnnotationPresent(property.getElement(), XmlAttachmentRef.class) && this.areEquals(javaClass2, JAVAX_ACTIVATION_DATAHANDLER)) {
                property.setIsSwaAttachmentRef(true);
                property.setSchemaType(XMLConstants.SWA_REF_QNAME);
            } else if (this.areEquals(javaClass2, JAVAX_ACTIVATION_DATAHANDLER) || this.areEquals(javaClass2, byte[].class) || this.areEquals(javaClass2, Byte[].class) || this.areEquals(javaClass2, Image.class) || this.areEquals(javaClass2, Source.class) || this.areEquals(javaClass2, JAVAX_MAIL_INTERNET_MIMEMULTIPART)) {
                property.setIsMtomAttachment(true);
                property.setSchemaType(XMLConstants.BASE_64_BINARY_QNAME);
            }
            if (this.helper.isAnnotationPresent(property.getElement(), XmlMimeType.class)) {
                property.setMimeType(((XmlMimeType)this.helper.getAnnotation(property.getElement(), XmlMimeType.class)).value());
            }
            if (this.helper.isAnnotationPresent(property.getElement(), XmlJavaTypeAdapter.class)) {
                object3 = (XmlJavaTypeAdapter)this.helper.getAnnotation(property.getElement(), XmlJavaTypeAdapter.class);
                property.setAdapterClass(object3.value());
            } else if (typeInfo.getAdaptersByClass().get(javaClass2) != null) {
                property.setAdapterClass(typeInfo.getAdaptersByClass().get(javaClass2));
            }
            if (this.helper.isAnnotationPresent(property.getElement(), XmlAttribute.class)) {
                property.setIsAttribute(true);
                property.setIsRequired(((XmlAttribute)this.helper.getAnnotation(property.getElement(), XmlAttribute.class)).required());
            }
            if (this.helper.isAnnotationPresent(property.getElement(), XmlAnyAttribute.class)) {
                if (bl2) {
                    throw JAXBException.multipleAnyAttributeMapping(javaClass.getName());
                }
                if (!javaClass2.getName().equals("java.util.Map")) {
                    throw JAXBException.anyAttributeOnNonMap(property.getPropertyName());
                }
                property.setIsAttribute(true);
                bl2 = true;
            }
            if (this.helper.isAnnotationPresent(property.getElement(), XmlElements.class)) {
                object3 = (XmlElements)this.helper.getAnnotation(property.getElement(), XmlElements.class);
                xmlElementRef = object3.value();
                xmlElementRefArray = new ArrayList(((XmlElement[])xmlElementRef).length);
                for (int j = 0; j < ((XmlElement[])xmlElementRef).length; ++j) {
                    XmlElementRef xmlElementRef2 = xmlElementRef[j];
                    Property property2 = new Property();
                    object2 = xmlElementRef2.name();
                    string = xmlElementRef2.namespace();
                    object = null;
                    if (((String)object2).equals("##defualt")) {
                        object2 = string2;
                    }
                    object = !string.equals("##default") ? new QName(string, (String)object2) : new QName((String)object2);
                    property2.setPropertyName(property.getPropertyName());
                    property2.setType(this.helper.getJavaClass(xmlElementRef2.type()));
                    property2.setSchemaName((QName)object);
                    property2.setSchemaType(this.getSchemaTypeFor(this.helper.getJavaClass(xmlElementRef2.type())));
                    property2.setElement(property.getElement());
                    xmlElementRefArray.add(property2);
                }
                ((ChoiceProperty)property).setChoiceProperties((Collection<Property>)xmlElementRefArray);
            }
            if (this.helper.isAnnotationPresent(property.getElement(), XmlAnyElement.class)) {
                object3 = (XmlAnyElement)this.helper.getAnnotation(property.getElement(), XmlAnyElement.class);
                ((AnyProperty)property).setDomHandlerClass(object3.value());
                ((AnyProperty)property).setLax(object3.lax());
            }
            if (this.helper.isAnnotationPresent(property.getElement(), XmlElementRef.class) || this.helper.isAnnotationPresent(property.getElement(), XmlElementRefs.class)) {
                xmlElementRef = (XmlElementRef)this.helper.getAnnotation(property.getElement(), XmlElementRef.class);
                if (xmlElementRef != null) {
                    object3 = new XmlElementRef[]{xmlElementRef};
                } else {
                    xmlElementRefArray = (XmlElementRef[])this.helper.getAnnotation(property.getElement(), XmlElementRefs.class);
                    object3 = xmlElementRefArray.value();
                    typeInfo.setHasElementRefs(true);
                }
                for (Property property2 : object3) {
                    QName qName;
                    object2 = javaClass2;
                    string = object2.getQualifiedName();
                    property.setType((JavaClass)object2);
                    if (this.isCollectionType(property) && object2.hasActualTypeArguments()) {
                        object2 = (JavaClass)object2.getActualTypeArguments().toArray()[0];
                        string = object2.getQualifiedName();
                    }
                    if (property2.type() != XmlElementRef.DEFAULT.class) {
                        string = this.helper.getJavaClass(property2.type()).getQualifiedName();
                    }
                    if ((object = this.xmlRootElements.get(string)) != null) {
                        this.addReferencedElement((ReferenceProperty)property, (ElementDeclaration)object);
                        continue;
                    }
                    String string4 = property2.name();
                    String string5 = property2.namespace();
                    if (string5.equals("##default")) {
                        string5 = "";
                    }
                    if ((object = this.globalElements.get(qName = new QName(string5, string4))) != null) {
                        this.addReferencedElement((ReferenceProperty)property, (ElementDeclaration)object);
                        continue;
                    }
                    throw JAXBException.invalidElementRef(property.getPropertyName(), javaClass.getName());
                }
            }
            if (this.helper.isAnnotationPresent(property.getElement(), XmlValue.class)) {
                typeInfo.setXmlValueProperty(property);
                for (object3 = javaClass.getSuperclass(); object3 != null && !object3.getQualifiedName().equals("java.lang.Object"); object3 = object3.getSuperclass()) {
                    if (this.typeInfo.get(object3.getQualifiedName()) == null) continue;
                    throw JAXBException.propertyOrFieldCannotBeXmlValue(string2);
                }
            }
            if (!this.helper.isAnnotationPresent(property.getElement(), XmlTransient.class)) {
                arrayList.add(property);
            } else {
                object3 = Arrays.asList(typeInfo.getPropOrder());
                if (object3.contains(string2)) {
                    throw JAXBException.transientInProporder(string2);
                }
            }
            if (javaClass2.isPrimitive()) {
                property.setIsRequired(true);
                continue;
            }
            if (!this.helper.isAnnotationPresent(property.getElement(), XmlElement.class)) continue;
            object3 = (XmlElement)this.helper.getAnnotation(property.getElement(), XmlElement.class);
            property.setIsRequired(object3.required());
            property.setNillable(object3.nillable());
        }
        return arrayList;
    }

    public ArrayList getPublicMemberPropertiesForClass(JavaClass javaClass, TypeInfo typeInfo) {
        ArrayList<Property> arrayList = this.getFieldPropertiesForClass(javaClass, typeInfo, false);
        ArrayList<Property> arrayList2 = this.getPropertyPropertiesForClass(javaClass, typeInfo, false);
        ArrayList<Property> arrayList3 = new ArrayList<Property>();
        ArrayList<Property> arrayList4 = new ArrayList<Property>();
        for (Property property : arrayList) {
            if (Modifier.isPublic(((JavaField)property.getElement()).getModifiers())) {
                arrayList3.add(property);
                continue;
            }
            if (!this.hasJAXBAnnotations(property.getElement())) continue;
            arrayList3.add(property);
        }
        for (Property property : arrayList2) {
            if (property.getElement() == null) continue;
            if (Modifier.isPublic(((JavaMethod)property.getElement()).getModifiers())) {
                arrayList4.add(property);
                continue;
            }
            if (!this.hasJAXBAnnotations(property.getElement())) continue;
            arrayList4.add(property);
        }
        if (arrayList3.size() >= 0 && arrayList4.size() == 0) {
            return arrayList3;
        }
        if (arrayList4.size() > 0 && arrayList3.size() == 0) {
            return arrayList4;
        }
        HashMap hashMap = this.getPropertyMapFromArrayList(arrayList3);
        for (int i = 0; i < arrayList4.size(); ++i) {
            Property property = (Property)arrayList4.get(i);
            if (hashMap.get(property.getPropertyName()) != null) continue;
            arrayList3.add(property);
        }
        return arrayList3;
    }

    public HashMap getPropertyMapFromArrayList(ArrayList<Property> arrayList) {
        HashMap<String, Property> hashMap = new HashMap<String, Property>(arrayList.size());
        for (Property property : arrayList) {
            hashMap.put(property.getPropertyName(), property);
        }
        return hashMap;
    }

    public ArrayList getNoAccessTypePropertiesForClass(JavaClass javaClass, TypeInfo typeInfo) {
        JavaHasAnnotations javaHasAnnotations;
        Property property;
        int n;
        ArrayList<Property> arrayList = new ArrayList<Property>();
        if (javaClass == null) {
            return arrayList;
        }
        ArrayList<Property> arrayList2 = this.getFieldPropertiesForClass(javaClass, typeInfo, false);
        ArrayList<Property> arrayList3 = this.getPropertyPropertiesForClass(javaClass, typeInfo, false);
        for (n = 0; n < arrayList2.size(); ++n) {
            property = arrayList2.get(n);
            javaHasAnnotations = property.getElement();
            if (!this.hasJAXBAnnotations(javaHasAnnotations)) continue;
            arrayList.add(property);
        }
        for (n = 0; n < arrayList3.size(); ++n) {
            property = arrayList3.get(n);
            javaHasAnnotations = property.getElement();
            if (!this.hasJAXBAnnotations(javaHasAnnotations)) continue;
            arrayList.add(property);
        }
        return arrayList;
    }

    public void processSchemaType(XmlSchemaType xmlSchemaType) {
        String string = xmlSchemaType.name();
        Class clazz = xmlSchemaType.type();
        if (clazz == null) {
            return;
        }
        JavaClass javaClass = this.helper.getJavaClass(clazz);
        if (javaClass == null) {
            return;
        }
        QName qName = new QName(xmlSchemaType.namespace(), string);
        this.userDefinedSchemaTypes.put(javaClass.getQualifiedName(), qName);
    }

    public void addEnumTypeInfo(JavaClass javaClass, EnumTypeInfo enumTypeInfo) {
        Object object;
        if (javaClass == null) {
            return;
        }
        enumTypeInfo.setClassName(javaClass.getQualifiedName());
        Class clazz = String.class;
        if (this.helper.isAnnotationPresent(javaClass, XmlEnum.class)) {
            object = (XmlEnum)this.helper.getAnnotation(javaClass, XmlEnum.class);
            clazz = object.value();
        }
        object = this.getSchemaTypeFor(this.helper.getJavaClass(clazz));
        enumTypeInfo.setRestrictionBase((QName)object);
        for (JavaField javaField : javaClass.getDeclaredFields()) {
            if (!javaField.isEnumConstant()) continue;
            String string = javaField.getName();
            if (this.helper.isAnnotationPresent(javaField, XmlEnumValue.class)) {
                XmlEnumValue xmlEnumValue = (XmlEnumValue)this.helper.getAnnotation(javaField, XmlEnumValue.class);
                string = xmlEnumValue.value();
            }
            enumTypeInfo.addObjectToFieldValuePair(javaField.getName(), string);
        }
        this.typeInfoClasses.add(javaClass);
        this.typeInfo.put(javaClass.getQualifiedName(), enumTypeInfo);
    }

    public String getSchemaTypeNameForClassName(String string) {
        String string2 = "";
        string2 = string.indexOf(36) != -1 ? Introspector.decapitalize(string.substring(string.lastIndexOf(36) + 1)) : Introspector.decapitalize(string.substring(string.lastIndexOf(46) + 1));
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer(string2.length());
        for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            if (Character.isDigit(c)) {
                if (!bl) {
                    bl = true;
                }
                stringBuffer.append(c);
                continue;
            }
            if (bl) {
                stringBuffer.append(Character.toUpperCase(c));
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public QName getSchemaTypeFor(JavaClass javaClass) {
        if (javaClass == null) {
            return null;
        }
        QName qName = this.userDefinedSchemaTypes.get(javaClass.getQualifiedName());
        if (qName == null) {
            qName = (QName)this.helper.getXMLToJavaTypeMap().get(javaClass.getRawName());
        }
        if (qName == null) {
            return XMLConstants.ANY_SIMPLE_TYPE_QNAME;
        }
        return qName;
    }

    public boolean isCollectionType(Property property) {
        return this.isCollectionType(property.getType());
    }

    public boolean isCollectionType(JavaClass javaClass) {
        return this.helper.getJavaClass(Collection.class).isAssignableFrom(javaClass) || this.helper.getJavaClass(List.class).isAssignableFrom(javaClass) || this.helper.getJavaClass(Set.class).isAssignableFrom(javaClass);
    }

    public NamespaceInfo processNamespaceInformation(XmlSchema xmlSchema) {
        NamespaceInfo namespaceInfo = new NamespaceInfo();
        namespaceInfo.setNamespaceResolver(new NamespaceResolver());
        String string = null;
        if (xmlSchema != null) {
            Object object;
            String string2 = xmlSchema.namespace();
            if (!string2.equals("") && !string2.equals("##default")) {
                string = string2;
            }
            namespaceInfo.setNamespace(string);
            XmlNs[] xmlNsArray = xmlSchema.xmlns();
            for (int i = 0; i < xmlNsArray.length; ++i) {
                object = xmlNsArray[i];
                namespaceInfo.getNamespaceResolver().put(object.prefix(), object.namespaceURI());
            }
            namespaceInfo.setAttributeFormQualified(xmlSchema.attributeFormDefault() == XmlNsForm.QUALIFIED);
            namespaceInfo.setElementFormQualified(xmlSchema.elementFormDefault() == XmlNsForm.QUALIFIED);
            try {
                Method method = PrivilegedAccessHelper.getDeclaredMethod(XmlSchema.class, "location", new Class[0]);
                object = (String)PrivilegedAccessHelper.invokeMethod(method, xmlSchema, new Object[0]);
                if (object != null) {
                    if (((String)object).equals("##generate")) {
                        object = null;
                    } else if (((String)object).equals("")) {
                        object = null;
                    }
                }
                namespaceInfo.setLocation((String)object);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return namespaceInfo;
    }

    public HashMap<String, TypeInfo> getTypeInfo() {
        return this.typeInfo;
    }

    public ArrayList<JavaClass> getTypeInfoClasses() {
        return this.typeInfoClasses;
    }

    public HashMap getUserDefinedSchemaTypes() {
        return this.userDefinedSchemaTypes;
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.namespaceResolver;
    }

    public String getSchemaTypeNameFor(JavaClass javaClass, XmlType xmlType) {
        String string = "";
        if (javaClass == null) {
            return string;
        }
        if (this.helper.isAnnotationPresent(javaClass, XmlType.class)) {
            XmlType xmlType2 = (XmlType)this.helper.getAnnotation(javaClass, XmlType.class);
            string = xmlType2.name();
            if (string.equals("#default")) {
                string = this.getSchemaTypeNameForClassName(javaClass.getName());
            }
        } else {
            string = this.getSchemaTypeNameForClassName(javaClass.getName());
        }
        return string;
    }

    public QName getQNameForProperty(String string, JavaHasAnnotations javaHasAnnotations, NamespaceInfo namespaceInfo) {
        String string2 = "##default";
        String string3 = "##default";
        QName qName = null;
        if (this.helper.isAnnotationPresent(javaHasAnnotations, XmlAttribute.class)) {
            XmlAttribute xmlAttribute = (XmlAttribute)this.helper.getAnnotation(javaHasAnnotations, XmlAttribute.class);
            string2 = xmlAttribute.name();
            string3 = xmlAttribute.namespace();
            if (string2.equals("##default")) {
                string2 = string;
            }
            qName = !string3.equals("##default") ? new QName(string3, string2) : (namespaceInfo.isAttributeFormQualified() ? new QName(namespaceInfo.getNamespace(), string2) : new QName(string2));
        } else {
            if (this.helper.isAnnotationPresent(javaHasAnnotations, XmlElement.class)) {
                XmlElement xmlElement = (XmlElement)this.helper.getAnnotation(javaHasAnnotations, XmlElement.class);
                string2 = xmlElement.name();
                string3 = xmlElement.namespace();
            }
            if (string2.equals("##default")) {
                string2 = string;
            }
            qName = !string3.equals("##default") ? new QName(string3, string2) : (namespaceInfo.isElementFormQualified() ? new QName(namespaceInfo.getNamespace(), string2) : new QName(string2));
        }
        return qName;
    }

    public HashMap<String, NamespaceInfo> getPackageToNamespaceMappings() {
        return this.packageToNamespaceMappings;
    }

    public NamespaceInfo getNamespaceInfoForPackage(JavaPackage javaPackage) {
        NamespaceInfo namespaceInfo = this.packageToNamespaceMappings.get(javaPackage.getQualifiedName());
        if (namespaceInfo == null) {
            XmlSchema xmlSchema = (XmlSchema)this.helper.getAnnotation(javaPackage, XmlSchema.class);
            namespaceInfo = this.processNamespaceInformation(xmlSchema);
            if (namespaceInfo.getNamespace() == null) {
                namespaceInfo.setNamespace("");
            }
            if (this.helper.isAnnotationPresent(javaPackage, XmlAccessorType.class)) {
                XmlAccessorType xmlAccessorType = (XmlAccessorType)this.helper.getAnnotation(javaPackage, XmlAccessorType.class);
                namespaceInfo.setAccessType(xmlAccessorType.value());
            }
            this.packageToNamespaceMappings.put(javaPackage.getQualifiedName(), namespaceInfo);
        }
        return namespaceInfo;
    }

    private void checkForCallbackMethods() {
        for (JavaClass javaClass : this.typeInfoClasses) {
            if (javaClass == null) continue;
            JavaClass javaClass2 = this.helper.getJavaClass(Unmarshaller.class);
            JavaClass javaClass3 = this.helper.getJavaClass(Marshaller.class);
            JavaClass javaClass4 = this.helper.getJavaClass(Object.class);
            JavaClass[] javaClassArray = new JavaClass[]{javaClass2, javaClass4};
            JavaClass[] javaClassArray2 = new JavaClass[]{javaClass3};
            UnmarshalCallback unmarshalCallback = null;
            MarshalCallback marshalCallback = null;
            if (javaClass.getMethod("beforeUnmarshal", javaClassArray) != null) {
                unmarshalCallback = new UnmarshalCallback();
                unmarshalCallback.setDomainClassName(javaClass.getQualifiedName());
                unmarshalCallback.setHasBeforeUnmarshalCallback();
            }
            if (javaClass.getMethod("afterUnmarshal", javaClassArray) != null) {
                if (unmarshalCallback == null) {
                    unmarshalCallback = new UnmarshalCallback();
                    unmarshalCallback.setDomainClassName(javaClass.getQualifiedName());
                }
                unmarshalCallback.setHasAfterUnmarshalCallback();
            }
            if (unmarshalCallback != null) {
                if (this.unmarshalCallbacks == null) {
                    this.unmarshalCallbacks = new HashMap();
                }
                this.unmarshalCallbacks.put(javaClass.getQualifiedName(), unmarshalCallback);
            }
            if (javaClass.getMethod("beforeMarshal", javaClassArray2) != null) {
                marshalCallback = new MarshalCallback();
                marshalCallback.setDomainClassName(javaClass.getQualifiedName());
                marshalCallback.setHasBeforeMarshalCallback();
            }
            if (javaClass.getMethod("afterMarshal", javaClassArray2) != null) {
                if (marshalCallback == null) {
                    marshalCallback = new MarshalCallback();
                    marshalCallback.setDomainClassName(javaClass.getQualifiedName());
                }
                marshalCallback.setHasAfterMarshalCallback();
            }
            if (marshalCallback == null) continue;
            if (this.marshalCallbacks == null) {
                this.marshalCallbacks = new HashMap();
            }
            this.marshalCallbacks.put(javaClass.getQualifiedName(), marshalCallback);
        }
    }

    public HashMap<String, MarshalCallback> getMarshalCallbacks() {
        return this.marshalCallbacks;
    }

    public HashMap<String, UnmarshalCallback> getUnmarshalCallbacks() {
        return this.unmarshalCallbacks;
    }

    public JavaClass[] processObjectFactory(JavaClass javaClass, ArrayList<JavaClass> arrayList) {
        Collection collection = javaClass.getMethods();
        Iterator iterator = collection.iterator();
        NamespaceInfo namespaceInfo = this.getNamespaceInfoForPackage(javaClass.getPackage());
        while (iterator.hasNext()) {
            JavaMethod javaMethod = (JavaMethod)iterator.next();
            if (!javaMethod.getName().startsWith("create")) continue;
            JavaClass javaClass2 = javaMethod.getReturnType();
            if (javaClass2.getName().equals("javax.xml.bind.JAXBElement")) {
                javaClass2 = (JavaClass)javaMethod.getReturnType().getActualTypeArguments().toArray()[0];
            } else {
                this.factoryMethods.put(javaMethod.getReturnType().getRawName(), javaMethod);
            }
            if (this.helper.isAnnotationPresent(javaMethod, XmlElementDecl.class)) {
                Object object;
                String string;
                XmlElementDecl xmlElementDecl = (XmlElementDecl)this.helper.getAnnotation(javaMethod, XmlElementDecl.class);
                String string2 = xmlElementDecl.namespace();
                if ("##default".equals(string2)) {
                    string2 = namespaceInfo.getNamespace();
                }
                String string3 = xmlElementDecl.name();
                QName qName = new QName(string2, string3);
                if (this.globalElements == null) {
                    this.globalElements = new HashMap();
                }
                boolean bl = false;
                if ("java.util.List".equals(javaClass2.getName())) {
                    bl = true;
                    if (javaClass2.hasActualTypeArguments()) {
                        javaClass2 = (JavaClass)javaClass2.getActualTypeArguments().toArray()[0];
                    }
                }
                ElementDeclaration elementDeclaration = new ElementDeclaration(qName, javaClass2, javaClass2.getQualifiedName(), bl, xmlElementDecl.scope());
                if (!xmlElementDecl.substitutionHeadName().equals("")) {
                    string = xmlElementDecl.substitutionHeadName();
                    object = xmlElementDecl.substitutionHeadNamespace();
                    if (((String)object).equals("##default")) {
                        object = namespaceInfo.getNamespace();
                    }
                    elementDeclaration.setSubstitutionHead(new QName((String)object, string));
                }
                if (this.helper.isAnnotationPresent(javaMethod, XmlJavaTypeAdapter.class)) {
                    string = (XmlJavaTypeAdapter)this.helper.getAnnotation(javaMethod, XmlJavaTypeAdapter.class);
                    object = string.value();
                    elementDeclaration.setJavaTypeAdapterClass((Class)object);
                    Method[] methodArray = ((Class)object).getMethods();
                    Class<?> clazz = null;
                    for (int i = 0; i < methodArray.length; ++i) {
                        Method method = methodArray[i];
                        if (!method.getName().equals("marshal")) continue;
                        clazz = method.getReturnType();
                        break;
                    }
                    elementDeclaration.setJavaType(this.helper.getJavaClass(clazz));
                    elementDeclaration.setAdaptedJavaType(javaClass2);
                }
                this.globalElements.put(qName, elementDeclaration);
            }
            if (this.helper.isBuiltInJavaType(javaClass2) || arrayList.contains(javaClass2)) continue;
            arrayList.add(javaClass2);
        }
        if (arrayList.size() > 0) {
            return arrayList.toArray(new JavaClass[arrayList.size()]);
        }
        return new JavaClass[0];
    }

    public HashMap<QName, ElementDeclaration> getGlobalElements() {
        return this.globalElements;
    }

    public void updateGlobalElements(ArrayList<JavaClass> arrayList) {
        Object object;
        ElementDeclaration elementDeclaration;
        for (JavaClass object2 : arrayList) {
            int n;
            char c;
            if (this.helper.isAnnotationPresent(object2, XmlTransient.class) || !this.helper.isAnnotationPresent(object2, XmlRootElement.class)) continue;
            elementDeclaration = (XmlRootElement)this.helper.getAnnotation(object2, XmlRootElement.class);
            JavaPackage javaPackage = object2.getPackage();
            object = this.getNamespaceInfoForPackage(javaPackage);
            String string = elementDeclaration.name();
            if ((string.equals("##default") || string.equals("")) && (string = object2.getName().indexOf("$") != -1 ? Introspector.decapitalize(object2.getName().substring(object2.getName().lastIndexOf(36) + 1)) : Introspector.decapitalize(object2.getName().substring(object2.getName().lastIndexOf(46) + 1))).length() >= 3 && Character.isDigit(c = string.charAt((n = string.length() - 1) - 1))) {
                char c2 = Character.toUpperCase(string.charAt(n));
                string = string.substring(0, n) + c2;
            }
            String string2 = elementDeclaration.namespace();
            QName qName = null;
            qName = string2.equals("##default") ? (object == null ? new QName(string) : new QName(((NamespaceInfo)object).getNamespace(), string)) : new QName(string2, string);
            ElementDeclaration elementDeclaration2 = new ElementDeclaration(qName, object2, object2.getQualifiedName(), false);
            elementDeclaration2.setIsXmlRootElement(true);
            if (this.globalElements == null) {
                this.globalElements = new HashMap();
            }
            this.globalElements.put(qName, elementDeclaration2);
            this.xmlRootElements.put(object2.getQualifiedName(), elementDeclaration2);
        }
        if (this.globalElements == null) {
            return;
        }
        for (QName qName : this.globalElements.keySet()) {
            elementDeclaration = this.globalElements.get(qName);
            if (elementDeclaration.getSubstitutionHead() == null) continue;
            object = this.globalElements.get(elementDeclaration.getSubstitutionHead());
            ((ElementDeclaration)object).addSubstitutableElement(elementDeclaration);
        }
    }

    private void addReferencedElement(ReferenceProperty referenceProperty, ElementDeclaration elementDeclaration) {
        referenceProperty.addReferencedElement(elementDeclaration);
        if (elementDeclaration.getSubstitutableElements() != null && elementDeclaration.getSubstitutableElements().size() > 0) {
            for (ElementDeclaration elementDeclaration2 : elementDeclaration.getSubstitutableElements()) {
                this.addReferencedElement(referenceProperty, elementDeclaration2);
            }
        }
    }

    private boolean hasJAXBAnnotations(JavaHasAnnotations javaHasAnnotations) {
        return this.helper.isAnnotationPresent(javaHasAnnotations, XmlElement.class) || this.helper.isAnnotationPresent(javaHasAnnotations, XmlAttribute.class) || this.helper.isAnnotationPresent(javaHasAnnotations, XmlAnyElement.class) || this.helper.isAnnotationPresent(javaHasAnnotations, XmlAnyAttribute.class) || this.helper.isAnnotationPresent(javaHasAnnotations, XmlValue.class) || this.helper.isAnnotationPresent(javaHasAnnotations, XmlElements.class) || this.helper.isAnnotationPresent(javaHasAnnotations, XmlElementRef.class) || this.helper.isAnnotationPresent(javaHasAnnotations, XmlElementRefs.class) || this.helper.isAnnotationPresent(javaHasAnnotations, XmlID.class) || this.helper.isAnnotationPresent(javaHasAnnotations, XmlSchemaType.class) || this.helper.isAnnotationPresent(javaHasAnnotations, XmlElementWrapper.class) || this.helper.isAnnotationPresent(javaHasAnnotations, XmlID.class) || this.helper.isAnnotationPresent(javaHasAnnotations, XmlIDREF.class);
    }
}

