/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.compiler;

import java.beans.Introspector;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlAnyAttribute;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlIDREF;
import javax.xml.bind.annotation.XmlInlineBinaryData;
import javax.xml.bind.annotation.XmlList;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.namespace.QName;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.jaxb.DomHandlerConverter;
import org.eclipse.persistence.internal.jaxb.JAXBElementAttributeAccessor;
import org.eclipse.persistence.internal.jaxb.JaxbClassLoader;
import org.eclipse.persistence.internal.jaxb.MultiArgInstantiationPolicy;
import org.eclipse.persistence.internal.jaxb.WrappedValue;
import org.eclipse.persistence.internal.jaxb.XMLJavaTypeConverter;
import org.eclipse.persistence.internal.libraries.asm.ClassWriter;
import org.eclipse.persistence.internal.libraries.asm.CodeVisitor;
import org.eclipse.persistence.internal.libraries.asm.Type;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.jaxb.JAXBEnumTypeConverter;
import org.eclipse.persistence.jaxb.compiler.AnyProperty;
import org.eclipse.persistence.jaxb.compiler.ChoiceProperty;
import org.eclipse.persistence.jaxb.compiler.ElementDeclaration;
import org.eclipse.persistence.jaxb.compiler.EnumTypeInfo;
import org.eclipse.persistence.jaxb.compiler.NamespaceInfo;
import org.eclipse.persistence.jaxb.compiler.Property;
import org.eclipse.persistence.jaxb.compiler.ReferenceProperty;
import org.eclipse.persistence.jaxb.compiler.TypeInfo;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.jaxb.javamodel.JavaMethod;
import org.eclipse.persistence.mappings.AttributeAccessor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.foundation.AbstractCompositeDirectCollectionMapping;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.annotations.XmlContainerProperty;
import org.eclipse.persistence.oxm.mappings.FixedMimeTypePolicy;
import org.eclipse.persistence.oxm.mappings.UnmarshalKeepAsElementPolicy;
import org.eclipse.persistence.oxm.mappings.XMLAnyAttributeMapping;
import org.eclipse.persistence.oxm.mappings.XMLAnyCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLAnyObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLBinaryDataMapping;
import org.eclipse.persistence.oxm.mappings.XMLChoiceCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLChoiceObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLCollectionReferenceMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeDirectCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.oxm.mappings.XMLMapping;
import org.eclipse.persistence.oxm.mappings.XMLObjectReferenceMapping;
import org.eclipse.persistence.oxm.mappings.converters.XMLRootConverter;
import org.eclipse.persistence.oxm.mappings.nullpolicy.AbstractNullPolicy;
import org.eclipse.persistence.oxm.mappings.nullpolicy.IsSetNullPolicy;
import org.eclipse.persistence.oxm.mappings.nullpolicy.XMLNullRepresentationType;
import org.eclipse.persistence.oxm.schema.XMLSchemaReference;
import org.eclipse.persistence.sessions.Project;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappingsGenerator {
    private static String WRAPPER_CLASS = "org.eclipse.persistence.jaxb.generated";
    private static int wrapperCounter = 0;
    String outputDir = ".";
    private int nextNamespaceNumber = 0;
    private HashMap userDefinedSchemaTypes;
    private org.eclipse.persistence.jaxb.javamodel.Helper helper;
    private JavaClass jotArrayList;
    private JavaClass jotHashSet;
    private HashMap<String, NamespaceInfo> packageToNamespaceMappings;
    private HashMap<String, TypeInfo> typeInfo;
    private HashMap<QName, Class> qNamesToGeneratedClasses;
    private HashMap<QName, Class> qNamesToDeclaredClasses;
    private HashMap<QName, ElementDeclaration> globalElements;

    public MappingsGenerator(org.eclipse.persistence.jaxb.javamodel.Helper helper) {
        this.helper = helper;
        this.jotArrayList = helper.getJavaClass(ArrayList.class);
        this.jotHashSet = helper.getJavaClass(HashSet.class);
        this.qNamesToGeneratedClasses = new HashMap();
        this.qNamesToDeclaredClasses = new HashMap();
    }

    public Project generateProject(ArrayList<JavaClass> arrayList, HashMap<String, TypeInfo> hashMap, HashMap hashMap2, HashMap<String, NamespaceInfo> hashMap3, HashMap<QName, ElementDeclaration> hashMap4) throws Exception {
        this.typeInfo = hashMap;
        this.userDefinedSchemaTypes = hashMap2;
        this.packageToNamespaceMappings = hashMap3;
        this.globalElements = hashMap4;
        Project project = new Project();
        for (JavaClass javaClass : arrayList) {
            if (javaClass.isEnum()) continue;
            this.generateDescriptor(javaClass, project);
        }
        for (JavaClass javaClass : arrayList) {
            if (javaClass.isEnum()) continue;
            this.setupInheritance(javaClass);
        }
        this.generateMappings();
        this.processGlobalElements(project);
        wrapperCounter = 0;
        return project;
    }

    public void generateDescriptor(JavaClass javaClass, Project project) {
        String string;
        String string2;
        String string3 = javaClass.getQualifiedName();
        TypeInfo typeInfo = this.typeInfo.get(string3);
        if (typeInfo.isTransient()) {
            return;
        }
        NamespaceInfo namespaceInfo = this.packageToNamespaceMappings.get(javaClass.getPackage().getQualifiedName());
        String string4 = namespaceInfo.getNamespace();
        if (javaClass.getSuperclass() != null && javaClass.getSuperclass().getName().equals("javax.xml.bind.JAXBElement")) {
            this.generateDescriptorForJAXBElementSubclass(javaClass, project, namespaceInfo.getNamespaceResolver());
            return;
        }
        XmlRootElement xmlRootElement = (XmlRootElement)this.helper.getAnnotation(javaClass, XmlRootElement.class);
        if (xmlRootElement == null) {
            string2 = Introspector.decapitalize(string3.substring(string3.lastIndexOf(".") + 1));
            string = string4;
        } else {
            string2 = xmlRootElement.name();
            if (string2.equals("##default")) {
                string2 = Introspector.decapitalize(string3.substring(string3.lastIndexOf(".") + 1));
            }
            string = xmlRootElement.namespace();
        }
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClassName(string3);
        if (typeInfo.getFactoryMethodName() != null) {
            xMLDescriptor.getInstantiationPolicy().useFactoryInstantiationPolicy(typeInfo.getObjectFactoryClassName(), typeInfo.getFactoryMethodName());
        }
        if (string.equals("##default")) {
            string = namespaceInfo.getNamespace();
        }
        if (string.equals("")) {
            xMLDescriptor.setDefaultRootElement(string2);
        } else {
            xMLDescriptor.setDefaultRootElement(this.getPrefixForNamespace(string, namespaceInfo.getNamespaceResolver()) + ":" + string2);
        }
        xMLDescriptor.setNamespaceResolver(namespaceInfo.getNamespaceResolver());
        project.addDescriptor(xMLDescriptor);
        typeInfo.setDescriptor(xMLDescriptor);
    }

    public void generateDescriptorForJAXBElementSubclass(JavaClass javaClass, Project project, NamespaceResolver namespaceResolver) {
        String string = javaClass.getQualifiedName();
        TypeInfo typeInfo = this.typeInfo.get(string);
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClassName(string);
        String[] stringArray = typeInfo.getFactoryMethodParamTypes();
        MultiArgInstantiationPolicy multiArgInstantiationPolicy = new MultiArgInstantiationPolicy();
        multiArgInstantiationPolicy.useFactoryInstantiationPolicy(typeInfo.getObjectFactoryClassName(), typeInfo.getFactoryMethodName());
        multiArgInstantiationPolicy.setParameterTypeNames(stringArray);
        multiArgInstantiationPolicy.setDefaultValues(new String[]{null});
        xMLDescriptor.setInstantiationPolicy(multiArgInstantiationPolicy);
        JavaClass javaClass2 = this.helper.getJavaClass(stringArray[0]);
        if (this.helper.isBuiltInJavaType(javaClass2)) {
            XMLDirectMapping xMLDirectMapping = new XMLDirectMapping();
            xMLDirectMapping.setAttributeName("value");
            xMLDirectMapping.setGetMethodName("getValue");
            xMLDirectMapping.setSetMethodName("setValue");
            xMLDirectMapping.setXPath("text()");
            Class clazz = Helper.getClassFromClasseName(stringArray[0], this.getClass().getClassLoader());
            xMLDirectMapping.setAttributeClassification(clazz);
            xMLDescriptor.addMapping(xMLDirectMapping);
        } else {
            XMLCompositeObjectMapping xMLCompositeObjectMapping = new XMLCompositeObjectMapping();
            xMLCompositeObjectMapping.setAttributeName("value");
            xMLCompositeObjectMapping.setGetMethodName("getValue");
            xMLCompositeObjectMapping.setSetMethodName("setValue");
            xMLCompositeObjectMapping.setXPath(".");
            xMLCompositeObjectMapping.setReferenceClassName(stringArray[0]);
            xMLDescriptor.addMapping(xMLCompositeObjectMapping);
        }
        xMLDescriptor.setNamespaceResolver(namespaceResolver);
        project.addDescriptor(xMLDescriptor);
        typeInfo.setDescriptor(xMLDescriptor);
    }

    public void generateMapping(Property property, XMLDescriptor xMLDescriptor, NamespaceInfo namespaceInfo) {
        if (property.getAdapterClass() != null) {
            JavaClass javaClass = property.getAdapterClass();
            JavaClass javaClass2 = this.helper.getJavaClass(Object.class);
            for (JavaMethod javaMethod : new ArrayList(javaClass.getDeclaredMethods())) {
                JavaClass javaClass3;
                if (!javaMethod.getName().equals("marshal") || (javaClass3 = javaMethod.getReturnType()).getQualifiedName().equals(javaClass2.getQualifiedName())) continue;
                javaClass2 = javaClass3;
                break;
            }
            if (this.typeInfo.containsKey(javaClass2.getQualifiedName())) {
                if (this.isCollectionType(property)) {
                    this.generateCompositeCollectionMapping(property, xMLDescriptor, namespaceInfo, javaClass2.getQualifiedName()).setConverter(new XMLJavaTypeConverter(javaClass.getQualifiedName()));
                } else {
                    this.generateCompositeObjectMapping(property, xMLDescriptor, namespaceInfo, javaClass2.getQualifiedName()).setConverter(new XMLJavaTypeConverter(javaClass.getQualifiedName()));
                }
            } else if (this.isCollectionType(property)) {
                this.generateDirectCollectionMapping(property, xMLDescriptor, namespaceInfo).setValueConverter(new XMLJavaTypeConverter(javaClass.getQualifiedName()));
            } else if (property.isSwaAttachmentRef() || property.isMtomAttachment()) {
                this.generateBinaryMapping(property, xMLDescriptor, namespaceInfo).setConverter(new XMLJavaTypeConverter(javaClass.getQualifiedName()));
            } else {
                this.generateDirectMapping(property, xMLDescriptor, namespaceInfo).setConverter(new XMLJavaTypeConverter(javaClass.getQualifiedName()));
            }
            return;
        }
        if (property.isChoice()) {
            if (this.isCollectionType(property)) {
                this.generateChoiceCollectionMapping(property, xMLDescriptor, namespaceInfo);
            } else {
                this.generateChoiceMapping(property, xMLDescriptor, namespaceInfo);
            }
        } else if (property.isAny()) {
            if (this.isCollectionType(property)) {
                this.generateAnyCollectionMapping(property, xMLDescriptor, namespaceInfo);
            } else {
                this.generateAnyObjectMapping(property, xMLDescriptor, namespaceInfo);
            }
        } else if (property.isReference()) {
            if (this.isCollectionType(property)) {
                this.generateCollectionMappingForReferenceProperty((ReferenceProperty)property, xMLDescriptor, namespaceInfo);
            } else {
                this.generateMappingForReferenceProperty((ReferenceProperty)property, xMLDescriptor, namespaceInfo);
            }
        } else if (this.isMapType(property) && this.helper.isAnnotationPresent(property.getElement(), XmlAnyAttribute.class)) {
            this.generateAnyAttributeMapping(property, xMLDescriptor, namespaceInfo);
        } else if (this.isCollectionType(property)) {
            this.generateCollectionMapping(property, xMLDescriptor, namespaceInfo);
        } else {
            JavaClass javaClass = property.getType();
            TypeInfo typeInfo = this.typeInfo.get(javaClass.getQualifiedName());
            if (typeInfo != null) {
                if (this.helper.isAnnotationPresent(property.getElement(), XmlIDREF.class)) {
                    this.generateXMLObjectReferenceMapping(property, xMLDescriptor, namespaceInfo, javaClass);
                } else if (typeInfo.isEnumerationType()) {
                    this.generateDirectEnumerationMapping(property, xMLDescriptor, namespaceInfo, (EnumTypeInfo)typeInfo);
                } else {
                    this.generateCompositeObjectMapping(property, xMLDescriptor, namespaceInfo, javaClass.getQualifiedName());
                }
            } else if (property.isSwaAttachmentRef() || property.isMtomAttachment()) {
                this.generateBinaryMapping(property, xMLDescriptor, namespaceInfo);
            } else if (javaClass.getQualifiedName().equals("java.lang.Object")) {
                XMLCompositeObjectMapping xMLCompositeObjectMapping = this.generateCompositeObjectMapping(property, xMLDescriptor, namespaceInfo, null);
                xMLCompositeObjectMapping.setKeepAsElementPolicy(UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT);
            } else {
                this.generateDirectMapping(property, xMLDescriptor, namespaceInfo);
            }
        }
    }

    public XMLChoiceObjectMapping generateChoiceMapping(Property property, XMLDescriptor xMLDescriptor, NamespaceInfo namespaceInfo) {
        ChoiceProperty choiceProperty = (ChoiceProperty)property;
        XMLChoiceObjectMapping xMLChoiceObjectMapping = new XMLChoiceObjectMapping();
        xMLChoiceObjectMapping.setAttributeName(property.getPropertyName());
        if (property.isMethodProperty()) {
            if (property.getSetMethodName() != null) {
                xMLChoiceObjectMapping.setSetMethodName(property.getSetMethodName());
                xMLChoiceObjectMapping.setGetMethodName(property.getGetMethodName());
            } else {
                xMLChoiceObjectMapping.setGetMethodName(property.getGetMethodName());
            }
        }
        Iterator<Property> iterator = choiceProperty.getChoiceProperties().iterator();
        while (iterator.hasNext()) {
            Property property2;
            JavaClass javaClass = (property2 = iterator.next()).getType();
            XMLField xMLField = this.getXPathForField(property2, namespaceInfo, !this.typeInfo.containsKey(javaClass.getQualifiedName()));
            xMLChoiceObjectMapping.addChoiceElement(xMLField.getName(), javaClass.getQualifiedName(), false);
        }
        xMLDescriptor.addMapping(xMLChoiceObjectMapping);
        return xMLChoiceObjectMapping;
    }

    public XMLChoiceCollectionMapping generateChoiceCollectionMapping(Property property, XMLDescriptor xMLDescriptor, NamespaceInfo namespaceInfo) {
        JavaClass javaClass;
        ChoiceProperty choiceProperty = (ChoiceProperty)property;
        XMLChoiceCollectionMapping xMLChoiceCollectionMapping = new XMLChoiceCollectionMapping();
        xMLChoiceCollectionMapping.setAttributeName(property.getPropertyName());
        if (property.isMethodProperty()) {
            if (property.getSetMethodName() != null) {
                xMLChoiceCollectionMapping.setSetMethodName(property.getSetMethodName());
                xMLChoiceCollectionMapping.setGetMethodName(property.getGetMethodName());
            } else {
                xMLChoiceCollectionMapping.setGetMethodName(property.getGetMethodName());
            }
        }
        if (this.areEquals(javaClass = property.getType(), Collection.class) || this.areEquals(javaClass, List.class)) {
            javaClass = this.jotArrayList;
        } else if (this.areEquals(javaClass, Set.class)) {
            javaClass = this.jotHashSet;
        }
        xMLChoiceCollectionMapping.useCollectionClassName(javaClass.getRawName());
        Iterator<Property> iterator = choiceProperty.getChoiceProperties().iterator();
        while (iterator.hasNext()) {
            Property property2;
            JavaClass javaClass2 = (property2 = iterator.next()).getType();
            XMLField xMLField = this.getXPathForField(property2, namespaceInfo, !this.typeInfo.containsKey(javaClass2.getQualifiedName()));
            xMLChoiceCollectionMapping.addChoiceElement(xMLField.getName(), javaClass2.getQualifiedName());
        }
        xMLDescriptor.addMapping(xMLChoiceCollectionMapping);
        return xMLChoiceCollectionMapping;
    }

    public XMLMapping generateMappingForReferenceProperty(ReferenceProperty referenceProperty, XMLDescriptor xMLDescriptor, NamespaceInfo namespaceInfo) {
        boolean bl = this.isCollectionType(referenceProperty);
        DatabaseMapping databaseMapping = bl ? new XMLChoiceCollectionMapping() : new XMLChoiceObjectMapping();
        databaseMapping.setAttributeName(referenceProperty.getPropertyName());
        if (referenceProperty.isMethodProperty()) {
            if (referenceProperty.getSetMethodName() != null) {
                databaseMapping.setSetMethodName(referenceProperty.getSetMethodName());
                databaseMapping.setGetMethodName(referenceProperty.getGetMethodName());
            } else {
                databaseMapping.setGetMethodName(referenceProperty.getGetMethodName());
            }
        }
        List<ElementDeclaration> list = referenceProperty.getReferencedElements();
        boolean bl2 = false;
        AttributeAccessor attributeAccessor = databaseMapping.getAttributeAccessor();
        HashMap<QName, Class> hashMap = new HashMap<QName, Class>();
        for (ElementDeclaration elementDeclaration : list) {
            QName qName = elementDeclaration.getElementName();
            XMLField xMLField = this.getXPathForElement("", qName, namespaceInfo, !this.typeInfo.containsKey(elementDeclaration.getJavaTypeName()));
            if (bl) {
                ((XMLChoiceCollectionMapping)databaseMapping).addChoiceElement(xMLField, elementDeclaration.getJavaTypeName());
            } else {
                ((XMLChoiceObjectMapping)databaseMapping).addChoiceElement(xMLField, elementDeclaration.getJavaTypeName());
            }
            if (!elementDeclaration.isXmlRootElement()) {
                XMLRootConverter xMLRootConverter = new XMLRootConverter(xMLField);
                if (bl) {
                    ((XMLChoiceCollectionMapping)databaseMapping).addConverter(xMLField, xMLRootConverter);
                } else {
                    ((XMLChoiceObjectMapping)databaseMapping).addConverter(xMLField, xMLRootConverter);
                }
                hashMap.put(qName, elementDeclaration.getScopeClass());
            }
            bl2 = bl2 || !elementDeclaration.isXmlRootElement();
        }
        if (bl2) {
            JAXBElementAttributeAccessor jAXBElementAttributeAccessor = new JAXBElementAttributeAccessor(attributeAccessor);
            jAXBElementAttributeAccessor.setQNamesToScopes(hashMap);
            databaseMapping.setAttributeAccessor(jAXBElementAttributeAccessor);
        }
        xMLDescriptor.addMapping(databaseMapping);
        return (XMLMapping)((Object)databaseMapping);
    }

    public XMLMapping generateCollectionMappingForReferenceProperty(ReferenceProperty referenceProperty, XMLDescriptor xMLDescriptor, NamespaceInfo namespaceInfo) {
        XMLChoiceCollectionMapping xMLChoiceCollectionMapping = new XMLChoiceCollectionMapping();
        xMLChoiceCollectionMapping.setAttributeName(referenceProperty.getPropertyName());
        if (referenceProperty.isMethodProperty()) {
            if (referenceProperty.getSetMethodName() != null) {
                xMLChoiceCollectionMapping.setSetMethodName(referenceProperty.getSetMethodName());
                xMLChoiceCollectionMapping.setGetMethodName(referenceProperty.getGetMethodName());
            } else {
                xMLChoiceCollectionMapping.setGetMethodName(referenceProperty.getGetMethodName());
            }
        }
        List<ElementDeclaration> list = referenceProperty.getReferencedElements();
        boolean bl = false;
        AttributeAccessor attributeAccessor = xMLChoiceCollectionMapping.getAttributeAccessor();
        HashMap<QName, Class> hashMap = new HashMap<QName, Class>();
        for (ElementDeclaration elementDeclaration : list) {
            QName qName = elementDeclaration.getElementName();
            XMLField xMLField = this.getXPathForElement("", qName, namespaceInfo, !this.typeInfo.containsKey(elementDeclaration.getJavaTypeName()));
            xMLChoiceCollectionMapping.addChoiceElement(xMLField, elementDeclaration.getJavaTypeName());
            if (!elementDeclaration.isXmlRootElement()) {
                XMLRootConverter xMLRootConverter = new XMLRootConverter(xMLField);
                xMLChoiceCollectionMapping.addConverter(xMLField, xMLRootConverter);
                hashMap.put(qName, elementDeclaration.getScopeClass());
            }
            bl = bl || !elementDeclaration.isXmlRootElement();
        }
        if (bl) {
            JAXBElementAttributeAccessor jAXBElementAttributeAccessor = new JAXBElementAttributeAccessor(attributeAccessor, xMLChoiceCollectionMapping.getContainerPolicy());
            jAXBElementAttributeAccessor.setQNamesToScopes(hashMap);
            xMLChoiceCollectionMapping.setAttributeAccessor(jAXBElementAttributeAccessor);
        }
        xMLDescriptor.addMapping(xMLChoiceCollectionMapping);
        return xMLChoiceCollectionMapping;
    }

    public XMLAnyCollectionMapping generateAnyCollectionMapping(Property property, XMLDescriptor xMLDescriptor, NamespaceInfo namespaceInfo) {
        AnyProperty anyProperty = (AnyProperty)property;
        XMLAnyCollectionMapping xMLAnyCollectionMapping = new XMLAnyCollectionMapping();
        xMLAnyCollectionMapping.setAttributeName(property.getPropertyName());
        xMLAnyCollectionMapping.setUseXMLRoot(true);
        xMLAnyCollectionMapping.setAttributeAccessor(new JAXBElementAttributeAccessor(xMLAnyCollectionMapping.getAttributeAccessor(), xMLAnyCollectionMapping.getContainerPolicy()));
        if (anyProperty.isLax()) {
            xMLAnyCollectionMapping.setKeepAsElementPolicy(UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT);
        } else {
            xMLAnyCollectionMapping.setKeepAsElementPolicy(UnmarshalKeepAsElementPolicy.KEEP_ALL_AS_ELEMENT);
        }
        if (anyProperty.getDomHandlerClass() != null) {
            DomHandlerConverter domHandlerConverter = new DomHandlerConverter(anyProperty.getDomHandlerClass());
            xMLAnyCollectionMapping.setConverter(domHandlerConverter);
        }
        xMLDescriptor.addMapping(xMLAnyCollectionMapping);
        return xMLAnyCollectionMapping;
    }

    public XMLCompositeObjectMapping generateCompositeObjectMapping(Property property, XMLDescriptor xMLDescriptor, NamespaceInfo namespaceInfo, String string) {
        XMLCompositeObjectMapping xMLCompositeObjectMapping = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping.setReferenceClassName(string);
        xMLCompositeObjectMapping.setAttributeName(property.getPropertyName());
        if (property.isMethodProperty()) {
            if (property.getSetMethodName() != null) {
                xMLCompositeObjectMapping.setSetMethodName(property.getSetMethodName());
                xMLCompositeObjectMapping.setGetMethodName(property.getGetMethodName());
            } else {
                xMLCompositeObjectMapping.setGetMethodName(property.getGetMethodName());
            }
        }
        if (property.isNillable()) {
            xMLCompositeObjectMapping.getNullPolicy().setNullRepresentedByXsiNil(true);
        }
        xMLCompositeObjectMapping.setXPath(this.getXPathForField(property, namespaceInfo, false).getXPath());
        if (this.helper.isAnnotationPresent(property.getElement(), XmlContainerProperty.class)) {
            XmlContainerProperty xmlContainerProperty = (XmlContainerProperty)this.helper.getAnnotation(property.getElement(), XmlContainerProperty.class);
            String string2 = xmlContainerProperty.value();
            xMLCompositeObjectMapping.setContainerAttributeName(string2);
            if (!xmlContainerProperty.getMethodName().equals("") && !xmlContainerProperty.setMethodName().equals("")) {
                xMLCompositeObjectMapping.setContainerGetMethodName(xmlContainerProperty.getMethodName());
                xMLCompositeObjectMapping.setContainerSetMethodName(xmlContainerProperty.setMethodName());
            }
        }
        xMLDescriptor.addMapping(xMLCompositeObjectMapping);
        return xMLCompositeObjectMapping;
    }

    public XMLDirectMapping generateDirectMapping(Property property, XMLDescriptor xMLDescriptor, NamespaceInfo namespaceInfo) {
        XMLDirectMapping xMLDirectMapping = new XMLDirectMapping();
        xMLDirectMapping.setAttributeName(property.getPropertyName());
        if (property.isMethodProperty()) {
            if (property.getSetMethodName() != null) {
                xMLDirectMapping.setSetMethodName(property.getSetMethodName());
                xMLDirectMapping.setGetMethodName(property.getGetMethodName());
            } else {
                xMLDirectMapping.setGetMethodName(property.getGetMethodName());
            }
        }
        if (property.isNillable()) {
            xMLDirectMapping.getNullPolicy().setNullRepresentedByXsiNil(true);
        }
        xMLDirectMapping.setField(this.getXPathForField(property, namespaceInfo, true));
        if (XMLConstants.QNAME_QNAME.equals(property.getSchemaType())) {
            ((XMLField)xMLDirectMapping.getField()).setSchemaType(XMLConstants.QNAME_QNAME);
        }
        xMLDescriptor.addMapping(xMLDirectMapping);
        return xMLDirectMapping;
    }

    public XMLBinaryDataMapping generateBinaryMapping(Property property, XMLDescriptor xMLDescriptor, NamespaceInfo namespaceInfo) {
        XMLBinaryDataMapping xMLBinaryDataMapping = new XMLBinaryDataMapping();
        xMLBinaryDataMapping.setAttributeName(property.getPropertyName());
        if (property.isMethodProperty()) {
            if (property.getSetMethodName() != null) {
                xMLBinaryDataMapping.setSetMethodName(property.getSetMethodName());
                xMLBinaryDataMapping.setGetMethodName(property.getGetMethodName());
            } else {
                xMLBinaryDataMapping.setGetMethodName(property.getGetMethodName());
            }
        }
        xMLBinaryDataMapping.setField(this.getXPathForField(property, namespaceInfo, false));
        if (property.isSwaAttachmentRef()) {
            ((XMLField)xMLBinaryDataMapping.getField()).setSchemaType(XMLConstants.SWA_REF_QNAME);
            xMLBinaryDataMapping.setSwaRef(true);
        } else if (property.isMtomAttachment()) {
            ((XMLField)xMLBinaryDataMapping.getField()).setSchemaType(XMLConstants.BASE_64_BINARY_QNAME);
        }
        if (this.helper.isAnnotationPresent(property.getElement(), XmlInlineBinaryData.class)) {
            xMLBinaryDataMapping.setShouldInlineBinaryData(true);
        }
        xMLBinaryDataMapping.setMimeTypePolicy(new FixedMimeTypePolicy(property.getMimeType()));
        xMLDescriptor.addMapping(xMLBinaryDataMapping);
        return xMLBinaryDataMapping;
    }

    public void generateDirectEnumerationMapping(Property property, XMLDescriptor xMLDescriptor, NamespaceInfo namespaceInfo, EnumTypeInfo enumTypeInfo) {
        XMLDirectMapping xMLDirectMapping = new XMLDirectMapping();
        xMLDirectMapping.setConverter(this.buildJAXBEnumTypeConverter(xMLDirectMapping, enumTypeInfo));
        xMLDirectMapping.setAttributeName(property.getPropertyName());
        if (property.isMethodProperty()) {
            if (property.getSetMethodName() != null) {
                xMLDirectMapping.setSetMethodName(property.getSetMethodName());
                xMLDirectMapping.setGetMethodName(property.getGetMethodName());
            } else {
                xMLDirectMapping.setGetMethodName(property.getGetMethodName());
            }
        }
        xMLDirectMapping.setField(this.getXPathForField(property, namespaceInfo, true));
        xMLDescriptor.addMapping(xMLDirectMapping);
    }

    private JAXBEnumTypeConverter buildJAXBEnumTypeConverter(DatabaseMapping databaseMapping, EnumTypeInfo enumTypeInfo) {
        JAXBEnumTypeConverter jAXBEnumTypeConverter = new JAXBEnumTypeConverter(databaseMapping, enumTypeInfo.getClassName(), false);
        List<Object> list = enumTypeInfo.getObjectValues();
        List<String> list2 = enumTypeInfo.getFieldValues();
        for (int i = 0; i < list.size(); ++i) {
            jAXBEnumTypeConverter.addConversionValue(list2.get(i), list.get(i));
        }
        return jAXBEnumTypeConverter;
    }

    public void generateCollectionMapping(Property property, XMLDescriptor xMLDescriptor, NamespaceInfo namespaceInfo) {
        Object object;
        JavaClass javaClass = null;
        if (property.getGenericType() != null) {
            javaClass = property.getGenericType();
        }
        if (this.helper.isAnnotationPresent(property.getElement(), XmlElement.class) && (object = (XmlElement)this.helper.getAnnotation(property.getElement(), XmlElement.class)).type() != XmlElement.DEFAULT.class) {
            javaClass = this.helper.getJavaClass(object.type());
        }
        if (javaClass != null && this.typeInfo.get(javaClass.getQualifiedName()) != null) {
            object = this.typeInfo.get(javaClass.getQualifiedName());
            if (((TypeInfo)object).isEnumerationType()) {
                this.generateEnumCollectionMapping(property, xMLDescriptor, namespaceInfo, (EnumTypeInfo)object);
            } else if (this.helper.isAnnotationPresent(property.getElement(), XmlIDREF.class)) {
                this.generateXMLCollectionReferenceMapping(property, xMLDescriptor, namespaceInfo, javaClass);
            } else {
                this.generateCompositeCollectionMapping(property, xMLDescriptor, namespaceInfo, javaClass.getQualifiedName());
            }
        } else {
            this.generateDirectCollectionMapping(property, xMLDescriptor, namespaceInfo);
        }
    }

    public void generateEnumCollectionMapping(Property property, XMLDescriptor xMLDescriptor, NamespaceInfo namespaceInfo, EnumTypeInfo enumTypeInfo) {
        XMLCompositeDirectCollectionMapping xMLCompositeDirectCollectionMapping = new XMLCompositeDirectCollectionMapping();
        xMLCompositeDirectCollectionMapping.setAttributeName(property.getPropertyName());
        if (property.isMethodProperty()) {
            if (property.getSetMethodName() != null) {
                xMLCompositeDirectCollectionMapping.setSetMethodName(property.getSetMethodName());
                xMLCompositeDirectCollectionMapping.setGetMethodName(property.getGetMethodName());
            } else {
                xMLCompositeDirectCollectionMapping.setGetMethodName(property.getGetMethodName());
            }
        }
        xMLCompositeDirectCollectionMapping.setValueConverter(this.buildJAXBEnumTypeConverter(xMLCompositeDirectCollectionMapping, enumTypeInfo));
        JavaClass javaClass = property.getType();
        if (this.areEquals(javaClass, Collection.class) || this.areEquals(javaClass, List.class)) {
            javaClass = this.jotArrayList;
        } else if (this.areEquals(javaClass, Set.class)) {
            javaClass = this.jotHashSet;
        }
        xMLCompositeDirectCollectionMapping.useCollectionClassName(javaClass.getRawName());
        xMLCompositeDirectCollectionMapping.setField(this.getXPathForField(property, namespaceInfo, true));
        if (this.helper.isAnnotationPresent(property.getElement(), XmlList.class)) {
            xMLCompositeDirectCollectionMapping.setUsesSingleNode(true);
        }
        xMLDescriptor.addMapping(xMLCompositeDirectCollectionMapping);
    }

    public void generateAnyAttributeMapping(Property property, XMLDescriptor xMLDescriptor, NamespaceInfo namespaceInfo) {
        XMLAnyAttributeMapping xMLAnyAttributeMapping = new XMLAnyAttributeMapping();
        xMLAnyAttributeMapping.setAttributeName(property.getPropertyName());
        if (property.isMethodProperty()) {
            if (property.getSetMethodName() != null) {
                xMLAnyAttributeMapping.setSetMethodName(property.getSetMethodName());
                xMLAnyAttributeMapping.setGetMethodName(property.getGetMethodName());
            } else {
                xMLAnyAttributeMapping.setGetMethodName(property.getGetMethodName());
            }
        }
        xMLAnyAttributeMapping.setSchemaInstanceIncluded(false);
        xMLAnyAttributeMapping.setNamespaceDeclarationIncluded(false);
        xMLDescriptor.addMapping(xMLAnyAttributeMapping);
    }

    public void generateAnyObjectMapping(Property property, XMLDescriptor xMLDescriptor, NamespaceInfo namespaceInfo) {
        XMLAnyObjectMapping xMLAnyObjectMapping = new XMLAnyObjectMapping();
        xMLAnyObjectMapping.setAttributeName(property.getPropertyName());
        if (property.isMethodProperty()) {
            if (property.getSetMethodName() != null) {
                xMLAnyObjectMapping.setSetMethodName(property.getSetMethodName());
                xMLAnyObjectMapping.setGetMethodName(property.getGetMethodName());
            } else {
                xMLAnyObjectMapping.setGetMethodName(property.getGetMethodName());
            }
        }
        if (property.getType().getQualifiedName().equals("org.w3c.dom.Element")) {
            xMLAnyObjectMapping.setKeepAsElementPolicy(UnmarshalKeepAsElementPolicy.KEEP_ALL_AS_ELEMENT);
        } else {
            xMLAnyObjectMapping.setKeepAsElementPolicy(UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT);
        }
        xMLDescriptor.addMapping(xMLAnyObjectMapping);
    }

    protected boolean areEquals(JavaClass javaClass, Class clazz) {
        if (javaClass == null || clazz == null) {
            return false;
        }
        return javaClass.getRawName().equals(clazz.getCanonicalName());
    }

    public XMLCompositeCollectionMapping generateCompositeCollectionMapping(Property property, XMLDescriptor xMLDescriptor, NamespaceInfo namespaceInfo, String string) {
        JavaClass javaClass;
        XMLCompositeCollectionMapping xMLCompositeCollectionMapping = new XMLCompositeCollectionMapping();
        xMLCompositeCollectionMapping.setAttributeName(property.getPropertyName());
        if (property.isMethodProperty()) {
            if (property.getSetMethodName() != null) {
                xMLCompositeCollectionMapping.setSetMethodName(property.getSetMethodName());
                xMLCompositeCollectionMapping.setGetMethodName(property.getGetMethodName());
            } else {
                xMLCompositeCollectionMapping.setGetMethodName(property.getGetMethodName());
            }
        }
        xMLCompositeCollectionMapping.setReferenceClassName(string);
        if (property.isNillable()) {
            xMLCompositeCollectionMapping.getNullPolicy().setNullRepresentedByXsiNil(true);
        }
        if (this.areEquals(javaClass = property.getType(), Collection.class) || this.areEquals(javaClass, List.class)) {
            javaClass = this.jotArrayList;
        } else if (this.areEquals(javaClass, Set.class)) {
            javaClass = this.jotHashSet;
        }
        xMLCompositeCollectionMapping.useCollectionClassName(javaClass.getRawName());
        XMLField xMLField = this.getXPathForField(property, namespaceInfo, false);
        xMLCompositeCollectionMapping.setXPath(xMLField.getXPath());
        if (this.helper.isAnnotationPresent(property.getElement(), XmlContainerProperty.class)) {
            XmlContainerProperty xmlContainerProperty = (XmlContainerProperty)this.helper.getAnnotation(property.getElement(), XmlContainerProperty.class);
            String string2 = xmlContainerProperty.value();
            xMLCompositeCollectionMapping.setContainerAttributeName(string2);
            if (!xmlContainerProperty.getMethodName().equals("") && !xmlContainerProperty.setMethodName().equals("")) {
                xMLCompositeCollectionMapping.setContainerGetMethodName(xmlContainerProperty.getMethodName());
                xMLCompositeCollectionMapping.setContainerSetMethodName(xmlContainerProperty.setMethodName());
            }
        }
        xMLDescriptor.addMapping(xMLCompositeCollectionMapping);
        return xMLCompositeCollectionMapping;
    }

    public XMLCompositeDirectCollectionMapping generateDirectCollectionMapping(Property property, XMLDescriptor xMLDescriptor, NamespaceInfo namespaceInfo) {
        JavaClass javaClass;
        XMLCompositeDirectCollectionMapping xMLCompositeDirectCollectionMapping = new XMLCompositeDirectCollectionMapping();
        xMLCompositeDirectCollectionMapping.setAttributeName(property.getPropertyName());
        if (property.isMethodProperty()) {
            if (property.getSetMethodName() != null) {
                xMLCompositeDirectCollectionMapping.setSetMethodName(property.getSetMethodName());
                xMLCompositeDirectCollectionMapping.setGetMethodName(property.getGetMethodName());
            } else {
                xMLCompositeDirectCollectionMapping.setGetMethodName(property.getGetMethodName());
            }
        }
        if (this.areEquals(javaClass = property.getType(), Collection.class) || this.areEquals(javaClass, List.class)) {
            javaClass = this.jotArrayList;
        } else if (this.areEquals(javaClass, Set.class)) {
            javaClass = this.jotHashSet;
        }
        xMLCompositeDirectCollectionMapping.useCollectionClassName(javaClass.getRawName());
        XMLField xMLField = this.getXPathForField(property, namespaceInfo, true);
        xMLCompositeDirectCollectionMapping.setField(xMLField);
        if (XMLConstants.QNAME_QNAME.equals(property.getSchemaType())) {
            ((XMLField)xMLCompositeDirectCollectionMapping.getField()).setSchemaType(XMLConstants.QNAME_QNAME);
        }
        if (xMLField.getXPathFragment().isAttribute()) {
            xMLCompositeDirectCollectionMapping.setUsesSingleNode(true);
        }
        if (this.helper.isAnnotationPresent(property.getElement(), XmlList.class)) {
            xMLCompositeDirectCollectionMapping.setUsesSingleNode(true);
        }
        xMLDescriptor.addMapping(xMLCompositeDirectCollectionMapping);
        return xMLCompositeDirectCollectionMapping;
    }

    public String getPrefixForNamespace(String string, NamespaceResolver namespaceResolver) {
        String string2;
        Enumeration enumeration = namespaceResolver.getPrefixes();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            String string3 = namespaceResolver.resolveNamespacePrefix(string2);
            if (!string3.equals(string)) continue;
            return string2;
        }
        string2 = "ns" + this.nextNamespaceNumber;
        ++this.nextNamespaceNumber;
        namespaceResolver.put(string2, string);
        return string2;
    }

    public boolean isCollectionType(Property property) {
        JavaClass javaClass = property.getType();
        return this.helper.getJavaClass(Collection.class).isAssignableFrom(javaClass) || this.helper.getJavaClass(List.class).isAssignableFrom(javaClass) || this.helper.getJavaClass(Set.class).isAssignableFrom(javaClass);
    }

    private void setupInheritance(JavaClass javaClass) {
        XMLDescriptor xMLDescriptor = this.typeInfo.get(javaClass.getName()).getDescriptor();
        NamespaceInfo namespaceInfo = this.packageToNamespaceMappings.get(javaClass.getPackageName());
        if (xMLDescriptor == null) {
            return;
        }
        JavaClass javaClass2 = this.getNextMappedSuperClass(javaClass, xMLDescriptor, namespaceInfo);
        if (javaClass2 == null) {
            return;
        }
        TypeInfo typeInfo = this.typeInfo.get(javaClass2.getName());
        XMLDescriptor xMLDescriptor2 = typeInfo.getDescriptor();
        if (xMLDescriptor2 != null) {
            XMLSchemaReference xMLSchemaReference;
            XMLField xMLField;
            String string;
            XMLSchemaReference xMLSchemaReference2 = xMLDescriptor.getSchemaReference();
            if (xMLSchemaReference2 == null || xMLSchemaReference2.getSchemaContext() == null) {
                return;
            }
            JavaClass javaClass3 = this.getRootMappedSuperClass(javaClass2, xMLDescriptor, namespaceInfo);
            TypeInfo typeInfo2 = this.typeInfo.get(javaClass3.getName());
            XMLDescriptor xMLDescriptor3 = typeInfo2.getDescriptor();
            if (xMLDescriptor3.getNamespaceResolver() == null) {
                xMLDescriptor3.setNamespaceResolver(new NamespaceResolver());
            }
            if (xMLDescriptor3.getInheritancePolicy().getClassIndicatorField() == null) {
                string = xMLDescriptor3.getNamespaceResolver().resolveNamespaceURI("http://www.w3.org/2001/XMLSchema-instance");
                if (string == null) {
                    string = xMLDescriptor3.getNamespaceResolver().generatePrefix("xsi");
                }
                xMLField = new XMLField("@" + string + ":type");
                xMLDescriptor3.getNamespaceResolver().put(string, "http://www.w3.org/2001/XMLSchema-instance");
                xMLDescriptor3.getInheritancePolicy().setClassIndicatorField(xMLField);
            }
            if ((string = xMLSchemaReference2.getSchemaContext()).length() > 1 && string.startsWith("/")) {
                string = string.substring(1);
            }
            xMLDescriptor.getInheritancePolicy().setParentClassName(javaClass2.getName());
            xMLDescriptor3.getInheritancePolicy().addClassNameIndicator(javaClass.getName(), string);
            xMLField = xMLDescriptor3.getInheritancePolicy().getClassNameIndicatorMapping().get(xMLDescriptor3.getJavaClassName());
            if (xMLField == null && (xMLSchemaReference = xMLDescriptor3.getSchemaReference()) != null && xMLSchemaReference.getSchemaContext() != null) {
                String string2 = xMLSchemaReference.getSchemaContext();
                if (string2.length() > 1 && string2.startsWith("/")) {
                    string2 = string2.substring(1);
                }
                xMLDescriptor3.getInheritancePolicy().addClassNameIndicator(xMLDescriptor3.getJavaClassName(), string2);
            }
            xMLDescriptor3.getInheritancePolicy().setShouldReadSubclasses(true);
        }
    }

    private JavaClass getNextMappedSuperClass(JavaClass javaClass, XMLDescriptor xMLDescriptor, NamespaceInfo namespaceInfo) {
        JavaClass javaClass2 = javaClass.getSuperclass();
        if (javaClass2 == null) {
            return null;
        }
        TypeInfo typeInfo = this.typeInfo.get(javaClass2.getName());
        if (typeInfo == null) {
            return null;
        }
        if (typeInfo.isTransient()) {
            this.generateMappings(typeInfo, xMLDescriptor, namespaceInfo);
            return this.getNextMappedSuperClass(javaClass2, xMLDescriptor, namespaceInfo);
        }
        return javaClass2;
    }

    private JavaClass getRootMappedSuperClass(JavaClass javaClass, XMLDescriptor xMLDescriptor, NamespaceInfo namespaceInfo) {
        JavaClass javaClass2;
        JavaClass javaClass3 = javaClass2 = javaClass;
        while (javaClass3 != null) {
            if ((javaClass3 = this.getNextMappedSuperClass(javaClass3, xMLDescriptor, namespaceInfo)) == null) {
                return javaClass2;
            }
            javaClass2 = javaClass3;
        }
        return javaClass2;
    }

    public void generateMappings() {
        for (String string : this.typeInfo.keySet()) {
            XMLDescriptor xMLDescriptor;
            JavaClass javaClass = this.helper.getJavaClass(string);
            TypeInfo typeInfo = this.typeInfo.get(string);
            NamespaceInfo namespaceInfo = this.packageToNamespaceMappings.get(javaClass.getPackageName());
            if (typeInfo.isEnumerationType() || (xMLDescriptor = typeInfo.getDescriptor()) == null) continue;
            this.generateMappings(typeInfo, xMLDescriptor, namespaceInfo);
        }
    }

    public void generateMappings(TypeInfo typeInfo, XMLDescriptor xMLDescriptor, NamespaceInfo namespaceInfo) {
        String[] stringArray = typeInfo.getPropOrder();
        if (stringArray.length == 0 || stringArray[0].equals("")) {
            ArrayList<String> arrayList = typeInfo.getPropertyNames();
            for (int i = 0; i < arrayList.size(); ++i) {
                String string = arrayList.get(i);
                Property property = typeInfo.getProperties().get(string);
                this.generateMapping(property, xMLDescriptor, namespaceInfo);
            }
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                Property property = typeInfo.getProperties().get(stringArray[i]);
                if (property == null) continue;
                this.generateMapping(property, xMLDescriptor, namespaceInfo);
            }
        }
    }

    public void generateXMLCollectionReferenceMapping(Property property, XMLDescriptor xMLDescriptor, NamespaceInfo namespaceInfo, JavaClass javaClass) {
        XMLField xMLField = this.getXPathForField(property, namespaceInfo, true);
        XMLCollectionReferenceMapping xMLCollectionReferenceMapping = new XMLCollectionReferenceMapping();
        xMLCollectionReferenceMapping.setAttributeName(property.getPropertyName());
        if (property.isMethodProperty()) {
            if (property.getSetMethodName() != null) {
                xMLCollectionReferenceMapping.setSetMethodName(property.getSetMethodName());
                xMLCollectionReferenceMapping.setGetMethodName(property.getGetMethodName());
            } else {
                xMLCollectionReferenceMapping.setGetMethodName(property.getGetMethodName());
            }
        }
        xMLCollectionReferenceMapping.setReferenceClassName(javaClass.getQualifiedName());
        JavaClass javaClass2 = property.getType();
        if (this.areEquals(javaClass2, Collection.class) || this.areEquals(javaClass2, List.class)) {
            javaClass2 = this.jotArrayList;
        } else if (this.areEquals(javaClass2, Set.class)) {
            javaClass2 = this.jotHashSet;
        }
        xMLCollectionReferenceMapping.useCollectionClassName(javaClass2.getRawName());
        TypeInfo typeInfo = this.typeInfo.get(javaClass.getQualifiedName());
        if (typeInfo.isIDSet()) {
            Property property2;
            XMLField xMLField2 = this.getXPathForField(property2, namespaceInfo, !this.helper.isAnnotationPresent((property2 = typeInfo.getIDProperty()).getElement(), XmlAttribute.class));
            xMLCollectionReferenceMapping.addSourceToTargetKeyFieldAssociation(xMLField.getXPath(), xMLField2.getXPath());
        }
        xMLDescriptor.addMapping(xMLCollectionReferenceMapping);
    }

    public void generateXMLObjectReferenceMapping(Property property, XMLDescriptor xMLDescriptor, NamespaceInfo namespaceInfo, JavaClass javaClass) {
        XMLField xMLField = this.getXPathForField(property, namespaceInfo, true);
        XMLObjectReferenceMapping xMLObjectReferenceMapping = new XMLObjectReferenceMapping();
        xMLObjectReferenceMapping.setAttributeName(property.getPropertyName());
        if (property.isMethodProperty()) {
            if (property.getSetMethodName() != null) {
                xMLObjectReferenceMapping.setSetMethodName(property.getSetMethodName());
                xMLObjectReferenceMapping.setGetMethodName(property.getGetMethodName());
            } else {
                xMLObjectReferenceMapping.setGetMethodName(property.getGetMethodName());
            }
        }
        xMLObjectReferenceMapping.setReferenceClassName(javaClass.getQualifiedName());
        TypeInfo typeInfo = this.typeInfo.get(javaClass.getQualifiedName());
        if (typeInfo.isIDSet()) {
            Property property2;
            XMLField xMLField2 = this.getXPathForField(property2, namespaceInfo, !this.helper.isAnnotationPresent((property2 = typeInfo.getIDProperty()).getElement(), XmlAttribute.class));
            xMLObjectReferenceMapping.addSourceToTargetKeyFieldAssociation(xMLField.getXPath(), xMLField2.getXPath());
        }
        xMLDescriptor.addMapping(xMLObjectReferenceMapping);
    }

    public XMLField getXPathForField(Property property, NamespaceInfo namespaceInfo, boolean bl) {
        Object object;
        Object object2;
        String string = "";
        XMLField xMLField = null;
        if (this.helper.isAnnotationPresent(property.getElement(), XmlElementWrapper.class)) {
            object2 = (XmlElementWrapper)this.helper.getAnnotation(property.getElement(), XmlElementWrapper.class);
            object = object2.namespace();
            if (((String)object).equals("##default")) {
                object = namespaceInfo.isElementFormQualified() ? namespaceInfo.getNamespace() : "";
            }
            string = ((String)object).equals("") ? string + object2.name() + "/" : string + this.getPrefixForNamespace((String)object, namespaceInfo.getNamespaceResolver()) + ":" + object2.name() + "/";
        }
        if (this.helper.isAnnotationPresent(property.getElement(), XmlAttribute.class)) {
            Object object3;
            object2 = property.getSchemaName();
            object = "";
            if (namespaceInfo.isAttributeFormQualified()) {
                object = namespaceInfo.getNamespace();
            }
            if (!((QName)object2).getNamespaceURI().equals("")) {
                object = ((QName)object2).getNamespaceURI();
            }
            if (((String)object).equals("")) {
                string = string + "@" + ((QName)object2).getLocalPart();
            } else {
                object3 = this.getPrefixForNamespace((String)object, namespaceInfo.getNamespaceResolver());
                string = string + "@" + (String)object3 + ":" + ((QName)object2).getLocalPart();
            }
            object3 = (QName)this.userDefinedSchemaTypes.get(property.getClass());
            if (property.getSchemaType() != null) {
                object3 = property.getSchemaType();
            }
            if (object3 == null) {
                object3 = (QName)this.helper.getXMLToJavaTypeMap().get(property.getType().getRawName());
            }
            XMLField xMLField2 = new XMLField(string);
            xMLField2.setSchemaType((QName)object3);
            return xMLField2;
        }
        if (this.helper.isAnnotationPresent(property.getElement(), XmlValue.class)) {
            string = "text()";
            object2 = new XMLField(string);
            object = (QName)this.userDefinedSchemaTypes.get(property.getType());
            if (property.getSchemaType() != null) {
                object = property.getSchemaType();
            }
            if (object == null) {
                object = (QName)this.helper.getXMLToJavaTypeMap().get(property.getType());
            }
            ((XMLField)object2).setSchemaType((QName)object);
            return object2;
        }
        object2 = property.getSchemaName();
        xMLField = this.getXPathForElement(string, (QName)object2, namespaceInfo, bl);
        object = (QName)this.userDefinedSchemaTypes.get(property.getType());
        if (property.getSchemaType() != null) {
            object = property.getSchemaType();
        }
        if (object == null) {
            object = (QName)this.helper.getXMLToJavaTypeMap().get(property.getType());
        }
        xMLField.setSchemaType((QName)object);
        return xMLField;
    }

    public XMLField getXPathForElement(String string, QName qName, NamespaceInfo namespaceInfo, boolean bl) {
        Object object;
        String string2 = "";
        if (!qName.getNamespaceURI().equals("")) {
            string2 = qName.getNamespaceURI();
        }
        if (string2.equals("")) {
            string = string + qName.getLocalPart();
            if (bl) {
                string = string + "/text()";
            }
        } else {
            object = this.getPrefixForNamespace(string2, namespaceInfo.getNamespaceResolver());
            string = string + (String)object + ":" + qName.getLocalPart();
            if (bl) {
                string = string + "/text()";
            }
        }
        object = new XMLField(string);
        return object;
    }

    public Property getXmlValueFieldForSimpleContent(ArrayList<Property> arrayList) {
        boolean bl = false;
        boolean bl2 = false;
        Property property = null;
        for (Property property2 : arrayList) {
            if (this.helper.isAnnotationPresent(property2.getElement(), XmlValue.class)) {
                bl = true;
                property = property2;
                continue;
            }
            if (this.helper.isAnnotationPresent(property2.getElement(), XmlAttribute.class) || this.helper.isAnnotationPresent(property2.getElement(), XmlTransient.class) || this.helper.isAnnotationPresent(property2.getElement(), XmlAnyAttribute.class)) continue;
            bl2 = true;
        }
        if (bl && !bl2) {
            return property;
        }
        return null;
    }

    public void processSchemaType(XmlSchemaType xmlSchemaType) {
        String string = xmlSchemaType.name();
        Class clazz = xmlSchemaType.type();
        if (clazz == null) {
            return;
        }
        QName qName = new QName(xmlSchemaType.namespace(), string);
        this.userDefinedSchemaTypes.put(clazz, qName);
    }

    public String getSchemaTypeNameForClassName(String string) {
        String string2 = Introspector.decapitalize(string.substring(string.lastIndexOf(46) + 1));
        return string2;
    }

    public boolean isMapType(Property property) {
        JavaClass javaClass = this.helper.getJavaClass(Map.class);
        return javaClass.isAssignableFrom(property.getType());
    }

    public void processGlobalElements(Project project) {
        if (this.globalElements == null) {
            return;
        }
        for (QName qName : this.globalElements.keySet()) {
            Object object;
            String string;
            Object object2;
            ElementDeclaration elementDeclaration = this.globalElements.get(qName);
            String string2 = elementDeclaration.getJavaTypeName();
            TypeInfo typeInfo = this.typeInfo.get(string2);
            if (this.helper.isBuiltInJavaType(elementDeclaration.getJavaType()) || typeInfo != null && typeInfo.isEnumerationType()) {
                String string3;
                Object object3;
                Object object4;
                Serializable serializable;
                object2 = qName.getNamespaceURI();
                if (object2 == null || ((String)object2).equals("##default")) {
                    object2 = "";
                }
                string = string2;
                if (elementDeclaration.getAdaptedJavaTypeName() != null) {
                    string = elementDeclaration.getAdaptedJavaTypeName();
                }
                object = this.generateWrapperClass(WRAPPER_CLASS + wrapperCounter++, string, elementDeclaration.isList(), qName);
                this.qNamesToGeneratedClasses.put(qName, (Class)object);
                try {
                    serializable = PrivilegedAccessHelper.getClassForName(string2, false, this.helper.getClassLoader());
                    this.qNamesToDeclaredClasses.put(qName, (Class)serializable);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                serializable = new XMLDescriptor();
                ((ClassDescriptor)serializable).setJavaClass((Class)object);
                if (elementDeclaration.isList()) {
                    object4 = new XMLCompositeDirectCollectionMapping();
                    ((DatabaseMapping)object4).setAttributeName("value");
                    ((XMLCompositeDirectCollectionMapping)object4).setXPath("text()");
                    ((AbstractCompositeDirectCollectionMapping)object4).setUsesSingleNode(true);
                    if (typeInfo != null && typeInfo.isEnumerationType()) {
                        ((AbstractCompositeDirectCollectionMapping)object4).setValueConverter(this.buildJAXBEnumTypeConverter((DatabaseMapping)object4, (EnumTypeInfo)typeInfo));
                    } else {
                        try {
                            object3 = PrivilegedAccessHelper.getClassForName(string2, false, this.helper.getClassLoader());
                            ((AbstractCompositeDirectCollectionMapping)object4).setFieldElementClass((Class)object3);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                    }
                    if (string2.equals("[B") || string2.equals("[Ljava.lang.Byte;")) {
                        ((XMLField)((AbstractCompositeDirectCollectionMapping)object4).getField()).setSchemaType(XMLConstants.BASE_64_BINARY_QNAME);
                    } else if (string2.equals("javax.xml.namespace.QName")) {
                        ((XMLField)((AbstractCompositeDirectCollectionMapping)object4).getField()).setSchemaType(XMLConstants.QNAME_QNAME);
                    }
                    ((ClassDescriptor)serializable).addMapping((DatabaseMapping)object4);
                } else {
                    object4 = new XMLDirectMapping();
                    ((DatabaseMapping)object4).setAttributeName("value");
                    ((XMLDirectMapping)object4).setXPath("text()");
                    ((DatabaseMapping)object4).setSetMethodName("setWrappedValue");
                    ((DatabaseMapping)object4).setGetMethodName("getWrappedValue");
                    if (this.helper.isBuiltInJavaType(elementDeclaration.getJavaType())) {
                        object3 = Helper.getClassFromClasseName(string, this.getClass().getClassLoader());
                        ((AbstractDirectMapping)object4).setAttributeClassification((Class)object3);
                    }
                    object3 = new IsSetNullPolicy("isSetValue", false, true, XMLNullRepresentationType.ABSENT_NODE);
                    ((XMLDirectMapping)object4).setNullPolicy((AbstractNullPolicy)object3);
                    if (typeInfo != null && typeInfo.isEnumerationType()) {
                        ((AbstractDirectMapping)object4).setConverter(this.buildJAXBEnumTypeConverter((DatabaseMapping)object4, (EnumTypeInfo)typeInfo));
                    }
                    if (string2.equals("[B") || string2.equals("[Ljava.lang.Byte;")) {
                        ((XMLField)((AbstractDirectMapping)object4).getField()).setSchemaType(XMLConstants.BASE_64_BINARY_QNAME);
                    } else if (string2.equals("javax.xml.namespace.QName")) {
                        ((XMLField)((AbstractDirectMapping)object4).getField()).setSchemaType(XMLConstants.QNAME_QNAME);
                    }
                    if (elementDeclaration.getJavaTypeAdapterClass() != null) {
                        ((AbstractDirectMapping)object4).setConverter(new XMLJavaTypeConverter(elementDeclaration.getJavaTypeAdapterClass()));
                    }
                    ((ClassDescriptor)serializable).addMapping((DatabaseMapping)object4);
                }
                object4 = this.getNamespaceInfoForURI((String)object2);
                if (object4 != null) {
                    object3 = ((NamespaceInfo)object4).getNamespaceResolver();
                    string3 = ((NamespaceResolver)object3).resolveNamespaceURI((String)object2);
                    ((XMLDescriptor)serializable).setNamespaceResolver((NamespaceResolver)object3);
                    ((XMLDescriptor)serializable).setDefaultRootElement(string3 + ":" + qName.getLocalPart());
                } else if (((String)object2).equals("")) {
                    ((XMLDescriptor)serializable).setDefaultRootElement(qName.getLocalPart());
                } else {
                    object3 = new NamespaceResolver();
                    string3 = ((NamespaceResolver)object3).generatePrefix();
                    ((NamespaceResolver)object3).put(string3, (String)object2);
                    ((XMLDescriptor)serializable).setNamespaceResolver((NamespaceResolver)object3);
                    ((XMLDescriptor)serializable).setDefaultRootElement(string3 + ":" + qName.getLocalPart());
                }
                project.addDescriptor((ClassDescriptor)serializable);
                continue;
            }
            if (typeInfo == null || typeInfo.isTransient()) continue;
            if (qName.getNamespaceURI() == null || qName.getNamespaceURI().equals("")) {
                typeInfo.getDescriptor().addRootElement(qName.getLocalPart());
                continue;
            }
            object2 = typeInfo.getDescriptor();
            string = qName.getNamespaceURI();
            object = ((XMLDescriptor)object2).getNamespaceResolver().resolveNamespaceURI(string);
            if (object == null) {
                object = ((XMLDescriptor)object2).getNamespaceResolver().generatePrefix();
                ((XMLDescriptor)object2).getNamespaceResolver().put((String)object, string);
            }
            ((XMLDescriptor)object2).addRootElement((String)object + ":" + qName.getLocalPart());
        }
    }

    private NamespaceInfo getNamespaceInfoForURI(String string) {
        for (NamespaceInfo namespaceInfo : this.packageToNamespaceMappings.values()) {
            if (!namespaceInfo.getNamespace().equals(string)) continue;
            return namespaceInfo;
        }
        return null;
    }

    private String getPackageNameForURI(String string) {
        for (String string2 : this.packageToNamespaceMappings.keySet()) {
            if (!this.packageToNamespaceMappings.get(string2).getNamespace().equals(string)) continue;
            return string2;
        }
        return null;
    }

    public Class generateWrapperClass(String string, String string2, boolean bl, QName qName) {
        ClassWriter classWriter = new ClassWriter(false);
        classWriter.visit(49, 1, string.replace(".", "/"), Type.getType(Object.class).getInternalName(), new String[]{Type.getType(WrappedValue.class).getInternalName()}, null);
        String string3 = null;
        if (bl) {
            string3 = "Ljava/util/List;";
        } else {
            string3 = string2.replace(".", "/");
            if (!string3.startsWith("[")) {
                string3 = "L" + string3 + ";";
            }
        }
        classWriter.visitField(2, "value", string3, null, null);
        classWriter.visitField(2, "isSetValue", "Z", null, null);
        classWriter.visitField(10, "wrappedValueQName", "Ljavax/xml/namespace/QName;", null, null);
        CodeVisitor codeVisitor = classWriter.visitMethod(1, "<init>", "()V", null, null);
        codeVisitor.visitVarInsn(25, 0);
        codeVisitor.visitMethodInsn(183, "java/lang/Object", "<init>", "()V");
        codeVisitor.visitInsn(177);
        codeVisitor.visitMaxs(1, 1);
        codeVisitor = classWriter.visitMethod(8, "<clinit>", "()V", null, null);
        codeVisitor.visitTypeInsn(187, "javax/xml/namespace/QName");
        codeVisitor.visitInsn(89);
        codeVisitor.visitLdcInsn(qName.getNamespaceURI());
        codeVisitor.visitLdcInsn(qName.getLocalPart());
        codeVisitor.visitMethodInsn(183, "javax/xml/namespace/QName", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V");
        codeVisitor.visitFieldInsn(179, string.replace(".", "/"), "wrappedValueQName", "Ljavax/xml/namespace/QName;");
        codeVisitor.visitInsn(177);
        codeVisitor.visitMaxs(4, 0);
        codeVisitor = classWriter.visitMethod(1, "getWrappedValue", Type.getMethodDescriptor(Type.getType(Object.class), new Type[0]), null, null);
        codeVisitor.visitVarInsn(25, 0);
        codeVisitor.visitFieldInsn(180, string.replace(".", "/"), "value", string3);
        codeVisitor.visitInsn(Type.getType(Object.class).getOpcode(172));
        codeVisitor.visitMaxs(1, 1);
        String string4 = string3;
        if (string4.endsWith(";") && !string4.startsWith("[L")) {
            string4 = string4.substring(0, string4.length() - 1);
        }
        if (string4.startsWith("L")) {
            string4 = string4.substring(1, string4.length());
        }
        codeVisitor = classWriter.visitMethod(1, "setWrappedValue", "(Ljava/lang/Object;)V", null, null);
        codeVisitor.visitVarInsn(25, 0);
        codeVisitor.visitVarInsn(25, 1);
        codeVisitor.visitTypeInsn(192, string4);
        codeVisitor.visitFieldInsn(181, string.replace(".", "/"), "value", string3);
        codeVisitor.visitVarInsn(25, 0);
        codeVisitor.visitInsn(4);
        codeVisitor.visitFieldInsn(181, string.replace(".", "/"), "isSetValue", "Z");
        codeVisitor.visitInsn(177);
        codeVisitor.visitMaxs(2, 2);
        codeVisitor = classWriter.visitMethod(1, "isSetValue", "()Z", null, null);
        codeVisitor.visitVarInsn(25, 0);
        codeVisitor.visitFieldInsn(180, string.replace(".", "/"), "isSetValue", "Z");
        codeVisitor.visitInsn(172);
        codeVisitor.visitMaxs(1, 1);
        codeVisitor = classWriter.visitMethod(1, "getQName", "()Ljavax/xml/namespace/QName;", null, null);
        codeVisitor.visitFieldInsn(178, string.replace(".", "/"), "wrappedValueQName", "Ljavax/xml/namespace/QName;");
        codeVisitor.visitInsn(176);
        codeVisitor.visitMaxs(1, 1);
        codeVisitor = classWriter.visitMethod(1, "getWrappedValueClass", "()Ljava/lang/Class;", null, null);
        codeVisitor.visitLdcInsn(Type.getType(string3));
        codeVisitor.visitInsn(176);
        codeVisitor.visitMaxs(1, 1);
        classWriter.visitEnd();
        byte[] byArray = classWriter.toByteArray();
        JaxbClassLoader jaxbClassLoader = (JaxbClassLoader)this.helper.getClassLoader();
        Class clazz = jaxbClassLoader.generateClass(string, byArray);
        return clazz;
    }

    public HashMap<QName, Class> getQNamesToGeneratedClasses() {
        return this.qNamesToGeneratedClasses;
    }

    public HashMap<QName, Class> getQNamesToDeclaredClasses() {
        return this.qNamesToDeclaredClasses;
    }
}

