/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings;

import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.changetracking.AttributeChangeTrackingPolicy;
import org.eclipse.persistence.descriptors.changetracking.DeferredChangeDetectionPolicy;
import org.eclipse.persistence.descriptors.changetracking.ObjectChangeTrackingPolicy;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.descriptors.DescriptorIterator;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.AggregateChangeRecord;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.AggregateMapping;
import org.eclipse.persistence.mappings.Association;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.EmbeddableMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.RelationalMapping;
import org.eclipse.persistence.mappings.foundation.AbstractTransformationMapping;
import org.eclipse.persistence.mappings.foundation.MapKeyMapping;
import org.eclipse.persistence.queries.DataReadQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.queries.WriteObjectQuery;
import org.eclipse.persistence.sessions.Project;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregateObjectMapping
extends AggregateMapping
implements RelationalMapping,
MapKeyMapping,
EmbeddableMapping {
    protected boolean isNullAllowed = true;
    protected DatabaseTable aggregateKeyTable = null;
    protected transient Map<String, String> aggregateToSourceFieldNames = new HashMap<String, String>(5);

    @Override
    public boolean isRelationalMapping() {
        return true;
    }

    @Override
    public void addAdditionalFieldsToQuery(ReadQuery readQuery, Expression expression) {
        for (DatabaseField databaseField : this.getReferenceDescriptor().getAllFields()) {
            if (readQuery.isObjectLevelReadQuery()) {
                if (expression != null) {
                    ((ObjectLevelReadQuery)readQuery).addAdditionalField(expression.getField(databaseField));
                    continue;
                }
                ((ObjectLevelReadQuery)readQuery).addAdditionalField((DatabaseField)databaseField.clone());
                continue;
            }
            if (!readQuery.isDataReadQuery()) continue;
            if (expression == null) {
                ((SQLSelectStatement)((DataReadQuery)readQuery).getSQLStatement()).addField((DatabaseField)databaseField.clone());
                if (((SQLSelectStatement)((DataReadQuery)readQuery).getSQLStatement()).getTables().contains(databaseField.getTable())) continue;
                ((SQLSelectStatement)((DataReadQuery)readQuery).getSQLStatement()).addTable((DatabaseTable)databaseField.getTable().clone());
                continue;
            }
            ((SQLSelectStatement)((DataReadQuery)readQuery).getSQLStatement()).addField(expression.getTable(databaseField.getTable()).getField(databaseField));
        }
    }

    @Override
    public void addFieldsForMapKey(AbstractRecord abstractRecord) {
        Iterator<DatabaseField> iterator = this.getReferenceDescriptor().getAllFields().iterator();
        while (iterator.hasNext()) {
            abstractRecord.put(iterator.next(), (Object)null);
        }
    }

    @Override
    public void addFieldNameTranslation(String string, String string2) {
        String string3 = string2.substring(string2.lastIndexOf(46) + 1);
        this.getAggregateToSourceFieldNames().put(string3, string);
    }

    @Override
    public void addNestedFieldNameTranslation(String string, String string2, String string3) {
        this.addFieldNameTranslation(string2, string3);
    }

    @Override
    public void addKeyToDeletedObjectsList(Object object, Map map) {
    }

    protected boolean allAggregateFieldsAreNull(AbstractRecord abstractRecord) {
        Vector<DatabaseField> vector = this.getReferenceFields();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            DatabaseField databaseField = vector.get(i);
            Object object = abstractRecord.get(databaseField);
            if (object == null) continue;
            return false;
        }
        return true;
    }

    public void allowNull() {
        this.setIsNullAllowed(true);
    }

    protected boolean backupAttributeValueIsNull(WriteObjectQuery writeObjectQuery) {
        Object object;
        return writeObjectQuery.getSession().isUnitOfWork() && (object = this.getAttributeValueFromObject(writeObjectQuery.getBackupClone())) == null;
    }

    public Object buildAggregateFromRow(AbstractRecord abstractRecord, Object object, JoinedAttributeManager joinedAttributeManager, ObjectBuildingQuery objectBuildingQuery, boolean bl, AbstractSession abstractSession) throws DatabaseException {
        Serializable serializable;
        if (this.isNullAllowed() && this.allAggregateFieldsAreNull(abstractRecord)) {
            return null;
        }
        Object object2 = null;
        ClassDescriptor classDescriptor = this.getReferenceDescriptor();
        boolean bl2 = true;
        if (object != null) {
            if (classDescriptor.hasInheritance()) {
                serializable = classDescriptor.getInheritancePolicy().classFromRow(abstractRecord, abstractSession);
                object2 = this.getMatchingAttributeValueFromObject(abstractRecord, object, abstractSession, classDescriptor = this.getReferenceDescriptor((Class)serializable, abstractSession));
                if (object2 != null && object2.getClass() != serializable) {
                    object2 = classDescriptor.getObjectBuilder().buildNewInstance();
                    bl2 = false;
                }
            } else {
                object2 = this.getMatchingAttributeValueFromObject(abstractRecord, object, abstractSession, classDescriptor);
            }
        }
        if (object2 == null) {
            object2 = classDescriptor.getObjectBuilder().buildNewInstance();
            bl2 = false;
        }
        serializable = objectBuildingQuery;
        if (objectBuildingQuery.isObjectLevelReadQuery() && (((ObjectLevelReadQuery)serializable).isPartialAttribute(this.getAttributeName()) || joinedAttributeManager != null && joinedAttributeManager.isAttributeJoined(this.getDescriptor(), this.getAttributeName()))) {
            if (((ObjectLevelReadQuery)(serializable = (ObjectLevelReadQuery)((ObjectBuildingQuery)serializable).deepClone())).hasPartialAttributeExpressions()) {
                ((ObjectLevelReadQuery)serializable).setPartialAttributeExpressions(this.extractNestedExpressions(((ObjectLevelReadQuery)objectBuildingQuery).getPartialAttributeExpressions(), ((ObjectLevelReadQuery)serializable).getExpressionBuilder(), false));
            } else {
                ((ObjectLevelReadQuery)serializable).getJoinedAttributeManager().setJoinedAttributeExpressions_(this.extractNestedExpressions(joinedAttributeManager.getJoinedAttributeExpressions(), joinedAttributeManager.getBaseExpressionBuilder(), false));
            }
            ((DatabaseQuery)serializable).setDescriptor(classDescriptor);
        }
        if (objectBuildingQuery.isReadAllQuery() && ((ReadAllQuery)objectBuildingQuery).isAttributeBatchRead(this.getDescriptor(), this.getAttributeName())) {
            serializable = (ObjectLevelReadQuery)objectBuildingQuery.clone();
            ((DatabaseQuery)serializable).setProperties(objectBuildingQuery.getProperties());
            ((ReadAllQuery)serializable).setBatchReadAttributeExpressions(this.extractNestedExpressions(((ReadAllQuery)objectBuildingQuery).getBatchReadAttributeExpressions(), ((ReadAllQuery)serializable).getExpressionBuilder(), false));
        }
        if (bl) {
            classDescriptor.getObjectBuilder().buildAttributesIntoShallowObject(object2, abstractRecord, (ObjectBuildingQuery)serializable);
        } else if (abstractSession.isUnitOfWork()) {
            classDescriptor.getObjectBuilder().buildAttributesIntoWorkingCopyClone(object2, (ObjectBuildingQuery)serializable, joinedAttributeManager, abstractRecord, (UnitOfWorkImpl)abstractSession, bl2);
        } else {
            classDescriptor.getObjectBuilder().buildAttributesIntoObject(object2, abstractRecord, (ObjectBuildingQuery)serializable, joinedAttributeManager, bl2);
        }
        return object2;
    }

    protected void writeNullReferenceRow(AbstractRecord abstractRecord) {
        Vector<DatabaseField> vector = this.getReferenceFields();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            abstractRecord.put((DatabaseField)vector.get(i), (Object)null);
        }
    }

    @Override
    public Expression buildObjectJoinExpression(Expression expression, Object object, AbstractSession abstractSession) {
        Expression expression2 = null;
        Expression expression3 = null;
        Object object2 = null;
        ClassDescriptor classDescriptor = this.getReferenceDescriptor();
        if (object != null && !classDescriptor.getJavaClass().isInstance(object)) {
            throw QueryException.incorrectClassForObjectComparison(expression, object, this);
        }
        Enumeration<DatabaseMapping> enumeration = classDescriptor.getMappings().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseMapping databaseMapping = enumeration.nextElement();
            object2 = object == null ? null : databaseMapping.getAttributeValueFromObject(object);
            expression3 = expression.get(databaseMapping.getAttributeName()).equal(object2);
            if (expression2 == null) {
                expression2 = expression3;
                continue;
            }
            expression2 = expression2.and(expression3);
        }
        return expression2;
    }

    @Override
    public Expression buildObjectJoinExpression(Expression expression, Expression expression2, AbstractSession abstractSession) {
        Expression expression3 = null;
        Enumeration<DatabaseMapping> enumeration = this.getReferenceDescriptor().getMappings().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseMapping databaseMapping = enumeration.nextElement();
            String string = databaseMapping.getAttributeName();
            Expression expression4 = expression.get(string).equal(expression2.get(string));
            if (expression3 == null) {
                expression3 = expression4;
                continue;
            }
            expression3 = expression3.and(expression4);
        }
        return expression3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void writeToRowFromAggregate(AbstractRecord abstractRecord, Object object, Object object2, AbstractSession abstractSession) throws DescriptorException {
        if (object2 == null) {
            if (!this.isNullAllowed) throw DescriptorException.nullForNonNullAggregate(object, this);
            this.writeNullReferenceRow(abstractRecord);
            return;
        } else {
            if (abstractSession.isClassReadOnly(object2.getClass())) return;
            this.getObjectBuilder(object2, abstractSession).buildRow(abstractRecord, object2, abstractSession);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void writeToRowFromAggregateWithChangeRecord(AbstractRecord abstractRecord, ChangeRecord changeRecord, ObjectChangeSet objectChangeSet, AbstractSession abstractSession) throws DescriptorException {
        if (objectChangeSet != null) {
            if (abstractSession.isClassReadOnly(objectChangeSet.getClassType(abstractSession))) return;
            this.getReferenceDescriptor(objectChangeSet.getClassType(abstractSession), abstractSession).getObjectBuilder().buildRowWithChangeSet(abstractRecord, objectChangeSet, abstractSession);
            return;
        }
        if (this.isNullAllowed) {
            this.writeNullReferenceRow(abstractRecord);
            return;
        }
        Object object = ((ObjectChangeSet)changeRecord.getOwner()).getUnitOfWorkClone();
        throw DescriptorException.nullForNonNullAggregate(object, this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void writeToRowFromAggregateForUpdate(AbstractRecord abstractRecord, WriteObjectQuery writeObjectQuery, Object object) throws DescriptorException {
        if (object == null) {
            if (!this.isNullAllowed) throw DescriptorException.nullForNonNullAggregate(writeObjectQuery.getObject(), this);
            if (this.backupAttributeValueIsNull(writeObjectQuery)) return;
            this.writeNullReferenceRow(abstractRecord);
            return;
        } else if (!(writeObjectQuery.getBackupClone() == null || this.getMatchingBackupAttributeValue(writeObjectQuery, object) != null && object.getClass().equals(this.getMatchingBackupAttributeValue(writeObjectQuery, object).getClass()))) {
            this.getObjectBuilder(object, writeObjectQuery.getSession()).buildRow(abstractRecord, object, writeObjectQuery.getSession());
            return;
        } else {
            if (writeObjectQuery.getSession().isClassReadOnly(object.getClass())) return;
            WriteObjectQuery writeObjectQuery2 = (WriteObjectQuery)writeObjectQuery.clone();
            writeObjectQuery2.setObject(object);
            if (writeObjectQuery.getSession().isUnitOfWork()) {
                Object object2 = this.getMatchingBackupAttributeValue(writeObjectQuery, object);
                if (object2 == null) {
                    object2 = this.getObjectBuilder(object, writeObjectQuery.getSession()).buildNewInstance();
                }
                writeObjectQuery2.setBackupClone(object2);
            }
            this.getObjectBuilder(object, writeObjectQuery.getSession()).buildRowForUpdate(abstractRecord, writeObjectQuery2);
        }
    }

    @Override
    public void buildClone(Object object, Object object2, UnitOfWorkImpl unitOfWorkImpl) {
        Object object3 = this.getAttributeValueFromObject(object);
        Object object4 = this.buildClonePart(object, object3, unitOfWorkImpl);
        if (object4 != null) {
            ClassDescriptor classDescriptor = this.getReferenceDescriptor(object4, (AbstractSession)unitOfWorkImpl);
            classDescriptor.getObjectChangePolicy().setAggregateChangeListener(object2, object4, unitOfWorkImpl, classDescriptor, this.getAttributeName());
        }
        this.setAttributeValueInObject(object2, object4);
    }

    @Override
    public Object buildElementClone(Object object, Object object2, UnitOfWorkImpl unitOfWorkImpl, boolean bl) {
        Object object3 = this.buildClonePart(object, unitOfWorkImpl, bl);
        if (object3 != null) {
            ClassDescriptor classDescriptor = this.getReferenceDescriptor(object3, (AbstractSession)unitOfWorkImpl);
            classDescriptor.getObjectChangePolicy().setAggregateChangeListener(object2, object3, unitOfWorkImpl, classDescriptor, this.getAttributeName());
        }
        return object3;
    }

    @Override
    public void setChangeListener(Object object, PropertyChangeListener propertyChangeListener, UnitOfWorkImpl unitOfWorkImpl) {
        Object object2 = this.getAttributeValueFromObject(object);
        if (object2 != null) {
            ClassDescriptor classDescriptor = this.getReferenceDescriptor(object2, (AbstractSession)unitOfWorkImpl);
            classDescriptor.getObjectChangePolicy().setAggregateChangeListener(object, object2, unitOfWorkImpl, classDescriptor, this.getAttributeName());
        }
    }

    @Override
    public void buildCloneFromRow(AbstractRecord abstractRecord, JoinedAttributeManager joinedAttributeManager, Object object, ObjectBuildingQuery objectBuildingQuery, UnitOfWorkImpl unitOfWorkImpl, AbstractSession abstractSession) {
        Object object2 = this.buildAggregateFromRow(abstractRecord, object, joinedAttributeManager, objectBuildingQuery, false, abstractSession);
        ClassDescriptor classDescriptor = this.getReferenceDescriptor(object2, (AbstractSession)unitOfWorkImpl);
        if (object2 != null) {
            classDescriptor.getObjectChangePolicy().setAggregateChangeListener(object, object2, unitOfWorkImpl, classDescriptor, this.getAttributeName());
        }
        this.setAttributeValueInObject(object, object2);
    }

    @Override
    public void buildShallowOriginalFromRow(AbstractRecord abstractRecord, Object object, JoinedAttributeManager joinedAttributeManager, ObjectBuildingQuery objectBuildingQuery, AbstractSession abstractSession) {
        Object object2 = this.buildAggregateFromRow(abstractRecord, object, joinedAttributeManager, objectBuildingQuery, true, abstractSession);
        this.setAttributeValueInObject(object, object2);
    }

    @Override
    public ReadQuery buildSelectionQueryForDirectCollectionKeyMapping(ContainerPolicy containerPolicy) {
        ReadAllQuery readAllQuery = new ReadAllQuery();
        readAllQuery.setReferenceClass(this.referenceClass);
        readAllQuery.setDescriptor(this.getReferenceDescriptor());
        readAllQuery.setContainerPolicy(containerPolicy);
        return readAllQuery;
    }

    protected AbstractRecord buildTemplateInsertRow(AbstractSession abstractSession) {
        AbstractRecord abstractRecord = this.getReferenceDescriptor().getObjectBuilder().buildTemplateInsertRow(abstractSession);
        List list = (List)this.getReferenceDescriptor().getMappings().clone();
        if (this.getReferenceDescriptor().hasInheritance()) {
            Enumeration enumeration = this.getReferenceDescriptor().getInheritancePolicy().getChildDescriptors().elements();
            while (enumeration.hasMoreElements()) {
                Enumeration<DatabaseMapping> enumeration2 = ((ClassDescriptor)enumeration.nextElement()).getMappings().elements();
                while (enumeration2.hasMoreElements()) {
                    DatabaseMapping databaseMapping = enumeration2.nextElement();
                    if (list.contains(databaseMapping)) continue;
                    databaseMapping.writeInsertFieldsIntoRow(abstractRecord, abstractSession);
                    list.add(databaseMapping);
                }
            }
        }
        return abstractRecord;
    }

    @Override
    public void cascadeDiscoverAndPersistUnregisteredNewObjects(Object object, Map map, Map map2, Map map3, UnitOfWorkImpl unitOfWorkImpl, boolean bl) {
        ObjectBuilder objectBuilder = this.getReferenceDescriptor(object.getClass(), (AbstractSession)unitOfWorkImpl).getObjectBuilder();
        objectBuilder.cascadeDiscoverAndPersistUnregisteredNewObjects(object, map, map2, map3, unitOfWorkImpl);
    }

    @Override
    public void cascadePerformRemoveIfRequired(Object object, UnitOfWorkImpl unitOfWorkImpl, Map map, boolean bl) {
        Object object2 = null;
        object2 = bl ? this.getAttributeValueFromObject(object) : object;
        if (object2 == null) {
            return;
        }
        if (!map.containsKey(object2)) {
            map.put(object2, object2);
            ObjectBuilder objectBuilder = this.getReferenceDescriptor(object2.getClass(), (AbstractSession)unitOfWorkImpl).getObjectBuilder();
            objectBuilder.cascadePerformRemove(object2, unitOfWorkImpl, map);
        }
    }

    @Override
    public void cascadePerformRemoveIfRequired(Object object, UnitOfWorkImpl unitOfWorkImpl, Map map) {
        this.cascadePerformRemoveIfRequired(object, unitOfWorkImpl, map, true);
    }

    @Override
    public void cascadePerformRemovePrivateOwnedObjectFromChangeSetIfRequired(Object object, UnitOfWorkImpl unitOfWorkImpl, Map map) {
        Object object2 = this.getAttributeValueFromObject(object);
        if (object2 == null) {
            return;
        }
        if (!map.containsKey(object2)) {
            map.put(object2, object2);
            ObjectBuilder objectBuilder = this.getReferenceDescriptor(object2, (AbstractSession)unitOfWorkImpl).getObjectBuilder();
            objectBuilder.cascadePerformRemovePrivateOwnedObjectFromChangeSet(object2, unitOfWorkImpl, map);
        }
    }

    @Override
    public void cascadeRegisterNewIfRequired(Object object, UnitOfWorkImpl unitOfWorkImpl, Map map, boolean bl) {
        Object object2 = null;
        object2 = bl ? this.getAttributeValueFromObject(object) : object;
        if (object2 == null) {
            return;
        }
        if (!map.containsKey(object2)) {
            map.put(object2, object2);
            ObjectBuilder objectBuilder = this.getReferenceDescriptor(object2.getClass(), (AbstractSession)unitOfWorkImpl).getObjectBuilder();
            objectBuilder.cascadeRegisterNewForCreate(object2, unitOfWorkImpl, map);
        }
    }

    @Override
    public void cascadeRegisterNewIfRequired(Object object, UnitOfWorkImpl unitOfWorkImpl, Map map) {
        this.cascadeRegisterNewIfRequired(object, unitOfWorkImpl, map, true);
    }

    @Override
    public Object clone() {
        AggregateObjectMapping aggregateObjectMapping = (AggregateObjectMapping)super.clone();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.putAll(this.getAggregateToSourceFieldNames());
        aggregateObjectMapping.setAggregateToSourceFieldNames(hashMap);
        return aggregateObjectMapping;
    }

    @Override
    protected Vector<DatabaseField> collectFields() {
        return this.getReferenceFields();
    }

    @Override
    public Object createMapComponentFromRow(AbstractRecord abstractRecord, ObjectBuildingQuery objectBuildingQuery, AbstractSession abstractSession) {
        Object object = this.buildAggregateFromRow(abstractRecord, null, null, objectBuildingQuery, false, abstractSession);
        return object;
    }

    @Override
    public Object createMapComponentFromJoinedRow(AbstractRecord abstractRecord, JoinedAttributeManager joinedAttributeManager, ObjectBuildingQuery objectBuildingQuery, AbstractSession abstractSession) {
        return this.createMapComponentFromRow(abstractRecord, objectBuildingQuery, abstractSession);
    }

    @Override
    public void deleteMapKey(Object object, AbstractSession abstractSession) {
    }

    public void dontAllowNull() {
        this.setIsNullAllowed(false);
    }

    @Override
    public Map extractIdentityFieldsForQuery(Object object, AbstractSession abstractSession) {
        HashMap<DatabaseField, Object> hashMap = new HashMap<DatabaseField, Object>();
        ClassDescriptor classDescriptor = this.getReferenceDescriptor();
        Iterator<DatabaseField> iterator = null;
        iterator = classDescriptor.getPrimaryKeyFields() != null && !classDescriptor.getPrimaryKeyFields().isEmpty() ? classDescriptor.getPrimaryKeyFields().iterator() : classDescriptor.getAllFields().iterator();
        while (iterator.hasNext()) {
            DatabaseField databaseField = iterator.next();
            Object object2 = classDescriptor.getObjectBuilder().extractValueFromObjectForField(object, databaseField, abstractSession);
            hashMap.put(databaseField, object2);
        }
        return hashMap;
    }

    @Override
    public List<DatabaseTable> getAdditionalTablesForJoinQuery() {
        return this.getReferenceDescriptor().getTables();
    }

    @Override
    public Expression getAdditionalSelectionCriteriaForMapKey() {
        return null;
    }

    public Vector<Association> getAggregateToSourceFieldNameAssociations() {
        Vector<Association> vector = new Vector<Association>(this.getAggregateToSourceFieldNames().size());
        Iterator<String> iterator = this.getAggregateToSourceFieldNames().keySet().iterator();
        Iterator<String> iterator2 = this.getAggregateToSourceFieldNames().values().iterator();
        while (iterator.hasNext()) {
            vector.addElement(new Association(iterator.next(), iterator2.next()));
        }
        return vector;
    }

    public Map<String, String> getAggregateToSourceFieldNames() {
        return this.aggregateToSourceFieldNames;
    }

    @Override
    public Class getFieldClassification(DatabaseField databaseField) {
        DatabaseMapping databaseMapping = this.getReferenceDescriptor().getObjectBuilder().getMappingForField(databaseField);
        if (databaseMapping == null) {
            return null;
        }
        return databaseMapping.getFieldClassification(databaseField);
    }

    @Override
    public List<DatabaseField> getIdentityFieldsForMapKey() {
        ClassDescriptor classDescriptor = this.getReferenceDescriptor();
        if (classDescriptor.getPrimaryKeyFields() != null) {
            return classDescriptor.getPrimaryKeyFields();
        }
        return this.getAllFieldsForMapKey();
    }

    @Override
    public List<DatabaseField> getAllFieldsForMapKey() {
        return this.getReferenceDescriptor().getAllFields();
    }

    protected Object getMatchingAttributeValueFromObject(AbstractRecord abstractRecord, Object object, AbstractSession abstractSession, ClassDescriptor classDescriptor) {
        return this.getAttributeValueFromObject(object);
    }

    protected Object getMatchingBackupAttributeValue(WriteObjectQuery writeObjectQuery, Object object) {
        return this.getAttributeValueFromObject(writeObjectQuery.getBackupClone());
    }

    @Override
    public ObjectLevelReadQuery getNestedJoinQuery(JoinedAttributeManager joinedAttributeManager, ObjectLevelReadQuery objectLevelReadQuery, AbstractSession abstractSession) {
        return null;
    }

    @Override
    public ClassDescriptor getReferenceDescriptor(Class clazz, AbstractSession abstractSession) {
        if (this.getReferenceDescriptor().getJavaClass().equals(clazz)) {
            return this.getReferenceDescriptor();
        }
        ClassDescriptor classDescriptor = this.getReferenceDescriptor().getInheritancePolicy().getSubclassDescriptor(clazz);
        if (classDescriptor == null) {
            throw DescriptorException.noSubClassMatch(clazz, this);
        }
        return classDescriptor;
    }

    protected Vector<DatabaseField> getReferenceFields() {
        return this.getReferenceDescriptor().getAllFields();
    }

    @Override
    public Object getTargetVersionOfSourceObject(Object object, Object object2, MergeManager mergeManager) {
        if (mergeManager.getSession().isUnitOfWork()) {
            UnitOfWorkImpl unitOfWorkImpl = (UnitOfWorkImpl)mergeManager.getSession();
            Object object3 = this.buildClonePart(object, unitOfWorkImpl, unitOfWorkImpl.isOriginalNewObject(object2));
            return object3;
        }
        return object;
    }

    @Override
    public boolean hasDependency() {
        return this.getReferenceDescriptor().hasDependencyOnParts();
    }

    @Override
    public void initialize(AbstractSession abstractSession) throws DescriptorException {
        super.initialize(abstractSession);
        ClassDescriptor classDescriptor = (ClassDescriptor)this.getReferenceDescriptor().clone();
        if (classDescriptor.isChildDescriptor()) {
            ClassDescriptor classDescriptor2 = abstractSession.getDescriptor(classDescriptor.getInheritancePolicy().getParentClass());
            this.initializeParentInheritance(classDescriptor2, classDescriptor, abstractSession);
        }
        this.setReferenceDescriptor(classDescriptor);
        this.initializeReferenceDescriptor(classDescriptor);
        classDescriptor.preInitialize(abstractSession);
        classDescriptor.initialize(abstractSession);
        this.translateFields(classDescriptor, abstractSession);
        if (classDescriptor.hasInheritance() && classDescriptor.getInheritancePolicy().hasChildren()) {
            this.initializeChildInheritance(classDescriptor, abstractSession);
        }
        this.setFields(this.collectFields());
    }

    public void initializeChildInheritance(ClassDescriptor classDescriptor, AbstractSession abstractSession) throws DescriptorException {
        if (classDescriptor.getInheritancePolicy().hasChildren()) {
            Vector vector = classDescriptor.getInheritancePolicy().getChildDescriptors();
            NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                ClassDescriptor classDescriptor2 = (ClassDescriptor)((ClassDescriptor)enumeration.nextElement()).clone();
                classDescriptor2.getInheritancePolicy().setParentDescriptor(classDescriptor);
                this.initializeReferenceDescriptor(classDescriptor2);
                classDescriptor2.preInitialize(abstractSession);
                classDescriptor2.initialize(abstractSession);
                this.translateFields(classDescriptor2, abstractSession);
                ((Vector)nonSynchronizedVector).addElement(classDescriptor2);
                this.initializeChildInheritance(classDescriptor2, abstractSession);
            }
            classDescriptor.getInheritancePolicy().setChildDescriptors(nonSynchronizedVector);
        }
    }

    public void initializeParentInheritance(ClassDescriptor classDescriptor, ClassDescriptor classDescriptor2, AbstractSession abstractSession) throws DescriptorException {
        Cloneable cloneable;
        ClassDescriptor classDescriptor3 = (ClassDescriptor)classDescriptor.clone();
        if (classDescriptor3.getInheritancePolicy().isChildDescriptor()) {
            cloneable = abstractSession.getDescriptor(classDescriptor3.getJavaClass());
            this.initializeParentInheritance((ClassDescriptor)cloneable, classDescriptor, abstractSession);
        }
        this.initializeReferenceDescriptor(classDescriptor3);
        cloneable = NonSynchronizedVector.newInstance(1);
        ((Vector)cloneable).addElement(classDescriptor2);
        classDescriptor3.getInheritancePolicy().setChildDescriptors((Vector)cloneable);
        classDescriptor3.preInitialize(abstractSession);
        classDescriptor3.initialize(abstractSession);
        this.translateFields(classDescriptor3, abstractSession);
    }

    protected void initializeReferenceDescriptor(ClassDescriptor classDescriptor) {
        if (this.aggregateKeyTable != null) {
            classDescriptor.setDefaultTable(this.aggregateKeyTable);
            Vector<DatabaseTable> vector = new Vector<DatabaseTable>(1);
            vector.add(this.aggregateKeyTable);
            classDescriptor.setTables(vector);
        } else {
            classDescriptor.setDefaultTable(this.getDescriptor().getDefaultTable());
            classDescriptor.setTables(this.getDescriptor().getTables());
            classDescriptor.setPrimaryKeyFields(this.getDescriptor().getPrimaryKeyFields());
        }
    }

    @Override
    public void iterateOnMapKey(DescriptorIterator descriptorIterator, Object object) {
        super.iterateOnAttributeValue(descriptorIterator, object);
    }

    @Override
    public boolean isLockableMapping() {
        return true;
    }

    @Override
    public boolean isAggregateObjectMapping() {
        return true;
    }

    @Override
    public boolean isChangeTrackingSupported(Project project) {
        ClassDescriptor classDescriptor = this.getReferenceDescriptor();
        if (classDescriptor == null) {
            Iterator iterator = project.getOrderedDescriptors().iterator();
            while (iterator.hasNext() && classDescriptor == null) {
                ClassDescriptor classDescriptor2 = (ClassDescriptor)iterator.next();
                if (!classDescriptor2.getJavaClassName().equals(this.getReferenceClassName())) continue;
                classDescriptor = classDescriptor2;
            }
        }
        if (classDescriptor != null) {
            if (!classDescriptor.supportsChangeTracking(project)) {
                return false;
            }
            if (classDescriptor.hasInheritance()) {
                for (ClassDescriptor classDescriptor2 : classDescriptor.getInheritancePolicy().getChildDescriptors()) {
                    if (classDescriptor2.supportsChangeTracking(project)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isCascadedLockingSupported() {
        return true;
    }

    public boolean isNullAllowed() {
        return this.isNullAllowed;
    }

    @Override
    public void postInitialize(AbstractSession abstractSession) throws DescriptorException {
        super.postInitialize(abstractSession);
        if (this.getReferenceDescriptor() != null) {
            if (this.getDescriptor().getObjectChangePolicy().getClass().equals(DeferredChangeDetectionPolicy.class)) {
                this.getReferenceDescriptor().setObjectChangePolicy(new DeferredChangeDetectionPolicy());
            } else if (this.getDescriptor().getObjectChangePolicy().getClass().equals(ObjectChangeTrackingPolicy.class) && this.getReferenceDescriptor().getObjectChangePolicy().getClass().equals(AttributeChangeTrackingPolicy.class)) {
                this.getReferenceDescriptor().setObjectChangePolicy(new ObjectChangeTrackingPolicy());
            }
            this.getReferenceDescriptor().postInitialize(abstractSession);
        }
    }

    @Override
    public void preinitializeMapKey(DatabaseTable databaseTable) throws DescriptorException {
        this.setTableForAggregateMappingKey(databaseTable);
    }

    public void postInitializeMapValueSelectionQuery(ReadQuery readQuery, AbstractSession abstractSession) {
        readQuery.setShouldMaintainCache(false);
    }

    public Object readFromReturnRowIntoObject(AbstractRecord abstractRecord, Object object, ReadObjectQuery readObjectQuery, Collection collection) throws DatabaseException {
        int n;
        Object object2 = this.getAttributeValueFromObject(object);
        if (object2 == null) {
            object2 = this.readFromRowIntoObject(abstractRecord, null, object, readObjectQuery, readObjectQuery.getSession());
            if (collection != null) {
                collection.add(this);
            }
            return object2;
        }
        for (n = 0; n < this.getReferenceFields().size(); ++n) {
            DatabaseField databaseField = this.getReferenceFields().elementAt(n);
            if (!abstractRecord.containsKey(databaseField)) continue;
            this.getObjectBuilder(object2, readObjectQuery.getSession()).assignReturnValueForField(object2, readObjectQuery, abstractRecord, databaseField, collection);
        }
        if (this.isNullAllowed()) {
            n = 1;
            for (int i = 0; i < this.getReferenceFields().size() && n != 0; ++i) {
                DatabaseField databaseField = (DatabaseField)this.fields.elementAt(i);
                if (abstractRecord.containsKey(databaseField)) {
                    n = abstractRecord.get(databaseField) == null ? 1 : 0;
                    continue;
                }
                Object object3 = this.valueFromObject(object, databaseField, readObjectQuery.getSession());
                if (object3 == null) {
                    DatabaseMapping databaseMapping;
                    Object object4 = this.getDescriptor().getObjectBuilder().getBaseValueForField(databaseField, object);
                    if (object4 == null) continue;
                    DatabaseMapping databaseMapping2 = this.getDescriptor().getObjectBuilder().getBaseMappingForField(databaseField);
                    if (databaseMapping2.isForeignReferenceMapping()) {
                        databaseMapping = (ForeignReferenceMapping)databaseMapping2;
                        if (!((ForeignReferenceMapping)databaseMapping).usesIndirection()) continue;
                        n = ((ForeignReferenceMapping)databaseMapping).getIndirectionPolicy().objectIsInstantiated(object4) ? 1 : 0;
                        continue;
                    }
                    if (!databaseMapping2.isTransformationMapping() || !((AbstractTransformationMapping)(databaseMapping = (AbstractTransformationMapping)databaseMapping2)).usesIndirection()) continue;
                    n = ((AbstractTransformationMapping)databaseMapping).getIndirectionPolicy().objectIsInstantiated(object4) ? 1 : 0;
                    continue;
                }
                n = 0;
            }
            if (n != 0) {
                object2 = null;
                this.setAttributeValueInObject(object, object2);
            }
        }
        if (collection != null) {
            collection.add(this);
        }
        return object2;
    }

    @Override
    public Object readFromRowIntoObject(AbstractRecord abstractRecord, JoinedAttributeManager joinedAttributeManager, Object object, ObjectBuildingQuery objectBuildingQuery, AbstractSession abstractSession) throws DatabaseException {
        Object object2 = this.buildAggregateFromRow(abstractRecord, object, joinedAttributeManager, objectBuildingQuery, false, abstractSession);
        this.setAttributeValueInObject(object, object2);
        return object2;
    }

    @Override
    public void rehashFieldDependancies(AbstractSession abstractSession) {
        this.getReferenceDescriptor().rehashFieldDependancies(abstractSession);
    }

    public void setAggregateToSourceFieldNameAssociations(Vector<Association> vector) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>(vector.size() + 1);
        Enumeration<Association> enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Association association = enumeration.nextElement();
            hashtable.put((String)association.getKey(), (String)association.getValue());
        }
        this.setAggregateToSourceFieldNames(hashtable);
    }

    protected void setAggregateToSourceFieldNames(Map<String, String> map) {
        this.aggregateToSourceFieldNames = map;
    }

    public void setIsNullAllowed(boolean bl) {
        this.isNullAllowed = bl;
    }

    public void setTableForAggregateMappingKey(DatabaseTable databaseTable) {
        this.aggregateKeyTable = databaseTable;
    }

    protected void translateFields(ClassDescriptor classDescriptor, AbstractSession abstractSession) {
        Enumeration<DatabaseField> enumeration = classDescriptor.getFields().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseField databaseField = enumeration.nextElement();
            String string = databaseField.getName();
            String string2 = this.getAggregateToSourceFieldNames().get(string);
            if (string2 == null) continue;
            DatabaseField databaseField2 = new DatabaseField(string2);
            if (databaseField2.getName().equals(string2)) {
                databaseField.setName(string2);
                continue;
            }
            databaseField.setName(databaseField2.getName());
            databaseField.setTable(classDescriptor.getTable(databaseField2.getTable().getName()));
        }
        classDescriptor.rehashFieldDependancies(abstractSession);
    }

    @Override
    public Object unwrapKey(Object object, AbstractSession abstractSession) {
        return object;
    }

    @Override
    public Object wrapKey(Object object, AbstractSession abstractSession) {
        return object;
    }

    @Override
    public void writeFromAttributeIntoRow(Object object, AbstractRecord abstractRecord, AbstractSession abstractSession) {
        this.writeToRowFromAggregate(abstractRecord, null, object, abstractSession);
    }

    @Override
    public Object valueFromObject(Object object, DatabaseField databaseField, AbstractSession abstractSession) throws DescriptorException {
        Object object2 = this.getAttributeValueFromObject(object);
        if (object2 == null) {
            if (this.isNullAllowed()) {
                return null;
            }
            throw DescriptorException.nullForNonNullAggregate(object, this);
        }
        return this.getObjectBuilder(object2, abstractSession).extractValueFromObjectForField(object2, databaseField, abstractSession);
    }

    @Override
    public void writeFromObjectIntoRow(Object object, AbstractRecord abstractRecord, AbstractSession abstractSession) throws DescriptorException {
        if (this.isReadOnly()) {
            return;
        }
        this.writeToRowFromAggregate(abstractRecord, object, this.getAttributeValueFromObject(object), abstractSession);
    }

    @Override
    public void writeFromObjectIntoRowWithChangeRecord(ChangeRecord changeRecord, AbstractRecord abstractRecord, AbstractSession abstractSession) throws DescriptorException {
        if (this.isReadOnly()) {
            return;
        }
        this.writeToRowFromAggregateWithChangeRecord(abstractRecord, changeRecord, (ObjectChangeSet)((AggregateChangeRecord)changeRecord).getChangedObject(), abstractSession);
    }

    @Override
    public void writeFromObjectIntoRowForUpdate(WriteObjectQuery writeObjectQuery, AbstractRecord abstractRecord) throws DescriptorException {
        if (this.isReadOnly()) {
            return;
        }
        this.writeToRowFromAggregateForUpdate(abstractRecord, writeObjectQuery, this.getAttributeValueFromObject(writeObjectQuery.getObject()));
    }

    @Override
    public void writeInsertFieldsIntoRow(AbstractRecord abstractRecord, AbstractSession abstractSession) {
        if (this.isReadOnly()) {
            return;
        }
        AbstractRecord abstractRecord2 = this.buildTemplateInsertRow(abstractSession);
        Enumeration enumeration = abstractRecord2.keys();
        while (enumeration.hasMoreElements()) {
            DatabaseField databaseField = (DatabaseField)enumeration.nextElement();
            Object object = abstractRecord2.get(databaseField);
            abstractRecord.add(databaseField, object);
        }
    }

    public void addPrimaryKeyJoinField(DatabaseField databaseField, DatabaseField databaseField2) {
        ObjectBuilder objectBuilder = this.getReferenceDescriptor().getObjectBuilder();
        DatabaseMapping databaseMapping = objectBuilder.getMappingForField(databaseField);
        if (databaseMapping != null) {
            objectBuilder.getMappingsByField().put(databaseField2, databaseMapping);
        }
    }
}

