/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings.foundation;

import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.internal.descriptors.DescriptorIterator;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.queries.CollectionContainerPolicy;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.queries.ListContainerPolicy;
import org.eclipse.persistence.internal.queries.MapContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.AggregateCollectionChangeRecord;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.AggregateMapping;
import org.eclipse.persistence.mappings.ContainerMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.queries.DeleteObjectQuery;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.WriteObjectQuery;
import org.eclipse.persistence.sessions.ObjectCopyingPolicy;
import org.eclipse.persistence.sessions.remote.RemoteSession;

public abstract class AbstractCompositeCollectionMapping
extends AggregateMapping
implements ContainerMapping {
    protected DatabaseField field;
    private ContainerPolicy containerPolicy = ContainerPolicy.buildDefaultPolicy();
    protected Converter converter;

    public Object buildAddedElementFromChangeSet(Object object, MergeManager mergeManager) {
        return this.buildElementFromChangeSet(object, mergeManager);
    }

    protected Object buildBackupClonePart(Object object, UnitOfWorkImpl unitOfWorkImpl) {
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        if (object == null) {
            return containerPolicy.containerInstance();
        }
        Object object2 = containerPolicy.containerInstance(containerPolicy.sizeFor(object));
        Object object3 = containerPolicy.iteratorFor(object);
        while (containerPolicy.hasNext(object3)) {
            Object object4 = super.buildBackupClonePart(containerPolicy.next(object3, unitOfWorkImpl), unitOfWorkImpl);
            containerPolicy.addInto(object4, object2, unitOfWorkImpl);
        }
        return object2;
    }

    public Object buildChangeSet(Object object, ObjectChangeSet objectChangeSet, AbstractSession abstractSession) {
        ObjectBuilder objectBuilder = this.getObjectBuilder(object, abstractSession);
        return objectBuilder.compareForChange(object, null, (UnitOfWorkChangeSet)objectChangeSet.getUOWChangeSet(), abstractSession);
    }

    protected Object buildClonePart(Object object, Object object2, UnitOfWorkImpl unitOfWorkImpl) {
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        if (object2 == null) {
            return containerPolicy.containerInstance();
        }
        Object object3 = containerPolicy.containerInstance(containerPolicy.sizeFor(object2));
        Object object4 = containerPolicy.iteratorFor(object2);
        while (containerPolicy.hasNext(object4)) {
            Object object5 = super.buildClonePart(object, containerPolicy.next(object4, unitOfWorkImpl), unitOfWorkImpl);
            containerPolicy.addInto(object5, object3, unitOfWorkImpl);
        }
        return object3;
    }

    protected Object buildCopyOfAttributeValue(Object object, ObjectCopyingPolicy objectCopyingPolicy) {
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        if (object == null) {
            return containerPolicy.containerInstance();
        }
        Object object2 = containerPolicy.containerInstance(containerPolicy.sizeFor(object));
        Object object3 = containerPolicy.iteratorFor(object);
        while (containerPolicy.hasNext(object3)) {
            Object object4 = super.buildCopyOfAttributeValue(containerPolicy.next(object3, objectCopyingPolicy.getSession()), objectCopyingPolicy);
            containerPolicy.addInto(object4, object2, objectCopyingPolicy.getSession());
        }
        return object2;
    }

    protected Object buildElementFromChangeSet(Object object, MergeManager mergeManager) {
        ObjectChangeSet objectChangeSet = (ObjectChangeSet)object;
        ObjectBuilder objectBuilder = this.getObjectBuilderForClass(objectChangeSet.getClassType(mergeManager.getSession()), mergeManager.getSession());
        Object object2 = objectBuilder.buildNewInstance();
        objectBuilder.mergeChangesIntoObject(object2, objectChangeSet, null, mergeManager);
        return object2;
    }

    public Object buildElementFromElement(Object object, MergeManager mergeManager) {
        ObjectBuilder objectBuilder = this.getObjectBuilder(object, mergeManager.getSession());
        Object object2 = objectBuilder.buildNewInstance();
        objectBuilder.mergeIntoObject(object2, true, object, mergeManager);
        return object2;
    }

    public Object buildRemovedElementFromChangeSet(Object object, MergeManager mergeManager) {
        return this.buildElementFromChangeSet(object, mergeManager);
    }

    public void cascadePerformRemoveIfRequired(Object object, UnitOfWorkImpl unitOfWorkImpl, Map map) {
        Object object2 = null;
        object2 = this.getAttributeValueFromObject(object);
        if (object2 == null) {
            return;
        }
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object object3 = null;
        object3 = this.getRealCollectionAttributeValueFromObject(object, unitOfWorkImpl);
        Object object4 = containerPolicy.iteratorFor(object3);
        while (containerPolicy.hasNext(object4)) {
            Object object5 = containerPolicy.next(object4, unitOfWorkImpl);
            if (object5 == null || map.containsKey(object5)) continue;
            map.put(object5, object5);
            ObjectBuilder objectBuilder = this.getReferenceDescriptor(object5.getClass(), (AbstractSession)unitOfWorkImpl).getObjectBuilder();
            objectBuilder.cascadePerformRemove(object5, unitOfWorkImpl, map);
        }
    }

    public void cascadeDiscoverAndPersistUnregisteredNewObjects(Object object, Map map, Map map2, Map map3, UnitOfWorkImpl unitOfWorkImpl) {
        Object object2 = this.getAttributeValueFromObject(object);
        if (object2 == null) {
            return;
        }
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object object3 = this.getRealCollectionAttributeValueFromObject(object, unitOfWorkImpl);
        Object object4 = containerPolicy.iteratorFor(object3);
        while (containerPolicy.hasNext(object4)) {
            Object object5 = containerPolicy.next(object4, unitOfWorkImpl);
            if (object5 == null) continue;
            ObjectBuilder objectBuilder = this.getReferenceDescriptor(object5.getClass(), (AbstractSession)unitOfWorkImpl).getObjectBuilder();
            objectBuilder.cascadeDiscoverAndPersistUnregisteredNewObjects(object5, map, map2, map3, unitOfWorkImpl);
        }
    }

    public void cascadeRegisterNewIfRequired(Object object, UnitOfWorkImpl unitOfWorkImpl, Map map) {
        Object object2 = null;
        object2 = this.getAttributeValueFromObject(object);
        if (object2 == null) {
            return;
        }
        ObjectBuilder objectBuilder = null;
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object object3 = null;
        object3 = this.getRealCollectionAttributeValueFromObject(object, unitOfWorkImpl);
        Object object4 = containerPolicy.iteratorFor(object3);
        while (containerPolicy.hasNext(object4)) {
            Object object5 = containerPolicy.next(object4, unitOfWorkImpl);
            if (object5 == null || map.containsKey(object5)) continue;
            map.put(object5, object5);
            objectBuilder = this.getReferenceDescriptor(object5.getClass(), (AbstractSession)unitOfWorkImpl).getObjectBuilder();
            objectBuilder.cascadeRegisterNewForCreate(object5, unitOfWorkImpl, map);
        }
    }

    protected Vector collectFields() {
        Vector<DatabaseField> vector = new Vector<DatabaseField>(1);
        vector.addElement(this.getField());
        return vector;
    }

    public boolean compareElements(Object object, Object object2, AbstractSession abstractSession) {
        if (object.getClass() != object2.getClass()) {
            return false;
        }
        return this.getObjectBuilder(object, abstractSession).compareObjects(object, object2, abstractSession);
    }

    public boolean compareElementsForChange(Object object, Object object2, AbstractSession abstractSession) {
        return this.compareElements(object, object2, abstractSession);
    }

    public ChangeRecord compareForChange(Object object, Object object2, ObjectChangeSet objectChangeSet, AbstractSession abstractSession) {
        Object object3 = null;
        Object object4 = null;
        if (abstractSession.isClassReadOnly(this.getReferenceClass())) {
            return null;
        }
        object3 = this.getAttributeValueFromObject(object);
        if (!objectChangeSet.isNew()) {
            object4 = this.getAttributeValueFromObject(object2);
            if (object4 == null && object3 == null) {
                return null;
            }
            ContainerPolicy containerPolicy = this.getContainerPolicy();
            Object object5 = null;
            Object object6 = null;
            object6 = this.getRealCollectionAttributeValueFromObject(object, abstractSession);
            object5 = this.getRealCollectionAttributeValueFromObject(object2, abstractSession);
            if (containerPolicy.sizeFor(object5) != containerPolicy.sizeFor(object6)) {
                return this.convertToChangeRecord(object6, objectChangeSet, abstractSession);
            }
            Object object7 = containerPolicy.iteratorFor(object6);
            Object object8 = containerPolicy.iteratorFor(object5);
            boolean bl = false;
            UnitOfWorkChangeSet unitOfWorkChangeSet = new UnitOfWorkChangeSet(abstractSession);
            while (containerPolicy.hasNext(object7)) {
                Object object9 = containerPolicy.next(object7, abstractSession);
                if (object9 == null) {
                    bl = true;
                    break;
                }
                Object object10 = null;
                if (!containerPolicy.hasNext(object8)) {
                    bl = true;
                    break;
                }
                object10 = containerPolicy.next(object8, abstractSession);
                if (object9.getClass().equals(object10.getClass())) {
                    ObjectBuilder objectBuilder = this.getReferenceDescriptor(object9.getClass(), abstractSession).getObjectBuilder();
                    ObjectChangeSet objectChangeSet2 = objectBuilder.createObjectChangeSet(object9, unitOfWorkChangeSet, objectChangeSet.isNew(), abstractSession);
                    ObjectChangeSet objectChangeSet3 = objectBuilder.compareForChange(object9, object10, unitOfWorkChangeSet, abstractSession);
                    if (objectChangeSet3 == null) continue;
                    bl = true;
                    break;
                }
                bl = true;
                break;
            }
            if (bl || containerPolicy.hasNext(object8)) {
                return this.convertToChangeRecord(object6, objectChangeSet, abstractSession);
            }
            return null;
        }
        return this.convertToChangeRecord(this.getRealCollectionAttributeValueFromObject(object, abstractSession), objectChangeSet, abstractSession);
    }

    public void convertClassNamesToClasses(ClassLoader classLoader) {
        super.convertClassNamesToClasses(classLoader);
        this.containerPolicy.convertClassNamesToClasses(classLoader);
    }

    protected ChangeRecord convertToChangeRecord(Object object, ObjectChangeSet objectChangeSet, AbstractSession abstractSession) {
        Object object2;
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object object3 = containerPolicy.iteratorFor(object);
        Vector<ObjectChangeSet> vector = new Vector<ObjectChangeSet>(2);
        while (containerPolicy.hasNext(object3)) {
            object2 = containerPolicy.next(object3, abstractSession);
            if (object2 == null) continue;
            ObjectChangeSet objectChangeSet2 = this.getReferenceDescriptor(object2.getClass(), abstractSession).getObjectBuilder().compareForChange(object2, null, (UnitOfWorkChangeSet)objectChangeSet.getUOWChangeSet(), abstractSession);
            vector.addElement(objectChangeSet2);
        }
        object2 = new AggregateCollectionChangeRecord(objectChangeSet);
        ((ChangeRecord)object2).setAttribute(this.getAttributeName());
        ((ChangeRecord)object2).setMapping(this);
        ((AggregateCollectionChangeRecord)object2).setChangedValues(vector);
        return object2;
    }

    public boolean compareObjects(Object object, Object object2, AbstractSession abstractSession) {
        Object object3 = this.getRealCollectionAttributeValueFromObject(object, abstractSession);
        Object object4 = this.getRealCollectionAttributeValueFromObject(object2, abstractSession);
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        if (containerPolicy.sizeFor(object3) != containerPolicy.sizeFor(object4)) {
            return false;
        }
        if (containerPolicy.sizeFor(object3) == 0) {
            return true;
        }
        Object object5 = containerPolicy.iteratorFor(object3);
        Object object6 = containerPolicy.iteratorFor(object4);
        while (containerPolicy.hasNext(object5)) {
            Object object7 = containerPolicy.next(object5, abstractSession);
            Object object8 = containerPolicy.next(object6, abstractSession);
            if (this.getReferenceDescriptor().getObjectBuilder().compareObjects(object7, object8, abstractSession)) continue;
            return false;
        }
        return true;
    }

    protected void fixAttributeValue(Object object, Map map, Map map2, ObjectLevelReadQuery objectLevelReadQuery, RemoteSession remoteSession) {
        if (object == null) {
            return;
        }
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object object2 = containerPolicy.iteratorFor(object);
        while (containerPolicy.hasNext(object2)) {
            super.fixAttributeValue(containerPolicy.next(object2, remoteSession), map, map2, objectLevelReadQuery, remoteSession);
        }
    }

    protected Object getAttributeValueFromBackupClone(Object object) {
        return null;
    }

    public ContainerPolicy getContainerPolicy() {
        return this.containerPolicy;
    }

    public Converter getConverter() {
        return this.converter;
    }

    public DatabaseField getField() {
        return this.field;
    }

    public Object getRealCollectionAttributeValueFromObject(Object object, AbstractSession abstractSession) throws DescriptorException {
        Object object2 = this.getRealAttributeValueFromObject(object, abstractSession);
        if (object2 == null) {
            object2 = this.getContainerPolicy().containerInstance(1);
        }
        return object2;
    }

    protected String getStructureName() {
        return "";
    }

    public boolean hasConverter() {
        return this.getConverter() != null;
    }

    public boolean isAbstractCompositeCollectionMapping() {
        return true;
    }

    public void initialize(AbstractSession abstractSession) throws DescriptorException {
        super.initialize(abstractSession);
        if (this.getField() == null) {
            throw DescriptorException.fieldNameNotSetInMapping(this);
        }
        this.setField(this.getDescriptor().buildField(this.getField()));
        this.setFields(this.collectFields());
        if (this.hasConverter()) {
            this.getConverter().initialize(this, abstractSession);
        }
    }

    protected void iterateOnAttributeValue(DescriptorIterator descriptorIterator, Object object) {
        if (object == null) {
            return;
        }
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object object2 = containerPolicy.iteratorFor(object);
        while (containerPolicy.hasNext(object2)) {
            super.iterateOnAttributeValue(descriptorIterator, containerPolicy.next(object2, descriptorIterator.getSession()));
        }
    }

    public boolean mapKeyHasChanged(Object object, AbstractSession abstractSession) {
        return false;
    }

    public void mergeChangesIntoObject(Object object, ChangeRecord changeRecord, Object object2, MergeManager mergeManager) {
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        AbstractSession abstractSession = mergeManager.getSession();
        Vector vector = ((AggregateCollectionChangeRecord)changeRecord).getChangedValues();
        Object object3 = containerPolicy.containerInstance();
        ObjectChangeSet objectChangeSet = null;
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            objectChangeSet = (ObjectChangeSet)vector.get(i);
            containerPolicy.addInto(this.buildElementFromChangeSet(objectChangeSet, mergeManager), object3, abstractSession);
        }
        this.setRealAttributeValueInObject(object, object3);
    }

    public void mergeIntoObject(Object object, boolean bl, Object object2, MergeManager mergeManager) {
        if (!mergeManager.shouldCascadeReferences()) {
            return;
        }
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object object3 = this.getRealCollectionAttributeValueFromObject(object2, mergeManager.getSession());
        Object object4 = containerPolicy.containerInstance(containerPolicy.sizeFor(object3));
        Object object5 = containerPolicy.iteratorFor(object3);
        while (containerPolicy.hasNext(object5)) {
            Object object6 = containerPolicy.next(object5, mergeManager.getSession());
            Object object7 = this.getReferenceDescriptor(object6.getClass(), mergeManager.getSession()).getObjectBuilder().buildNewInstance();
            this.getReferenceDescriptor(object6.getClass(), mergeManager.getSession()).getObjectBuilder().mergeIntoObject(object7, true, object6, mergeManager);
            containerPolicy.addInto(object7, object4, mergeManager.getSession());
        }
        this.setRealAttributeValueInObject(object, object4);
    }

    public void postDeleteAttributeValue(DeleteObjectQuery deleteObjectQuery, Object object) throws DatabaseException, OptimisticLockException {
        if (object == null) {
            return;
        }
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object object2 = containerPolicy.iteratorFor(object);
        while (containerPolicy.hasNext(object2)) {
            super.postDeleteAttributeValue(deleteObjectQuery, containerPolicy.next(object2, deleteObjectQuery.getSession()));
        }
    }

    public void postInsertAttributeValue(WriteObjectQuery writeObjectQuery, Object object) throws DatabaseException, OptimisticLockException {
        if (object == null) {
            return;
        }
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object object2 = containerPolicy.iteratorFor(object);
        while (containerPolicy.hasNext(object2)) {
            super.postInsertAttributeValue(writeObjectQuery, containerPolicy.next(object2, writeObjectQuery.getSession()));
        }
    }

    public void postUpdateAttributeValue(WriteObjectQuery writeObjectQuery, Object object) throws DatabaseException, OptimisticLockException {
        if (object == null) {
            return;
        }
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object object2 = containerPolicy.iteratorFor(object);
        while (containerPolicy.hasNext(object2)) {
            super.postUpdateAttributeValue(writeObjectQuery, containerPolicy.next(object2, writeObjectQuery.getSession()));
        }
    }

    public void preDeleteAttributeValue(DeleteObjectQuery deleteObjectQuery, Object object) throws DatabaseException, OptimisticLockException {
        if (object == null) {
            return;
        }
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object object2 = containerPolicy.iteratorFor(object);
        while (containerPolicy.hasNext(object2)) {
            super.preDeleteAttributeValue(deleteObjectQuery, containerPolicy.next(object2, deleteObjectQuery.getSession()));
        }
    }

    public void preInsertAttributeValue(WriteObjectQuery writeObjectQuery, Object object) throws DatabaseException, OptimisticLockException {
        if (object == null) {
            return;
        }
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object object2 = containerPolicy.iteratorFor(object);
        while (containerPolicy.hasNext(object2)) {
            super.preInsertAttributeValue(writeObjectQuery, containerPolicy.next(object2, writeObjectQuery.getSession()));
        }
    }

    public void preUpdateAttributeValue(WriteObjectQuery writeObjectQuery, Object object) throws DatabaseException, OptimisticLockException {
        if (object == null) {
            return;
        }
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object object2 = containerPolicy.iteratorFor(object);
        while (containerPolicy.hasNext(object2)) {
            super.preUpdateAttributeValue(writeObjectQuery, containerPolicy.next(object2, writeObjectQuery.getSession()));
        }
    }

    public void setContainerPolicy(ContainerPolicy containerPolicy) {
        this.containerPolicy = containerPolicy;
    }

    public void setConverter(Converter converter) {
        this.converter = converter;
    }

    public void setField(DatabaseField databaseField) {
        this.field = databaseField;
    }

    public void simpleAddToCollectionChangeRecord(Object object, Object object2, ObjectChangeSet objectChangeSet, AbstractSession abstractSession) {
        AggregateCollectionChangeRecord aggregateCollectionChangeRecord = (AggregateCollectionChangeRecord)objectChangeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (aggregateCollectionChangeRecord == null) {
            Object object3 = ((UnitOfWorkChangeSet)objectChangeSet.getUOWChangeSet()).getUOWCloneForObjectChangeSet(objectChangeSet);
            Object object4 = this.getRealAttributeValueFromObject(object3, abstractSession);
            aggregateCollectionChangeRecord = (AggregateCollectionChangeRecord)this.convertToChangeRecord(object4, objectChangeSet, abstractSession);
            objectChangeSet.addChange(aggregateCollectionChangeRecord);
        } else {
            aggregateCollectionChangeRecord.getChangedValues().add(object2);
        }
    }

    public void simpleRemoveFromCollectionChangeRecord(Object object, Object object2, ObjectChangeSet objectChangeSet, AbstractSession abstractSession) {
        AggregateCollectionChangeRecord aggregateCollectionChangeRecord = (AggregateCollectionChangeRecord)objectChangeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (aggregateCollectionChangeRecord == null) {
            Object object3 = ((UnitOfWorkChangeSet)objectChangeSet.getUOWChangeSet()).getUOWCloneForObjectChangeSet(objectChangeSet);
            Object object4 = this.getRealAttributeValueFromObject(object3, abstractSession);
            aggregateCollectionChangeRecord = (AggregateCollectionChangeRecord)this.convertToChangeRecord(object4, objectChangeSet, abstractSession);
            objectChangeSet.addChange(aggregateCollectionChangeRecord);
        } else {
            aggregateCollectionChangeRecord.getChangedValues().remove(object2);
        }
    }

    public void useCollectionClass(Class clazz) {
        this.setContainerPolicy(ContainerPolicy.buildPolicyFor(clazz));
    }

    public void useCollectionClassName(String string) {
        this.setContainerPolicy(new CollectionContainerPolicy(string));
    }

    public void useListClassName(String string) {
        this.setContainerPolicy(new ListContainerPolicy(string));
    }

    public void useMapClass(Class clazz, String string) {
        if (this.getReferenceClass() == null) {
            throw DescriptorException.referenceClassNotSpecified(this);
        }
        ContainerPolicy containerPolicy = ContainerPolicy.buildPolicyFor(clazz);
        containerPolicy.setKeyName(string, this.getReferenceClass());
        this.setContainerPolicy(containerPolicy);
    }

    public void useMapClassName(String string, String string2) {
        if (this.getReferenceClassName() == null) {
            throw DescriptorException.referenceClassNotSpecified(this);
        }
        MapContainerPolicy mapContainerPolicy = new MapContainerPolicy(string);
        mapContainerPolicy.setKeyName(string2, this.getReferenceClass().getName());
        this.setContainerPolicy(mapContainerPolicy);
    }

    public Object valueFromRow(AbstractRecord abstractRecord, JoinedAttributeManager joinedAttributeManager, ObjectBuildingQuery objectBuildingQuery, AbstractSession abstractSession) throws DatabaseException {
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object object = abstractRecord.getValues(this.getField());
        if (object == null || object instanceof String) {
            return containerPolicy.containerInstance();
        }
        Vector vector = this.getReferenceDescriptor().buildNestedRowsFromFieldValue(object, abstractSession);
        if (vector == null) {
            return containerPolicy.containerInstance();
        }
        Object object2 = containerPolicy.containerInstance(vector.size());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Object object3;
            AbstractRecord abstractRecord2 = (AbstractRecord)enumeration.nextElement();
            ClassDescriptor classDescriptor = this.getReferenceDescriptor();
            if (classDescriptor.hasInheritance()) {
                object3 = classDescriptor.getInheritancePolicy().classFromRow(abstractRecord2, abstractSession);
                classDescriptor = this.getReferenceDescriptor((Class)object3, abstractSession);
            }
            object3 = this.buildCompositeObject(classDescriptor, abstractRecord2, objectBuildingQuery, joinedAttributeManager);
            if (this.hasConverter()) {
                object3 = this.getConverter().convertDataValueToObjectValue(object3, abstractSession);
            }
            containerPolicy.addInto(object3, object2, objectBuildingQuery.getSession());
        }
        return object2;
    }

    protected abstract Object buildCompositeObject(ClassDescriptor var1, AbstractRecord var2, ObjectBuildingQuery var3, JoinedAttributeManager var4);

    protected boolean verifyDeleteOfAttributeValue(Object object, AbstractSession abstractSession) throws DatabaseException {
        if (object == null) {
            return true;
        }
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object object2 = containerPolicy.iteratorFor(object);
        while (containerPolicy.hasNext(object2)) {
            if (super.verifyDeleteOfAttributeValue(containerPolicy.next(object2, abstractSession), abstractSession)) continue;
            return false;
        }
        return true;
    }

    public void writeFromObjectIntoRow(Object object, AbstractRecord abstractRecord, AbstractSession abstractSession) throws DescriptorException {
        if (this.isReadOnly()) {
            return;
        }
        Object object2 = this.getAttributeValueFromObject(object);
        if (object2 == null) {
            abstractRecord.put(this.getField(), (Object)null);
            return;
        }
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Vector<AbstractRecord> vector = new Vector<AbstractRecord>(containerPolicy.sizeFor(object2));
        Object object3 = containerPolicy.iteratorFor(object2);
        while (containerPolicy.hasNext(object3)) {
            Object object4 = containerPolicy.next(object3, abstractSession);
            if (this.hasConverter()) {
                object4 = this.getConverter().convertObjectValueToDataValue(object4, abstractSession);
            }
            vector.addElement(this.buildCompositeRow(object4, abstractSession, abstractRecord));
        }
        object3 = null;
        if (!vector.isEmpty()) {
            object3 = this.getReferenceDescriptor().buildFieldValueFromNestedRows(vector, this.getStructureName(), abstractSession);
        }
        abstractRecord.put(this.getField(), object3);
    }

    protected abstract AbstractRecord buildCompositeRow(Object var1, AbstractSession var2, AbstractRecord var3);

    public void writeFromObjectIntoRowForUpdate(WriteObjectQuery writeObjectQuery, AbstractRecord abstractRecord) throws DescriptorException {
        AbstractSession abstractSession = writeObjectQuery.getSession();
        if (abstractSession.isClassReadOnly(this.getReferenceClass())) {
            return;
        }
        if (abstractSession.isUnitOfWork() && this.compareObjects(writeObjectQuery.getObject(), writeObjectQuery.getBackupClone(), abstractSession)) {
            return;
        }
        this.writeFromObjectIntoRow(writeObjectQuery.getObject(), abstractRecord, abstractSession);
    }

    public void writeFromObjectIntoRowWithChangeRecord(ChangeRecord changeRecord, AbstractRecord abstractRecord, AbstractSession abstractSession) throws DescriptorException {
        Object object = ((ObjectChangeSet)changeRecord.getOwner()).getUnitOfWorkClone();
        this.writeFromObjectIntoRow(object, abstractRecord, abstractSession);
    }

    public void writeInsertFieldsIntoRow(AbstractRecord abstractRecord, AbstractSession abstractSession) {
        if (this.isReadOnly()) {
            return;
        }
        abstractRecord.put(this.getField(), (Object)null);
    }

    public boolean isCollectionMapping() {
        return true;
    }
}

