/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.record;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.oxm.MarshalRecordContentHandler;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.record.XMLFragmentReader;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.record.MarshalRecord;
import org.eclipse.persistence.platform.xml.XMLPlatform;
import org.eclipse.persistence.platform.xml.XMLPlatformFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class NodeRecord
extends MarshalRecord {
    private Document document;
    private Stack nodes;

    public NodeRecord() {
        XMLPlatform xMLPlatform = XMLPlatformFactory.getInstance().getXMLPlatform();
        this.document = xMLPlatform.createDocument();
    }

    public NodeRecord(String string) {
        this(string, (NamespaceResolver)null);
    }

    public NodeRecord(String string, NamespaceResolver namespaceResolver) {
        this();
        String string2 = this.resolveNamespace(namespaceResolver, string);
        Element element = this.document.createElementNS(string2, string);
        this.document.appendChild(element);
        this.setDOM(element);
    }

    public NodeRecord(String string, Node node) {
        this(string, null, node);
    }

    public NodeRecord(String string, NamespaceResolver namespaceResolver, Node node) {
        this();
        Document document = node instanceof Document ? (Document)node : node.getOwnerDocument();
        String string2 = this.resolveNamespace(namespaceResolver, string);
        Element element = document.createElementNS(string2, string);
        node.appendChild(element);
        this.setDOM(element);
    }

    public NodeRecord(Element element) {
        this();
        this.setDOM(element);
    }

    public NodeRecord(Document document) {
        this();
        this.setDOM(document.getDocumentElement());
    }

    public String getLocalName() {
        return this.getNode().getLocalName();
    }

    public String getNamespaceURI() {
        return this.getNode().getNamespaceURI();
    }

    public void clear() {
    }

    public Document getDocument() {
        return this.document;
    }

    public Element getDOM() {
        return (Element)this.nodes.peek();
    }

    private Node getNode() {
        return (Node)this.nodes.peek();
    }

    public void setDOM(Node node) {
        this.nodes = new Stack();
        if (node.getNodeType() == 9) {
            this.document = (Document)node;
        } else if (node.getNodeType() == 1 || node.getNodeType() == 11) {
            this.document = node.getOwnerDocument();
            this.nodes.push(node);
            this.getNamespaceResolver().setDOM(node);
        } else {
            throw XMLMarshalException.marshalException(null);
        }
    }

    public String transformToXML() {
        return null;
    }

    public void startDocument(String string, String string2) {
    }

    public void endDocument() {
    }

    public void node(Node node, NamespaceResolver namespaceResolver) {
        if (node.getNodeType() == 2) {
            Attr attr = (Attr)node;
            String string = null;
            if (namespaceResolver != null) {
                string = namespaceResolver.resolveNamespaceURI(attr.getNamespaceURI());
            }
            if (string != null) {
                this.attribute(attr.getNamespaceURI(), "", string + ":" + attr.getLocalName(), attr.getNodeValue());
            } else {
                this.attribute(attr.getNamespaceURI(), "", attr.getName(), attr.getNodeValue());
                if (attr.getNamespaceURI() != null) {
                    this.attribute("http://www.w3.org/2000/xmlns/", "", "xmlns:" + attr.getPrefix(), attr.getNamespaceURI());
                }
            }
        } else if (node.getNodeType() == 3) {
            this.characters(node.getNodeValue());
        } else {
            NodeRecordContentHandler nodeRecordContentHandler = new NodeRecordContentHandler(this, namespaceResolver);
            XMLFragmentReader xMLFragmentReader = new XMLFragmentReader(namespaceResolver);
            xMLFragmentReader.setContentHandler(nodeRecordContentHandler);
            try {
                xMLFragmentReader.parse(node);
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
        }
    }

    public void openStartElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        super.openStartElement(xPathFragment, namespaceResolver);
        String string = this.resolveNamespacePrefix(xPathFragment, namespaceResolver);
        Element element = this.getDocument().createElementNS(string, xPathFragment.getShortName());
        try {
            this.getNode().appendChild(element);
            this.nodes.push(element);
        }
        catch (Exception exception) {
            this.document.appendChild(element);
            this.setDOM(element);
            this.nodes.push(element);
        }
    }

    public void element(String string, String string2, String string3) {
        Element element = this.getDocument().createElementNS(string, string3);
        this.getNode().appendChild(element);
    }

    public void attribute(XPathFragment xPathFragment, NamespaceResolver namespaceResolver, String string) {
        String string2 = this.resolveNamespacePrefix(xPathFragment, namespaceResolver);
        if (this.getNode().getNodeType() == 1) {
            this.getDOM().setAttributeNS(string2, xPathFragment.getShortName(), string);
        }
    }

    public void attribute(String string, String string2, String string3, String string4) {
        if (this.getNode().getNodeType() == 1) {
            this.getDOM().setAttributeNS(string, string3, string4);
        }
    }

    public void closeStartElement() {
    }

    public void endElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        this.nodes.pop();
    }

    public void characters(String string) {
        Text text = this.getDocument().createTextNode(string);
        this.getNode().appendChild(text);
    }

    public void cdata(String string) {
        CDATASection cDATASection = this.getDocument().createCDATASection(string);
        this.getNode().appendChild(cDATASection);
    }

    private String resolveNamespace(NamespaceResolver namespaceResolver, String string) {
        int n = string.indexOf(58);
        if (n < 0) {
            if (namespaceResolver != null) {
                return namespaceResolver.resolveNamespacePrefix("");
            }
            return null;
        }
        if (namespaceResolver == null) {
            throw XMLMarshalException.namespaceResolverNotSpecified(string);
        }
        String string2 = string.substring(0, n);
        String string3 = namespaceResolver.resolveNamespacePrefix(string2);
        if (string3 == null) {
            throw XMLMarshalException.namespaceNotFound(string2);
        }
        return string3;
    }

    protected class NodeRecordContentHandler
    extends MarshalRecordContentHandler {
        Map<String, String> prefixMappings;

        public NodeRecordContentHandler(NodeRecord nodeRecord2, NamespaceResolver namespaceResolver) {
            super(nodeRecord2, namespaceResolver);
            this.prefixMappings = new HashMap<String, String>();
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            Element element = string == null ? NodeRecord.this.getDocument().createElement(string3) : NodeRecord.this.getDocument().createElementNS(string, string3);
            try {
                NodeRecord.this.getNode().appendChild(element);
                NodeRecord.this.nodes.push(element);
            }
            catch (Exception exception) {
                NodeRecord.this.document.appendChild(element);
                NodeRecord.this.setDOM(element);
                NodeRecord.this.nodes.push(element);
            }
            for (int i = 0; i < attributes.getLength(); ++i) {
                this.marshalRecord.attribute(attributes.getURI(i), attributes.getLocalName(i), attributes.getQName(i), attributes.getValue(i));
            }
            if (!this.prefixMappings.isEmpty()) {
                for (String string4 : this.prefixMappings.keySet()) {
                    element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + string4, this.prefixMappings.get(string4));
                }
                this.prefixMappings.clear();
            }
            this.marshalRecord.closeStartElement();
        }

        public void startPrefixMapping(String string, String string2) throws SAXException {
            String string3 = NodeRecord.this.getNamespaceResolver().resolveNamespacePrefix(string);
            if (string3 == null || !string3.equals(string2)) {
                this.prefixMappings.put(string, string2);
            }
        }
    }
}

