/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Hashtable;
import org.eclipse.persistence.expressions.ExpressionOperator;
import org.eclipse.persistence.internal.databaseaccess.FieldTypeDefinition;
import org.eclipse.persistence.platform.database.DatabasePlatform;

public class PointBasePlatform
extends DatabasePlatform {
    protected void appendBoolean(Boolean bl, Writer writer) throws IOException {
        writer.write(bl.toString());
    }

    protected void appendTime(Time time, Writer writer) throws IOException {
        writer.write("TIME '" + time + "'");
    }

    protected void appendDate(Date date, Writer writer) throws IOException {
        writer.write("DATE '" + date + "'");
    }

    protected void appendTimestamp(Timestamp timestamp, Writer writer) throws IOException {
        writer.write("TIMESTAMP '" + timestamp + "'");
    }

    protected Hashtable buildClassTypes() {
        Hashtable hashtable = super.buildClassTypes();
        hashtable.put("FLOAT", Double.class);
        hashtable.put("DOUBLE PRECISION", Double.class);
        hashtable.put("CHARACTER", String.class);
        hashtable.put("CLOB", Character[].class);
        hashtable.put("BLOB", Byte[].class);
        hashtable.put("BOOLEAN", Boolean.class);
        return hashtable;
    }

    protected Hashtable buildFieldTypes() {
        Hashtable hashtable = super.buildFieldTypes();
        hashtable.put(Boolean.class, new FieldTypeDefinition("BOOLEAN"));
        hashtable.put(Long.class, new FieldTypeDefinition("NUMERIC", 19));
        hashtable.put(Short.class, new FieldTypeDefinition("NUMERIC", 5));
        hashtable.put(Byte.class, new FieldTypeDefinition("NUMERIC", 3));
        hashtable.put(BigInteger.class, new FieldTypeDefinition("NUMERIC", 19));
        hashtable.put(Integer.class, new FieldTypeDefinition("INTEGER", false));
        hashtable.put(Float.class, new FieldTypeDefinition("REAL", false));
        hashtable.put(Double.class, new FieldTypeDefinition("DOUBLE", false));
        hashtable.put(Short.class, new FieldTypeDefinition("SMALLINT", false));
        hashtable.put(BigDecimal.class, new FieldTypeDefinition("DECIMAL"));
        hashtable.put(Number.class, new FieldTypeDefinition("DECIMAL"));
        hashtable.put(Character.class, new FieldTypeDefinition("CHARACTER"));
        return hashtable;
    }

    protected void initializePlatformOperators() {
        super.initializePlatformOperators();
        this.addOperator(ExpressionOperator.simpleMath(31, "||"));
    }

    public boolean isPointBase() {
        return true;
    }
}

