/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo;

import commonj.sdo.helper.HelperContext;
import commonj.sdo.impl.ExternalizableDelegator;
import commonj.sdo.impl.HelperProvider;
import java.io.IOException;
import java.io.ObjectInput;
import java.lang.reflect.Field;
import org.eclipse.persistence.exceptions.SDOException;
import org.eclipse.persistence.internal.security.PrivilegedGetField;
import org.eclipse.persistence.internal.security.PrivilegedGetValueFromField;
import org.eclipse.persistence.internal.security.PrivilegedSetValueInField;
import org.eclipse.persistence.sdo.SDOResolvable;
import org.eclipse.persistence.sdo.helper.DataObjectInputStream;
import org.eclipse.persistence.sdo.helper.SDOHelperContext;

public class SDOExternalizableDelegator
extends ExternalizableDelegator {
    static final PrivilegedGetField privilegedGetDelegateField = new PrivilegedGetField(ExternalizableDelegator.class, "delegate", true);

    public SDOExternalizableDelegator() {
    }

    public SDOExternalizableDelegator(Object object) {
        super(object);
    }

    public SDOExternalizableDelegator(Object object, HelperContext helperContext) {
        if (helperContext instanceof SDOHelperContext) {
            this.setDelegate(((SDOHelperContext)helperContext).createResolvable(object));
        } else {
            this.setDelegate(HelperProvider.createResolvable((Object)object));
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        if (objectInput instanceof DataObjectInputStream) {
            this.getDelegate().setHelperContext(((DataObjectInputStream)objectInput).getHelperContext());
        }
        super.readExternal(objectInput);
    }

    private SDOResolvable getDelegate() {
        try {
            Field field = (Field)privilegedGetDelegateField.run();
            PrivilegedGetValueFromField privilegedGetValueFromField = new PrivilegedGetValueFromField(field, (Object)this);
            return (SDOResolvable)privilegedGetValueFromField.run();
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw SDOException.errorAccessingExternalizableDelegator("delegate", noSuchFieldException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw SDOException.errorAccessingExternalizableDelegator("delegate", illegalAccessException);
        }
    }

    private void setDelegate(ExternalizableDelegator.Resolvable resolvable) {
        try {
            Field field = (Field)privilegedGetDelegateField.run();
            PrivilegedSetValueInField privilegedSetValueInField = new PrivilegedSetValueInField(field, (Object)this, resolvable);
            privilegedSetValueInField.run();
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw SDOException.errorAccessingExternalizableDelegator("delegate", noSuchFieldException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw SDOException.errorAccessingExternalizableDelegator("delegate", illegalAccessException);
        }
    }
}

