/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper;

import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.helper.EqualityHelper;
import commonj.sdo.helper.HelperContext;
import commonj.sdo.impl.HelperProvider;
import java.util.List;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.oxm.sequenced.Setting;
import org.eclipse.persistence.sdo.SDODataObject;
import org.eclipse.persistence.sdo.SDOProperty;
import org.eclipse.persistence.sdo.SDOSequence;

public class SDOEqualityHelper
implements EqualityHelper {
    private HelperContext aHelperContext;

    public SDOEqualityHelper() {
    }

    public SDOEqualityHelper(HelperContext helperContext) {
        this.aHelperContext = helperContext;
    }

    public boolean equalShallow(DataObject dataObject, DataObject dataObject2) {
        return this.compareDataObjects(dataObject, dataObject2, false);
    }

    public boolean equal(DataObject dataObject, DataObject dataObject2) {
        return this.compareDataObjects(dataObject, dataObject2, true);
    }

    private boolean compareDataObjects(DataObject dataObject, DataObject dataObject2, boolean bl) {
        if (null == dataObject) {
            return dataObject2 == null;
        }
        if (null == dataObject2) {
            return false;
        }
        if (dataObject.getType() != dataObject2.getType()) {
            return false;
        }
        if (dataObject.getType().isSequenced() && !this.compareSequences((SDOSequence)dataObject.getSequence(), (SDOSequence)dataObject2.getSequence(), bl)) {
            return false;
        }
        if (!this.compare(dataObject, dataObject2, bl, dataObject.getType().getProperties())) {
            return false;
        }
        List list = ((SDODataObject)dataObject)._getOpenContentProperties();
        List list2 = ((SDODataObject)dataObject2)._getOpenContentProperties();
        if (list.size() != list2.size() || !list.containsAll(list2)) {
            return false;
        }
        if (!this.compare(dataObject, dataObject2, bl, list)) {
            return false;
        }
        List list3 = ((SDODataObject)dataObject)._getOpenContentPropertiesAttributes();
        List list4 = ((SDODataObject)dataObject2)._getOpenContentPropertiesAttributes();
        if (list3.size() != list4.size() || !list3.containsAll(list4)) {
            return false;
        }
        return this.compare(dataObject, dataObject2, bl, list3);
    }

    private boolean compareSequences(SDOSequence sDOSequence, SDOSequence sDOSequence2, boolean bl) {
        if (null == sDOSequence && null == sDOSequence2) {
            return true;
        }
        if (null == sDOSequence || null == sDOSequence2) {
            return false;
        }
        if (bl && sDOSequence.size() != sDOSequence2.size()) {
            return false;
        }
        List<Setting> list = sDOSequence.getSettings();
        List<Setting> list2 = sDOSequence2.getSettings();
        if (null == list || null == list2) {
            return false;
        }
        Property property = null;
        Property property2 = null;
        if (bl) {
            int n = sDOSequence.size();
            for (int i = 0; i < n; ++i) {
                property = sDOSequence.getProperty(list.get(i));
                property2 = sDOSequence2.getProperty(list2.get(i));
                if (null == property && null != property2 || null != property && null == property2) {
                    return false;
                }
                if (!this.arePropertiesEqual(property, property2)) {
                    return false;
                }
                Object object = sDOSequence.getValue(i);
                Object object2 = sDOSequence2.getValue(i);
                if (null == property || property.getType().isDataType()) {
                    if (null == object && null != object2 || null != object && null == object2) {
                        return false;
                    }
                    if (null == object || object.equals(object2)) continue;
                    return false;
                }
                if (!bl) continue;
                if (null != object && null != object2) {
                    if (object instanceof DataObject && object2 instanceof DataObject) {
                        if (this.equal((DataObject)object, (DataObject)object2)) continue;
                        return false;
                    }
                    if (object instanceof XMLRoot && object2 instanceof XMLRoot) {
                        XMLRoot xMLRoot = (XMLRoot)object;
                        XMLRoot xMLRoot2 = (XMLRoot)object2;
                        if (!xMLRoot.getLocalName().equals(xMLRoot2.getLocalName())) {
                            return false;
                        }
                        if (!xMLRoot.getNamespaceURI().equals(xMLRoot2.getNamespaceURI())) {
                            return false;
                        }
                        Object object3 = xMLRoot.getObject();
                        Object object4 = xMLRoot2.getObject();
                        if (!(object3 instanceof DataObject) || !(object4 instanceof DataObject) || this.equal((DataObject)object3, (DataObject)object4)) continue;
                        return false;
                    }
                    return false;
                }
                if ((null != object || null == object2) && (null != object2 || null == object)) continue;
                return false;
            }
        } else {
            int n = 0;
            for (int i = 0; i < sDOSequence.getSettings().size(); ++i) {
                Property property3 = sDOSequence.getProperty(i);
                if (property3 != null && !property3.getType().isDataType()) continue;
                Object object = sDOSequence.getValue(i);
                boolean bl2 = false;
                while (n < sDOSequence2.getSettings().size()) {
                    Property property4 = sDOSequence2.getProperty(n);
                    if (property4 == null || property4.getType().isDataType()) {
                        Object object5 = sDOSequence2.getValue(n);
                        if (object == object5 && this.arePropertiesEqual(property3, property4)) {
                            bl2 = true;
                        }
                        ++n;
                        break;
                    }
                    ++n;
                }
                if (bl2) continue;
                return false;
            }
            if (this.getIndexOfNextDataTypeSetting(sDOSequence2, n) != -1) {
                return false;
            }
        }
        return true;
    }

    private int getIndexOfNextDataTypeSetting(SDOSequence sDOSequence, int n) {
        List<Setting> list = sDOSequence.getSettings();
        for (int i = n; i < list.size(); ++i) {
            Property property = sDOSequence.getProperty(i);
            if (property != null && !property.getType().isDataType()) continue;
            return i;
        }
        return -1;
    }

    private boolean arePropertiesEqual(Property property, Property property2) {
        if (null == property && null != property2 || null != property && null == property2) {
            return false;
        }
        return property.equals(property2);
    }

    private boolean compare(DataObject dataObject, DataObject dataObject2, boolean bl, List list) {
        for (SDOProperty sDOProperty : list) {
            if (this.compareProperty(dataObject, dataObject2, bl, sDOProperty)) continue;
            return false;
        }
        return true;
    }

    private boolean compareProperty(DataObject dataObject, DataObject dataObject2, boolean bl, SDOProperty sDOProperty) {
        if (sDOProperty.isMany()) {
            return this.compareManyProperty(dataObject, dataObject2, bl, sDOProperty);
        }
        if (sDOProperty.getType().isDataType() && !sDOProperty.getType().isChangeSummaryType()) {
            boolean bl2 = dataObject.isSet((Property)sDOProperty);
            boolean bl3 = dataObject2.isSet((Property)sDOProperty);
            if (!bl2 && !bl3) {
                return true;
            }
            if (bl2 && bl3) {
                Object object = dataObject.get((Property)sDOProperty);
                Object object2 = dataObject2.get((Property)sDOProperty);
                if (null == object) {
                    return object2 == null;
                }
                if (null == object2) {
                    return false;
                }
                return object.equals(object2);
            }
            return false;
        }
        if (bl && !sDOProperty.getType().isChangeSummaryType()) {
            if (!dataObject.isSet((Property)sDOProperty) && !dataObject2.isSet((Property)sDOProperty)) {
                return true;
            }
            if (!sDOProperty.getType().isDataType()) {
                if (null == sDOProperty.getOpposite()) {
                    return this.compareDataObjects(dataObject.getDataObject((Property)sDOProperty), dataObject2.getDataObject((Property)sDOProperty), bl);
                }
                return this.compareDataObjects(dataObject.getDataObject((Property)sDOProperty), dataObject2.getDataObject((Property)sDOProperty), false);
            }
            return false;
        }
        return true;
    }

    private boolean compareManyProperty(DataObject dataObject, DataObject dataObject2, boolean bl, Property property) {
        List list = dataObject.getList(property);
        List list2 = dataObject2.getList(property);
        if (property.getType().isDataType()) {
            if (dataObject.isSet(property) != dataObject2.isSet(property)) {
                return false;
            }
            if (list.size() != list2.size()) {
                return false;
            }
            for (int i = 0; i < list.size(); ++i) {
                Object e;
                Object e2 = list.get(i);
                if (e2.equals(e = list2.get(i))) continue;
                return false;
            }
            return true;
        }
        if (bl) {
            if (dataObject.isSet(property) != dataObject2.isSet(property)) {
                return false;
            }
            if (list.size() != list2.size()) {
                return false;
            }
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                DataObject dataObject3 = (DataObject)list.get(i);
                DataObject dataObject4 = (DataObject)list2.get(i);
                if (!this.isADataObjectInList(dataObject3, list2)) {
                    return false;
                }
                if (this.isADataObjectInList(dataObject4, list)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isADataObjectInList(DataObject dataObject, List list) {
        for (DataObject dataObject2 : list) {
            if (!this.compareDataObjects(dataObject, dataObject2, true)) continue;
            return true;
        }
        return false;
    }

    public HelperContext getHelperContext() {
        if (null == this.aHelperContext) {
            this.aHelperContext = HelperProvider.getDefaultContext();
        }
        return this.aHelperContext;
    }

    public void setHelperContext(HelperContext helperContext) {
        this.aHelperContext = helperContext;
    }
}

