/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.schemaframework;

import java.io.IOException;
import java.io.Writer;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.tools.schemaframework.FieldDefinition;
import org.eclipse.persistence.tools.schemaframework.StoredProcedureDefinition;

public class StoredFunctionDefinition
extends StoredProcedureDefinition {
    public StoredFunctionDefinition() {
        this.addOutputArgument(new FieldDefinition());
    }

    public Writer buildCreationWriter(AbstractSession abstractSession, Writer writer) throws ValidationException {
        if (!abstractSession.getPlatform().supportsStoredFunctions()) {
            throw ValidationException.platformDoesNotSupportStoredFunctions(Helper.getShortClassName(abstractSession.getPlatform()));
        }
        super.buildCreationWriter(abstractSession, writer);
        return writer;
    }

    public Writer buildDeletionWriter(AbstractSession abstractSession, Writer writer) throws ValidationException {
        if (!abstractSession.getPlatform().supportsStoredFunctions()) {
            throw ValidationException.platformDoesNotSupportStoredFunctions(Helper.getShortClassName(abstractSession.getPlatform()));
        }
        super.buildDeletionWriter(abstractSession, writer);
        return writer;
    }

    public String getCreationHeader() {
        return "CREATE FUNCTION ";
    }

    public String getDeletionHeader() {
        return "DROP FUNCTION ";
    }

    public int getFirstArgumentIndex() {
        return 1;
    }

    public void setReturnType(Class clazz) {
        FieldDefinition fieldDefinition = (FieldDefinition)this.getArguments().firstElement();
        fieldDefinition.setType(clazz);
    }

    protected void printReturn(Writer writer, AbstractSession abstractSession) throws ValidationException {
        try {
            writer.write("\n\t RETURN ");
            FieldDefinition fieldDefinition = (FieldDefinition)this.getArguments().firstElement();
            this.printArgument(fieldDefinition, writer, abstractSession);
            writer.write("\n");
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
    }
}

