/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.internal;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.eclipse.persistence.tools.workbench.framework.Application;
import org.eclipse.persistence.tools.workbench.framework.NodeManager;
import org.eclipse.persistence.tools.workbench.framework.action.ActionRepository;
import org.eclipse.persistence.tools.workbench.framework.app.NavigatorSelectionModel;
import org.eclipse.persistence.tools.workbench.framework.context.AbstractApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.context.AbstractWorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.help.HelpManager;
import org.eclipse.persistence.tools.workbench.framework.internal.FrameworkApplication;
import org.eclipse.persistence.tools.workbench.framework.internal.WorkbenchWindow;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.TextAreaDialog;
import org.eclipse.persistence.tools.workbench.utility.iterators.SingleElementIterator;

final class FrameworkLogHandlerDialog
extends AbstractDialog {
    private LogRecord logRecord;
    private Formatter logFormatter;

    private static WorkbenchWindow findWindow() {
        WorkbenchWindow workbenchWindow = null;
        WorkbenchWindow workbenchWindow2 = null;
        Frame[] frameArray = Frame.getFrames();
        for (int i = 0; i < frameArray.length; ++i) {
            Frame frame = frameArray[i];
            if (!(frame instanceof WorkbenchWindow)) continue;
            WorkbenchWindow workbenchWindow3 = (WorkbenchWindow)frame;
            if (workbenchWindow3.isFocusOwner()) {
                workbenchWindow2 = workbenchWindow3;
                break;
            }
            if (workbenchWindow != null) continue;
            workbenchWindow = workbenchWindow3;
        }
        return workbenchWindow2 == null ? workbenchWindow : workbenchWindow2;
    }

    private static WorkbenchContext buildContext(FrameworkApplication frameworkApplication) {
        return new LocalWorkbenchContext(frameworkApplication, FrameworkLogHandlerDialog.findWindow());
    }

    public FrameworkLogHandlerDialog(FrameworkApplication frameworkApplication, LogRecord logRecord) {
        super(FrameworkLogHandlerDialog.buildContext(frameworkApplication), frameworkApplication.getResourceRepository().getString("UNEXPECTED_ERROR"));
        this.logRecord = logRecord;
        this.logFormatter = new SimpleFormatter();
    }

    protected Component buildMainPanel() {
        JPanel jPanel = new JPanel(new GridLayout(0, 1));
        JLabel jLabel = new JLabel();
        jLabel.setText(this.logFormatter.formatMessage(this.logRecord));
        jLabel.setIcon(this.resourceRepository().getIcon("error"));
        jLabel.setHorizontalAlignment(0);
        jPanel.add(jLabel);
        if (this.logRecord.getThrown() != null) {
            JTextArea jTextArea = new JTextArea(this.logRecord.getThrown().toString());
            jTextArea.setFont(jLabel.getFont());
            jTextArea.setTabSize(2);
            jPanel.add(new JScrollPane(jTextArea));
        }
        jPanel.setPreferredSize(new Dimension(350, Math.min(jPanel.getPreferredSize().height + 50, 150)));
        return jPanel;
    }

    protected String helpTopicId() {
        return "dialog.unexpectedError";
    }

    protected boolean cancelButtonIsVisible() {
        return false;
    }

    protected Iterator buildCustomActions() {
        if (this.logRecord.getThrown() == null) {
            return super.buildCustomActions();
        }
        Action action = this.buildStackTraceAction();
        return new SingleElementIterator((Object)action);
    }

    private Action buildStackTraceAction() {
        return new AbstractAction(this.buildStackTraceText()){

            public void actionPerformed(ActionEvent actionEvent) {
                FrameworkLogHandlerDialog.this.displayStackTrace();
            }
        };
    }

    protected String buildStackTraceText() {
        return this.resourceRepository().getString("STACK_TRACE");
    }

    protected void displayStackTrace() {
        TextAreaDialog textAreaDialog = new TextAreaDialog(this.logRecord.getThrown(), this.helpTopicId(), this.getWorkbenchContext(), (Dialog)this);
        textAreaDialog.setTitle(this.buildStackTraceText());
        textAreaDialog.show();
    }

    private static class LocalWorkbenchContext
    extends AbstractWorkbenchContext {
        FrameworkApplication application;
        private WorkbenchWindow window;
        private ApplicationContext applicationContext;

        LocalWorkbenchContext(FrameworkApplication frameworkApplication, WorkbenchWindow workbenchWindow) {
            this.application = frameworkApplication;
            this.window = workbenchWindow;
            this.applicationContext = this.buildApplicationContext();
        }

        private ApplicationContext buildApplicationContext() {
            return new AbstractApplicationContext(){

                public Application getApplication() {
                    return LocalWorkbenchContext.this.application;
                }

                public HelpManager getHelpManager() {
                    return LocalWorkbenchContext.this.application.getHelpManager();
                }

                public NodeManager getNodeManager() {
                    return LocalWorkbenchContext.this.application.getNodeManager();
                }

                public Preferences getPreferences() {
                    return LocalWorkbenchContext.this.application.getRootPreferences();
                }

                public ResourceRepository getResourceRepository() {
                    return LocalWorkbenchContext.this.application.getResourceRepository();
                }
            };
        }

        public Application getApplication() {
            return this.application;
        }

        public HelpManager getHelpManager() {
            return this.application.getHelpManager();
        }

        public NodeManager getNodeManager() {
            return this.application.getNodeManager();
        }

        public Preferences getPreferences() {
            return this.application.getRootPreferences();
        }

        public ResourceRepository getResourceRepository() {
            return this.application.getResourceRepository();
        }

        public ApplicationContext getApplicationContext() {
            return this.applicationContext;
        }

        public ActionRepository getActionRepository() {
            throw new UnsupportedOperationException();
        }

        public Window getCurrentWindow() {
            return this.window;
        }

        public NavigatorSelectionModel getNavigatorSelectionModel() {
            throw new UnsupportedOperationException();
        }

        public Component getPropertiesPage() {
            throw new UnsupportedOperationException();
        }
    }
}

