/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.internal;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.eclipse.persistence.tools.workbench.framework.app.AccessibleNode;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.app.GroupContainerDescription;
import org.eclipse.persistence.tools.workbench.framework.app.NavigatorSelectionModel;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.help.HelpManager;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.uitools.Displayable;
import org.eclipse.persistence.tools.workbench.uitools.app.TreeNodeValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.TreeModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.DisplayableTreeCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.SimpleStack;
import org.eclipse.persistence.tools.workbench.utility.Stack;
import org.eclipse.persistence.tools.workbench.utility.iterators.EnumerationIterator;

final class NavigatorView {
    private ApplicationContext context;
    private ValueModel selectionMenuDescriptionHolder;
    private PropertyChangeListener selectionMenuDescriptionListener;
    private JPopupMenu selectionPopupMenu;
    private SelectionModel selectionModel;
    private TreeModel treeModel;
    private TreeModelListener treeModelListener;
    private int rootNodeChildrenSize;
    private JPanel component;
    private JTree tree;

    NavigatorView(ApplicationContext applicationContext, ValueModel valueModel) {
        this.context = applicationContext;
        this.selectionPopupMenu = new JPopupMenu();
        this.selectionMenuDescriptionHolder = valueModel;
        this.selectionMenuDescriptionListener = this.buildSelectionMenuDescriptionListener();
        this.selectionMenuDescriptionHolder.addPropertyChangeListener("value", this.selectionMenuDescriptionListener);
        this.treeModel = this.buildTreeModel();
        this.treeModelListener = this.buildTreeModelListener();
        this.treeModel.addTreeModelListener(this.treeModelListener);
        this.rootNodeChildrenSize = this.rootNode().getChildrenModel().size();
        this.component = this.buildComponent();
    }

    private PropertyChangeListener buildSelectionMenuDescriptionListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                NavigatorView.this.selectionMenuDescriptionChanged();
            }
        };
    }

    private JPanel buildComponent() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        jPanel.setMinimumSize(new Dimension(0, 0));
        JLabel jLabel = new JLabel(this.resourceRepository().getString("NAVIGATOR_LABEL"));
        jLabel.setDisplayedMnemonic(this.resourceRepository().getMnemonic("NAVIGATOR_LABEL"));
        jLabel.setIcon(this.resourceRepository().getIcon("navigator"));
        jLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, jPanel.getBackground().darker()), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        jPanel.add((Component)jLabel, "First");
        this.tree = this.buildTree();
        this.selectionModel = new SelectionModel(this.tree);
        this.tree.setSelectionModel(this.selectionModel);
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        jScrollPane.getHorizontalScrollBar().setUnitIncrement(10);
        jScrollPane.setBorder(null);
        jPanel.add((Component)jScrollPane, "Center");
        jLabel.setLabelFor(this.tree);
        return jPanel;
    }

    private JTree buildTree() {
        NavigatorTree navigatorTree = new NavigatorTree(this.treeModel);
        navigatorTree.setShowsRootHandles(true);
        navigatorTree.setRootVisible(false);
        navigatorTree.setCellRenderer(this.buildTreeCellRenderer());
        navigatorTree.setRowHeight(0);
        navigatorTree.addMouseListener(this.buildMouseListener());
        navigatorTree.addKeyListener(this.buildKeyListener());
        return navigatorTree;
    }

    private TreeCellRenderer buildTreeCellRenderer() {
        return new TreeCellRenderer(){

            public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
                return new ApplicationNodeTreeCellRenderer().getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            }
        };
    }

    private MouseListener buildMouseListener() {
        return new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                this.handleMouseEvent(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.handleMouseEvent(mouseEvent);
            }

            private void handleMouseEvent(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    NavigatorView.this.displayPopupMenu((JTree)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        };
    }

    private KeyListener buildKeyListener() {
        return new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                NavigatorView.this.keyPressed(keyEvent);
            }
        };
    }

    private TreeModel buildTreeModel() {
        return new TreeModelAdapter(this.rootNode());
    }

    private TreeModelListener buildTreeModelListener() {
        return new TreeModelListener(){

            public void treeNodesChanged(TreeModelEvent treeModelEvent) {
                NavigatorView.this.treeChanged();
            }

            public void treeNodesInserted(TreeModelEvent treeModelEvent) {
                NavigatorView.this.treeChanged();
            }

            public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
                NavigatorView.this.treeChanged();
            }

            public void treeStructureChanged(TreeModelEvent treeModelEvent) {
                NavigatorView.this.treeChanged();
            }
        };
    }

    void addTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.selectionModel.addTreeSelectionListener(treeSelectionListener);
    }

    void removeTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.selectionModel.removeTreeSelectionListener(treeSelectionListener);
    }

    void selectionMenuDescriptionChanged() {
        this.selectionPopupMenu.removeAll();
        GroupContainerDescription groupContainerDescription = (GroupContainerDescription)this.selectionMenuDescriptionHolder.getValue();
        ListIterator listIterator = groupContainerDescription.components();
        while (listIterator.hasNext()) {
            this.selectionPopupMenu.add((Component)listIterator.next());
        }
    }

    void displayPopupMenu(JTree jTree, int n, int n2) {
        TreePath treePath = jTree.getPathForLocation(n, n2);
        if (treePath == null) {
            return;
        }
        Object[] objectArray = jTree.getSelectionPaths();
        if (objectArray == null || !CollectionTools.contains((Object[])objectArray, (Object)treePath)) {
            jTree.setSelectionPath(treePath);
        }
        if (this.selectionPopupMenu.getComponentCount() > 0) {
            this.selectionPopupMenu.show(jTree, n, n2);
        }
    }

    void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.isConsumed()) {
            return;
        }
        switch (keyEvent.getKeyCode()) {
            case 112: {
                this.displayHelp();
                keyEvent.consume();
                break;
            }
            case 121: {
                if (!keyEvent.isShiftDown()) break;
                this.displayPopupMenu((JTree)keyEvent.getSource());
                keyEvent.consume();
                break;
            }
        }
    }

    private void displayHelp() {
        ApplicationNode[] applicationNodeArray = this.selectionModel.getSelectedNodes();
        if (applicationNodeArray.length != 1) {
            return;
        }
        ApplicationNode applicationNode = applicationNodeArray[0];
        this.helpManager().showTopic(applicationNode.helpTopicID());
    }

    private void displayPopupMenu(JTree jTree) {
        ApplicationNode[] applicationNodeArray = this.selectionModel.getSelectedNodes();
        if (applicationNodeArray.length != 1) {
            return;
        }
        ApplicationNode applicationNode = applicationNodeArray[0];
        Rectangle rectangle = jTree.getPathBounds(new TreePath(applicationNode.path()));
        if (this.selectionPopupMenu.getComponentCount() > 0) {
            this.selectionPopupMenu.show(jTree, (int)rectangle.getCenterX(), (int)rectangle.getCenterY());
        }
    }

    void treeChanged() {
        int n = this.rootNodeChildrenSize;
        int n2 = this.rootNode().getChildrenModel().size();
        if (n == 0 && n2 != 0) {
            this.selectionModel.setSelectedNode((ApplicationNode)this.rootNode().getChildrenModel().getItem(0));
        }
        this.rootNodeChildrenSize = n2;
    }

    void saveTreeExpansionState(Preferences preferences) {
        this.selectionModel.saveTreeExpansionState(preferences);
    }

    void restoreTreeExpansionState(Preferences preferences) {
        this.selectionModel.restoreTreeExpansionState(preferences);
    }

    void close() {
        this.treeModel.removeTreeModelListener(this.treeModelListener);
        this.selectionMenuDescriptionHolder.removePropertyChangeListener("value", this.selectionMenuDescriptionListener);
        this.tree.setModel(null);
    }

    Component getComponent() {
        return this.component;
    }

    NavigatorSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    private ResourceRepository resourceRepository() {
        return this.context.getResourceRepository();
    }

    private TreeNodeValueModel rootNode() {
        return this.context.getNodeManager().getRootNode();
    }

    private HelpManager helpManager() {
        return this.context.getHelpManager();
    }

    private static class ApplicationNodeTreeCellRenderer
    extends DisplayableTreeCellRenderer {
        private ApplicationNodeTreeCellRenderer() {
        }

        protected String buildAccessibleName(Object object) {
            return ((AccessibleNode)object).accessibleName();
        }

        protected String buildText(Object object) {
            String string = super.buildText(object);
            if (string == null) {
                return string;
            }
            return ((ApplicationNode)object).isDirty() ? '*' + string : string;
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            return new Dimension(dimension.width, dimension.height + 1);
        }
    }

    private static class SelectionModel
    extends DefaultTreeSelectionModel
    implements NavigatorSelectionModel {
        private JTree tree;
        private Stack expansionStates;
        private static final ApplicationNode[] EMPTY_SELECTED_NODES = new ApplicationNode[0];

        public SelectionModel(JTree jTree) {
            this.tree = jTree;
            this.expansionStates = new SimpleStack();
        }

        public ApplicationNode[] getSelectedNodes() {
            int n;
            TreePath[] treePathArray = this.getSelectionPaths();
            int n2 = n = treePathArray == null ? 0 : treePathArray.length;
            if (n == 0) {
                return EMPTY_SELECTED_NODES;
            }
            ApplicationNode[] applicationNodeArray = new ApplicationNode[n];
            int n3 = n;
            while (n3-- > 0) {
                applicationNodeArray[n3] = (ApplicationNode)treePathArray[n3].getLastPathComponent();
            }
            return applicationNodeArray;
        }

        public ApplicationNode[] getSelectedProjectNodes() {
            ApplicationNode[] applicationNodeArray = this.getSelectedNodes();
            HashSet<ApplicationNode> hashSet = new HashSet<ApplicationNode>(applicationNodeArray.length);
            int n = applicationNodeArray.length;
            while (n-- > 0) {
                hashSet.add(applicationNodeArray[n].getProjectRoot());
            }
            return hashSet.toArray(new ApplicationNode[hashSet.size()]);
        }

        public void pushExpansionState() {
            this.expansionStates.push((Object)this.currentExpansionState());
        }

        public void popAndRestoreExpansionState() {
            Collection collection = (Collection)this.expansionStates.pop();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.tree.expandPath((TreePath)iterator.next());
            }
        }

        public void popAndRestoreExpansionState(ApplicationNode applicationNode, ApplicationNode applicationNode2) {
            Collection collection = (Collection)this.expansionStates.pop();
            for (TreePath treePath : collection) {
                if (treePath.getLastPathComponent() == applicationNode) {
                    treePath = new TreePath(applicationNode2.path());
                }
                this.tree.expandPath(treePath);
            }
        }

        public void setSelectedNode(ApplicationNode applicationNode) {
            TreePath treePath = new TreePath(applicationNode.path());
            this.setSelectionPath(treePath);
            this.tree.scrollPathToVisible(treePath);
        }

        public void setSelectionPaths(TreePath[] treePathArray) {
            super.setSelectionPaths(treePathArray);
            for (int i = 0; i < treePathArray.length; ++i) {
                this.tree.scrollPathToVisible(treePathArray[i]);
            }
        }

        public void expandNode(ApplicationNode applicationNode) {
            this.tree.expandPath(new TreePath(applicationNode.path()));
        }

        void saveTreeExpansionState(Preferences preferences) {
        }

        void restoreTreeExpansionState(Preferences preferences) {
        }

        private Collection currentExpansionState() {
            Enumeration<TreePath> enumeration = this.tree.getExpandedDescendants(new TreePath(this.tree.getModel().getRoot()));
            if (enumeration == null) {
                return Collections.EMPTY_LIST;
            }
            return CollectionTools.list((Iterator)new EnumerationIterator(enumeration));
        }
    }

    private class NavigatorTree
    extends JTree {
        public NavigatorTree(TreeModel treeModel) {
            super(treeModel);
        }

        public String convertValueToText(Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            return object == null ? "" : ((Displayable)object).displayString();
        }
    }
}

