/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin;

import java.awt.Cursor;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.mappingsplugin.MappingsPlugin;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ProjectCreationDialog;

final class NewProjectAction
extends AbstractFrameworkAction {
    private MappingsPlugin plugin;

    NewProjectAction(MappingsPlugin mappingsPlugin, WorkbenchContext workbenchContext) {
        super(workbenchContext);
        this.plugin = mappingsPlugin;
    }

    protected void initialize() {
        this.initializeTextAndMnemonic("NEW_PROJECT_ACTION");
        this.initializeAccelerator("NEW_PROJECT_ACTION.accelerator");
        this.initializeIcon("PROJECT.NEW");
        this.initializeToolTipText("NEW_PROJECT_ACTION.toolTipText");
    }

    protected void execute() {
        ProjectCreationDialog projectCreationDialog = new ProjectCreationDialog(this.getWorkbenchContext());
        projectCreationDialog.show();
        if (projectCreationDialog.wasCanceled()) {
            return;
        }
        this.currentWindow().setCursor(Cursor.getPredefinedCursor(3));
        this.navigatorSelectionModel().pushExpansionState();
        ApplicationNode applicationNode = this.plugin.buildProjectNode(projectCreationDialog.getProject(), this.getWorkbenchContext());
        this.nodeManager().addProjectNode(applicationNode);
        this.navigatorSelectionModel().setSelectedNode(applicationNode);
        this.navigatorSelectionModel().expandNode(applicationNode);
        this.navigatorSelectionModel().popAndRestoreExpansionState();
        this.currentWindow().setCursor(Cursor.getDefaultCursor());
    }
}

