/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin;

import java.io.File;
import java.util.prefs.Preferences;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.uitools.FileChooser;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProject;
import org.eclipse.persistence.tools.workbench.mappingsplugin.MappingsPlugin;
import org.eclipse.persistence.tools.workbench.uitools.CancelException;
import org.eclipse.persistence.tools.workbench.uitools.LabelArea;
import org.eclipse.persistence.tools.workbench.utility.io.FileTools;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public final class ProjectDeploymentXmlGenerationCoordinator {
    private WorkbenchContext context;

    public ProjectDeploymentXmlGenerationCoordinator(WorkbenchContext workbenchContext) {
        this.context = workbenchContext;
    }

    public boolean exportProjectDeploymentXml(MWProject mWProject) {
        try {
            this.configureProjectDeploymentXMLFile(mWProject);
            this.checkProjectProblems(mWProject);
        }
        catch (CancelException cancelException) {
            return false;
        }
        if (mWProject.deploymentXMLFile().isDirectory()) {
            this.showInvalidFileDialog(mWProject);
            return false;
        }
        try {
            mWProject.exportDeploymentXML();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            if (noClassDefFoundError.getMessage().startsWith("oracle.xdb")) {
                this.showMissingXdbJarDialog();
                return false;
            }
            throw noClassDefFoundError;
        }
        this.showSuccessDialog(mWProject);
        return true;
    }

    private void configureProjectDeploymentXMLFile(MWProject mWProject) {
        if (!StringTools.stringIsEmpty((String)mWProject.getDeploymentXMLFileName())) {
            return;
        }
        File file = MappingsPlugin.buildExportDirectory(mWProject, "", this.preferences());
        File file2 = new File(file, mWProject.getName() + ".xml");
        LocalFileChooser localFileChooser = new LocalFileChooser(this.context, file, mWProject.getSaveDirectory());
        localFileChooser.setDialogTitle(this.resourceRepository().getString("PROJECT_XML_SAVE_AS_DIALOG_TITLE"));
        localFileChooser.setAcceptAllFileFilterUsed(true);
        localFileChooser.setFileSelectionMode(0);
        localFileChooser.setMultiSelectionEnabled(false);
        localFileChooser.setSelectedFile(file2);
        localFileChooser.setFileFilter(this.buildXMLFileFilter());
        int n = localFileChooser.showSaveDialog(this.context.getCurrentWindow());
        if (n == 1) {
            throw new CancelException();
        }
        File file3 = localFileChooser.getSelectedFile();
        mWProject.setDeploymentXMLFileName(file3.getPath());
        File file4 = file3.getParentFile();
        if (file4 != null && file4.isAbsolute() && !file4.equals(mWProject.getSaveDirectory())) {
            this.preferences().put("export location", file4.getPath());
        }
    }

    private Preferences preferences() {
        return this.context.getApplicationContext().getPreferences();
    }

    private FileFilter buildXMLFileFilter() {
        return new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory() || ".xml".equals(FileTools.extension((File)file).toLowerCase());
            }

            public String getDescription() {
                return ProjectDeploymentXmlGenerationCoordinator.this.resourceRepository().getString("PROJECT_XML_SAVE_AS_DIALOG_XML_DESCRIPTION");
            }
        };
    }

    private void checkProjectProblems(MWProject mWProject) {
        if (!mWProject.hasBranchProblems()) {
            return;
        }
        int n = JOptionPane.showConfirmDialog(this.context.getCurrentWindow(), new LabelArea(this.resourceRepository().getString("PROJECT_XML_PROJECT_PROBLEMS_DIALOG.message", StringTools.CR)), this.resourceRepository().getString("PROJECT_XML_PROJECT_PROBLEMS_DIALOG.title", mWProject.getName()), 0, 2);
        if (n != 0) {
            throw new CancelException();
        }
    }

    private void showInvalidFileDialog(MWProject mWProject) {
        JOptionPane.showMessageDialog(this.context.getCurrentWindow(), this.resourceRepository().getString("GENERATE_PROJECT_XML_INVALID_FILE_DIALOG.message", mWProject.deploymentXMLFile()), this.resourceRepository().getString("GENERATE_PROJECT_XML_INVALID_FILE_DIALOG.title", mWProject.getName()), 0);
    }

    private void showMissingXdbJarDialog() {
        JOptionPane.showMessageDialog(this.context.getCurrentWindow(), this.resourceRepository().getString("GENERATE_PROJECT_XML_MISSING_XDB_JAR.message", StringTools.CR), this.resourceRepository().getString("GENERATE_PROJECT_XML_MISSING_XDB_JAR.title"), 0);
    }

    private void showSuccessDialog(MWProject mWProject) {
        JOptionPane.showMessageDialog(this.context.getCurrentWindow(), this.resourceRepository().getString("GENERATE_PROJECT_XML_SUCCESS_DIALOG.message"), this.resourceRepository().getString("GENERATE_PROJECT_XML_SUCCESS_DIALOG.title", mWProject.getName()), 1);
    }

    ResourceRepository resourceRepository() {
        return this.context.getApplicationContext().getResourceRepository();
    }

    private class LocalFileChooser
    extends FileChooser {
        private final WorkbenchContext workbenchContext;
        private static final long serialVersionUID = 1L;

        private LocalFileChooser(WorkbenchContext workbenchContext, File file, File file2) {
            super(file, file2);
            this.workbenchContext = workbenchContext;
        }

        public void approveSelection() {
            int n = this.canReplaceExistingFile();
            if (n == 0) {
                super.approveSelection();
            } else if (n == 2) {
                this.cancelSelection();
            }
        }

        private int canReplaceExistingFile() {
            File file = this.getSelectedFile();
            if (file.exists() && !file.canWrite()) {
                String string = ProjectDeploymentXmlGenerationCoordinator.this.resourceRepository().getString("PROJECT_XML_SAVE_AS_DIALOG_CANT_SAVE", file);
                LabelArea labelArea = new LabelArea(string);
                JOptionPane.showMessageDialog(this.workbenchContext.getCurrentWindow(), labelArea, ProjectDeploymentXmlGenerationCoordinator.this.resourceRepository().getString("PROJECT_XML_SAVE_AS_DIALOG_CANT_SAVE_TITLE"), 2);
                return 1;
            }
            if (file.exists()) {
                String string = ProjectDeploymentXmlGenerationCoordinator.this.resourceRepository().getString("PROJECT_XML_SAVE_AS_DIALOG_REPLACE", this.getSelectedFile().getPath());
                LabelArea labelArea = new LabelArea(string);
                return JOptionPane.showConfirmDialog(this.workbenchContext.getCurrentWindow(), labelArea, ProjectDeploymentXmlGenerationCoordinator.this.resourceRepository().getString("PROJECT_XML_SAVE_AS_DIALOG_REPLACE_TITLE"), 1);
            }
            return 0;
        }
    }
}

