/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractValidatingDialog;
import org.eclipse.persistence.tools.workbench.framework.uitools.RegexpDocument;
import org.eclipse.persistence.tools.workbench.framework.uitools.Spacer;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.relational.MWRelationalProject;
import org.eclipse.persistence.tools.workbench.utility.NameTools;

final class DescriptorGenerationDialog
extends AbstractValidatingDialog {
    private MWRelationalProject project;
    private JTextField packageNameTextField;
    private JCheckBox generateAccessorsCheckBox;

    public DescriptorGenerationDialog(MWRelationalProject mWRelationalProject, WorkbenchContext workbenchContext) {
        super(workbenchContext);
        this.project = mWRelationalProject;
        this.initializeDialog();
    }

    public boolean getGenerateAccessors() {
        return this.generateAccessorsCheckBox.isSelected();
    }

    public String getPackageName() {
        return this.packageNameTextField.getText();
    }

    protected String helpTopicId() {
        return "dialog.descriptorGeneration";
    }

    private void initializeDialog() {
        String string = null;
        string = "DescriptorGenerationDialog_class.title";
        this.setResizable(true);
        this.setTitle(this.resourceRepository().getString(string));
    }

    protected Component buildMainPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = SwingComponentFactory.buildLabel("DescriptorGenerationDialog_packageName", this.resourceRepository());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.packageNameTextField = new JTextField();
        this.packageNameTextField.setColumns(30);
        RegexpDocument regexpDocument = new RegexpDocument(1);
        regexpDocument.addDocumentListener(this.buildPackageNameDocumentListener());
        this.packageNameTextField.setDocument(regexpDocument);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        jPanel.add((Component)this.packageNameTextField, gridBagConstraints);
        jLabel.setLabelFor(this.packageNameTextField);
        this.generateAccessorsCheckBox = new JCheckBox(this.resourceRepository().getString("DescriptorGenerationDialog_generateAccessingMethods"), true);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        jPanel.add((Component)this.generateAccessorsCheckBox, gridBagConstraints);
        Spacer spacer = new Spacer();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)spacer, gridBagConstraints);
        return jPanel;
    }

    void showNoRelationshipSupportDialog() {
        JOptionPane.showMessageDialog(this, this.resourceRepository().getString("DescriptorGenerationDialog_noRelationshipSupport.message"), this.resourceRepository().getString("DescriptorGenerationDialog_noRelationshipSupport.title"), 2);
    }

    protected DocumentListener buildPackageNameDocumentListener() {
        return new DocumentListener(){

            public void removeUpdate(DocumentEvent documentEvent) {
                DescriptorGenerationDialog.this.packageNameDocumentChanged();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                DescriptorGenerationDialog.this.packageNameDocumentChanged();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
            }
        };
    }

    void packageNameDocumentChanged() {
        if (this.isVisible()) {
            this.validatePackageName();
        }
    }

    private void validatePackageName() {
        String string = this.packageNameTextField.getText();
        if (this.packageNameIsIllegal(string)) {
            this.setErrorMessageKey("NEW_NAME_DIALOG.ILLEGAL_VALUE");
            return;
        }
        this.clearErrorMessage();
    }

    private boolean packageNameIsIllegal(String string) {
        String[] stringArray = string.split("\\.");
        for (int i = 0; i < stringArray.length; ++i) {
            if (!NameTools.javaReservedWordsContains((String)stringArray[i])) continue;
            return true;
        }
        return false;
    }

    protected void setErrorMessageKey(String string) {
        super.setErrorMessageKey(string);
        this.getOKAction().setEnabled(false);
    }

    protected void clearErrorMessage() {
        super.clearErrorMessage();
        this.getOKAction().setEnabled(true);
    }
}

