/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractEnablableFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.AbstractApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWDatabase;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.db.ExternalTableDescription;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db.TableNode;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleListCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

class RefreshTableAction
extends AbstractEnablableFrameworkAction {
    RefreshTableAction(WorkbenchContext workbenchContext) {
        super(workbenchContext);
    }

    protected void initialize() {
        super.initialize();
        this.initializeIcon("synchronize");
        this.initializeTextAndMnemonic("REFRESH");
        this.initializeToolTipText("REFRESH");
    }

    protected void engageValueEnabled(AbstractApplicationNode abstractApplicationNode) {
        super.engageValueEnabled(abstractApplicationNode);
        ((TableNode)abstractApplicationNode).getTable().getDatabase().addPropertyChangeListener("connected", this.getEnabledStateListener());
    }

    protected void disengageValueEnabled(AbstractApplicationNode abstractApplicationNode) {
        super.disengageValueEnabled(abstractApplicationNode);
        ((TableNode)abstractApplicationNode).getTable().getDatabase().removePropertyChangeListener("connected", this.getEnabledStateListener());
    }

    private Collection selectedTables() {
        ArrayList<MWTable> arrayList = new ArrayList<MWTable>();
        ApplicationNode[] applicationNodeArray = this.selectedNodes();
        for (int i = 0; i < applicationNodeArray.length; ++i) {
            arrayList.add(((TableNode)applicationNodeArray[i]).getTable());
        }
        return arrayList;
    }

    protected void execute() {
        Collection collection = this.selectedTables();
        MWDatabase mWDatabase = ((MWTable)collection.iterator().next()).getDatabase();
        ArrayList arrayList = new ArrayList(collection.size());
        ArrayList<MWTable> arrayList2 = new ArrayList<MWTable>();
        for (MWTable mWTable : collection) {
            Collection collection2 = CollectionTools.collection((Iterator)mWTable.matchingExternalTableDescriptions());
            if (collection2.size() == 1) {
                arrayList.add(collection2.iterator().next());
                continue;
            }
            if (collection2.size() > 1) {
                DuplicateTablesDialog duplicateTablesDialog = new DuplicateTablesDialog(this.getWorkbenchContext(), mWTable, collection2);
                duplicateTablesDialog.show();
                if (duplicateTablesDialog.wasConfirmed()) {
                    arrayList.add(duplicateTablesDialog.selectedExternalTableDescription());
                    continue;
                }
                arrayList2.add(mWTable);
                continue;
            }
            arrayList2.add(mWTable);
        }
        mWDatabase.refreshQualifiedTablesFor(arrayList);
        if (arrayList2.size() > 0) {
            MissingTablesDialog missingTablesDialog = new MissingTablesDialog(this.getWorkbenchContext(), arrayList2);
            missingTablesDialog.show();
        }
    }

    protected boolean shouldBeEnabled(ApplicationNode applicationNode) {
        return ((MWTable)((TableNode)applicationNode).getValue()).getDatabase().isConnected();
    }

    private static class DuplicateTablesDialog
    extends AbstractDialog {
        private MWTable table;
        private Vector duplicateExternalTableDescriptions;
        private JList tableList;
        private static final Comparator EXTERNAL_TABLE_DESCRIPTION_COMPARATOR = new Comparator(){

            public int compare(Object object, Object object2) {
                return Collator.getInstance().compare(((ExternalTableDescription)object).getQualifiedName(), ((ExternalTableDescription)object2).getQualifiedName());
            }
        };

        DuplicateTablesDialog(WorkbenchContext workbenchContext, MWTable mWTable, Collection collection) {
            super(workbenchContext);
            this.table = mWTable;
            this.setTitle(this.resourceRepository().getString("DUPLICATE_TABLES_DIALOG.title", mWTable.qualifiedName()));
            this.duplicateExternalTableDescriptions = new Vector(collection);
            Collections.sort(this.duplicateExternalTableDescriptions, EXTERNAL_TABLE_DESCRIPTION_COMPARATOR);
            this.getOKAction().setEnabled(false);
        }

        ExternalTableDescription selectedExternalTableDescription() {
            return (ExternalTableDescription)this.tableList.getSelectedValue();
        }

        protected Component buildMainPanel() {
            JPanel jPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            JLabel jLabel = new JLabel(this.resourceRepository().getString("DUPLICATE_TABLES_DIALOG.message", this.table.qualifiedName()));
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            jPanel.add((Component)jLabel, gridBagConstraints);
            this.tableList = SwingComponentFactory.buildList(this.duplicateExternalTableDescriptions);
            this.tableList.setBorder(BorderFactory.createEmptyBorder());
            this.tableList.setFont(new Font("dialog", 0, 12));
            this.tableList.setSelectionMode(0);
            this.tableList.setCellRenderer(this.buildExternalTableDescriptionCellRenderer());
            this.tableList.addListSelectionListener(this.buildExternalTableDescriptionListSelectionListener());
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.insets = new Insets(1, 0, 0, 0);
            jPanel.add((Component)new JScrollPane(this.tableList), gridBagConstraints);
            return jPanel;
        }

        private ListCellRenderer buildExternalTableDescriptionCellRenderer() {
            return new SimpleListCellRenderer(){

                protected String buildText(Object object) {
                    return ((ExternalTableDescription)object).getQualifiedName();
                }
            };
        }

        void externalTableDescriptionSelectionChanged() {
            this.getOKAction().setEnabled(this.tableList.getSelectedIndex() != -1);
        }

        private ListSelectionListener buildExternalTableDescriptionListSelectionListener() {
            return new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (!listSelectionEvent.getValueIsAdjusting()) {
                        DuplicateTablesDialog.this.externalTableDescriptionSelectionChanged();
                    }
                }
            };
        }

        protected String helpTopicId() {
            return "dialog.duplicateTables";
        }
    }

    private static class MissingTablesDialog
    extends AbstractDialog {
        private Collection missingTables;

        public MissingTablesDialog(WorkbenchContext workbenchContext, Collection collection) {
            super(workbenchContext);
            this.setTitle(this.resourceRepository().getString("ERROR_REFRESHING_TABLES_DIALOG.title"));
            this.missingTables = new TreeSet(collection);
        }

        protected Component buildMainPanel() {
            JPanel jPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            JLabel jLabel = new JLabel(this.resourceRepository().getString("ERROR_REFRESHING_TABLES_DIALOG.message"));
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            jPanel.add((Component)jLabel, gridBagConstraints);
            JTextArea jTextArea = new JTextArea();
            jTextArea.setBorder(BorderFactory.createEmptyBorder());
            jTextArea.setFont(new Font("dialog", 0, 12));
            jTextArea.setEditable(false);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.insets = new Insets(1, 0, 0, 0);
            jPanel.add((Component)new JScrollPane(jTextArea), gridBagConstraints);
            jTextArea.setText(null);
            Iterator iterator = this.missingTables.iterator();
            while (iterator.hasNext()) {
                jTextArea.append(((MWTable)iterator.next()).qualifiedName());
                if (!iterator.hasNext()) continue;
                jTextArea.append(StringTools.CR);
            }
            return jPanel;
        }

        protected String helpTopicId() {
            return "dialog.tablesNotFound";
        }
    }
}

