/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.ListCellRenderer;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.ScrollablePropertiesPage;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWCachingPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorCachingPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWNullCachingPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWTransactionalDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWTransactionalPolicy;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.CacheExpiryPanel;
import org.eclipse.persistence.tools.workbench.uitools.ComponentEnabler;
import org.eclipse.persistence.tools.workbench.uitools.app.AbstractReadOnlyListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.FilteringPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.CheckBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.NumberSpinnerModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleListCellRenderer;

public final class CachingPolicyPropertiesPage
extends ScrollablePropertiesPage {
    private PropertyValueModel cachingPolicyHolder;
    private PropertyValueModel nonNullCachingPolicyHolder;
    private PropertyValueModel projectDefaultCachingPolicyHolder;

    CachingPolicyPropertiesPage(PropertyValueModel propertyValueModel, WorkbenchContextHolder workbenchContextHolder) {
        super(propertyValueModel, workbenchContextHolder);
    }

    protected String getHelpTopicId() {
        return "descriptor.identity";
    }

    protected void initialize(PropertyValueModel propertyValueModel) {
        super.initialize(propertyValueModel);
        this.cachingPolicyHolder = this.buildCachingPolicyHolder();
        this.nonNullCachingPolicyHolder = this.buildNonNullCachingPolicyHolder();
        this.projectDefaultCachingPolicyHolder = this.buildProjectDefaultCachingPolicyHolder();
    }

    private PropertyValueModel buildNonNullCachingPolicyHolder() {
        return new FilteringPropertyValueModel(this.cachingPolicyHolder){

            protected boolean accept(Object object) {
                return !(object instanceof MWNullCachingPolicy);
            }
        };
    }

    private PropertyValueModel buildCachingPolicyHolder() {
        return new PropertyAspectAdapter(this.buildTransactionalPolicyHolder()){

            protected Object getValueFromSubject() {
                return ((MWTransactionalPolicy)this.subject).getCachingPolicy();
            }
        };
    }

    private PropertyValueModel buildTransactionalPolicyHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder()){

            protected Object getValueFromSubject() {
                return ((MWTransactionalDescriptor)this.subject).getTransactionalPolicy();
            }
        };
    }

    private PropertyValueModel buildProjectDefaultCachingPolicyHolder() {
        return new PropertyAspectAdapter(this.nonNullCachingPolicyHolder){

            protected Object getValueFromSubject() {
                return ((MWCachingPolicy)this.subject).getProject().getDefaultsPolicy().getCachingPolicy();
            }
        };
    }

    protected Component buildPage() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        PropertyValueModel propertyValueModel = this.buildProjectDefaultCachingTypeHolder();
        JComponent jComponent = this.buildLabeledComboBox("CACHING_POLICY_CACHE_TYPE_CHOOSER", new ComboBoxModelAdapter(this.buildCacheTypeCollectionHolder(), this.buildCacheTypeHolder()), this.buildCacheTypeOptionRenderer(propertyValueModel));
        new ComponentEnabler(this.buildCacheTypeHolderBooleanModel(), jComponent);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        jPanel.add((Component)jComponent, gridBagConstraints);
        this.helpManager().addTopicID(jComponent, "descriptor.cacheType");
        propertyValueModel.addPropertyChangeListener("value", this.buildProjectDefaultListener((JComboBox)jComponent.getComponent(1)));
        PropertyValueModel propertyValueModel2 = this.buildCacheSizeHolder();
        final NumberSpinnerModelAdapter numberSpinnerModelAdapter = new NumberSpinnerModelAdapter(propertyValueModel2, 0, 99999, 1);
        JComponent jComponent2 = this.buildLabeledSpinnerNumber("CACHING_POLICY_CACHE_SIZE_SPINNER", numberSpinnerModelAdapter);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        jPanel.add((Component)jComponent2, gridBagConstraints);
        this.helpManager().addTopicID(jComponent2, "descriptor.cacheSize");
        final JSpinner jSpinner = (JSpinner)jComponent2.getComponent(1);
        JCheckBox jCheckBox = this.buildCheckBox("CACHING_POLICY_CACHE_SIZE_DEFAULT_CHECKBOX", this.buildDefaultCacheSizeCheckBoxAdapter());
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        jPanel.add((Component)jCheckBox, gridBagConstraints);
        this.helpManager().addTopicID(jCheckBox, "descriptor.cacheSize.default");
        PropertyValueModel propertyValueModel3 = this.buildProjectCacheSizeHolder();
        final NumberSpinnerModelAdapter numberSpinnerModelAdapter2 = new NumberSpinnerModelAdapter(propertyValueModel3, 0, 99999, 1);
        jCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    jSpinner.setModel(numberSpinnerModelAdapter2);
                } else {
                    jSpinner.setModel(numberSpinnerModelAdapter);
                }
            }
        });
        new ComponentEnabler(this.buildCacheSizeHolderBooleanModel(), new Component[]{jComponent2, jCheckBox});
        PropertyValueModel propertyValueModel4 = this.buildCacheIsolationHolder();
        PropertyValueModel propertyValueModel5 = this.buildProjectDefaultCacheIsolationHolder();
        JComponent jComponent3 = this.buildLabeledComboBox("CACHING_POLICY_CACHE_ISOLATION_CHOOSER", new ComboBoxModelAdapter(this.buildCacheIsolationCollectionHolder(), propertyValueModel4), this.buildCacheIsolationOptionRenderer(propertyValueModel5));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        jPanel.add((Component)jComponent3, gridBagConstraints);
        this.helpManager().addTopicID(jComponent3, "descriptor.cacheIsolation");
        propertyValueModel5.addPropertyChangeListener("value", this.buildProjectDefaultListener((JComboBox)jComponent3.getComponent(1)));
        PropertyValueModel propertyValueModel6 = this.buildProjectDefaultCacheCoordinationHolder();
        JComponent jComponent4 = this.buildLabeledComboBox("CACHING_POLICY_CACHE_COORDINATION_CHOOSER", new ComboBoxModelAdapter(this.buildCacheCoordinationCollectionHolder(), this.buildCacheCoordinationHolder()), this.buildCacheCoordinationOptionRenderer(propertyValueModel6));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        jPanel.add((Component)jComponent4, gridBagConstraints);
        this.helpManager().addTopicID(jComponent4, "descriptor.cacheCoord");
        propertyValueModel6.addPropertyChangeListener("value", this.buildProjectDefaultListener((JComboBox)jComponent4.getComponent(1)));
        propertyValueModel4.addPropertyChangeListener("value", this.buildUpdateCacheCoordinationComboBox((JComboBox)jComponent4.getComponent(1), propertyValueModel4, propertyValueModel5));
        propertyValueModel5.addPropertyChangeListener("value", this.buildUpdateCacheCoordinationComboBox((JComboBox)jComponent4.getComponent(1), propertyValueModel4, propertyValueModel5));
        CacheExpiryPanel cacheExpiryPanel = new CacheExpiryPanel(this.getApplicationContext(), this.nonNullCachingPolicyHolder, this.getHelpTopicId() + ".CacheExpiry");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        jPanel.add((Component)cacheExpiryPanel, gridBagConstraints);
        PropertyValueModel propertyValueModel7 = this.buildProjectDefaultExistenceCheckingHolder();
        JComponent jComponent5 = this.buildLabeledComboBox("CACHING_POLICY_EXISTENCE_CHECKING_CHOOSER", new ComboBoxModelAdapter(this.buildExistenceCheckingCollectionHolder(), this.buildExistenceCheckingHolder()), this.buildExistenceCheckingOptionRenderer(propertyValueModel7));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        jPanel.add((Component)jComponent5, gridBagConstraints);
        this.addHelpTopicId(jComponent5, "descriptor.identity.existenceCheck");
        propertyValueModel7.addPropertyChangeListener("value", this.buildProjectDefaultListener((JComboBox)jComponent5.getComponent(1)));
        this.addHelpTopicId(jPanel, this.getHelpTopicId());
        return jPanel;
    }

    private ValueModel buildCacheTypeHolderBooleanModel() {
        PropertyAspectAdapter propertyAspectAdapter = new PropertyAspectAdapter(this.cachingPolicyHolder, "cacheTypeHolder"){

            protected Object getValueFromSubject() {
                return ((MWDescriptorCachingPolicy)this.subject).getCacheTypeHolder();
            }
        };
        return new TransformationPropertyValueModel(propertyAspectAdapter){

            protected Object transform(Object object) {
                if (object == null) {
                    return Boolean.FALSE;
                }
                return ((MWDescriptorCachingPolicy.CacheTypeHolder)object).typeCanBeSet();
            }
        };
    }

    private ValueModel buildCacheSizeHolderBooleanModel() {
        PropertyAspectAdapter propertyAspectAdapter = new PropertyAspectAdapter(this.cachingPolicyHolder, "cacheSizeHolder"){

            protected Object getValueFromSubject() {
                return ((MWDescriptorCachingPolicy)this.subject).getCacheSizeHolder();
            }
        };
        return new TransformationPropertyValueModel(propertyAspectAdapter){

            protected Object transform(Object object) {
                if (object == null) {
                    return Boolean.FALSE;
                }
                return ((MWDescriptorCachingPolicy.CacheSizeHolder)object).sizeCanBeSet();
            }
        };
    }

    private PropertyChangeListener buildProjectDefaultListener(final JComboBox jComboBox) {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                jComboBox.repaint();
            }
        };
    }

    private PropertyChangeListener buildUpdateCacheCoordinationComboBox(final JComboBox jComboBox, final PropertyValueModel propertyValueModel, final PropertyValueModel propertyValueModel2) {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                MWCachingPolicy.CacheIsolationOption cacheIsolationOption = (MWCachingPolicy.CacheIsolationOption)propertyValueModel.getValue();
                if (cacheIsolationOption != null) {
                    String string = cacheIsolationOption.getMWModelOption();
                    if (string == "DEFAULT" && (MWCachingPolicy.CacheIsolationOption)propertyValueModel2.getValue() != null) {
                        string = ((MWCachingPolicy.CacheIsolationOption)propertyValueModel2.getValue()).getMWModelOption();
                    }
                    if (string == "Isolated") {
                        jComboBox.setEnabled(false);
                    } else {
                        jComboBox.setEnabled(true);
                    }
                }
            }
        };
    }

    private PropertyValueModel buildCacheTypeHolder() {
        return new PropertyAspectAdapter(this.nonNullCachingPolicyHolder, "cacheType", "cacheTypeHolder", "descriptorInheritance"){

            protected Object getValueFromSubject() {
                return ((MWCachingPolicy)this.subject).getCacheType();
            }

            protected void setValueOnSubject(Object object) {
                ((MWCachingPolicy)this.subject).setCacheType((MWCachingPolicy.CacheTypeOption)object);
            }
        };
    }

    private ListValueModel buildCacheTypeCollectionHolder() {
        return new AbstractReadOnlyListValueModel(){

            public Object getValue() {
                return MWDescriptorCachingPolicy.cacheTypeOptions().toplinkOptions();
            }
        };
    }

    private ListCellRenderer buildCacheTypeOptionRenderer(final PropertyValueModel propertyValueModel) {
        return new SimpleListCellRenderer(){

            protected String buildText(Object object) {
                if (((MWCachingPolicy.CacheTypeOption)object).getMWModelOption() == "DEFAULT") {
                    if (propertyValueModel.getValue() == null) {
                        return CachingPolicyPropertiesPage.this.resourceRepository().getString(((MWCachingPolicy.CacheTypeOption)object).resourceKey());
                    }
                    return CachingPolicyPropertiesPage.this.resourceRepository().getString(((MWCachingPolicy.CacheTypeOption)object).resourceKey(), CachingPolicyPropertiesPage.this.resourceRepository().getString(((MWCachingPolicy.CacheTypeOption)propertyValueModel.getValue()).resourceKey()));
                }
                return CachingPolicyPropertiesPage.this.resourceRepository().getString(((MWCachingPolicy.CacheTypeOption)object).resourceKey());
            }
        };
    }

    private PropertyValueModel buildProjectDefaultCachingTypeHolder() {
        return new PropertyAspectAdapter(this.projectDefaultCachingPolicyHolder, "cacheType"){

            protected Object getValueFromSubject() {
                return ((MWCachingPolicy)this.subject).getCacheType();
            }
        };
    }

    private PropertyValueModel buildCacheSizeHolder() {
        return new PropertyAspectAdapter(this.nonNullCachingPolicyHolder, "cacheSize", "cacheTypeHolder", "descriptorInheritance"){

            protected Object getValueFromSubject() {
                return new Integer(((MWCachingPolicy)this.subject).getCacheSize());
            }

            protected void setValueOnSubject(Object object) {
                ((MWCachingPolicy)this.subject).setCacheSize(((Integer)object).intValue());
            }
        };
    }

    private PropertyValueModel buildProjectCacheSizeHolder() {
        return new PropertyAspectAdapter(this.projectDefaultCachingPolicyHolder, "cacheSize"){

            protected Object getValueFromSubject() {
                return new Integer(((MWCachingPolicy)this.subject).getCacheSize());
            }

            protected void setValueOnSubject(Object object) {
                if (((Integer)object).intValue() != ((MWDescriptorCachingPolicy)CachingPolicyPropertiesPage.this.cachingPolicyHolder.getValue()).getProject().getDefaultsPolicy().getCachingPolicy().getCacheSize()) {
                    ((MWDescriptorCachingPolicy)CachingPolicyPropertiesPage.this.cachingPolicyHolder.getValue()).setDontUseProjectDefaultCacheSize(((Integer)object).intValue());
                }
            }
        };
    }

    private CheckBoxModelAdapter buildDefaultCacheSizeCheckBoxAdapter() {
        return new CheckBoxModelAdapter(this.buildDefaultCacheSizeHolder());
    }

    private PropertyValueModel buildDefaultCacheSizeHolder() {
        return new PropertyAspectAdapter(this.nonNullCachingPolicyHolder, "useProjectDefaultCacheSize", "cacheSizeHolder", "descriptorInheritance"){

            protected Object getValueFromSubject() {
                return ((MWDescriptorCachingPolicy)this.subject).getCacheSizeHolder().usesProjectDefaultCacheSize();
            }

            protected void setValueOnSubject(Object object) {
                ((MWDescriptorCachingPolicy)this.subject).setUseProjectDefaultCacheSize(((Boolean)object).booleanValue());
            }
        };
    }

    private PropertyValueModel buildCacheIsolationHolder() {
        return new PropertyAspectAdapter(this.nonNullCachingPolicyHolder, "cacheIsolation"){

            protected Object getValueFromSubject() {
                return ((MWCachingPolicy)this.subject).getCacheIsolation();
            }

            protected void setValueOnSubject(Object object) {
                ((MWCachingPolicy)this.subject).setCacheIsolation((MWCachingPolicy.CacheIsolationOption)object);
            }
        };
    }

    private ListValueModel buildCacheIsolationCollectionHolder() {
        return new AbstractReadOnlyListValueModel(){

            public Object getValue() {
                return MWDescriptorCachingPolicy.cacheIsolationOptions().toplinkOptions();
            }
        };
    }

    private ListCellRenderer buildCacheIsolationOptionRenderer(final PropertyValueModel propertyValueModel) {
        return new SimpleListCellRenderer(){

            protected String buildText(Object object) {
                if (((MWCachingPolicy.CacheIsolationOption)object).getMWModelOption() == "DEFAULT") {
                    if (propertyValueModel.getValue() == null) {
                        return CachingPolicyPropertiesPage.this.resourceRepository().getString(((MWCachingPolicy.CacheIsolationOption)object).resourceKey());
                    }
                    return CachingPolicyPropertiesPage.this.resourceRepository().getString(((MWCachingPolicy.CacheIsolationOption)object).resourceKey(), CachingPolicyPropertiesPage.this.resourceRepository().getString(((MWCachingPolicy.CacheIsolationOption)propertyValueModel.getValue()).resourceKey()));
                }
                return CachingPolicyPropertiesPage.this.resourceRepository().getString(((MWCachingPolicy.CacheIsolationOption)object).resourceKey());
            }
        };
    }

    private PropertyValueModel buildProjectDefaultCacheIsolationHolder() {
        return new PropertyAspectAdapter(this.projectDefaultCachingPolicyHolder, "cacheIsolation"){

            protected Object getValueFromSubject() {
                return ((MWCachingPolicy)this.subject).getCacheIsolation();
            }
        };
    }

    private PropertyValueModel buildCacheCoordinationHolder() {
        return new PropertyAspectAdapter(this.nonNullCachingPolicyHolder, "cacheCoordination"){

            protected Object getValueFromSubject() {
                return ((MWCachingPolicy)this.subject).getCacheCoordination();
            }

            protected void setValueOnSubject(Object object) {
                ((MWCachingPolicy)this.subject).setCacheCoordination((MWCachingPolicy.CacheCoordinationOption)object);
            }
        };
    }

    private ListValueModel buildCacheCoordinationCollectionHolder() {
        return new AbstractReadOnlyListValueModel(){

            public Object getValue() {
                return MWDescriptorCachingPolicy.cacheCoordinationOptions().toplinkOptions();
            }
        };
    }

    private ListCellRenderer buildCacheCoordinationOptionRenderer(final PropertyValueModel propertyValueModel) {
        return new SimpleListCellRenderer(){

            protected String buildText(Object object) {
                if (((MWCachingPolicy.CacheCoordinationOption)object).getMWModelOption() == "DEFAULT") {
                    if (propertyValueModel.getValue() == null) {
                        return CachingPolicyPropertiesPage.this.resourceRepository().getString(((MWCachingPolicy.CacheCoordinationOption)object).resourceKey());
                    }
                    return CachingPolicyPropertiesPage.this.resourceRepository().getString(((MWCachingPolicy.CacheCoordinationOption)object).resourceKey(), CachingPolicyPropertiesPage.this.resourceRepository().getString(((MWCachingPolicy.CacheCoordinationOption)propertyValueModel.getValue()).resourceKey()));
                }
                return CachingPolicyPropertiesPage.this.resourceRepository().getString(((MWCachingPolicy.CacheCoordinationOption)object).resourceKey());
            }
        };
    }

    private PropertyValueModel buildProjectDefaultCacheCoordinationHolder() {
        return new PropertyAspectAdapter(this.projectDefaultCachingPolicyHolder, "cacheCoordination"){

            protected Object getValueFromSubject() {
                return ((MWCachingPolicy)this.subject).getCacheCoordination();
            }
        };
    }

    private PropertyValueModel buildExistenceCheckingHolder() {
        return new PropertyAspectAdapter(this.nonNullCachingPolicyHolder, "existenceChecking"){

            protected Object getValueFromSubject() {
                return ((MWCachingPolicy)this.subject).getExistenceChecking();
            }

            protected void setValueOnSubject(Object object) {
                ((MWCachingPolicy)this.subject).setExistenceChecking((MWCachingPolicy.ExistenceCheckingOption)object);
            }
        };
    }

    private ListValueModel buildExistenceCheckingCollectionHolder() {
        return new AbstractReadOnlyListValueModel(){

            public Object getValue() {
                return MWDescriptorCachingPolicy.existenceCheckingOptions().toplinkOptions();
            }
        };
    }

    private ListCellRenderer buildExistenceCheckingOptionRenderer(final PropertyValueModel propertyValueModel) {
        return new SimpleListCellRenderer(){

            protected String buildText(Object object) {
                if (((MWCachingPolicy.ExistenceCheckingOption)object).getMWModelOption() == "DEFAULT") {
                    if (propertyValueModel.getValue() == null) {
                        return CachingPolicyPropertiesPage.this.resourceRepository().getString(((MWCachingPolicy.ExistenceCheckingOption)object).resourceKey());
                    }
                    return CachingPolicyPropertiesPage.this.resourceRepository().getString(((MWCachingPolicy.ExistenceCheckingOption)object).resourceKey(), CachingPolicyPropertiesPage.this.resourceRepository().getString(((MWCachingPolicy.ExistenceCheckingOption)propertyValueModel.getValue()).resourceKey()));
                }
                return CachingPolicyPropertiesPage.this.resourceRepository().getString(((MWCachingPolicy.ExistenceCheckingOption)object).resourceKey());
            }
        };
    }

    private PropertyValueModel buildProjectDefaultExistenceCheckingHolder() {
        return new PropertyAspectAdapter(this.projectDefaultCachingPolicyHolder, "existenceChecking"){

            protected Object getValueFromSubject() {
                return ((MWCachingPolicy)this.subject).getExistenceChecking();
            }
        };
    }

    private MWDescriptor rootDescriptor() {
        return ((MWMappingDescriptor)this.getSelectionHolder().getValue()).getInheritancePolicy().getRootDescriptor();
    }
}

