/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.persistence.tools.workbench.framework.action.FrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.action.ToggleFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.ActiveIconBuilder;
import org.eclipse.persistence.tools.workbench.framework.app.GroupContainerDescription;
import org.eclipse.persistence.tools.workbench.framework.app.IconBuilder;
import org.eclipse.persistence.tools.workbench.framework.app.MenuDescription;
import org.eclipse.persistence.tools.workbench.framework.app.MenuGroupDescription;
import org.eclipse.persistence.tools.workbench.framework.app.RootMenuDescription;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWTransactionalPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsplugin.AutomappableNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.RemovableNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.RemoveAction;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.MappingsApplicationNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.ActivateDescriptorAction;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.AdvancedPolicyAction;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.DescriptorPackageNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.MoveDescriptorAction;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.RenameDescriptorAction;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.UnmappablePackageNode;
import org.eclipse.persistence.tools.workbench.uitools.app.TreeNodeValueModel;
import org.eclipse.persistence.tools.workbench.utility.iterators.SingleElementIterator;

public abstract class DescriptorNode
extends MappingsApplicationNode
implements UnmappablePackageNode,
AutomappableNode,
RemovableNode {
    protected static final String[] DESCRIPTOR_DISPLAY_STRING_PROPERTY_NAMES = new String[]{"name"};
    protected static final String[] DESCRIPTOR_ICON_PROPERTY_NAMES = new String[]{"hasBranchProblems", "active"};

    protected DescriptorNode(MWDescriptor mWDescriptor, DescriptorPackageNode descriptorPackageNode) {
        super((MWModel)mWDescriptor, (TreeNodeValueModel)descriptorPackageNode, descriptorPackageNode.getPlugin(), descriptorPackageNode.getApplicationContext());
    }

    private ToggleFrameworkAction getActivateDescriptorAction(WorkbenchContext workbenchContext) {
        return new ActivateDescriptorAction(workbenchContext);
    }

    protected FrameworkAction getRemoveDescriptorAction(WorkbenchContext workbenchContext) {
        return new RemoveAction(workbenchContext, "descriptor.remove");
    }

    protected FrameworkAction getRenameDescriptorAction(WorkbenchContext workbenchContext) {
        return new RenameDescriptorAction(workbenchContext);
    }

    protected FrameworkAction getMoveDescriptorAction(WorkbenchContext workbenchContext) {
        return new MoveDescriptorAction(workbenchContext);
    }

    public String accessibleName() {
        return this.resourceRepository().getString(this.accessibleNameKey(), this.displayString());
    }

    protected abstract String accessibleNameKey();

    protected String[] displayStringPropertyNames() {
        return DESCRIPTOR_DISPLAY_STRING_PROPERTY_NAMES;
    }

    protected String[] iconPropertyNames() {
        return DESCRIPTOR_ICON_PROPERTY_NAMES;
    }

    protected IconBuilder buildIconBuilder() {
        return new ActiveIconBuilder(super.buildIconBuilder(), this.getDescriptor().isActive());
    }

    public String candidatePackageName() {
        return this.getDescriptor().packageName();
    }

    public boolean isAutoMappable() {
        return true;
    }

    public Iterator descriptors() {
        return new SingleElementIterator((Object)this.getDescriptor());
    }

    public void addDescriptorsTo(Collection collection) {
        collection.add(this.getDescriptor());
    }

    public String getAutomapSuccessfulStringKey() {
        return "AUTOMAP_DESCRIPTOR_SUCCESSFUL";
    }

    public void unmapEntirePackage() {
        this.getPackageNode().unmap();
    }

    protected DescriptorPackageNode getPackageNode() {
        return (DescriptorPackageNode)this.getParent();
    }

    public void unmap() {
        this.getDescriptor().unmap();
    }

    public String getName() {
        return this.getDescriptor().getName();
    }

    public void remove() {
        this.getDescriptor().getProject().removeDescriptor(this.getDescriptor());
    }

    public MWDescriptor getDescriptor() {
        return (MWDescriptor)this.getValue();
    }

    public MWClass type() {
        return this.getDescriptor().getMWClass();
    }

    protected MWTransactionalPolicy transactionalPolicy() {
        return this.getDescriptor().getTransactionalPolicy();
    }

    public GroupContainerDescription buildMenuDescription(WorkbenchContext workbenchContext) {
        workbenchContext = this.buildLocalWorkbenchContext(workbenchContext);
        RootMenuDescription rootMenuDescription = new RootMenuDescription();
        MenuGroupDescription menuGroupDescription = new MenuGroupDescription();
        menuGroupDescription.add(this.getActivateDescriptorAction(workbenchContext));
        if (this.supportsDescriptorMorphing()) {
            menuGroupDescription.add(this.buildDescriptorTypeMenuDescription(workbenchContext));
        }
        if (this.supportsAdvancedProperties()) {
            menuGroupDescription.add(this.getAdvancedPolicyAction(workbenchContext));
        }
        rootMenuDescription.add(menuGroupDescription);
        return rootMenuDescription;
    }

    protected MenuDescription buildDescriptorTypeMenuDescription(WorkbenchContext workbenchContext) {
        MenuDescription menuDescription = new MenuDescription(this.resourceRepository().getString("DESCRIPTOR_TYPE_MENU_ITEM"), this.resourceRepository().getString("DESCRIPTOR_TYPE_MENU_ITEM"), this.resourceRepository().getMnemonic("DESCRIPTOR_TYPE_MENU_ITEM"), EMPTY_ICON);
        menuDescription.add(this.buildDescriptorTypeMenuGroupDescription(workbenchContext));
        return menuDescription;
    }

    protected abstract boolean supportsAdvancedProperties();

    protected FrameworkAction getAdvancedPolicyAction(WorkbenchContext workbenchContext) {
        return new AdvancedPolicyAction(workbenchContext);
    }

    protected abstract boolean supportsDescriptorMorphing();

    protected MenuGroupDescription buildDescriptorTypeMenuGroupDescription(WorkbenchContext workbenchContext) {
        throw new UnsupportedOperationException("This descriptor does not support morphing");
    }

    public boolean isActive() {
        return this.getDescriptor().isActive();
    }

    public boolean supportsEventsPolicy() {
        return true;
    }

    public boolean supportsInterfaceAliasPolicy() {
        return false;
    }

    public boolean supportsTransactionalDescriptorProperties() {
        return false;
    }

    public boolean isAggregateDescriptor() {
        return false;
    }

    public boolean isTableDescriptor() {
        return false;
    }
}

