/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.view.TitledPropertiesPage;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.UiCommonBundle;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.DescriptorCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.DescriptorNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.UiDescriptorBundle;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.NullListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ListModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;

final class DescriptorPackagePropertiesPage
extends TitledPropertiesPage {
    private ListModelAdapter descriptorListModel;
    private static final Class[] REQUIRED_RESOURCE_BUNDLES = new Class[]{UiCommonBundle.class, UiDescriptorBundle.class};

    DescriptorPackagePropertiesPage(WorkbenchContext workbenchContext) {
        super(workbenchContext);
    }

    protected void initialize(PropertyValueModel propertyValueModel) {
        super.initialize(propertyValueModel);
        propertyValueModel.addPropertyChangeListener("value", this.buildNodeListener());
        this.descriptorListModel = this.buildDescriptorListModel();
    }

    private PropertyChangeListener buildNodeListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                DescriptorPackagePropertiesPage.this.nodeChanged();
            }
        };
    }

    private ListModelAdapter buildDescriptorListModel() {
        return new ListModelAdapter(this.buildDescriptorLVM());
    }

    protected Component buildPage() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        JList jList = SwingComponentFactory.buildList(this.descriptorListModel);
        jList.setBackground(UIManager.getColor("Panel.background"));
        jList.setSelectionBackground(UIManager.getColor("Panel.background"));
        jList.setCellRenderer(this.buildDescriptorListCellRenderer());
        jPanel.add((Component)jList, "Center");
        return jPanel;
    }

    private ListCellRenderer buildDescriptorListCellRenderer() {
        return new AdaptableListCellRenderer(new DescriptorCellRendererAdapter(this.resourceRepository()){

            protected String buildNonNullValueText(Object object) {
                return ((MWDescriptor)object).displayString();
            }

            public String toString() {
                return "descriptor cell renderer";
            }
        });
    }

    void nodeChanged() {
        this.descriptorListModel.setModel(this.buildDescriptorLVM());
    }

    private ListValueModel buildDescriptorLVM() {
        return new TransformationListValueModelAdapter(this.buildDescriptorNodeLVM()){

            protected Object transformItem(Object object) {
                return ((DescriptorNode)object).getDescriptor();
            }
        };
    }

    private ListValueModel buildDescriptorNodeLVM() {
        ApplicationNode applicationNode = this.getNode();
        return applicationNode == null ? NullListValueModel.instance() : applicationNode.getChildrenModel();
    }
}

