/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.ScrollablePropertiesPage;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorEventsPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethod;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.MethodCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.DescriptorComponentFactory;
import org.eclipse.persistence.tools.workbench.uitools.SwitcherPanel;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.FilteringCollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ItemPropertyListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ReadOnlyListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ListModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.chooser.ListChooser;
import org.eclipse.persistence.tools.workbench.uitools.swing.ExtendedComboBoxModel;
import org.eclipse.persistence.tools.workbench.utility.Transformer;

public final class EventsPolicyPropertiesPage
extends ScrollablePropertiesPage {
    public static final int EDITOR_WEIGHT = 11;
    private PropertyValueModel eventsPolicyValueModel;
    private SimplePropertyValueModel methodTypesSelectionModel;
    private JPanel postXMethodsPanel;
    private JPanel updatingMethodsPanel;
    private JPanel insertingMethodsPanel;
    private JPanel writingMethodsPanel;
    private JPanel deletingMethodsPanel;
    private JList methodTypeSelectionList;
    private String POST_X_METHODS;
    private String UPDATING_METHODS;
    private String INSERTING_METHODS;
    private String WRITING_METHODS;
    private String DELETING_METHODS;

    EventsPolicyPropertiesPage(PropertyValueModel propertyValueModel, WorkbenchContextHolder workbenchContextHolder) {
        super(propertyValueModel, workbenchContextHolder);
    }

    protected void initialize(PropertyValueModel propertyValueModel) {
        super.initialize(propertyValueModel);
        this.POST_X_METHODS = this.resourceRepository().getString("EVENTS_POLICY_POST_X_METHODS");
        this.UPDATING_METHODS = this.resourceRepository().getString("EVENTS_POLICY_UPDATING_METHODS");
        this.INSERTING_METHODS = this.resourceRepository().getString("EVENTS_POLICY_INSERTING_METHODS");
        this.WRITING_METHODS = this.resourceRepository().getString("EVENTS_POLICY_WRITING_METHODS");
        this.DELETING_METHODS = this.resourceRepository().getString("EVENTS_POLICY_DELETING_METHODS");
    }

    protected String getHelpTopicId() {
        return "descriptor.events";
    }

    protected Component buildPage() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JComponent jComponent = this.buildMethodTypeListPanel();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jComponent, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        SwitcherPanel switcherPanel = new SwitcherPanel(this.buildMethodTypeValueModel(), new MethodTypeTransformer());
        jPanel.add((Component)switcherPanel, gridBagConstraints);
        this.getMethodTypeSelectionList().setSelectedValue(this.POST_X_METHODS, true);
        Dimension dimension = this.getMethodTypeSelectionList().getPreferredSize();
        this.getMethodTypeSelectionList().setPreferredSize(new Dimension(dimension.width + 20, dimension.height));
        this.addHelpTopicId(jPanel, this.getHelpTopicId());
        return jPanel;
    }

    private JComponent buildMethodTypeListPanel() {
        JList jList = this.getMethodTypeSelectionList();
        return new JScrollPane(jList, 21, 31);
    }

    private JPanel buildPostXMethodsPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JLabel jLabel = this.buildLabel("EVENTS_POLICY_BUILD");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        ListChooser listChooser = this.buildPostBuildMethodListChooser();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        jPanel.add((Component)listChooser, gridBagConstraints);
        jLabel.setLabelFor(listChooser);
        JLabel jLabel2 = this.buildLabel("EVENTS_POLICY_CLONE");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        jPanel.add((Component)jLabel2, gridBagConstraints);
        ListChooser listChooser2 = this.buildPostCloneMethodListChooser();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        jPanel.add((Component)listChooser2, gridBagConstraints);
        jLabel2.setLabelFor(listChooser2);
        JLabel jLabel3 = this.buildLabel("EVENTS_POLICY_MERGE");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        jPanel.add((Component)jLabel3, gridBagConstraints);
        ListChooser listChooser3 = this.buildPostMergeMethodListChooser();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        jPanel.add((Component)listChooser3, gridBagConstraints);
        jLabel3.setLabelFor(listChooser3);
        JLabel jLabel4 = this.buildLabel("EVENTS_POLICY_REFRESH");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        jPanel.add((Component)jLabel4, gridBagConstraints);
        ListChooser listChooser4 = this.buildPostRefreshMethodListChooser();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        jPanel.add((Component)listChooser4, gridBagConstraints);
        jLabel4.setLabelFor(listChooser4);
        this.addHelpTopicId(jPanel, this.getHelpTopicId() + ".postX");
        return jPanel;
    }

    protected JPanel buildDeleteMethodsPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JLabel jLabel = this.buildLabel("EVENTS_POLICY_PRE");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        ListChooser listChooser = this.buildPreDeleteMethodListChooser();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        jPanel.add((Component)listChooser, gridBagConstraints);
        jLabel.setLabelFor(listChooser);
        JLabel jLabel2 = this.buildLabel("EVENTS_POLICY_POST");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        jPanel.add((Component)jLabel2, gridBagConstraints);
        ListChooser listChooser2 = this.buildPostDeleteMethodListChooser();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        jPanel.add((Component)listChooser2, gridBagConstraints);
        jLabel2.setLabelFor(listChooser2);
        this.addHelpTopicId(jPanel, this.getHelpTopicId() + ".delete");
        return jPanel;
    }

    private JPanel buildInsertMethodsPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JLabel jLabel = this.buildLabel("EVENTS_POLICY_PRE");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        ListChooser listChooser = this.buildPreInsertMethodListChooser();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        jPanel.add((Component)listChooser, gridBagConstraints);
        jLabel.setLabelFor(listChooser);
        JLabel jLabel2 = this.buildLabel("EVENTS_POLICY_ABOUT_TO");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        jPanel.add((Component)jLabel2, gridBagConstraints);
        ListChooser listChooser2 = this.buildAboutToInsertMethodListChooser();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        jPanel.add((Component)listChooser2, gridBagConstraints);
        jLabel2.setLabelFor(listChooser2);
        JLabel jLabel3 = this.buildLabel("EVENTS_POLICY_POST");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        jPanel.add((Component)jLabel3, gridBagConstraints);
        ListChooser listChooser3 = this.buildPostInsertMethodListChooser();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        jPanel.add((Component)listChooser3, gridBagConstraints);
        jLabel3.setLabelFor(listChooser3);
        this.addHelpTopicId(jPanel, this.getHelpTopicId() + ".insert");
        return jPanel;
    }

    protected JPanel buildUpdateMethodPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JLabel jLabel = this.buildLabel("EVENTS_POLICY_PRE");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        ListChooser listChooser = this.buildPreUpdateMethodListChooser();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        jPanel.add((Component)listChooser, gridBagConstraints);
        jLabel.setLabelFor(listChooser);
        JLabel jLabel2 = this.buildLabel("EVENTS_POLICY_ABOUT_TO");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        jPanel.add((Component)jLabel2, gridBagConstraints);
        ListChooser listChooser2 = this.buildAboutToUpdateMethodListChooser();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        jPanel.add((Component)listChooser2, gridBagConstraints);
        jLabel2.setLabelFor(listChooser2);
        JLabel jLabel3 = this.buildLabel("EVENTS_POLICY_POST");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        jPanel.add((Component)jLabel3, gridBagConstraints);
        ListChooser listChooser3 = this.buildPostUpdateMethodListChooser();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        jPanel.add((Component)listChooser3, gridBagConstraints);
        jLabel3.setLabelFor(listChooser3);
        this.addHelpTopicId(jPanel, this.getHelpTopicId() + ".update");
        return jPanel;
    }

    protected JPanel buildWriteMethodPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JLabel jLabel = this.buildLabel("EVENTS_POLICY_PRE");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        ListChooser listChooser = this.buildPreWritingMethodListChooser();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        jPanel.add((Component)listChooser, gridBagConstraints);
        jLabel.setLabelFor(listChooser);
        JLabel jLabel2 = this.buildLabel("EVENTS_POLICY_POST");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        jPanel.add((Component)jLabel2, gridBagConstraints);
        ListChooser listChooser2 = this.buildPostWritingMethodListChooser();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        jPanel.add((Component)listChooser2, gridBagConstraints);
        jLabel2.setLabelFor(listChooser2);
        this.addHelpTopicId(jPanel, this.getHelpTopicId() + ".write");
        return jPanel;
    }

    private PropertyValueModel buildEventsPolicyHolder() {
        if (this.eventsPolicyValueModel == null) {
            this.eventsPolicyValueModel = new PropertyAspectAdapter(this.getSelectionHolder(), "eventsPolicy"){

                protected Object getValueFromSubject() {
                    MWDescriptorPolicy mWDescriptorPolicy = ((MWMappingDescriptor)this.subject).getEventsPolicy();
                    return mWDescriptorPolicy.isActive() ? mWDescriptorPolicy : null;
                }
            };
        }
        return this.eventsPolicyValueModel;
    }

    private CollectionValueModel buildEventMethodCollectionHolder() {
        return new CollectionAspectAdapter(this.buildEventMethodTypeHolder(), "methods"){

            protected Iterator getValueFromSubject() {
                return ((MWClass)this.subject).allMethods();
            }
        };
    }

    private ItemPropertyListValueModelAdapter buildEventMethodPropertyListAdapter() {
        return new ItemPropertyListValueModelAdapter(this.buildEventMethodCollectionHolder(), "signature");
    }

    private FilteringCollectionValueModel buildEventMethodFilteringCollectionModel() {
        return new FilteringCollectionValueModel(this.buildEventMethodPropertyListAdapter()){

            protected boolean accept(Object object) {
                return ((MWMethod)object).isCandidateDescriptorEventMethod();
            }
        };
    }

    private PropertyValueModel buildEventMethodTypeHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder(), "mwClass"){

            protected Object getValueFromSubject() {
                return ((MWDescriptor)this.subject).getMWClass();
            }
        };
    }

    private JPanel getDeletingMethodsPanel() {
        if (this.deletingMethodsPanel == null) {
            this.deletingMethodsPanel = this.buildDeleteMethodsPanel();
        }
        return this.deletingMethodsPanel;
    }

    private JPanel getInsertingMethodsPanel() {
        if (this.insertingMethodsPanel == null) {
            this.insertingMethodsPanel = this.buildInsertMethodsPanel();
        }
        return this.insertingMethodsPanel;
    }

    private JPanel getPostXMethodsPanel() {
        if (this.postXMethodsPanel == null) {
            this.postXMethodsPanel = this.buildPostXMethodsPanel();
        }
        return this.postXMethodsPanel;
    }

    private JPanel getUpdatingMethodsPanel() {
        if (this.updatingMethodsPanel == null) {
            this.updatingMethodsPanel = this.buildUpdateMethodPanel();
        }
        return this.updatingMethodsPanel;
    }

    private JPanel getWritingMethodsPanel() {
        if (this.writingMethodsPanel == null) {
            this.writingMethodsPanel = this.buildWriteMethodPanel();
        }
        return this.writingMethodsPanel;
    }

    private JList getMethodTypeSelectionList() {
        if (this.methodTypeSelectionList == null) {
            this.methodTypeSelectionList = this.buildMethodTypeSelectionJList();
        }
        return this.methodTypeSelectionList;
    }

    private ListChooser buildPostBuildMethodListChooser() {
        ListChooser listChooser = new ListChooser(new ExtendedComboBoxModel(this.buildPostBuildComboBoxModel()), DescriptorComponentFactory.buildMethodNodeSelector(this.getWorkbenchContextHolder()));
        listChooser.setRenderer((ListCellRenderer)new AdaptableListCellRenderer(new MethodCellRendererAdapter(this.resourceRepository())));
        return listChooser;
    }

    private ListChooser buildPostCloneMethodListChooser() {
        ListChooser listChooser = new ListChooser(new ExtendedComboBoxModel(this.buildPostCloneComboBoxModel()), DescriptorComponentFactory.buildMethodNodeSelector(this.getWorkbenchContextHolder()));
        listChooser.setRenderer((ListCellRenderer)new AdaptableListCellRenderer(new MethodCellRendererAdapter(this.resourceRepository())));
        return listChooser;
    }

    private ListChooser buildPostMergeMethodListChooser() {
        ListChooser listChooser = new ListChooser(new ExtendedComboBoxModel(this.buildPostMergeComboBoxModel()), DescriptorComponentFactory.buildMethodNodeSelector(this.getWorkbenchContextHolder()));
        listChooser.setRenderer((ListCellRenderer)new AdaptableListCellRenderer(new MethodCellRendererAdapter(this.resourceRepository())));
        return listChooser;
    }

    private ListChooser buildPostRefreshMethodListChooser() {
        ListChooser listChooser = new ListChooser(new ExtendedComboBoxModel(this.buildPostRefreshComboBoxModel()), DescriptorComponentFactory.buildMethodNodeSelector(this.getWorkbenchContextHolder()));
        listChooser.setRenderer((ListCellRenderer)new AdaptableListCellRenderer(new MethodCellRendererAdapter(this.resourceRepository())));
        return listChooser;
    }

    private ListChooser buildPreDeleteMethodListChooser() {
        ListChooser listChooser = new ListChooser(new ExtendedComboBoxModel(this.buildPreDeleteComboBoxModel()), DescriptorComponentFactory.buildMethodNodeSelector(this.getWorkbenchContextHolder()));
        listChooser.setRenderer((ListCellRenderer)new AdaptableListCellRenderer(new MethodCellRendererAdapter(this.resourceRepository())));
        return listChooser;
    }

    private ListChooser buildPostDeleteMethodListChooser() {
        ListChooser listChooser = new ListChooser(new ExtendedComboBoxModel(this.buildPostDeleteComboBoxModel()), DescriptorComponentFactory.buildMethodNodeSelector(this.getWorkbenchContextHolder()));
        listChooser.setRenderer((ListCellRenderer)new AdaptableListCellRenderer(new MethodCellRendererAdapter(this.resourceRepository())));
        return listChooser;
    }

    private ListChooser buildPreInsertMethodListChooser() {
        ListChooser listChooser = new ListChooser(new ExtendedComboBoxModel(this.buildPreInsertComboBoxModel()), DescriptorComponentFactory.buildMethodNodeSelector(this.getWorkbenchContextHolder()));
        listChooser.setRenderer((ListCellRenderer)new AdaptableListCellRenderer(new MethodCellRendererAdapter(this.resourceRepository())));
        return listChooser;
    }

    private ListChooser buildAboutToInsertMethodListChooser() {
        ListChooser listChooser = new ListChooser(new ExtendedComboBoxModel(this.buildAboutToInsertComboBoxModel()), DescriptorComponentFactory.buildMethodNodeSelector(this.getWorkbenchContextHolder()));
        listChooser.setRenderer((ListCellRenderer)new AdaptableListCellRenderer(new MethodCellRendererAdapter(this.resourceRepository())));
        return listChooser;
    }

    private ListChooser buildPostInsertMethodListChooser() {
        ListChooser listChooser = new ListChooser(new ExtendedComboBoxModel(this.buildPostInsertComboBoxModel()), DescriptorComponentFactory.buildMethodNodeSelector(this.getWorkbenchContextHolder()));
        listChooser.setRenderer((ListCellRenderer)new AdaptableListCellRenderer(new MethodCellRendererAdapter(this.resourceRepository())));
        return listChooser;
    }

    private ListChooser buildPreUpdateMethodListChooser() {
        ListChooser listChooser = new ListChooser(new ExtendedComboBoxModel(this.buildPreUpdateComboBoxModel()), DescriptorComponentFactory.buildMethodNodeSelector(this.getWorkbenchContextHolder()));
        listChooser.setRenderer((ListCellRenderer)new AdaptableListCellRenderer(new MethodCellRendererAdapter(this.resourceRepository())));
        return listChooser;
    }

    private ListChooser buildAboutToUpdateMethodListChooser() {
        ListChooser listChooser = new ListChooser(new ExtendedComboBoxModel(this.buildAboutToUpdateComboBoxModel()), DescriptorComponentFactory.buildMethodNodeSelector(this.getWorkbenchContextHolder()));
        listChooser.setRenderer((ListCellRenderer)new AdaptableListCellRenderer(new MethodCellRendererAdapter(this.resourceRepository())));
        return listChooser;
    }

    private ListChooser buildPostUpdateMethodListChooser() {
        ListChooser listChooser = new ListChooser(new ExtendedComboBoxModel(this.buildPostUpdateComboBoxModel()), DescriptorComponentFactory.buildMethodNodeSelector(this.getWorkbenchContextHolder()));
        listChooser.setRenderer((ListCellRenderer)new AdaptableListCellRenderer(new MethodCellRendererAdapter(this.resourceRepository())));
        return listChooser;
    }

    private ListChooser buildPreWritingMethodListChooser() {
        ListChooser listChooser = new ListChooser(new ExtendedComboBoxModel(this.buildPreWritingComboBoxModel()), DescriptorComponentFactory.buildMethodNodeSelector(this.getWorkbenchContextHolder()));
        listChooser.setRenderer((ListCellRenderer)new AdaptableListCellRenderer(new MethodCellRendererAdapter(this.resourceRepository())));
        return listChooser;
    }

    private ListChooser buildPostWritingMethodListChooser() {
        ListChooser listChooser = new ListChooser(new ExtendedComboBoxModel(this.buildPostWritingComboBoxModel()), DescriptorComponentFactory.buildMethodNodeSelector(this.getWorkbenchContextHolder()));
        listChooser.setRenderer((ListCellRenderer)new AdaptableListCellRenderer(new MethodCellRendererAdapter(this.resourceRepository())));
        return listChooser;
    }

    private ComboBoxModel buildPostBuildComboBoxModel() {
        return new ComboBoxModelAdapter(this.buildEventMethodFilteringCollectionModel(), this.buildPostBuildMethodSelectionHolder());
    }

    private ComboBoxModel buildPostCloneComboBoxModel() {
        return new ComboBoxModelAdapter(this.buildEventMethodFilteringCollectionModel(), this.buildPostCloneMethodSelectionHolder());
    }

    private ComboBoxModel buildPostMergeComboBoxModel() {
        return new ComboBoxModelAdapter(this.buildEventMethodFilteringCollectionModel(), this.buildPostMergeMethodSelectionHolder());
    }

    private ComboBoxModel buildPostRefreshComboBoxModel() {
        return new ComboBoxModelAdapter(this.buildEventMethodFilteringCollectionModel(), this.buildPostRefreshMethodSelectionHolder());
    }

    private ComboBoxModel buildPreDeleteComboBoxModel() {
        return new ComboBoxModelAdapter(this.buildEventMethodFilteringCollectionModel(), this.buildPreDeleteMethodSelectionHolder());
    }

    private ComboBoxModel buildPostDeleteComboBoxModel() {
        return new ComboBoxModelAdapter(this.buildEventMethodFilteringCollectionModel(), this.buildPostDeleteMethodSelectionHolder());
    }

    private ComboBoxModel buildPreInsertComboBoxModel() {
        return new ComboBoxModelAdapter(this.buildEventMethodFilteringCollectionModel(), this.buildPreInsertMethodSelectionHolder());
    }

    private ComboBoxModel buildAboutToInsertComboBoxModel() {
        return new ComboBoxModelAdapter(this.buildEventMethodFilteringCollectionModel(), this.buildAboutToInsertMethodSelectionHolder());
    }

    private ComboBoxModel buildPostInsertComboBoxModel() {
        return new ComboBoxModelAdapter(this.buildEventMethodFilteringCollectionModel(), this.buildPostInsertMethodSelectionHolder());
    }

    private ComboBoxModel buildPreUpdateComboBoxModel() {
        return new ComboBoxModelAdapter(this.buildEventMethodFilteringCollectionModel(), this.buildPreUpdateMethodSelectionHolder());
    }

    private ComboBoxModel buildAboutToUpdateComboBoxModel() {
        return new ComboBoxModelAdapter(this.buildEventMethodFilteringCollectionModel(), this.buildAboutToUpdateMethodSelectionHolder());
    }

    private ComboBoxModel buildPostUpdateComboBoxModel() {
        return new ComboBoxModelAdapter(this.buildEventMethodFilteringCollectionModel(), this.buildPostUpdateMethodSelectionHolder());
    }

    private ComboBoxModel buildPreWritingComboBoxModel() {
        return new ComboBoxModelAdapter(this.buildEventMethodFilteringCollectionModel(), this.buildPreWritingMethodSelectionHolder());
    }

    private ComboBoxModel buildPostWritingComboBoxModel() {
        return new ComboBoxModelAdapter(this.buildEventMethodFilteringCollectionModel(), this.buildPostWritingMethodSelectionHolder());
    }

    private PropertyValueModel buildPostBuildMethodSelectionHolder() {
        return new PropertyAspectAdapter(this.buildEventsPolicyHolder(), "postBuildMethod"){

            protected Object getValueFromSubject() {
                return ((MWDescriptorEventsPolicy)this.subject).getPostBuildMethod();
            }

            protected void setValueOnSubject(Object object) {
                ((MWDescriptorEventsPolicy)this.subject).setPostBuildMethod((MWMethod)object);
            }
        };
    }

    private PropertyValueModel buildPostCloneMethodSelectionHolder() {
        return new PropertyAspectAdapter(this.buildEventsPolicyHolder(), "postCloneMethod"){

            protected Object getValueFromSubject() {
                return ((MWDescriptorEventsPolicy)this.subject).getPostCloneMethod();
            }

            protected void setValueOnSubject(Object object) {
                ((MWDescriptorEventsPolicy)this.subject).setPostCloneMethod((MWMethod)object);
            }
        };
    }

    private PropertyValueModel buildPostMergeMethodSelectionHolder() {
        return new PropertyAspectAdapter(this.buildEventsPolicyHolder(), "postMergeMethod"){

            protected Object getValueFromSubject() {
                return ((MWDescriptorEventsPolicy)this.subject).getPostMergeMethod();
            }

            protected void setValueOnSubject(Object object) {
                ((MWDescriptorEventsPolicy)this.subject).setPostMergeMethod((MWMethod)object);
            }
        };
    }

    private PropertyValueModel buildPostRefreshMethodSelectionHolder() {
        return new PropertyAspectAdapter(this.buildEventsPolicyHolder(), "postRefreshMethod"){

            protected Object getValueFromSubject() {
                return ((MWDescriptorEventsPolicy)this.subject).getPostRefreshMethod();
            }

            protected void setValueOnSubject(Object object) {
                ((MWDescriptorEventsPolicy)this.subject).setPostRefreshMethod((MWMethod)object);
            }
        };
    }

    private PropertyValueModel buildPreDeleteMethodSelectionHolder() {
        return new PropertyAspectAdapter(this.buildEventsPolicyHolder(), "preDeletingMethod"){

            protected Object getValueFromSubject() {
                return ((MWDescriptorEventsPolicy)this.subject).getPreDeletingMethod();
            }

            protected void setValueOnSubject(Object object) {
                ((MWDescriptorEventsPolicy)this.subject).setPreDeletingMethod((MWMethod)object);
            }
        };
    }

    private PropertyValueModel buildPostDeleteMethodSelectionHolder() {
        return new PropertyAspectAdapter(this.buildEventsPolicyHolder(), "postDeletingMethod"){

            protected Object getValueFromSubject() {
                return ((MWDescriptorEventsPolicy)this.subject).getPostDeletingMethod();
            }

            protected void setValueOnSubject(Object object) {
                ((MWDescriptorEventsPolicy)this.subject).setPostDeletingMethod((MWMethod)object);
            }
        };
    }

    private PropertyValueModel buildPreInsertMethodSelectionHolder() {
        return new PropertyAspectAdapter(this.buildEventsPolicyHolder(), "preInsertMethod"){

            protected Object getValueFromSubject() {
                return ((MWDescriptorEventsPolicy)this.subject).getPreInsertMethod();
            }

            protected void setValueOnSubject(Object object) {
                ((MWDescriptorEventsPolicy)this.subject).setPreInsertMethod((MWMethod)object);
            }
        };
    }

    private PropertyValueModel buildAboutToInsertMethodSelectionHolder() {
        return new PropertyAspectAdapter(this.buildEventsPolicyHolder(), "aboutToInsertMethod"){

            protected Object getValueFromSubject() {
                return ((MWDescriptorEventsPolicy)this.subject).getAboutToInsertMethod();
            }

            protected void setValueOnSubject(Object object) {
                ((MWDescriptorEventsPolicy)this.subject).setAboutToInsertMethod((MWMethod)object);
            }
        };
    }

    private PropertyValueModel buildPostInsertMethodSelectionHolder() {
        return new PropertyAspectAdapter(this.buildEventsPolicyHolder(), "postInsertMethod"){

            protected Object getValueFromSubject() {
                return ((MWDescriptorEventsPolicy)this.subject).getPostInsertMethod();
            }

            protected void setValueOnSubject(Object object) {
                ((MWDescriptorEventsPolicy)this.subject).setPostInsertMethod((MWMethod)object);
            }
        };
    }

    private PropertyValueModel buildPreUpdateMethodSelectionHolder() {
        return new PropertyAspectAdapter(this.buildEventsPolicyHolder(), "preUpdateMethod"){

            protected Object getValueFromSubject() {
                return ((MWDescriptorEventsPolicy)this.subject).getPreUpdateMethod();
            }

            protected void setValueOnSubject(Object object) {
                ((MWDescriptorEventsPolicy)this.subject).setPreUpdateMethod((MWMethod)object);
            }
        };
    }

    private PropertyValueModel buildAboutToUpdateMethodSelectionHolder() {
        return new PropertyAspectAdapter(this.buildEventsPolicyHolder(), "aboutToUpdateMethod"){

            protected Object getValueFromSubject() {
                return ((MWDescriptorEventsPolicy)this.subject).getAboutToUpdateMethod();
            }

            protected void setValueOnSubject(Object object) {
                ((MWDescriptorEventsPolicy)this.subject).setAboutToUpdateMethod((MWMethod)object);
            }
        };
    }

    private PropertyValueModel buildPostUpdateMethodSelectionHolder() {
        return new PropertyAspectAdapter(this.buildEventsPolicyHolder(), "postUpdateMethod"){

            protected Object getValueFromSubject() {
                return ((MWDescriptorEventsPolicy)this.subject).getPostUpdateMethod();
            }

            protected void setValueOnSubject(Object object) {
                ((MWDescriptorEventsPolicy)this.subject).setPostUpdateMethod((MWMethod)object);
            }
        };
    }

    private PropertyValueModel buildPreWritingMethodSelectionHolder() {
        return new PropertyAspectAdapter(this.buildEventsPolicyHolder(), "preWritingMethod"){

            protected Object getValueFromSubject() {
                return ((MWDescriptorEventsPolicy)this.subject).getPreWritingMethod();
            }

            protected void setValueOnSubject(Object object) {
                ((MWDescriptorEventsPolicy)this.subject).setPreWritingMethod((MWMethod)object);
            }
        };
    }

    private PropertyValueModel buildPostWritingMethodSelectionHolder() {
        return new PropertyAspectAdapter(this.buildEventsPolicyHolder(), "postWritingMethod"){

            protected Object getValueFromSubject() {
                return ((MWDescriptorEventsPolicy)this.subject).getPostWritingMethod();
            }

            protected void setValueOnSubject(Object object) {
                ((MWDescriptorEventsPolicy)this.subject).setPostWritingMethod((MWMethod)object);
            }
        };
    }

    private JList buildMethodTypeSelectionJList() {
        ListModelAdapter listModelAdapter = new ListModelAdapter(this.buildMethodTypesModel());
        JList jList = SwingComponentFactory.buildList(listModelAdapter);
        jList.getSelectionModel().setSelectionMode(0);
        jList.addListSelectionListener(new MethodTypesListDataListener(jList, this.buildMethodTypeValueModel()));
        return jList;
    }

    private ReadOnlyListValueModel buildMethodTypesModel() {
        return new ReadOnlyListValueModel(this.buildMethodTypeSelectionList());
    }

    private List buildMethodTypeSelectionList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.DELETING_METHODS);
        arrayList.add(this.INSERTING_METHODS);
        arrayList.add(this.POST_X_METHODS);
        arrayList.add(this.UPDATING_METHODS);
        arrayList.add(this.WRITING_METHODS);
        return arrayList;
    }

    private SimplePropertyValueModel buildMethodTypeValueModel() {
        if (this.methodTypesSelectionModel == null) {
            this.methodTypesSelectionModel = new SimplePropertyValueModel();
        }
        return this.methodTypesSelectionModel;
    }

    private class MethodTypeTransformer
    implements Transformer {
        private MethodTypeTransformer() {
        }

        public Object transform(Object object) {
            String string = (String)object;
            if (string == EventsPolicyPropertiesPage.this.POST_X_METHODS) {
                return EventsPolicyPropertiesPage.this.getPostXMethodsPanel();
            }
            if (string == EventsPolicyPropertiesPage.this.DELETING_METHODS) {
                return EventsPolicyPropertiesPage.this.getDeletingMethodsPanel();
            }
            if (string == EventsPolicyPropertiesPage.this.INSERTING_METHODS) {
                return EventsPolicyPropertiesPage.this.getInsertingMethodsPanel();
            }
            if (string == EventsPolicyPropertiesPage.this.UPDATING_METHODS) {
                return EventsPolicyPropertiesPage.this.getUpdatingMethodsPanel();
            }
            if (string == EventsPolicyPropertiesPage.this.WRITING_METHODS) {
                return EventsPolicyPropertiesPage.this.getWritingMethodsPanel();
            }
            return null;
        }
    }

    private class MethodTypesListDataListener
    implements ListSelectionListener {
        private JList list;
        private PropertyValueModel selectionModel;

        private MethodTypesListDataListener(JList jList, PropertyValueModel propertyValueModel) {
            this.selectionModel = propertyValueModel;
            this.list = jList;
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                this.selectionModel.setValue(this.list.getSelectedValue());
            }
        }
    }
}

